/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.impl.combat.NegativeExplosionVisual;
import com.fs.starfarer.api.impl.combat.RiftCascadeMineExplosion;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.dweller.HumanShipShroudedHullmod;
import com.fs.starfarer.api.impl.combat.dweller.RiftLightningEffect;
import com.fs.starfarer.api.impl.combat.threat.EnergyLashSystemScript;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedThunderheadHullmod
extends HumanShipShroudedHullmod {
    public static float MAX_RANGE = 3000.0f;
    public static float RECENT_HIT_DUR = 5.0f;
    public static float MAX_TIME_SINCE_RECENT_HIT = 0.1f;
    public static float WEIGHT_PER_RECENT_HIT = 1.0f;
    public static float MISFIRE_WEIGHT = 10.0f;
    public static float MIN_REFIRE_DELAY = 0.22f;
    public static float MAX_REFIRE_DELAY = 0.44f;
    public static float REFIRE_RATE_MULT = 1.0f;
    public static float FLUX_PER_DAMAGE = 1.0f;
    public static float MIN_DAMAGE = 200.0f;
    public static float MAX_DAMAGE = 500.0f;
    public static float EMP_MULT = 2.0f;
    public static String DATA_KEY = "core_ShroudedThunderheadHullmod_data_key";

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        super.applyEffectsAfterShipCreation(ship, id);
        ship.addListener(new ShroudedThunderheadDamageDealtMod(ship));
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    @Override
    public CargoStackAPI getRequiredItem() {
        return Global.getSettings().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("shrouded_thunderhead", null), null);
    }

    public static ShroudedThunderheadHullmodData getData(ShipAPI ship) {
        CombatEngineAPI engine = Global.getCombatEngine();
        String key = String.valueOf(DATA_KEY) + "_" + ship.getId();
        ShroudedThunderheadHullmodData data = (ShroudedThunderheadHullmodData)engine.getCustomData().get(key);
        if (data == null) {
            data = new ShroudedThunderheadHullmodData();
            engine.getCustomData().put(key, data);
        }
        return data;
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        boolean hasRecentHits;
        super.advanceInCombat(ship, amount);
        if (!ship.isAlive()) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        ShroudedThunderheadHullmodData data = ShroudedThunderheadHullmod.getData(ship);
        float prob = data.getHitProbability();
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        shroud.getParams().flashProbability = Math.min(0.1f + prob * 1.4f, 1.0f);
        data.untilArc -= amount * REFIRE_RATE_MULT;
        if (data.untilArc <= 0.0f && (hasRecentHits = data.hasRecentEnoughHits())) {
            RecentHitData hit = data.pickRecentHit();
            if (hit != null && hit.target != null) {
                data.recentHits.remove(hit);
                this.spawnLightning(ship, hit);
            }
            data.untilArc = MIN_REFIRE_DELAY + (float)Math.random() * (MAX_REFIRE_DELAY - MIN_REFIRE_DELAY);
        }
        data.recentHits.advance(amount);
    }

    public static float getPowerMult(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return 1.0f;
            }
            case CRUISER: {
                return 0.6666667f;
            }
            case DESTROYER: {
                return 0.33333334f;
            }
            case FIGHTER: 
            case FRIGATE: {
                return 0.0f;
            }
        }
        return 1.0f;
    }

    public static float getDamage(ShipAPI.HullSize size) {
        float mult = ShroudedThunderheadHullmod.getPowerMult(size);
        return MIN_DAMAGE + (MAX_DAMAGE - MIN_DAMAGE) * mult;
    }

    public static float getEMPDamage(ShipAPI.HullSize size) {
        return ShroudedThunderheadHullmod.getDamage(size) * EMP_MULT;
    }

    public static float getFluxCost(ShipAPI.HullSize size) {
        return ShroudedThunderheadHullmod.getDamage(size) * FLUX_PER_DAMAGE;
    }

    public void spawnLightning(final ShipAPI ship, RecentHitData hit) {
        float fluxCost;
        Vector2f point;
        final CombatEngineAPI engine = Global.getCombatEngine();
        Vector2f from = ship.getLocation();
        float dist = Misc.getDistance(from, point = hit.point);
        if (dist > MAX_RANGE) {
            return;
        }
        final float mult = ShroudedThunderheadHullmod.getPowerMult(ship.getHullSize());
        final float damage = ShroudedThunderheadHullmod.getDamage(ship.getHullSize());
        final float emp = ShroudedThunderheadHullmod.getEMPDamage(ship.getHullSize());
        if (FLUX_PER_DAMAGE > 0.0f && !this.deductFlux(ship, fluxCost = ShroudedThunderheadHullmod.getFluxCost(ship.getHullSize()))) {
            return;
        }
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        if (shroud != null) {
            float angle = Misc.getAngleInDegrees(ship.getLocation(), point);
            from = Misc.getUnitVectorAtDegreeAngle(angle + 90.0f - 180.0f * (float)Math.random());
            from.scale((0.5f + (float)Math.random() * 0.25f) * shroud.getShroudParams().maxOffset * shroud.getShroudParams().overloadArcOffsetMult);
            Vector2f.add((Vector2f)ship.getLocation(), (Vector2f)from, (Vector2f)from);
        }
        float arcSpeed = RiftLightningEffect.RIFT_LIGHTNING_SPEED;
        EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
        params.segmentLengthMult = 8.0f;
        params.zigZagReductionFactor = 0.15f;
        params.fadeOutDist = 50.0f;
        params.minFadeOutMult = 10.0f;
        params.flickerRateMult = 0.3f;
        params.movementDurOverride = Math.max(0.05f, dist / arcSpeed);
        float arcWidth = 40.0f + mult * 40.0f;
        final float explosionRadius = 40.0f + mult * 40.0f;
        Color color = RiftLightningEffect.RIFT_LIGHTNING_COLOR;
        EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, ship, point, null, arcWidth, color, new Color(255, 255, 255, 255), params);
        arc.setCoreWidthOverride(arcWidth / 2.0f);
        arc.setRenderGlowAtStart(false);
        arc.setFadedOutAtStart(true);
        arc.setSingleFlickerMode(true);
        float volume = 0.75f + 0.25f * mult;
        float pitch = 1.0f + 0.25f * (1.0f - mult);
        Global.getSoundPlayer().playSound("rift_lightning_fire", pitch, volume, from, ship.getVelocity());
        if (shroud != null) {
            DwellerShroud.DwellerShroudParams shroudParams = shroud.getShroudParams();
            params = new EmpArcEntityAPI.EmpArcParams();
            params.segmentLengthMult = 4.0f;
            params.glowSizeMult = 4.0f;
            params.flickerRateMult = 0.5f + (float)Math.random() * 0.5f;
            params.flickerRateMult *= 1.5f;
            Color fringe = color;
            Color core = Color.white;
            float thickness = shroudParams.overloadArcThickness;
            float angle = Misc.getAngleInDegrees(from, ship.getLocation());
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle += 90.0f * ((float)Math.random() - 0.5f));
            dist = shroudParams.maxOffset * shroud.getShroudParams().overloadArcOffsetMult;
            dist = dist * 0.5f + dist * 0.5f * (float)Math.random();
            dir.scale(dist *= 0.5f);
            Vector2f to = Vector2f.add((Vector2f)from, (Vector2f)dir, (Vector2f)new Vector2f());
            arc = engine.spawnEmpArcVisual(from, ship, to, ship, thickness, fringe, core, params);
            arc.setCoreWidthOverride(shroudParams.overloadArcCoreThickness);
            arc.setSingleFlickerMode(false);
        }
        float explosionDelay = params.movementDurOverride * 0.8f;
        Global.getCombatEngine().addPlugin(new EnergyLashSystemScript.DelayedCombatActionPlugin(explosionDelay, new Runnable(){

            @Override
            public void run() {
                DamagingExplosionSpec spec = new DamagingExplosionSpec(0.1f, explosionRadius, explosionRadius * 0.5f, damage, damage / 2.0f, CollisionClass.PROJECTILE_NO_FF, CollisionClass.GAS_CLOUD, 3.0f, 3.0f, 0.5f, 0, new Color(255, 255, 255, 0), new Color(255, 100, 100, 0));
                spec.setMinEMPDamage(emp * 0.5f);
                spec.setMaxEMPDamage(emp);
                spec.setDamageType(DamageType.ENERGY);
                spec.setUseDetailedExplosion(false);
                spec.setSoundSetId("rift_lightning_explosion");
                spec.setSoundVolume(0.5f + 0.5f * mult);
                DamagingProjectileAPI explosion = engine.spawnDamagingExplosion(spec, ship, point);
                Color color = RiftLightningEffect.RIFT_LIGHTNING_COLOR;
                color = new Color(255, 75, 75, 255);
                NegativeExplosionVisual.NEParams p = RiftCascadeMineExplosion.createStandardRiftParams(color, 14.0f + 6.0f * mult);
                p.fadeOut = 0.5f + 0.5f * mult;
                p.hitGlowSizeMult = 0.6f;
                p.thickness = 50.0f;
                RiftCascadeMineExplosion.spawnStandardRift(explosion, p);
            }
        }));
    }

    @Override
    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    @Override
    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("Fires rift lightning bolts at locations recently hit by this ship's weapons.", opad);
        tooltip.addPara("The amount of damage and the flux generated depend on the size of the ship the hullmod is installed on. The probability of a bolt being fired increases with the number of hits landed over the previous %s seconds. Bolts are not triggered by weapons dealing soft flux damage, such as beams.", opad, Misc.getHighlightColor(), "" + Math.round(RECENT_HIT_DUR));
        if (isForModSpec || ship == null && !Global.CODEX_TOOLTIP_MODE) {
            return;
        }
        tooltip.setBgAlpha(0.9f);
        ShipAPI.HullSize[] sizes = new ShipAPI.HullSize[]{ShipAPI.HullSize.FRIGATE, ShipAPI.HullSize.DESTROYER, ShipAPI.HullSize.CRUISER, ShipAPI.HullSize.CAPITAL_SHIP};
        float damW = 87.0f;
        float empW = 87.0f;
        float fluxW = 87.0f;
        float sizeW = width - damW - empW - fluxW - 10.0f;
        tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"Ship size", Float.valueOf(sizeW), "Damage", Float.valueOf(damW), "EMP", Float.valueOf(empW), "Flux cost", Float.valueOf(fluxW)});
        ShipAPI.HullSize[] hullSizeArray = sizes;
        int n = sizes.length;
        int n2 = 0;
        while (n2 < n) {
            ShipAPI.HullSize size = hullSizeArray[n2];
            float damage = ShroudedThunderheadHullmod.getDamage(size);
            float emp = ShroudedThunderheadHullmod.getEMPDamage(size);
            float fluxCost = ShroudedThunderheadHullmod.getFluxCost(size);
            Color c = Misc.getGrayColor();
            if (size == hullSize || Global.CODEX_TOOLTIP_MODE) {
                c = Misc.getHighlightColor();
            }
            tooltip.addRow(new Object[]{Alignment.MID, c, Misc.getHullSizeStr(size), Alignment.MID, c, "" + Math.round(damage), Alignment.MID, c, "" + Math.round(emp), Alignment.MID, c, "" + Math.round(fluxCost)});
            ++n2;
        }
        tooltip.addTable("", 0, opad);
        tooltip.addSpacer(5.0f);
        this.addCrewCasualties(tooltip, opad);
    }

    public static class RecentHitData {
        Object param;
        CombatEntityAPI target;
        Vector2f point;
        DamageAPI damage;
        boolean shieldHit;
    }

    public static class ShroudedThunderheadDamageDealtMod
    implements DamageDealtModifier {
        public ShipAPI ship;

        public ShroudedThunderheadDamageDealtMod(ShipAPI ship) {
            this.ship = ship;
        }

        @Override
        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            DamagingProjectileAPI proj;
            DamagingExplosionSpec spec;
            if (param instanceof DamagingProjectileAPI ? (spec = (proj = (DamagingProjectileAPI)param).getExplosionSpecIfExplosion()) != null && spec.getCollisionClassIfByFighter() == CollisionClass.GAS_CLOUD : damage.isDps() && !damage.isForceHardFlux() || damage.getDamage() <= 0.0f) {
                return null;
            }
            if (target != null) {
                ShroudedThunderheadHullmodData data = ShroudedThunderheadHullmod.getData(this.ship);
                RecentHitData hit = new RecentHitData();
                hit.param = param;
                hit.target = target;
                hit.point = new Vector2f((ReadableVector2f)point);
                hit.damage = damage;
                hit.shieldHit = shieldHit;
                data.recentHits.add(hit, RECENT_HIT_DUR);
            }
            return null;
        }
    }

    public static class ShroudedThunderheadHullmodData {
        float untilArc = 0.0f;
        TimeoutTracker<RecentHitData> recentHits = new TimeoutTracker();

        boolean hasRecentEnoughHits() {
            for (RecentHitData curr : this.recentHits.getItems()) {
                float remaining = this.recentHits.getRemaining(curr);
                if (!(remaining >= RECENT_HIT_DUR - MAX_TIME_SINCE_RECENT_HIT)) continue;
                return true;
            }
            return false;
        }

        float getHitProbability() {
            float recent = (float)this.recentHits.getItems().size() * WEIGHT_PER_RECENT_HIT;
            return recent / (recent + MISFIRE_WEIGHT);
        }

        RecentHitData pickRecentHit() {
            if (!this.hasRecentEnoughHits()) {
                return null;
            }
            WeightedRandomPicker<RecentHitData> picker = new WeightedRandomPicker<RecentHitData>();
            for (RecentHitData curr : this.recentHits.getItems()) {
                float remaining = this.recentHits.getRemaining(curr);
                if (remaining < RECENT_HIT_DUR - MAX_TIME_SINCE_RECENT_HIT * 2.0f) continue;
                picker.add(curr, WEIGHT_PER_RECENT_HIT);
            }
            RecentHitData misfire = new RecentHitData();
            picker.add(misfire, MISFIRE_WEIGHT);
            return (RecentHitData)picker.pick();
        }
    }
}

