/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.impl.combat.RiftTrailEffect;
import com.fs.starfarer.api.impl.combat.dweller.BaseDwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatPlugin;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipPart;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedVortexShipCreator
extends BaseDwellerShipCreator
implements DwellerCombatPlugin.DCPPlugin {
    public static float EXPLOSION_DAMAGE = 2000.0f;
    public static DamageType EXPLOSION_DAMAGE_TYPE = DamageType.ENERGY;
    public static String ID_BODY_ONE = "id_body_one";
    public static String ID_BODY_TWO = "id_body_two";
    public static String TAG_MIRRORED_VORTEX = "tag_mirrored_vortex";

    @Override
    protected DwellerCombatPlugin createPlugin(ShipAPI ship) {
        boolean mirror;
        DwellerCombatPlugin plugin = DwellerCombatPlugin.getDwellerPluginFor(ship);
        if (plugin == null) {
            plugin = new DwellerCombatPlugin(ship){
                protected boolean exploded;
                {
                    this.exploded = false;
                }

                @Override
                public boolean notifyAboutToTakeHullDamage(Object param, ShipAPI ship, Vector2f point, float damageAmount) {
                    if (damageAmount >= ship.getHitpoints() && !this.exploded) {
                        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
                        if (shroud != null) {
                            for (RoilingSwarmEffect.SwarmMember p : shroud.getMembers()) {
                                Vector2f.sub((Vector2f)p.vel, (Vector2f)ship.getVelocity(), (Vector2f)p.vel);
                            }
                        }
                        DamagingProjectileAPI explosion = Global.getCombatEngine().spawnDamagingExplosion(ShroudedVortexShipCreator.this.createExplosionSpec(ship), ship, ship.getLocation());
                        this.exploded = true;
                        ship.getVelocity().scale(0.1f);
                    }
                    return super.notifyAboutToTakeHullDamage(param, ship, point, damageAmount);
                }
            };
        }
        List<DwellerShipPart> parts = plugin.getParts();
        parts.clear();
        float scale = 1.0f;
        scale = 0.5f;
        float spinMult = 1.0f;
        boolean bl = mirror = (float)Math.random() > 0.5f;
        if (mirror) {
            ship.addTag(TAG_MIRRORED_VORTEX);
        }
        DwellerCombatPlugin.WobblyPart part = new DwellerCombatPlugin.WobblyPart("shrouded_vortex_base", 2.0f * scale, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        part.setId(ID_BODY_ONE);
        part.renderer.setMirror(mirror);
        parts.add(part);
        part = new DwellerCombatPlugin.WobblyPart("shrouded_vortex_base2", 3.0f * scale, 3, 3, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        part.setId(ID_BODY_TWO);
        part.renderer.setMirror(mirror);
        part.alphaMult = 0.5f;
        parts.add(part);
        return plugin;
    }

    @Override
    protected void modifyBaselineShroudParams(ShipAPI ship, DwellerShroud.DwellerShroudParams params) {
        params.maxOffset = 50.0f;
        params.baseMembersToMaintain = params.initialMembers = 30;
        params.baseSpriteSize *= 0.65f;
        params.flashFrequency /= 3.0f;
        params.negativeParticleAreaMult = 1.25f;
        params.negativeParticleDurMult *= 0.5f;
        params.negativeParticleSizeMult *= 1.4f;
        params.negativeParticleGenRate *= 0.5f;
        params.overloadGlowSizeMult *= 0.5f;
    }

    @Override
    public void initInCombat(ShipAPI ship) {
        super.initInCombat(ship);
        RiftTrailEffect trail = new RiftTrailEffect(ship, null){

            @Override
            protected Color getUndercolor() {
                return DwellerShroud.SHROUD_COLOR;
            }

            @Override
            protected Color getDarkeningColor() {
                return RiftLanceEffect.getColorForDarkening(this.getUndercolor());
            }

            @Override
            protected float getBaseParticleSize() {
                return this.ship.getCollisionRadius() * 1.0f;
            }

            @Override
            protected float getBaseParticleDuration() {
                return 1.5f;
            }
        };
        Global.getCombatEngine().addPlugin(trail);
    }

    @Override
    public void advance(DwellerCombatPlugin plugin, float amount) {
    }

    public DamagingExplosionSpec createExplosionSpec(ShipAPI ship) {
        float damage = EXPLOSION_DAMAGE;
        float radius = DamagingExplosionSpec.getShipExplosionRadius(ship);
        float coreRadius = ship.getCollisionRadius();
        DamagingExplosionSpec spec = new DamagingExplosionSpec(0.1f, radius, coreRadius, damage, 0.0f, CollisionClass.PROJECTILE_NO_FF, CollisionClass.PROJECTILE_NO_FF, 3.0f, 3.0f, 0.5f, 0, new Color(255, 255, 255, 0), new Color(255, 100, 100, 0));
        spec.setDamageType(DamageType.ENERGY);
        spec.setUseDetailedExplosion(false);
        spec.setSoundSetId(null);
        return spec;
    }
}

