/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.threat.FragmentSwarmHullmod;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.impl.combat.threat.SwarmLauncherEffect;
import com.fs.starfarer.api.impl.combat.threat.ThreatShipConstructionScript;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ConstructionSwarmSystemScript
extends BaseShipSystemScript {
    public static int BASE_FRAGMENTS = 50;
    public static float CONSTRUCTION_SWARM_SPEED_MULT = 0.33f;
    public static float BASE_CONSTRUCTION_TIME = 5.0f;
    public static float CONSTRUCTION_TIME_DP_MULT = 1.5f;
    public static float CONSTRUCTION_TIME_OVERSEER_EXTRA = 13.0f;
    public static float NUM_LARGE_AS_FRACTION_OF_DESTROYERS = 0.5f;
    public static float NUM_DESTROYERS_AS_FRACTION_OF_FRIGATES = 0.6f;
    public static int FAST_CONSTRUCTION_FRIGATES_MAX = 2;
    public static float MIN_CR;
    public static float MIN_DP;
    public static int MIN_FRAGMENTS;
    public static int MAX_FRAGMENTS;
    public static List<SwarmConstructableVariant> CONSTRUCTABLE;
    protected static boolean inited;
    protected WeightedRandomPicker<WeaponSlotAPI> slots;
    protected boolean readyToFire = true;
    protected int fastConstructionLeft = FAST_CONSTRUCTION_FRIGATES_MAX;

    static {
        CONSTRUCTABLE = new ArrayList<SwarmConstructableVariant>();
        inited = false;
    }

    public static void init() {
        if (inited) {
            return;
        }
        inited = true;
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.COMBAT_UNIT, "skirmish_unit_Type100"));
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.COMBAT_UNIT, "skirmish_unit_Type101"));
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.COMBAT_UNIT, "assault_unit_Type200"));
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.COMBAT_UNIT, "assault_unit_Type201"));
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.COMBAT_UNIT, "standoff_unit_Type300"));
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.COMBAT_UNIT, "standoff_unit_Type301"));
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.COMBAT_UNIT, "standoff_unit_Type302"));
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.OVERSEER, "overseer_unit_Type250"));
        CONSTRUCTABLE.add(new SwarmConstructableVariant(SwarmConstructableType.HIVE, "hive_unit_Type350"));
        MIN_CR = 1.0f;
        MIN_DP = 100.0f;
        MIN_FRAGMENTS = 500;
        MAX_FRAGMENTS = 0;
        for (SwarmConstructableVariant v : CONSTRUCTABLE) {
            MIN_CR = Math.min(v.cr, MIN_CR);
            MIN_DP = Math.min(v.dp, MIN_DP);
            MIN_FRAGMENTS = Math.min(v.fragments, MIN_FRAGMENTS);
            MAX_FRAGMENTS = Math.max(v.fragments, MAX_FRAGMENTS);
        }
    }

    protected void findSlots(ShipAPI ship) {
        if (this.slots != null) {
            return;
        }
        this.slots = new WeightedRandomPicker();
        for (WeaponSlotAPI slot : ship.getHullSpec().getAllWeaponSlotsCopy()) {
            if (!slot.isSystemSlot()) continue;
            this.slots.add(slot);
        }
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        ConstructionSwarmSystemScript.init();
        if (state == ShipSystemStatsScript.State.IDLE || state == ShipSystemStatsScript.State.COOLDOWN || effectLevel <= 0.0f) {
            this.readyToFire = true;
        }
        if (effectLevel == 1.0f && this.readyToFire) {
            this.readyToFire = false;
            this.launchSwarm(ship);
        }
    }

    protected void launchSwarm(ShipAPI ship) {
        int add;
        this.findSlots(ship);
        String wingId = SwarmLauncherEffect.CONSTRUCTION_SWARM_WING;
        CombatEngineAPI engine = Global.getCombatEngine();
        CombatFleetManagerAPI manager = engine.getFleetManager(ship.getOwner());
        manager.setSuppressDeploymentMessages(true);
        WeaponSlotAPI slot = this.slots.pick();
        Vector2f loc = slot.computePosition(ship);
        float facing = slot.computeMidArcAngle(ship);
        ShipAPI fighter = manager.spawnShipOrWing(wingId, loc, facing, 0.0f, null);
        fighter.getWing().setSourceShip(ship);
        manager.setSuppressDeploymentMessages(false);
        fighter.getMutableStats().getMaxSpeed().modifyMult("construction_swarm", CONSTRUCTION_SWARM_SPEED_MULT);
        Vector2f takeoffVel = Misc.getUnitVectorAtDegreeAngle(facing);
        takeoffVel.scale(fighter.getMaxSpeed() * 1.0f);
        fighter.setDoNotRender(true);
        fighter.setExplosionScale(0.0f);
        fighter.setHulkChanceOverride(0.0f);
        fighter.setImpactVolumeMult(SwarmLauncherEffect.IMPACT_VOLUME_MULT);
        fighter.getArmorGrid().clearComponentMap();
        Vector2f.add((Vector2f)fighter.getVelocity(), (Vector2f)takeoffVel, (Vector2f)fighter.getVelocity());
        RoilingSwarmEffect sourceSwarm = RoilingSwarmEffect.getSwarmFor(ship);
        if (sourceSwarm == null) {
            return;
        }
        RoilingSwarmEffect swarm = FragmentSwarmHullmod.createSwarmFor(fighter);
        swarm.params.flashFringeColor = VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR;
        RoilingSwarmEffect.getFlockingMap().remove(swarm.params.flockingClass, swarm);
        swarm.params.flockingClass = FragmentSwarmHullmod.CONSTRUCTION_SWARM_FLOCKING_CLASS;
        RoilingSwarmEffect.getFlockingMap().add(swarm.params.flockingClass, swarm);
        SwarmConstructableVariant pick = this.pickVariant(ship);
        if (pick == null) {
            return;
        }
        String variantId = pick.variantId;
        ShipVariantAPI variant = Global.getSettings().getVariant(variantId);
        if (variant == null) {
            return;
        }
        ship.setCurrentCR(ship.getCurrentCR() - pick.cr);
        float dp = variant.getHullSpec().getSuppliesToRecover();
        int numFragments = pick.fragments;
        float radiusMult = 1.0f;
        float collisionMult = 2.0f;
        float hpMult = 1.0f;
        float travelTime = 3.0f;
        if (variant.getHullSize() == ShipAPI.HullSize.DESTROYER) {
            radiusMult = 2.0f;
            collisionMult = 4.0f;
            hpMult = radiusMult;
            travelTime = 4.0f;
        } else if (variant.getHullSize() == ShipAPI.HullSize.CRUISER) {
            radiusMult = 3.5f;
            collisionMult = 6.0f;
            hpMult = radiusMult;
            travelTime = 5.0f;
        } else if (variant.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
            radiusMult = 4.0f;
            collisionMult = 8.0f;
            hpMult = radiusMult;
            travelTime = 6.0f;
        }
        for (BoundsAPI.SegmentAPI s : fighter.getExactBounds().getOrigSegments()) {
            s.getP1().scale(collisionMult);
            s.getP2().scale(collisionMult);
            s.set(s.getP1().x, s.getP1().y, s.getP2().x, s.getP2().y);
        }
        fighter.setCollisionRadius(fighter.getCollisionRadius() * collisionMult);
        fighter.setMaxHitpoints(fighter.getMaxHitpoints() * hpMult);
        fighter.setHitpoints(fighter.getHitpoints() * hpMult);
        swarm.params.maxOffset *= radiusMult;
        swarm.params.initialMembers = numFragments;
        swarm.params.baseMembersToMaintain = numFragments;
        boolean overseer = variant.getHullSpec().hasTag("threat_overseer");
        SwarmConstructionData data = new SwarmConstructionData();
        data.variantId = variantId;
        data.constructionTime = BASE_CONSTRUCTION_TIME + dp * CONSTRUCTION_TIME_DP_MULT;
        if (overseer) {
            data.constructionTime += CONSTRUCTION_TIME_OVERSEER_EXTRA;
        }
        data.preConstructionTravelTime = travelTime;
        if (this.fastConstructionLeft > 0) {
            if (pick.size == ShipAPI.HullSize.FRIGATE) {
                --this.fastConstructionLeft;
                data.constructionTime = 2.0f;
            } else {
                this.fastConstructionLeft = 0;
            }
        }
        swarm.custom1 = data;
        int transfer = Math.min(numFragments, sourceSwarm.getNumActiveMembers());
        if (transfer > 0) {
            loc = new Vector2f((ReadableVector2f)takeoffVel);
            loc.scale(0.5f);
            Vector2f.add((Vector2f)loc, (Vector2f)fighter.getLocation(), (Vector2f)loc);
            sourceSwarm.transferMembersTo(swarm, transfer, loc, 100.0f);
        }
        if ((add = numFragments - transfer) > 0) {
            swarm.addMembers(add);
        }
    }

    public SwarmConstructableVariant pickVariant(ShipAPI ship) {
        int wantHives;
        ConstructionSwarmSystemScript.init();
        CombatEngineAPI engine = Global.getCombatEngine();
        CombatFleetManagerAPI manager = engine.getFleetManager(ship.getOwner());
        if (manager == null) {
            return null;
        }
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(ship);
        int fragments = swarm == null ? 0 : swarm.getNumActiveMembers();
        int dpLeft = manager.getMaxStrength() - manager.getCurrStrength();
        float cr = ship.getCurrentCR();
        int overseers = ConstructionSwarmSystemScript.getNumOverseersDeployed(manager);
        int hives = ConstructionSwarmSystemScript.getNumHivesDeployed(manager);
        int fabricators = ConstructionSwarmSystemScript.getNumFabricatorsDeployed(manager);
        float combatWeight = ConstructionSwarmSystemScript.getCombatWeightDeployed(manager);
        int wantOverseers = (int)(combatWeight / 8.0f);
        if (wantOverseers < 1) {
            wantOverseers = 1;
        }
        if ((wantHives = (int)((combatWeight += Math.max(0.0f, (float)fabricators - 1.0f) * 16.0f) / 16.0f)) < 1) {
            wantHives = 1;
        }
        if (wantHives > 2) {
            wantHives = 2;
        }
        wantOverseers -= overseers;
        wantHives -= hives;
        float frigates = ConstructionSwarmSystemScript.getCombatDeployed(manager, ShipAPI.HullSize.FRIGATE);
        float destroyers = ConstructionSwarmSystemScript.getCombatDeployed(manager, ShipAPI.HullSize.DESTROYER);
        float cruisers = ConstructionSwarmSystemScript.getCombatDeployed(manager, ShipAPI.HullSize.CRUISER);
        float capitals = ConstructionSwarmSystemScript.getCombatDeployed(manager, ShipAPI.HullSize.CAPITAL_SHIP);
        float large = cruisers + capitals;
        if (frigates >= 2.0f) {
            this.fastConstructionLeft = 0;
        }
        CountingMap<ShipAPI.HullSize> numCombatVariants = new CountingMap<ShipAPI.HullSize>();
        for (SwarmConstructableVariant curr : CONSTRUCTABLE) {
            if (curr.type != SwarmConstructableType.COMBAT_UNIT) continue;
            numCombatVariants.add(curr.size);
        }
        WeightedRandomPicker<SwarmConstructableVariant> hivePicker = new WeightedRandomPicker<SwarmConstructableVariant>();
        WeightedRandomPicker<SwarmConstructableVariant> overseerPicker = new WeightedRandomPicker<SwarmConstructableVariant>();
        WeightedRandomPicker<SwarmConstructableVariant> smallPicker = new WeightedRandomPicker<SwarmConstructableVariant>();
        WeightedRandomPicker<SwarmConstructableVariant> mediumPicker = new WeightedRandomPicker<SwarmConstructableVariant>();
        WeightedRandomPicker<SwarmConstructableVariant> largePicker = new WeightedRandomPicker<SwarmConstructableVariant>();
        for (SwarmConstructableVariant curr : CONSTRUCTABLE) {
            if (curr.dp > (float)dpLeft || curr.cr > cr || curr.fragments > fragments) continue;
            if (curr.type == SwarmConstructableType.HIVE) {
                hivePicker.add(curr, 1.0f / curr.dp);
                continue;
            }
            if (curr.type == SwarmConstructableType.OVERSEER) {
                overseerPicker.add(curr, 1.0f / curr.dp);
                continue;
            }
            float wMult = 1.0f / Math.max(1.0f, (float)numCombatVariants.getCount(curr.size));
            if (curr.size == ShipAPI.HullSize.FRIGATE) {
                smallPicker.add(curr, 1.0f / curr.dp * wMult);
                continue;
            }
            if (curr.size == ShipAPI.HullSize.DESTROYER) {
                mediumPicker.add(curr, 1.0f / curr.dp * wMult);
                continue;
            }
            largePicker.add(curr, 1.0f / curr.dp * wMult);
        }
        if (frigates <= 1.0f && !smallPicker.isEmpty()) {
            return (SwarmConstructableVariant)smallPicker.pick();
        }
        if (wantOverseers > 0 || wantHives > 0) {
            if (wantOverseers >= wantHives && !overseerPicker.isEmpty()) {
                return (SwarmConstructableVariant)overseerPicker.pick();
            }
            if (!hivePicker.isEmpty()) {
                return (SwarmConstructableVariant)hivePicker.pick();
            }
        }
        if (large <= destroyers * NUM_LARGE_AS_FRACTION_OF_DESTROYERS && !largePicker.isEmpty()) {
            return (SwarmConstructableVariant)largePicker.pick();
        }
        if (destroyers <= frigates * NUM_DESTROYERS_AS_FRACTION_OF_FRIGATES && !mediumPicker.isEmpty()) {
            return (SwarmConstructableVariant)mediumPicker.pick();
        }
        return (SwarmConstructableVariant)smallPicker.pick();
    }

    public static boolean constructionSwarmWillBuild(ShipAPI ship, String tag, ShipAPI.HullSize size) {
        if (!ship.isFighter() || ship.hasTag(ThreatShipConstructionScript.SWARM_CONSTRUCTING_SHIP)) {
            return false;
        }
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(ship);
        if (swarm == null) {
            return false;
        }
        if (swarm.custom1 instanceof SwarmConstructionData) {
            SwarmConstructionData data = (SwarmConstructionData)swarm.custom1;
            ShipVariantAPI v = Global.getSettings().getVariant(data.variantId);
            if (v.getHullSpec().hasTag(tag)) {
                return size == null || v.getHullSize() == size;
            }
        }
        return false;
    }

    public static int getNumFabricatorsDeployed(CombatFleetManagerAPI manager) {
        ConstructionSwarmSystemScript.init();
        int count = 0;
        for (DeployedFleetMemberAPI dfm : manager.getDeployedCopyDFM()) {
            ShipAPI ship = dfm.getShip();
            if (ship == null || !ship.getHullSpec().hasTag("threat_fabricator")) continue;
            ++count;
        }
        return count;
    }

    public static int getNumOverseersDeployed(CombatFleetManagerAPI manager) {
        ConstructionSwarmSystemScript.init();
        int count = 0;
        for (DeployedFleetMemberAPI dfm : manager.getDeployedCopyDFM()) {
            ShipAPI ship = dfm.getShip();
            if (ship == null) continue;
            if (ConstructionSwarmSystemScript.constructionSwarmWillBuild(ship, "threat_overseer", null)) {
                ++count;
                continue;
            }
            if (ship.isFighter() || !ship.getHullSpec().hasTag("threat_overseer")) continue;
            ++count;
        }
        return count;
    }

    public static int getNumHivesDeployed(CombatFleetManagerAPI manager) {
        ConstructionSwarmSystemScript.init();
        int count = 0;
        for (DeployedFleetMemberAPI dfm : manager.getDeployedCopyDFM()) {
            ShipAPI ship = dfm.getShip();
            if (ship == null) continue;
            if (ConstructionSwarmSystemScript.constructionSwarmWillBuild(ship, "threat_hive", null)) {
                ++count;
                continue;
            }
            if (ship.isFighter() || !ship.getHullSpec().hasTag("threat_hive")) continue;
            ++count;
        }
        return count;
    }

    public static float getCombatWeightDeployed(CombatFleetManagerAPI manager) {
        ConstructionSwarmSystemScript.init();
        float weight = 0.0f;
        for (DeployedFleetMemberAPI dfm : manager.getDeployedCopyDFM()) {
            ShipAPI ship = dfm.getShip();
            if (ship == null) continue;
            if (ship.isFighter() && !ship.hasTag(ThreatShipConstructionScript.SWARM_CONSTRUCTING_SHIP)) {
                RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(ship);
                if (swarm == null || !(swarm.custom1 instanceof SwarmConstructionData)) continue;
                SwarmConstructionData data = (SwarmConstructionData)swarm.custom1;
                ShipVariantAPI v = Global.getSettings().getVariant(data.variantId);
                if (!v.getHullSpec().hasTag("threat_combat")) continue;
                switch (v.getHullSize()) {
                    case CAPITAL_SHIP: {
                        weight += 8.0f;
                        break;
                    }
                    case CRUISER: {
                        weight += 4.0f;
                        break;
                    }
                    case DESTROYER: {
                        weight += 2.0f;
                        break;
                    }
                    case FRIGATE: {
                        weight += 1.0f;
                        break;
                    }
                    case FIGHTER: {
                        weight += 1.0f;
                    }
                }
                continue;
            }
            if (!ship.getHullSpec().hasTag("threat_combat")) continue;
            weight += Misc.getShipWeight(ship, false);
        }
        return weight;
    }

    public static int getCombatDeployed(CombatFleetManagerAPI manager, ShipAPI.HullSize size) {
        ConstructionSwarmSystemScript.init();
        int count = 0;
        for (DeployedFleetMemberAPI dfm : manager.getDeployedCopyDFM()) {
            ShipAPI ship = dfm.getShip();
            if (ship == null) continue;
            if (ConstructionSwarmSystemScript.constructionSwarmWillBuild(ship, "threat_combat", size)) {
                ++count;
                continue;
            }
            if (ship.isFighter() || ship.getHullSize() != size || !ship.getHullSpec().hasTag("threat_combat")) continue;
            ++count;
        }
        return count;
    }

    public static int getFragmentCost(float dp, ShipAPI.HullSize size) {
        float numMult = 1.0f * dp / 5.0f;
        if (size == ShipAPI.HullSize.DESTROYER) {
            numMult = 2.0f * dp / 20.0f;
        } else if (size == ShipAPI.HullSize.CRUISER) {
            numMult = 3.0f * dp / 20.0f;
        } else if (size == ShipAPI.HullSize.CAPITAL_SHIP) {
            numMult = 5.0f * dp / 40.0f;
        }
        return Math.round((float)BASE_FRAGMENTS * numMult);
    }

    @Override
    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        ConstructionSwarmSystemScript.init();
        if (system.isOutOfAmmo()) {
            return null;
        }
        if (system.getState() != ShipSystemAPI.SystemState.IDLE) {
            return null;
        }
        if (!this.enoughFragments(system, ship)) {
            return "LOW FRAGMENTS";
        }
        if (!this.enoughDP(system, ship)) {
            return "LOW DP";
        }
        if (!this.enoughCR(system, ship)) {
            return "LOW CR";
        }
        return "READY";
    }

    public boolean enoughCR(ShipSystemAPI system, ShipAPI ship) {
        return ship.getCurrentCR() >= MIN_CR;
    }

    public boolean enoughDP(ShipSystemAPI system, ShipAPI ship) {
        CombatEngineAPI engine = Global.getCombatEngine();
        CombatFleetManagerAPI manager = engine.getFleetManager(ship.getOwner());
        if (manager == null) {
            return true;
        }
        int dpLeft = manager.getMaxStrength() - manager.getCurrStrength();
        for (DeployedFleetMemberAPI dfm : manager.getDeployedCopyDFM()) {
            RoilingSwarmEffect swarm;
            ShipAPI ship2 = dfm.getShip();
            if (ship2 == null || !ship2.isFighter() || ship2.hasTag(ThreatShipConstructionScript.SWARM_CONSTRUCTING_SHIP) || (swarm = RoilingSwarmEffect.getSwarmFor(ship2)) == null || !(swarm.custom1 instanceof SwarmConstructionData)) continue;
            SwarmConstructionData data = (SwarmConstructionData)swarm.custom1;
            ShipVariantAPI v = Global.getSettings().getVariant(data.variantId);
            dpLeft = (int)((float)dpLeft - v.getHullSpec().getSuppliesToRecover());
        }
        return (float)dpLeft >= MIN_DP;
    }

    public boolean enoughFragments(ShipSystemAPI system, ShipAPI ship) {
        int required;
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(ship);
        int active = swarm == null ? 0 : swarm.getNumActiveMembers();
        return active >= (required = MIN_FRAGMENTS);
    }

    @Override
    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        ConstructionSwarmSystemScript.init();
        return this.enoughFragments(system, ship) && this.enoughDP(system, ship) && this.enoughCR(system, ship);
    }

    public static enum SwarmConstructableType {
        COMBAT_UNIT,
        OVERSEER,
        HIVE;

    }

    public static class SwarmConstructableVariant {
        public SwarmConstructableType type;
        public String variantId;
        public float cr;
        public float dp;
        public int fragments;
        public ShipAPI.HullSize size;

        public SwarmConstructableVariant(SwarmConstructableType type, String variantId) {
            this.type = type;
            this.variantId = variantId;
            ShipVariantAPI v = Global.getSettings().getVariant(variantId);
            this.dp = v.getHullSpec().getSuppliesToRecover();
            this.size = v.getHullSize();
            this.cr = 0.01f;
            if (v.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                this.cr = 0.02f;
            } else if (v.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                this.cr = 0.04f;
            } else if (v.getHullSize() == ShipAPI.HullSize.CRUISER) {
                this.cr = 0.06f;
            } else if (v.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
                this.cr = 0.1f;
            }
            if (type == SwarmConstructableType.HIVE) {
                this.cr += 0.02f;
            }
            if (type == SwarmConstructableType.OVERSEER) {
                this.cr += 0.01f;
            }
            this.fragments = ConstructionSwarmSystemScript.getFragmentCost(this.dp, this.size);
        }
    }

    public static class SwarmConstructionData {
        public String variantId;
        public float constructionTime = 10.0f;
        public float preConstructionTravelTime = 3.0f;
    }
}

