/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.plugins.impl;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.GenericPluginManagerAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.plugins.BuildObjectiveTypePicker;

public class CoreBuildObjectiveTypePicker
implements BuildObjectiveTypePicker,
GenericPluginManagerAPI.GenericPlugin {
    @Override
    public String pickObjectiveToBuild(BuildObjectiveTypePicker.BuildObjectiveParams params) {
        CampaignFleetAPI fleet = params.fleet;
        FactionAPI faction = params.faction;
        SectorEntityToken stableLoc = params.stableLoc;
        boolean hasComm = false;
        boolean hasSensor = false;
        boolean hasNav = false;
        for (SectorEntityToken curr : stableLoc.getContainingLocation().getEntitiesWithTag("objective")) {
            if (curr.getFaction() != faction && !curr.getFaction().isHostileTo(faction)) continue;
            hasComm |= curr.hasTag("comm_relay");
            hasSensor |= curr.hasTag("sensor_array");
            hasNav |= curr.hasTag("nav_buoy");
        }
        if (faction.getCustomBoolean("pirateBehavior")) {
            if (!hasSensor && !hasNav) {
                if ((float)Math.random() > 0.5f) {
                    return "nav_buoy_makeshift";
                }
                return "sensor_array_makeshift";
            }
            if (!hasSensor) {
                return "sensor_array_makeshift";
            }
            if (!hasNav) {
                return "nav_buoy_makeshift";
            }
            if (!hasComm) {
                return "comm_relay_makeshift";
            }
        } else {
            if (!hasComm) {
                return "comm_relay_makeshift";
            }
            if (!hasNav) {
                return "nav_buoy_makeshift";
            }
            if (!hasSensor) {
                return "sensor_array_makeshift";
            }
        }
        return null;
    }

    @Override
    public int getHandlingPriority(Object params) {
        if (params instanceof BuildObjectiveTypePicker.BuildObjectiveParams) {
            return 0;
        }
        return -1;
    }
}

