/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;

public class CommodityIconCounts {
    protected CommodityOnMarketAPI com;
    public int available;
    public int production;
    public int demand;
    public int nonDemandExport;
    public int deficit;
    public int imports;
    public int demandMetWithLocal;
    public int demandMet;
    public int globalExport;
    public int inFactionOnlyExport;
    public int canNotExport;
    public int extra;

    public CommodityIconCounts(CommodityOnMarketAPI com) {
        int aboveMax;
        this.com = com;
        int shippingGlobal = Global.getSettings().getShippingCapacity(com.getMarket(), false);
        int shippingInFaction = Global.getSettings().getShippingCapacity(com.getMarket(), true);
        this.available = com.getAvailable();
        this.production = com.getMaxSupply();
        this.production = Math.min(this.production, this.available);
        int export = 0;
        this.demand = com.getMaxDemand();
        export = Math.min(this.production, shippingGlobal);
        this.extra = this.available - Math.max(export, this.demand);
        if (this.extra < 0) {
            this.extra = 0;
        }
        this.deficit = this.demand - this.available;
        this.demandMet = Math.min(this.available, this.demand);
        this.demandMetWithLocal = Math.min(this.available, this.production) - this.extra;
        this.imports = this.available - this.production;
        this.nonDemandExport = 0;
        if (this.demandMetWithLocal > this.demand && this.demand > 0) {
            this.nonDemandExport = this.demandMetWithLocal - this.demand;
            this.demandMetWithLocal = this.demand;
        }
        this.globalExport = this.production;
        this.inFactionOnlyExport = 0;
        this.canNotExport = 0;
        if (this.globalExport > shippingGlobal) {
            this.inFactionOnlyExport = this.globalExport - shippingGlobal;
            this.globalExport = shippingGlobal;
        }
        if (this.globalExport + this.inFactionOnlyExport > shippingInFaction) {
            this.canNotExport = this.globalExport + this.inFactionOnlyExport - shippingInFaction;
            this.inFactionOnlyExport -= this.canNotExport;
        }
        if ((aboveMax = Math.max(this.demandMetWithLocal, this.globalExport) + this.canNotExport + this.inFactionOnlyExport - (this.available - this.imports)) > 0) {
            this.inFactionOnlyExport -= aboveMax;
            if (this.inFactionOnlyExport < 0) {
                this.canNotExport += this.inFactionOnlyExport;
            }
        }
        if (this.inFactionOnlyExport < 0) {
            this.inFactionOnlyExport = 0;
        }
        if (this.canNotExport < 0) {
            this.canNotExport = 0;
        }
        if (this.nonDemandExport < 0) {
            this.nonDemandExport = 0;
        }
        if (this.imports < 0) {
            this.imports = 0;
        }
        if (this.deficit < 0) {
            this.deficit = 0;
        }
        if (this.demandMetWithLocal < 0) {
            this.demandMetWithLocal = 0;
        }
    }
}

