/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.GhostBehaviorInterrupt;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import java.util.ArrayList;
import java.util.List;

public class BaseGhostBehavior
implements GhostBehavior {
    protected float duration;
    protected List<GhostBehaviorInterrupt> interrupts = new ArrayList<GhostBehaviorInterrupt>();

    public BaseGhostBehavior(float duration) {
        this.duration = duration;
    }

    @Override
    public boolean isDone() {
        return this.duration <= 0.0f;
    }

    @Override
    public void advance(float amount, SensorGhost ghost) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.duration -= days;
        for (GhostBehaviorInterrupt curr : this.interrupts) {
            curr.advance(amount, ghost, this);
            if (!curr.shouldInterruptBehavior(ghost, this)) continue;
            this.end();
            break;
        }
    }

    public void end() {
        this.duration = 0.0f;
    }

    @Override
    public void addInterrupt(GhostBehaviorInterrupt interrupt) {
        this.interrupts.add(interrupt);
    }
}

