/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.intel.AnalyzeEntityMissionIntel;
import com.fs.starfarer.api.impl.campaign.intel.GenericMissionManager;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;

public class AnalyzeEntityIntelCreator
implements GenericMissionManager.GenericMissionCreator {
    protected transient WeightedRandomPicker<SectorEntityToken> entityPicker = null;

    @Override
    public EveryFrameScript createMissionIntel() {
        SectorEntityToken entity = this.pickEntity();
        if (entity == null) {
            return null;
        }
        return new AnalyzeEntityMissionIntel(entity);
    }

    @Override
    public float getMissionFrequencyWeight() {
        return 15.0f;
    }

    protected void initPicker() {
        this.entityPicker = new WeightedRandomPicker();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (system.hasTag("theme_derelict_mothership") || system.hasTag("theme_derelict_cryosleeper") || !system.hasTag("theme_derelict_probes") && !system.hasTag("theme_ruins") && !system.hasTag("theme_remnant_destroyed")) continue;
            float w = 1.0f;
            if (system.hasTag("theme_derelict_probes")) {
                w = 3.0f;
                if (Global.getSector().isInNewGameAdvance()) {
                    w = 5.0f;
                }
            }
            for (SectorEntityToken entity : system.getEntitiesWithTag("salvageable")) {
                if (entity.hasTag("expires") || Misc.isImportantForReason(entity.getMemoryWithoutUpdate(), "aem") || entity.hasTag("not_random_mission_target") || entity.getMemoryWithoutUpdate() != null && entity.getMemoryWithoutUpdate().getBoolean("$ttWeaponsCache") || entity.getCircularOrbitRadius() > 10000.0f || entity.getContainingLocation() != null && entity.getContainingLocation().hasTag("theme_hidden")) continue;
                this.entityPicker.add(entity, w);
            }
        }
    }

    protected void prunePicker() {
        for (SectorEntityToken item : new ArrayList<SectorEntityToken>(this.entityPicker.getItems())) {
            if (item.isAlive()) continue;
            this.entityPicker.remove(item);
        }
    }

    protected SectorEntityToken pickEntity() {
        if (this.entityPicker == null) {
            this.initPicker();
        }
        this.prunePicker();
        SectorEntityToken entity = this.entityPicker.pick();
        for (EveryFrameScript s : GenericMissionManager.getInstance().getActive()) {
            AnalyzeEntityMissionIntel intel;
            if (!(s instanceof AnalyzeEntityMissionIntel) || entity != (intel = (AnalyzeEntityMissionIntel)s).getEntity()) continue;
            return null;
        }
        return entity;
    }
}

