/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.PerseanLeagueHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.missions.DelayedFleetEncounter;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class GensHannanMachinations
extends BaseIntelPlugin {
    public static String AGREED_TO_PAY_HOUSE_HANNAN_AGAIN = "$agreedToPayHouseHannanAgain";
    public static String MACHINATIONS_IN_EFFECT = "$houseHannanMachinationsInEffect";
    public static String KEY = "$plGHMachinations_ref";
    public static String UPDATE_PARAM_START = "update_param_start";
    public static String UPDATE_PARAM_MACHINATION = "update_param_machination";
    public static float PROB_ACTION_TAKEN = 0.5f;
    public static float PROB_BOUNTY_HUNTER = 0.25f;
    protected FactionAPI faction = null;
    protected IntervalUtil interval = new IntervalUtil(10.0f, 110.0f);
    protected Random random = new Random();
    protected int repDamageRemaining = 100;
    protected ReputationActionResponsePlugin.ReputationAdjustmentResult recent = null;
    protected boolean recentIsBountyHunter = false;
    protected long recentTimestamp = 0L;

    public static boolean isMachinationsInEffect() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean(MACHINATIONS_IN_EFFECT);
    }

    public static boolean isAgreedToPayHouseHannanAgain() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(AGREED_TO_PAY_HOUSE_HANNAN_AGAIN);
    }

    public static void setAgreedToPayHouseHannanAgain(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(AGREED_TO_PAY_HOUSE_HANNAN_AGAIN, value);
        if (!value) {
            Global.getSector().getPlayerMemoryWithoutUpdate().unset(AGREED_TO_PAY_HOUSE_HANNAN_AGAIN);
        }
    }

    public static boolean canRemakeDealWithHouseHannan() {
        return !GensHannanMachinations.isAgreedToPayHouseHannanAgain() && PerseanLeagueMembership.isLeagueMember() && GensHannanMachinations.isMachinationsInEffect() && !PerseanLeagueMembership.isPayingHouseHannan();
    }

    public static GensHannanMachinations get() {
        return (GensHannanMachinations)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public GensHannanMachinations(InteractionDialogAPI dialog) {
        if (GensHannanMachinations.get() != null) {
            return;
        }
        this.faction = Global.getSector().getFaction("persean");
        this.setImportant(true);
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        Global.getSector().addScript(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getMemoryWithoutUpdate().set(MACHINATIONS_IN_EFFECT, true);
        Global.getSector().getIntelManager().addIntel(this, true);
        this.sendUpdateIfPlayerHasIntel((Object)dialog, text);
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.isEnded() || this.isEnding()) {
            return;
        }
        float days = Misc.getDays(amount);
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        if (PerseanLeagueHostileActivityFactor.getKazeron(false) == null) {
            this.setImportant(false);
            this.endAfterDelay();
            return;
        }
        if (this.random.nextFloat() > PROB_ACTION_TAKEN) {
            return;
        }
        if (GensHannanMachinations.isAgreedToPayHouseHannanAgain() && this.random.nextFloat() < PROB_BOUNTY_HUNTER) {
            this.sendBountyHunter();
            return;
        }
        int repLoss = 5 + this.random.nextInt(11);
        repLoss = Math.min(repLoss, this.repDamageRemaining);
        RepLevel limit = RepLevel.NEUTRAL;
        if (GensHannanMachinations.isAgreedToPayHouseHannanAgain()) {
            limit = RepLevel.VENGEFUL;
        }
        ReputationActionResponsePlugin.ReputationAdjustmentResult result = Misc.adjustRep("persean", (float)repLoss * -0.01f, limit, null, false, false);
        if ((repLoss = Math.min(repLoss, Math.abs(Math.round(result.delta * 100.0f)))) > 0) {
            this.repDamageRemaining -= Math.abs(repLoss);
            this.recent = result;
            this.recentTimestamp = Global.getSector().getClock().getTimestamp();
            this.recentIsBountyHunter = false;
            this.sendUpdateIfPlayerHasIntel((Object)UPDATE_PARAM_MACHINATION, false);
        }
        if ((float)this.repDamageRemaining <= 0.0f) {
            this.setImportant(false);
            this.endAfterDelay();
        }
    }

    protected void sendBountyHunter() {
        this.recent = new ReputationActionResponsePlugin.ReputationAdjustmentResult(0.0f);
        this.recentTimestamp = Global.getSector().getClock().getTimestamp();
        this.recentIsBountyHunter = true;
        DelayedFleetEncounter e = new DelayedFleetEncounter(this.random, "GensHannanMachinations");
        e.setDelayShort();
        e.setLocationInnerSector(true, "independent");
        e.beginCreate();
        e.triggerCreateFleet(HubMissionWithTriggers.FleetSize.HUGE, HubMissionWithTriggers.FleetQuality.SMOD_1, "persean", "mercBountyHunter", new Vector2f());
        e.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        e.triggerSetFleetFaction("independent");
        e.triggerMakeNoRepImpact();
        e.triggerSetStandardAggroInterceptFlags();
        e.triggerMakeFleetIgnoreOtherFleets();
        e.triggerSetFleetGenericHailPermanent("GensHannanMachinationsHail");
        e.endCreate();
        this.sendUpdateIfPlayerHasIntel((Object)UPDATE_PARAM_MACHINATION, false);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        Global.getSector().getMemoryWithoutUpdate().unset(MACHINATIONS_IN_EFFECT);
    }

    @Override
    protected void notifyEnded() {
        Global.getSector().removeScript(this);
        super.notifyEnded();
    }

    protected Object readResolve() {
        return this;
    }

    public String getBaseName() {
        return "Gens Hannan Machinations";
    }

    @Override
    public String getName() {
        String postfix = "";
        return String.valueOf(this.getBaseName()) + postfix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        boolean isUpdate;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean bl = isUpdate = this.getListInfoParam() != null;
        if (this.recent != null) {
            int days = (int)Global.getSector().getClock().getElapsedDaysSince(this.recentTimestamp);
            if ((float)days > 60.0f) {
                this.recentTimestamp = 0L;
                this.recent = null;
                this.recentIsBountyHunter = false;
            } else if (this.recentIsBountyHunter) {
                info.addPara("A bounty hunter was recently hired to eliminate you", tc, initPad);
            } else {
                CoreReputationPlugin.addAdjustmentMessage(this.recent.delta, this.faction, null, null, null, info, tc, isUpdate, initPad);
                if (!isUpdate) {
                    String daysStr = days == 1 ? "day" : "days";
                    info.addPara("%s " + daysStr + " ago", 0.0f, tc, h, "" + days);
                }
            }
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        info.addPara("You've gone back on a deal with Gens Hannan, and they work behind the scenesto damage your standing with the Persean League, and worse.", opad, this.getFaction().getBaseUIColor(), "Persean League");
        if (this.isEnding() || this.isEnded()) {
            info.addPara("You sources indicate that the further action by Gens Hannan is unlikely at this time.", opad);
        } else {
            PersonAPI person;
            info.addPara("It's likely that at some point this work will become less of a priority, but for now, their agents go about ruining your reputation with commendable vigor and discretion.", opad);
            if (GensHannanMachinations.isAgreedToPayHouseHannanAgain()) {
                info.addPara("There is no hope of reconciliation, and the gloves are off. There is a possibility of your being brought into active hostility with the League, and of bounty hunters being hired and equipped for the job.", opad, Misc.getNegativeHighlightColor(), "active hostility with the League", "bounty hunters");
            } else if (!GensHannanMachinations.canRemakeDealWithHouseHannan()) {
                info.addPara("You are not considered trustworthy enough for Gens Hannan to deal with again, and these actions are in the way of setting an example for others.", opad);
            } else if (this.getMapLocation(null) != null && (person = People.getPerson(People.REYNARD_HANNAN)) != null) {
                TooltipMakerAPI sub = info.beginImageWithText(person.getPortraitSprite(), 64.0f);
                sub.addPara("You may be able to negotiate an end to this by going to Kazeron and speaking with Reynard Hannan.", 0.0f, h, "speaking with Reynard Hannan");
                info.addImageWithText(opad);
            }
        }
        if (this.recent != null) {
            info.addSectionHeading("Recent events", this.getFaction().getBaseUIColor(), this.getFaction().getDarkUIColor(), Alignment.MID, opad);
            this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        }
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(false);
        if (kazeron != null) {
            return kazeron.getPrimaryEntity();
        }
        return null;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public void endMachinations(TextPanelAPI text) {
        if (!this.isEnded() && !this.isEnding()) {
            this.setImportant(false);
            this.endImmediately();
        }
    }
}

