/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class HAColonyDefensesFactor
extends BaseEventFactor {
    public static float PATROL_HQ_MULT = 0.9f;
    public static float MILITARY_BASE_MULT = 0.7f;
    public static float HIGH_COMMAND_MULT = 0.5f;

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                Color h = Misc.getHighlightColor();
                float opad = 10.0f;
                tooltip.addPara("The presence of military infrastructure slows down event progress, but does not actually stop or reverse it. The highest level military structure present on any of your colonies determines the multiplier.", 0.0f);
                HAColonyDefenseData data = HAColonyDefensesFactor.this.getDefenseData(null);
                tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, "Infrastructure", Float.valueOf(200.0f), "Multiplier", Float.valueOf(100.0f));
                Color c = Misc.getGrayColor();
                Color c2 = Misc.getGrayColor();
                if (data.industry != null && data.industry.getId().equals("patrolhq")) {
                    c = Misc.getHighlightColor();
                    c2 = Misc.getPositiveHighlightColor();
                }
                tooltip.addRow(c, "Patrol HQ", c2, "\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(PATROL_HQ_MULT));
                c = Misc.getGrayColor();
                c2 = Misc.getGrayColor();
                if (data.industry != null && data.industry.getId().equals("militarybase")) {
                    c = Misc.getHighlightColor();
                    c2 = Misc.getPositiveHighlightColor();
                }
                tooltip.addRow(c, "Military Base", c2, "\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(MILITARY_BASE_MULT));
                c = Misc.getGrayColor();
                c2 = Misc.getGrayColor();
                if (data.industry != null && data.industry.getId().equals("highcommand")) {
                    c = Misc.getHighlightColor();
                    c2 = Misc.getPositiveHighlightColor();
                }
                tooltip.addRow(c, "High Command", c2, "\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(HIGH_COMMAND_MULT));
                tooltip.addTable("None", 0, opad);
                tooltip.addSpacer(5.0f);
                if (data.industry != null && data.market != null) {
                    tooltip.addPara("You have a %s at %s.", opad, h, data.industry.getCurrentName(), data.market.getName());
                }
            }
        };
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        return true;
    }

    @Override
    public float getAllProgressMult(BaseEventIntel intel) {
        HAColonyDefenseData data = this.getDefenseData(intel);
        return data.mult;
    }

    @Override
    public Color getProgressColor(BaseEventIntel intel) {
        HAColonyDefenseData data = this.getDefenseData(intel);
        if (data.mult < 1.0f) {
            return Misc.getPositiveHighlightColor();
        }
        if (data.mult > 1.0f) {
            return Misc.getNegativeHighlightColor();
        }
        return Misc.getHighlightColor();
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        HAColonyDefenseData data = this.getDefenseData(intel);
        if (data.mult != 1.0f) {
            return "\u00d7" + Misc.getRoundedValueMaxOneAfterDecimal(data.mult);
        }
        return "";
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        HAColonyDefenseData data = this.getDefenseData(intel);
        if (data.industry == null) {
            return "Military infrastructure";
        }
        return data.industry.getCurrentName();
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getDefenseData((BaseEventIntel)intel).market == null) {
            return Misc.getGrayColor();
        }
        return super.getDescColor(intel);
    }

    public HAColonyDefenseData getDefenseData(BaseEventIntel intel) {
        HAColonyDefenseData best = new HAColonyDefenseData();
        List<MarketAPI> markets = Misc.getPlayerMarkets(false);
        for (MarketAPI market : markets) {
            float mult = 1.0f;
            Industry industry = null;
            if (market.hasFunctionalIndustry("patrolhq")) {
                mult = PATROL_HQ_MULT;
                industry = market.getIndustry("patrolhq");
            }
            if (Misc.isMilitary(market)) {
                if (market.hasFunctionalIndustry("highcommand")) {
                    mult = HIGH_COMMAND_MULT;
                    industry = market.getIndustry("highcommand");
                } else {
                    mult = MILITARY_BASE_MULT;
                    industry = market.getIndustry("militarybase");
                }
            }
            if (industry == null || !(mult < best.mult)) continue;
            best.market = market;
            best.industry = industry;
            best.mult = mult;
        }
        return best;
    }

    public static class HAColonyDefenseData {
        public MarketAPI market;
        public Industry industry;
        public float mult = 1.0f;
    }
}

