/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.rulecmd.KantaCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Range;

public class KantasWrathPirateActivityCause2
extends BaseHostileActivityCause2 {
    public static float MAX_MAG = 0.3f;
    public static float MAX_MAG_FOR_REL = 0.15f;
    public static float MAX_MAG_FOR_BLUFFS = 0.15f;
    public static float MAG_PER_BLUFF = 0.05f;

    public KantasWrathPirateActivityCause2(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getTooltip() {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                tooltip.addPara("Warlord Kanta, the feared pirate queen, is not pleased with you. Lesser pirates see attacking your interests as a way to curry favor with her.", 0.0f);
            }
        };
    }

    @Override
    public int getProgress() {
        float mag = this.getMagnitudeContribution(null);
        if (mag <= 0.0f) {
            return 0;
        }
        if ((mag /= MAX_MAG) > 1.0f) {
            mag = 1.0f;
        }
        Range r = new Range("kantasWrathPoints");
        return r.interpInt(mag);
    }

    @Override
    public String getDesc() {
        return "Kanta's wrath";
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (KantaCMD.playerHasProtection()) {
            return 0.0f;
        }
        PersonAPI kanta = People.getPerson(People.KANTA);
        if (kanta == null) {
            return 0.0f;
        }
        float rep = kanta.getRelToPlayer().getRel();
        float mag = -1.0f * rep * MAX_MAG_FOR_REL;
        int bluffs = Global.getSector().getCharacterData().getMemoryWithoutUpdate().getInt("$kantaBluffs");
        if ((mag += MAG_PER_BLUFF * (float)bluffs) > MAX_MAG) {
            mag = MAX_MAG;
        }
        mag = (float)Math.round(mag * 100.0f) / 100.0f;
        return mag;
    }
}

