/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.intel.PerseanLeagueMembership;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.EstablishedPolityScript;
import com.fs.starfarer.api.impl.campaign.intel.events.HAKazeronTacBombardmentFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.PerseanLeagueBlockade;
import com.fs.starfarer.api.impl.campaign.intel.group.PerseanLeaguePunitiveExpedition;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class PerseanLeagueHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener,
ColonyPlayerHostileActListener {
    public static final String HASSLE_REASON = "leagueEnforcer";

    public PerseanLeagueHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        if (!PerseanLeagueHostileActivityFactor.checkFactionExists("persean", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Persean League";
    }

    @Override
    public String getNameForThreatList(boolean first) {
        return "Persean League";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("persean").getBaseUIColor();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("A large independent polity is a tantalizing prize for the Persean League, and they will go quite far in exerting pressure for you to join them. League \"enforcer\" fleets prowl your systems, ostensibly to protect the League's interests in \"unclaimed territory\".", 0.0f);
            }
        };
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("persean").getBaseUIColor();
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("perseanLeagueMaxFleets");
    }

    @Override
    public float getSpawnInHyperProbability(StarSystemAPI system) {
        return 0.0f;
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = this.intel.getMarketPresenceFactor(system);
        int difficulty = 0 + (int)Math.max(1.0f, (float)Math.round(f * 4.0f));
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "persean";
        m.createStandardFleet(difficulty += random.nextInt(6), factionId, loc);
        m.triggerSetFleetType(HASSLE_REASON);
        m.triggerSetPatrol();
        m.triggerSetFleetHasslePlayer(HASSLE_REASON);
        m.triggerSetFleetFlag("$leagueEnforcer");
        m.triggerFleetAllowLongPursuit();
        m.triggerMakeLowRepImpact();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            fleet.addScript(new NPCHassler(fleet, system));
        }
        return fleet;
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("persean").getBaseUIColor();
        info.addPara("Impending Persean League blockade", initPad, tc, c, "Persean League");
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Persean League blockade averted", tc, initPad);
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        info.addPara("You've received intel that the Persean League is planning a lengthy blockade of one of your systems. Colonies in that system will suffer a major accessibility penalty for as long as the blockade lasts.", small, Misc.getNegativeHighlightColor(), "major accessibility penalty");
        LabelAPI label = info.addPara("If the blockading force is defeated, your colonies will be viewed as a more stable trading partner, resulting in increased accessibility, and the Persean League will likely abandon further efforts to strong-arm you and be more open to negotiation.", opad);
        label.setHighlight("increased accessibility", "Persean League");
        label.setHighlightColors(Misc.getPositiveHighlightColor(), Global.getSector().getFaction("persean").getBaseUIColor());
        Color c = Global.getSector().getFaction("persean").getBaseUIColor();
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("You go to %s and make an agreement about joining the League", 0.0f, c, "Kazeron");
        info.addPara("%s is tactically bombarded", 0.0f, c, "Kazeron");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("persean").getBaseUIColor());
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("persean").getCrest();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("Persean League blockade", intel, stage);
        }
        return null;
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            if (PerseanLeagueHostileActivityFactor.wasPLEverSatBombardedByPlayer() || PerseanLeagueHostileActivityFactor.getKazeron(true) == null) {
                return 0.0f;
            }
            if (PerseanLeagueBlockade.get() != null) {
                return 0.0f;
            }
            if (PerseanLeaguePunitiveExpedition.get() != null) {
                return 0.0f;
            }
            StarSystemAPI target = PerseanLeagueHostileActivityFactor.findBlockadeTarget(intel, stage);
            MarketAPI source = this.getBlockadeSource(intel, stage, target);
            if (target != null && source != null) {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        StarSystemAPI target = PerseanLeagueHostileActivityFactor.findBlockadeTarget(intel, stage);
        MarketAPI source = this.getBlockadeSource(intel, stage, target);
        if (source == null || target == null) {
            return false;
        }
        stage.rollData = null;
        return this.startBlockade(source, target, stage, this.getRandomizedStageRandom(3));
    }

    public static StarSystemAPI findBlockadeTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        float max = 0.0f;
        StarSystemAPI best = null;
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            float w = intel.getMarketPresenceFactor(system);
            if (!(w > max)) continue;
            max = w;
            best = system;
        }
        return best;
    }

    public MarketAPI getBlockadeSource(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, StarSystemAPI target) {
        return PerseanLeagueHostileActivityFactor.getKazeron(true);
    }

    public static MarketAPI getKazeron(boolean requireMilitaryBase) {
        MarketAPI kazeron = Global.getSector().getEconomy().getMarket("kazeron");
        if (kazeron == null || kazeron.hasCondition("decivilized") || !kazeron.getFactionId().equals("persean")) {
            return null;
        }
        if (requireMilitaryBase) {
            Industry b = kazeron.getIndustry("militarybase");
            if (b == null) {
                b = kazeron.getIndustry("highcommand");
            }
            if (b == null || b.isDisrupted() || !b.isFunctional()) {
                return null;
            }
        }
        return kazeron;
    }

    public static boolean wasPLEverSatBombardedByPlayer() {
        FactionAPI faction = Global.getSector().getFaction("persean");
        if (faction != null) {
            return faction.getMemoryWithoutUpdate().getInt("$numTimesSatBombardedByPlayer") > 0;
        }
        return false;
    }

    public boolean startBlockade(MarketAPI source, StarSystemAPI target, BaseEventIntel.EventStageData stage, Random random) {
        float f;
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 7.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 365.0f;
        params.makeFleetsHostile = false;
        FGBlockadeAction.FGBlockadeParams bParams = new FGBlockadeAction.FGBlockadeParams();
        bParams.where = target;
        bParams.targetFaction = "player";
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        float fleetSizeMult = source.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
        float totalDifficulty = fleetSizeMult * 50.0f * (0.5f + 0.5f * (f = this.intel.getMarketPresenceFactor(target)));
        if (totalDifficulty < 30.0f) {
            return false;
        }
        if (totalDifficulty > 100.0f) {
            totalDifficulty = 100.0f;
        }
        totalDifficulty -= 10.0f;
        totalDifficulty -= 5.0f;
        totalDifficulty -= 4.0f;
        totalDifficulty -= 1.0f;
        totalDifficulty -= 1.0f;
        params.fleetSizes.add(10);
        params.fleetSizes.add(5);
        params.fleetSizes.add(4);
        params.fleetSizes.add(1);
        params.fleetSizes.add(1);
        Random r = this.getRandomizedStageRandom(7);
        while (totalDifficulty > 0.0f) {
            float max = 5.0f;
            float min = 3.0f;
            if (r.nextFloat() > 0.3f) {
                min = (int)Math.min(totalDifficulty, 10.0f);
                max = (int)Math.min(totalDifficulty, 10.0f);
            }
            int diff = Math.round(StarSystemGenerator.getNormalRandom(r, min, max));
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        PerseanLeagueBlockade blockade = new PerseanLeagueBlockade(params, bParams);
        blockade.setListener(this);
        Global.getSector().getIntelManager().addIntel(blockade);
        return true;
    }

    @Override
    public void reportFGIAborted(FleetGroupIntel intel) {
        PerseanLeagueMembership.setDefeatedBlockade(true);
        new EstablishedPolityScript();
    }

    @Override
    public void notifyFactorRemoved() {
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    @Override
    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    @Override
    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
    }

    @Override
    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        BaseEventIntel.EventStageData stage;
        if (PerseanLeagueMembership.isDefeatedBlockadeOrPunEx()) {
            return;
        }
        MarketAPI kazeron = PerseanLeagueHostileActivityFactor.getKazeron(false);
        if (market != null && market == kazeron && (stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT)) != null) {
            int points;
            boolean thisEvent;
            boolean bl = thisEvent = stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this;
            if (!thisEvent && (points = Global.getSettings().getInt("HA_tacBombardKazeron")) > 0) {
                this.intel.addFactor(new HAKazeronTacBombardmentFactor(-points));
            }
        }
    }

    @Override
    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    @Override
    public void advance(float amount) {
        MarketAPI kazeron;
        super.advance(amount);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this && ((kazeron = PerseanLeagueHostileActivityFactor.getKazeron(true)) == null || PerseanLeagueHostileActivityFactor.wasPLEverSatBombardedByPlayer())) {
            this.intel.resetHA_EVENT();
        }
    }
}

