/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.MutableStatWithTempMods;
import com.fs.starfarer.api.impl.campaign.NPCHassler;
import com.fs.starfarer.api.impl.campaign.econ.RecentUnrest;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Sounds;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.BlockadeFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.FGAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadePlanetAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class KnightsOfLuddTakeoverExpedition
extends BlockadeFGI
implements EconomyTickListener {
    public static int STABILITY_PER_MONTH_FULL = 2;
    public static int STABILITY_PER_MONTH_PARTIAL = 1;
    public static float NUM_OTHER_FLEETS_MULT = 0.25f;
    public static final String STABILITY_UPDATE = "stability_update";
    public static final String TAKEOVER_UPDATE = "takeover_update";
    public static final String BLOCKADING = "$KOLT_isBlockading";
    public static final String KOLT_FLEET = "$KOLT_fleet";
    public static final String ARMADA = "$KOLT_armada";
    public static final String PICKET = "$KOLT_picket";
    public static String KEY = "$KOLT_ref";
    protected boolean voluntary;

    public static KnightsOfLuddTakeoverExpedition get() {
        return (KnightsOfLuddTakeoverExpedition)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public KnightsOfLuddTakeoverExpedition(GenericRaidFGI.GenericRaidParams params, FGBlockadeAction.FGBlockadeParams blockadeParams) {
        super(params, blockadeParams);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    @Override
    protected CampaignFleetAPI createFleet(int size, float damage) {
        CampaignFleetAPI fleet;
        Random r = this.getRandom();
        Vector2f loc = this.origin.getLocationInHyperspace();
        FleetCreatorMission m = new FleetCreatorMission(r);
        m.beginFleet();
        m.createFleet(this.params.style, size, this.params.factionId, loc);
        if (size == 10) {
            m.triggerSetFleetDoctrineOther(5, 0);
            m.triggerSetFleetSize(HubMissionWithTriggers.FleetSize.MAXIMUM);
            m.triggerSetFleetSizeFraction(1.4f);
            m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.HIGHER);
        }
        m.triggerSetFleetFlag(KOLT_FLEET);
        m.setFleetSource(this.params.source);
        this.setFleetCreatorQualityFromRoute(m);
        m.setFleetDamageTaken(damage);
        m.triggerSetWarFleet();
        m.triggerMakeLowRepImpact();
        m.triggerMakeAlwaysSpreadTOffHostility();
        if (size >= 8) {
            m.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
            m.triggerFleetAddCommanderSkill("tactical_drills", 1);
            m.triggerFleetAddCommanderSkill("carrier_group", 1);
        }
        if ((fleet = m.createFleet()) != null) {
            if (size >= 8) {
                this.setNeverStraggler(fleet);
            } else {
                fleet.addScript(new NPCHassler(fleet, this.getTargetSystem()));
                fleet.getMemoryWithoutUpdate().set(PICKET, true);
                fleet.setName("Knights of Ludd Watchers");
                fleet.setNoFactionInName(true);
            }
            if (size == 10) {
                fleet.setName("Knights of Ludd Holy Armada");
                fleet.setNoFactionInName(true);
                fleet.getMemoryWithoutUpdate().set(ARMADA, true);
                fleet.getCommander().setRankId(Ranks.SPACE_ADMIRAL);
            }
        }
        return fleet;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.isSpawnedFleets()) {
            if (this.isEnded() || this.isEnding() || this.isAborted() || this.isCurrent(RETURN_ACTION)) {
                for (CampaignFleetAPI curr : this.getFleets()) {
                    curr.getMemoryWithoutUpdate().set(BLOCKADING, false);
                }
                return;
            }
            if (this.isCurrent(PAYLOAD_ACTION)) {
                for (CampaignFleetAPI curr : this.getFleets()) {
                    curr.getMemoryWithoutUpdate().set(BLOCKADING, true);
                }
            }
        }
    }

    @Override
    protected void periodicUpdate() {
        FGBlockadePlanetAction blockade;
        super.periodicUpdate();
        if (this.isEnded() || this.isEnding() || this.isSucceeded() || this.isFailed() || this.isAborted()) {
            return;
        }
        if (HostileActivityEventIntel.get() == null) {
            this.abort();
            return;
        }
        MarketAPI target = this.blockadeParams.specificMarket;
        if (target != null && !target.hasCondition("luddic_majority")) {
            this.finish(false);
            return;
        }
        FGAction action = this.getCurrentAction();
        if (action instanceof FGBlockadeAction) {
            MutableStatWithTempMods stat = HostileActivityEventIntel.get().getNumFleetsStat(this.getTargetSystem());
            stat.addTemporaryModMult(1.0f, "KOLBlockade", null, NUM_OTHER_FLEETS_MULT);
        }
        if (!this.isSpawnedFleets() || this.isSpawning()) {
            return;
        }
        int armada = 0;
        for (CampaignFleetAPI curr : this.getFleets()) {
            if (!curr.getMemoryWithoutUpdate().getBoolean(ARMADA)) continue;
            ++armada;
        }
        if (armada <= 0) {
            this.abort();
        }
        if (action instanceof FGBlockadePlanetAction && (blockade = (FGBlockadePlanetAction)action).getPrimary() != null) {
            for (CampaignFleetAPI curr : this.getFleets()) {
                if (blockade.getPrimary().getContainingLocation() != curr.getContainingLocation() || curr.getMemoryWithoutUpdate().getBoolean(PICKET)) continue;
                curr.getMemoryWithoutUpdate().set("$doNotGetSidetracked", true, 0.4f);
            }
        }
    }

    @Override
    protected String getOfString() {
        return "targeting";
    }

    @Override
    protected GenericRaidFGI.GenericPayloadAction createPayloadAction() {
        FGBlockadePlanetAction action = new FGBlockadePlanetAction(this.blockadeParams, this.params.payloadDays);
        action.setSuccessFractionOverride(0.0f);
        return action;
    }

    @Override
    protected void applyBlockadeCondition() {
    }

    @Override
    protected void unapplyBlockadeCondition() {
    }

    @Override
    protected void addUpdateBulletPoints(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        Object p = this.getListInfoParam();
        if (STABILITY_UPDATE.equals(p)) {
            int penalty = this.getStabilityPenaltyPerMonth();
            MarketAPI target = this.blockadeParams.specificMarket;
            LabelAPI label = info.addPara(String.valueOf(target.getName()) + " stability reduced by %s", initPad, tc, Misc.getHighlightColor(), "" + penalty);
            label.setHighlightColors(target.getFaction().getBaseUIColor(), Misc.getHighlightColor());
            label.setHighlight(target.getName(), "" + penalty);
        } else if (!TAKEOVER_UPDATE.equals(p)) {
            super.addUpdateBulletPoints(info, tc, param, mode, initPad);
        }
    }

    @Override
    protected void addTargetingBulletPoint(TooltipMakerAPI info, Color tc, Object param, IntelInfoPlugin.ListInfoMode mode, float initPad) {
        MarketAPI target = this.blockadeParams.specificMarket;
        LabelAPI label = info.addPara("Targeting " + target.getName(), tc, initPad);
        label.setHighlightColors(target.getFaction().getBaseUIColor());
        label.setHighlight(target.getName());
    }

    @Override
    protected void addBasicDescription(TooltipMakerAPI info, float width, float height, float opad) {
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        MarketAPI target = this.blockadeParams.specificMarket;
        StarSystemAPI system = this.raidAction.getWhere();
        String noun = this.getNoun();
        LabelAPI label = info.addPara(String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefixAOrAn())) + " %s " + noun + " " + this.getOfString() + " " + target.getName() + " in the " + system.getNameWithLowercaseType() + ".", opad, this.faction.getBaseUIColor(), this.faction.getPersonNamePrefix());
        label.setHighlightColors(this.faction.getBaseUIColor(), target.getFaction().getBaseUIColor());
        label.setHighlight(this.faction.getPersonNamePrefix(), target.getName());
    }

    @Override
    protected void addAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        FactionAPI faction = this.getFaction();
        MarketAPI target = this.blockadeParams.specificMarket;
        String noun = this.getNoun();
        String forcesNoun = this.getForcesNoun();
        if (!(this.isEnding() || this.isSucceeded() || this.isFailed())) {
            String days;
            FactionAPI other = Global.getSector().getFaction(this.blockadeParams.targetFaction);
            boolean hostile = this.getFaction().isHostileTo(this.blockadeParams.targetFaction);
            info.addSectionHeading("Assessment", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
            boolean started = this.isCurrent(PAYLOAD_ACTION);
            float remaining = this.getETAUntil(PAYLOAD_ACTION, true) - this.getETAUntil(TRAVEL_ACTION, true);
            if (remaining > 0.0f && remaining < 1.0f) {
                remaining = 1.0f;
            }
            String string = days = (int)remaining == 1 ? "day" : "days";
            if (started) {
                days = "more " + days;
            }
            LabelAPI label = info.addPara("The operation will last for approximately %s " + days + ", causing a progressive loss of stability " + target.getOnOrAt() + " %s. If stability reaches zero, %s will permanently fall under %s control.", opad, h, "" + (int)remaining, target.getName(), target.getName(), faction.getDisplayName());
            label.setHighlight("" + (int)remaining, target.getName(), target.getName(), "will permanently fall", faction.getDisplayName());
            label.setHighlightColors(h, other.getBaseUIColor(), Misc.getTextColor(), Misc.getNegativeHighlightColor(), faction.getBaseUIColor());
            if (!hostile) {
                info.addPara("The " + forcesNoun + " are not nominally hostile, but will harass shipping and " + "attempt to maintain control of the volume around the colony and undermine your " + "authority.", opad, Misc.getHighlightColor(), "not nominally hostile");
            } else {
                info.addPara("The " + forcesNoun + " are actively hostile, and will engage any orbital defenses, and " + " conduct planetside operations to undermine your authority.", opad, Misc.getNegativeHighlightColor(), "actively hostile");
            }
            this.addStrengthDesc(info, opad, target, forcesNoun, "the colony is unlikely to be in danger", "the colony may be in danger", "the colony is in danger");
            this.addPostAssessmentSection(info, width, height, opad);
        }
    }

    @Override
    protected void addPostAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    @Override
    protected void addPayloadActionStatus(TooltipMakerAPI info, float width, float height, float opad) {
        StarSystemAPI to = this.raidAction.getWhere();
        info.addPara("Conducting operations in the " + to.getNameWithLowercaseTypeShort() + ".", opad);
        int penalty = this.getStabilityPenaltyPerMonth();
        MarketAPI target = this.blockadeParams.specificMarket;
        this.bullet(info);
        if (penalty > 0) {
            LabelAPI label = info.addPara(String.valueOf(target.getName()) + " stability: %s per month", opad, Misc.getHighlightColor(), "-" + penalty);
            label.setHighlightColors(target.getFaction().getBaseUIColor(), Misc.getHighlightColor());
            label.setHighlight(target.getName(), "-" + penalty);
        } else {
            info.addPara("%s stability unaffected", opad, target.getFaction().getBaseUIColor(), target.getName());
            this.unindent(info);
        }
    }

    public int getStabilityPenaltyPerMonth() {
        int str = this.getRelativeFGStrength(this.getTargetSystem());
        if (str < 0) {
            return 0;
        }
        if (str == 0) {
            return STABILITY_PER_MONTH_PARTIAL;
        }
        return STABILITY_PER_MONTH_FULL;
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        if (iterIndex == 0) {
            if (!this.isCurrent(PAYLOAD_ACTION)) {
                return;
            }
            MarketAPI target = this.blockadeParams.specificMarket;
            int penalty = this.getStabilityPenaltyPerMonth();
            if (penalty > 0) {
                RecentUnrest.get(target).add(penalty, "Luddic Church takeover operation");
                target.reapplyConditions();
                this.sendUpdateIfPlayerHasIntel((Object)STABILITY_UPDATE, false);
            }
            if (target.getStabilityValue() <= 0.0f) {
                this.performTakeover(false);
            }
        }
    }

    @Override
    public void reportEconomyMonthEnd() {
    }

    public void performTakeover(boolean voluntary) {
        this.voluntary = voluntary;
        MarketAPI target = this.blockadeParams.specificMarket;
        target.setFactionId("luddic_church");
        target.setPlayerOwned(false);
        target.setAdmin(null);
        target.setFreePort(false);
        target.setUseStockpilesForShortages(false);
        for (SectorEntityToken curr : target.getConnectedEntities()) {
            curr.setFaction("luddic_church");
        }
        if (!target.hasSubmarket("open_market")) {
            target.addSubmarket("open_market");
        }
        if (!target.hasSubmarket("black_market")) {
            target.addSubmarket("black_market");
        }
        if ((Misc.isMilitary(target) || target.hasIndustry("militarybase") || target.hasIndustry("highcommand")) && !target.hasSubmarket("generic_military")) {
            target.addSubmarket("generic_military");
        }
        RecentUnrest.get(target).setPenalty(0);
        if (this.getCurrentAction() instanceof FGBlockadePlanetAction) {
            FGBlockadePlanetAction action = (FGBlockadePlanetAction)this.getCurrentAction();
            action.setSuccessFractionOverride(1.0f);
            action.setActionFinished(true);
        }
        if (target.getStarSystem() != null) {
            for (CampaignFleetAPI fleet : target.getStarSystem().getFleets()) {
                MemoryAPI mem = fleet.getMemoryWithoutUpdate();
                String type = mem.getString("$hassleType");
                if (!"sacredProtectors".equals(type)) continue;
                mem.unset("$willHasslePlayer");
                mem.unset("$hassleType");
                mem.set("$hassleComplete", true);
                fleet.removeScriptsOfClass(NPCHassler.class);
            }
        }
    }

    @Override
    public String getCommMessageSound() {
        if (this.isSendingUpdate() && this.isSucceeded() && this.isCurrent(RETURN_ACTION) && !this.voluntary) {
            return Sounds.REP_LOSS;
        }
        return super.getCommMessageSound();
    }
}

