/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.ItemEffectsRepo;
import com.fs.starfarer.api.impl.campaign.intel.misc.MapMarkerIntel;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

public class HypershuntIntel
extends MapMarkerIntel {
    public HypershuntIntel(SectorEntityToken entity, TextPanelAPI textPanel) {
        String title = entity.getName();
        String text = null;
        this.setSound("ui_discovered_entity");
        this.setWithDeleteButton(false);
        this.init(entity, title, text, null, true, textPanel);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "hypershunt");
    }

    @Override
    protected boolean withTextInDesc() {
        return false;
    }

    @Override
    protected void addExtraBulletPoints(TooltipMakerAPI info, Color tc, float initPad, IntelInfoPlugin.ListInfoMode mode) {
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$usable")) {
            info.addPara("Active", tc, initPad);
        } else {
            info.addPara("Inactive", tc, initPad);
        }
    }

    public boolean defendersDefeated() {
        return this.entity.getMemoryWithoutUpdate().getBoolean("$defenderFleetDefeated");
    }

    @Override
    protected void addPostDescriptionSection(TooltipMakerAPI info, float width, float height, float opad) {
        if (this.defendersDefeated()) {
            SpecialItemSpecAPI spec = Global.getSettings().getSpecialItemSpec("coronal_portal");
            info.addPara("Allows colonies within %s light-years to build %s additional industry, provided they have a %s installed and have a steady supply of transplutonics.", opad, Misc.getHighlightColor(), "" + ItemEffectsRepo.CORONAL_TAP_LIGHT_YEARS, "" + ItemEffectsRepo.CORONAL_TAP_INDUSTRIES, spec.getName());
            if (!this.entity.getMemoryWithoutUpdate().getBoolean("$usable")) {
                int crew = 1000;
                int metals = 20000;
                int transplutonics = 5000;
                info.showCost("Resources required to activate", false, (int)((width - opad) / 3.0f), Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), opad, new String[]{"crew", "metals", "rare_metals"}, new int[]{crew, metals, transplutonics}, new boolean[3]);
            }
        }
    }

    public static HypershuntIntel getHypershuntIntel(SectorEntityToken entity) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(HypershuntIntel.class)) {
            if (((HypershuntIntel)intel).getEntity() != entity) continue;
            return (HypershuntIntel)intel;
        }
        return null;
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        return tags;
    }
}

