/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.rulecmd.KantaCMD;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

public class AFavorForKanta
extends HubMissionWithSearch
implements ColonyPlayerHostileActListener {
    public static float MISSION_DAYS = 365.0f;
    protected MarketAPI market;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        PersonAPI person = People.getPerson(People.KANTA);
        if (person == null) {
            return false;
        }
        MarketAPI kantasDen = person.getMarket();
        this.setPersonOverride(person);
        this.setStoryMission();
        this.setNoAbandon();
        if (!this.setGlobalReference("$affk_ref", "$affk_inProgress")) {
            return false;
        }
        String commission = Misc.getCommissionFactionId();
        if (kantasDen != null) {
            this.requireMarketIsNot(kantasDen);
        }
        this.requireMarketFactionNotPlayer();
        this.requireMarketFactionNot("pirates");
        this.requireMarketIsMilitary();
        this.requireMarketTacticallyBombardable();
        this.requireMarketNotHidden();
        this.requireMarketNotInHyperspace();
        if (commission != null) {
            this.preferMarketFactionNot(commission);
        }
        this.preferMarketFactionNotHostileTo("player");
        this.market = this.pickMarket();
        if (this.market == null) {
            return false;
        }
        this.makeImportant(this.market, "$affk_target", Stage.BOMBARD);
        this.setStartingStage((Object)Stage.BOMBARD);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.market, "$affk_completed");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.setRepPenaltyFaction(Float.valueOf(0.0f));
        this.setRepPenaltyPerson(Float.valueOf(0.0f));
        this.addNoPenaltyFailureStages(new Object[]{Stage.FAILED_NO_PENALTY});
        this.connectWithMarketDecivilized((Object)Stage.BOMBARD, (Object)Stage.FAILED_NO_PENALTY, this.market);
        this.setStageOnMarketDecivilized((Object)Stage.FAILED_NO_PENALTY, this.market);
        this.triggerCreateLargePatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
        this.triggerCreateLargePatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
        this.triggerCreateMediumPatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
        this.triggerCreateSmallPatrolAroundMarket(this.market, (Object)Stage.BOMBARD, 0.0f);
        return true;
    }

    @Override
    protected void endAbandonImpl() {
        super.endAbandonImpl();
        this.endFailureImpl(null, null);
    }

    @Override
    protected void endFailureImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        if (this.currentStage == Stage.FAILED) {
            KantaCMD.loseProtection(dialog);
        }
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$affk_systemName", this.market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$affk_marketName", this.market.getName());
        this.set("$affk_marketOnOrAt", this.market.getOnOrAt());
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.BOMBARD) {
            AFavorForKanta.addStandardMarketDesc("Perform a tactical bombardment of", this.market, info, opad);
            this.addBombardmentInfo(this.market, info, opad);
        } else if (this.currentStage == Stage.FAILED) {
            info.addPara("Kanta's Protection lost", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.BOMBARD) {
            info.addPara("Tactically bombard " + this.market.getName() + " in the " + this.market.getStarSystem().getNameWithLowercaseTypeShort(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    protected String getMissionTypeNoun() {
        return "task";
    }

    @Override
    public String getBaseName() {
        return "A Favor for Kanta";
    }

    @Override
    public void acceptImpl(InteractionDialogAPI dialog, Map<String, MemoryAPI> memoryMap) {
        super.acceptImpl(dialog, memoryMap);
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
    }

    @Override
    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    @Override
    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
    }

    @Override
    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        if (this.market == market) {
            Global.getSector().getListenerManager().removeListener(this);
            market.getMemoryWithoutUpdate().set("$affk_bombardedColony", true, 1.0f);
        }
    }

    public static enum Stage {
        BOMBARD,
        COMPLETED,
        FAILED,
        FAILED_NO_PENALTY;

    }
}

