/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.GateTransitListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionTrigger;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class DelayedFleetEncounter
extends HubMissionWithTriggers
implements GateTransitListener {
    public static String TRIGGER_REP_LOSS_MINOR = "DFEFWTRepLossMinor";
    public static String TRIGGER_REP_LOSS_MEDIUM = "DFEFWTRepLossMedium";
    public static String TRIGGER_REP_LOSS_HIGH = "DFEFWTRepLossHigh";
    public static float RADIUS_FROM_CORE = 30000.0f;
    public static float BASE_DAYS_IN_SYSTEM_BEFORE_AMBUSH_IN_HYPER = 5.0f;
    public static float BASE_DAYS_IN_SYSTEM_BEFORE_IN_SYSTEM_ATTACK = 10.0f;
    public static float BASE_TIMEOUT = 10.0f;
    public static float BASE_DELAY_VERY_SHORT = 91.25f;
    public static float BASE_DELAY_SHORT = 244.55f;
    public static float BASE_DELAY_MEDIUM = 730.0f;
    public static float BASE_DELAY_LONG = 1825.0f;
    public static float BASE_ONLY_CHECK_IN_SYSTEM_DAYS = 15.0f;
    public static String TIMEOUT_KEY = "$core_dfe_timeout";
    protected float minDelay;
    protected float maxDelay;
    protected float onlyCheckForSpawnInSystemDays;
    protected String globalEndFlag;
    protected List<EncounterType> allowedTypes = new ArrayList<EncounterType>();
    protected List<EncounterLocation> allowedLocations = new ArrayList<EncounterLocation>();
    protected boolean allowInsidePopulatedSystems = true;
    protected String requireLargestMarketNotHostileToFaction = null;
    protected List<String> requiredFactionPresence = null;
    protected List<HubMissionWithSearch.RequiredSystemTags> requiredTags = null;
    protected boolean canBeAvoidedByGateTransit = true;
    protected boolean madeGateTransit = false;
    protected LocationAPI initialTransitFrom = null;
    protected CanSpawnFleetConditionChecker checker;
    protected float waitDays;
    protected PersonAPI personForRepLoss = null;
    protected HubMissionWithTriggers.FleetSize fleetSize = HubMissionWithTriggers.FleetSize.MEDIUM;
    protected float estimatedFleetPoints = 0.0f;
    protected float playerFleetSizeAbortMult = 2.0f;

    public static float getRandomValue(float base) {
        return StarSystemGenerator.getNormalRandom(Misc.random, base * 0.75f, base * 1.25f);
    }

    public static boolean isInTimeout() {
        return Global.getSector().getMemoryWithoutUpdate().getBoolean(TIMEOUT_KEY);
    }

    public static void setTimeout() {
        Global.getSector().getMemoryWithoutUpdate().set(TIMEOUT_KEY, true, DelayedFleetEncounter.getRandomValue(BASE_TIMEOUT));
    }

    public DelayedFleetEncounter(Random random, String missionId) {
        if (random == null) {
            random = new Random(Misc.genRandomSeed());
        }
        this.setGenRandom(random);
        this.setNoRepChanges();
        this.globalEndFlag = "$dfe_" + missionId + "_" + Misc.genUID();
        this.setMissionId(missionId);
        this.setTypes(EncounterType.OUTSIDE_SYSTEM, EncounterType.JUMP_IN_NEAR_PLAYER, EncounterType.IN_HYPER_EN_ROUTE);
        this.onlyCheckForSpawnInSystemDays = BASE_ONLY_CHECK_IN_SYSTEM_DAYS * (0.5f + this.genRandom.nextFloat());
        Global.getSector().getListenerManager().addListener(this);
    }

    public void setCanNotBeAvoidedByGateTransit() {
        this.canBeAvoidedByGateTransit = false;
    }

    @Override
    public void reportFleetTransitingGate(CampaignFleetAPI fleet, SectorEntityToken gateFrom, SectorEntityToken gateTo) {
        if (!fleet.isPlayerFleet() || gateFrom == null) {
            return;
        }
        if (this.getCurrentStage() == Stage.WAITING && this.getElapsedInCurrentStage() < this.waitDays * 0.9f) {
            return;
        }
        float dist = Misc.getDistanceLY(gateFrom, gateTo);
        if (dist > 2.0f) {
            this.madeGateTransit = true;
        }
        if (this.initialTransitFrom == null) {
            this.initialTransitFrom = gateFrom.getContainingLocation();
        }
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        Global.getSector().getListenerManager().removeListener(this);
    }

    public void setAllowInsidePopulatedSystems(boolean allowInsidePopulatedSystems) {
        this.allowInsidePopulatedSystems = allowInsidePopulatedSystems;
    }

    public void setRequireLargestMarketNotHostileToFaction(String requireLargestMarketNotHostileToFaction) {
        this.requireLargestMarketNotHostileToFaction = requireLargestMarketNotHostileToFaction;
    }

    public void setRequireFactionPresence(String ... factions) {
        if (factions == null || factions.length <= 0) {
            this.requiredFactionPresence = null;
        } else {
            this.requiredFactionPresence = new ArrayList<String>();
            this.requiredFactionPresence.addAll(Arrays.asList(factions));
        }
    }

    public void clearDFESystemTagRequirements() {
        this.requiredTags = null;
    }

    public void requireDFESystemTags(ReqMode mode, String ... tags) {
        if (this.requiredTags == null) {
            this.requiredTags = new ArrayList<HubMissionWithSearch.RequiredSystemTags>();
        }
        HubMissionWithSearch.RequiredSystemTags req = new HubMissionWithSearch.RequiredSystemTags(mode, tags);
        this.requiredTags.add(req);
    }

    public void setEncounterInHyper() {
        this.setTypes(EncounterType.OUTSIDE_SYSTEM, EncounterType.IN_HYPER_EN_ROUTE);
    }

    public void setEncounterOutsideSystem() {
        this.setTypes(EncounterType.OUTSIDE_SYSTEM);
    }

    public void setEncounterInSystemFromJumpPoint() {
        this.setTypes(EncounterType.JUMP_IN_NEAR_PLAYER);
    }

    public void setEncounterFromSomewhereInSystem() {
        this.setTypes(EncounterType.FROM_SOMEWHERE_IN_SYSTEM);
    }

    public void setEncounterInHyperEnRoute() {
        this.setTypes(EncounterType.IN_HYPER_EN_ROUTE);
    }

    public void setTypes(EncounterType ... types) {
        this.allowedTypes.clear();
        this.allowedTypes.addAll(Arrays.asList(types));
    }

    public void setLocations(boolean allowInsidePopulatedSystems, String requireLargestMarketNotHostileToFaction, EncounterLocation ... locations) {
        this.allowedLocations.clear();
        this.allowedLocations.addAll(Arrays.asList(locations));
        this.setAllowInsidePopulatedSystems(allowInsidePopulatedSystems);
        this.setRequireLargestMarketNotHostileToFaction(requireLargestMarketNotHostileToFaction);
    }

    public void setDelay(float minDays, float maxDays) {
        this.minDelay = minDays;
        this.maxDelay = maxDays;
    }

    public void setDelay(float base) {
        this.minDelay = base * 0.5f;
        this.maxDelay = base * 1.5f;
    }

    public void setLocationAnyPopulated(boolean allowInsidePopulatedSystems, String requireLargestMarketNotHostileToFaction) {
        this.setLocations(allowInsidePopulatedSystems, requireLargestMarketNotHostileToFaction, EncounterLocation.POPULATED_SYSTEM);
    }

    public void setLocationCoreOnly(boolean allowInsidePopulatedSystems, String requireLargestMarketNotHostileToFaction) {
        this.setLocations(allowInsidePopulatedSystems, requireLargestMarketNotHostileToFaction, EncounterLocation.NEAR_CORE);
    }

    public void setLocationOuterSector(boolean allowInsidePopulatedSystems, String requireLargestMarketNotHostileToFaction) {
        this.setLocations(allowInsidePopulatedSystems, requireLargestMarketNotHostileToFaction, EncounterLocation.FRINGE, EncounterLocation.MIDRANGE);
    }

    public void setLocationAnywhere(boolean allowInsidePopulatedSystems, String requireLargestMarketNotHostileToFaction) {
        this.setLocations(allowInsidePopulatedSystems, requireLargestMarketNotHostileToFaction, EncounterLocation.ANYWHERE);
    }

    public void setLocationFringeOnly(boolean allowInsidePopulatedSystems, String requireLargestMarketNotHostileToFaction) {
        this.setLocations(allowInsidePopulatedSystems, requireLargestMarketNotHostileToFaction, EncounterLocation.FRINGE);
    }

    public void setLocationInnerSector(boolean allowInsidePopulatedSystems, String requireLargestMarketNotHostileToFaction) {
        this.setLocations(allowInsidePopulatedSystems, requireLargestMarketNotHostileToFaction, EncounterLocation.NEAR_CORE, EncounterLocation.MIDRANGE);
    }

    public void setDelayNone() {
        this.setDelay(0.0f);
    }

    public void setDelayVeryShort() {
        this.setDelay(BASE_DELAY_VERY_SHORT);
    }

    public void setDelayShort() {
        this.setDelay(BASE_DELAY_SHORT);
    }

    public void setDelayMedium() {
        this.setDelay(BASE_DELAY_MEDIUM);
    }

    public void setDelayLong() {
        this.setDelay(BASE_DELAY_LONG);
    }

    public void triggerSetStandardAggroInterceptFlags() {
        this.triggerMakeHostileAndAggressive();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerOrderFleetInterceptPlayer();
        this.triggerOrderFleetMaybeEBurn();
    }

    @Override
    protected void advanceImpl(float amount) {
        super.advanceImpl(amount);
        if (this.getCurrentStage() == Stage.SPAWN_FLEET && this.checker != null) {
            this.checker.advance(amount);
        }
    }

    public void beginCreate() {
        this.checker = new CanSpawnFleetConditionChecker();
        if (this.minDelay <= 0.0f && this.maxDelay <= 0.0f) {
            this.checker.daysBeforeInHyper = (0.5f + (0.5f + this.genRandom.nextFloat())) * 2.0f;
            this.checker.daysBeforeInSystem = (0.5f + (0.5f + this.genRandom.nextFloat())) * 3.0f;
            this.onlyCheckForSpawnInSystemDays = 0.5f + (0.5f + this.genRandom.nextFloat());
        }
        this.waitDays = this.minDelay + (this.maxDelay - this.minDelay) * this.genRandom.nextFloat();
        this.connectWithDaysElapsed((Object)Stage.WAITING, (Object)Stage.SPAWN_FLEET, this.waitDays);
        this.setStartingStage((Object)Stage.WAITING);
        this.setSuccessStage((Object)Stage.ENDED);
        this.setStageOnGlobalFlag((Object)Stage.ENDED, this.globalEndFlag);
        this.setStageOnCustomCondition((Object)Stage.ENDED, new BaseHubMission.ConditionChecker(){

            @Override
            public boolean conditionsMet() {
                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                if ((float)playerFleet.getFleetPoints() > DelayedFleetEncounter.this.estimatedFleetPoints * DelayedFleetEncounter.this.playerFleetSizeAbortMult) {
                    return DelayedFleetEncounter.this.getCurrentStage() == Stage.WAITING && DelayedFleetEncounter.this.getElapsedInCurrentStage() > DelayedFleetEncounter.this.waitDays * 0.9f || DelayedFleetEncounter.this.getCurrentStage() == Stage.SPAWN_FLEET;
                }
                return DelayedFleetEncounter.this.madeGateTransit && DelayedFleetEncounter.this.initialTransitFrom != null && Misc.getDistanceLY(DelayedFleetEncounter.this.initialTransitFrom.getLocation(), playerFleet.getLocationInHyperspace()) > 2.0f;
            }
        });
        this.beginCustomTrigger(this.checker, new Object[]{Stage.SPAWN_FLEET});
        this.triggerMakeAllFleetFlagsPermanent();
    }

    public void endCreate() {
        this.triggerSetGlobalMemoryValue(this.globalEndFlag, true);
        this.triggerCustomAction(new DFEPlaceFleetAction());
        this.endTrigger();
        this.accept(null, null);
    }

    public void triggerSetAdjustStrengthBasedOnQuality(boolean randomize, float quality) {
        if (randomize) {
            this.triggerRandomizeFleetProperties();
        }
        this.setQuality(quality);
        this.setUseQualityInsteadOfQualityFraction(true);
        this.triggerAutoAdjustFleetStrengthMajor();
        this.setUseQualityInsteadOfQualityFraction(false);
    }

    public void setFleetWantsThing(String originalFactionId, String thing, String thingItOrThey, String thingDesc, int paymentOffered, boolean aggressiveIfDeclined, HubMissionWithTriggers.ComplicationRepImpact repImpact, String failTrigger, PersonAPI personForRepLoss) {
        this.personForRepLoss = personForRepLoss;
        this.triggerSetFleetMissionRef("$" + this.getMissionId() + "_ref");
        this.triggerSetFleetMissionRef("$fwt_ref");
        if (aggressiveIfDeclined) {
            this.triggerSetPirateFleet();
            this.triggerMakeHostileAndAggressive();
        }
        if (repImpact == HubMissionWithTriggers.ComplicationRepImpact.LOW) {
            this.triggerMakeLowRepImpact();
        } else if (repImpact == HubMissionWithTriggers.ComplicationRepImpact.NONE) {
            this.triggerMakeNoRepImpact();
        }
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        FactionAPI faction = Global.getSector().getFaction(originalFactionId);
        if (faction.getCustomBoolean("spawnsAsIndependent")) {
            this.triggerSetFleetFaction("independent");
            this.triggerSetFleetMemoryValue("$fwt_originalFaction", originalFactionId);
        }
        this.triggerSetFleetMemoryValue("$fwt_wantsThing", true);
        this.triggerSetFleetMemoryValue("$fwt_aggressive", aggressiveIfDeclined);
        this.triggerSetFleetMemoryValue("$fwt_thing", this.getWithoutArticle(thing));
        this.triggerSetFleetMemoryValue("$fwt_Thing", Misc.ucFirst(this.getWithoutArticle(thing)));
        this.triggerSetFleetMemoryValue("$fwt_theThing", thing);
        this.triggerSetFleetMemoryValue("$fwt_TheThing", Misc.ucFirst(thing));
        this.triggerSetFleetMemoryValue("$fwt_payment", Misc.getWithDGS(paymentOffered));
        this.triggerSetFleetMemoryValue("$fwt_itOrThey", thingItOrThey);
        this.triggerSetFleetMemoryValue("$fwt_ItOrThey", Misc.ucFirst(thingItOrThey));
        String thingItOrThem = "them";
        if ("it".equals(thingItOrThey)) {
            thingItOrThem = "it";
        }
        this.triggerSetFleetMemoryValue("$fwt_itOrThem", thingItOrThem);
        this.triggerSetFleetMemoryValue("$fwt_ItOrThem", Misc.ucFirst(thingItOrThem));
        this.triggerSetFleetMemoryValue("$fwt_thingDesc", thingDesc);
        this.triggerSetFleetMemoryValue("$fwt_ThingDesc", Misc.ucFirst(thingDesc));
        if (failTrigger == null) {
            failTrigger = "FWTDefaultFailTrigger";
        }
        this.triggerSetFleetMemoryValue("$fwt_missionFailTrigger", failTrigger);
    }

    public void setAlwaysAbort() {
        this.playerFleetSizeAbortMult = 0.0f;
    }

    public void setDoNotAbortWhenPlayerFleetTooStrong() {
        this.playerFleetSizeAbortMult = 1.0E8f;
    }

    public void setPlayerFleetSizeAbortMult(float playerFleetSizeAbortMult) {
        this.playerFleetSizeAbortMult = playerFleetSizeAbortMult;
    }

    protected void computeThresholdPoints(String factionId) {
        FactionAPI faction = Global.getSector().getFaction(factionId);
        float maxPoints = faction.getApproximateMaxFPPerFleet(FactionAPI.ShipPickMode.PRIORITY_THEN_ALL);
        this.estimatedFleetPoints = this.fleetSize.maxFPFraction * maxPoints;
    }

    public void triggerFleetSetFaction(String factionId) {
        this.computeThresholdPoints(factionId);
        super.triggerSetFleetFaction(factionId);
    }

    @Override
    public void triggerCreateFleet(HubMissionWithTriggers.FleetSize size, HubMissionWithTriggers.FleetQuality quality, String factionId, String type, SectorEntityToken roughlyWhere) {
        this.fleetSize = size;
        this.computeThresholdPoints(factionId);
        super.triggerCreateFleet(size, quality, factionId, type, roughlyWhere);
    }

    @Override
    public void triggerCreateFleet(HubMissionWithTriggers.FleetSize size, HubMissionWithTriggers.FleetQuality quality, String factionId, String type, StarSystemAPI roughlyWhere) {
        this.fleetSize = size;
        this.computeThresholdPoints(factionId);
        super.triggerCreateFleet(size, quality, factionId, type, roughlyWhere);
    }

    @Override
    public void triggerCreateFleet(HubMissionWithTriggers.FleetSize size, HubMissionWithTriggers.FleetQuality quality, String factionId, String type, Vector2f locInHyper) {
        this.fleetSize = size;
        this.computeThresholdPoints(factionId);
        super.triggerCreateFleet(size, quality, factionId, type, locInHyper);
    }

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        return false;
    }

    @Override
    public String getBaseName() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        float repLossPerson = 0.0f;
        float repLossFaction = 0.0f;
        if ("repLossMinor".equals(action)) {
            repLossPerson = -0.02f;
            repLossFaction = -0.01f;
        } else if ("repLossMedium".equals(action)) {
            repLossPerson = -0.05f;
            repLossFaction = -0.02f;
        } else if ("repLossHigh".equals(action)) {
            repLossPerson = -0.1f;
            repLossFaction = -0.05f;
        }
        if (repLossPerson != 0.0f && this.personForRepLoss != null) {
            CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
            impact.delta = repLossPerson;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog.getTextPanel(), true), this.personForRepLoss);
            impact.delta = repLossFaction;
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, null, dialog.getTextPanel(), true), this.personForRepLoss.getFaction().getId());
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    public class CanSpawnFleetConditionChecker
    implements BaseHubMission.ConditionChecker {
        protected StarSystemAPI lastSystemPlayerWasIn = null;
        protected float daysInSystem = 0.0f;
        protected boolean conditionsMet = false;
        protected EncounterType typePicked = null;
        protected Vector2f location;
        protected SectorEntityToken foundEntity;
        protected float daysBeforeInHyper = DelayedFleetEncounter.getRandomValue(BASE_DAYS_IN_SYSTEM_BEFORE_AMBUSH_IN_HYPER);
        protected float daysBeforeInSystem = DelayedFleetEncounter.getRandomValue(BASE_DAYS_IN_SYSTEM_BEFORE_IN_SYSTEM_ATTACK);

        @Override
        public boolean conditionsMet() {
            this.doCheck();
            return this.conditionsMet;
        }

        public void advance(float amount) {
            if (this.conditionsMet) {
                return;
            }
            float days = Global.getSector().getClock().convertToDays(amount);
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            StarSystemAPI curr = playerFleet.getStarSystem();
            if (curr != null) {
                if (curr != this.lastSystemPlayerWasIn) {
                    this.daysInSystem = 0.0f;
                }
                this.lastSystemPlayerWasIn = curr;
                this.daysInSystem += days;
            }
        }

        public void doCheck() {
            if (DelayedFleetEncounter.isInTimeout()) {
                return;
            }
            if (this.conditionsMet) {
                return;
            }
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            if ((float)playerFleet.getFleetPoints() > DelayedFleetEncounter.this.estimatedFleetPoints * DelayedFleetEncounter.this.playerFleetSizeAbortMult) {
                return;
            }
            if (DelayedFleetEncounter.this.madeGateTransit && DelayedFleetEncounter.this.initialTransitFrom != null && Misc.getDistanceLY(DelayedFleetEncounter.this.initialTransitFrom.getLocation(), playerFleet.getLocationInHyperspace()) > 2.0f) {
                return;
            }
            boolean onlyCheckInSystem = true;
            BaseHubMission.StageData stage = DelayedFleetEncounter.this.getData(DelayedFleetEncounter.this.currentStage);
            if (stage != null && stage.elapsed > DelayedFleetEncounter.this.onlyCheckForSpawnInSystemDays) {
                onlyCheckInSystem = false;
            }
            if (this.isPlayerInRightRangeBand(this.lastSystemPlayerWasIn)) {
                float dist;
                if (DelayedFleetEncounter.this.allowedTypes.contains((Object)EncounterType.IN_HYPER_EN_ROUTE) && !onlyCheckInSystem && playerFleet.isInHyperspace()) {
                    float maxSpeed = Misc.getSpeedForBurnLevel(playerFleet.getFleetData().getBurnLevel());
                    float currSpeed = playerFleet.getVelocity().length();
                    if (currSpeed >= maxSpeed * 0.9f) {
                        float dist2 = DelayedFleetEncounter.getRandomValue(2500.0f);
                        float dir = Misc.getAngleInDegrees(playerFleet.getVelocity());
                        this.location = Misc.getUnitVectorAtDegreeAngle(dir += 75.0f - 150.0f * DelayedFleetEncounter.this.genRandom.nextFloat());
                        this.location.scale(dist2);
                        Vector2f.add((Vector2f)this.location, (Vector2f)playerFleet.getLocation(), (Vector2f)this.location);
                        this.conditionsMet = true;
                        this.typePicked = EncounterType.IN_HYPER_EN_ROUTE;
                        return;
                    }
                }
                if (DelayedFleetEncounter.this.allowedTypes.contains((Object)EncounterType.OUTSIDE_SYSTEM) && playerFleet.isInHyperspace() && this.daysInSystem > this.daysBeforeInHyper && this.lastSystemPlayerWasIn != null && (dist = Misc.getDistance(this.lastSystemPlayerWasIn.getLocation(), playerFleet.getLocationInHyperspace())) < 3000.0f) {
                    this.conditionsMet = true;
                    this.typePicked = EncounterType.OUTSIDE_SYSTEM;
                    return;
                }
                if (DelayedFleetEncounter.this.allowedTypes.contains((Object)EncounterType.FROM_SOMEWHERE_IN_SYSTEM) && playerFleet.getStarSystem() == this.lastSystemPlayerWasIn && this.daysInSystem > this.daysBeforeInSystem && this.lastSystemPlayerWasIn != null) {
                    this.conditionsMet = true;
                    this.typePicked = EncounterType.FROM_SOMEWHERE_IN_SYSTEM;
                    return;
                }
                if (DelayedFleetEncounter.this.allowedTypes.contains((Object)EncounterType.JUMP_IN_NEAR_PLAYER) && playerFleet.getStarSystem() == this.lastSystemPlayerWasIn && this.daysInSystem > this.daysBeforeInSystem && this.lastSystemPlayerWasIn != null) {
                    float dist3;
                    SectorEntityToken entity = Misc.findNearestJumpPointTo(playerFleet);
                    if (entity != null && (dist3 = Misc.getDistance(playerFleet, entity)) < 3000.0f) {
                        this.conditionsMet = true;
                    }
                    if (!this.conditionsMet && (entity = Misc.findNearestPlanetTo(playerFleet, true, false)) != null && (dist3 = Misc.getDistance(playerFleet, entity)) < 3000.0f) {
                        this.conditionsMet = true;
                    }
                    if (this.conditionsMet) {
                        this.foundEntity = entity;
                        this.typePicked = EncounterType.JUMP_IN_NEAR_PLAYER;
                        return;
                    }
                }
            }
        }

        protected boolean isPlayerInRightRangeBand(LocationAPI system) {
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            if (system instanceof StarSystemAPI && system == playerFleet.getContainingLocation()) {
                if (DelayedFleetEncounter.this.requiredTags != null) {
                    for (HubMissionWithSearch.RequiredSystemTags req : DelayedFleetEncounter.this.requiredTags) {
                        if (req.systemMatchesRequirement((StarSystemAPI)system)) continue;
                        return false;
                    }
                }
                List<MarketAPI> markets = Misc.getMarketsInLocation(system);
                if (DelayedFleetEncounter.this.requireLargestMarketNotHostileToFaction != null) {
                    MarketAPI largest = null;
                    MarketAPI largestHostile = null;
                    int maxSize = 0;
                    int maxHostileSize = 0;
                    for (MarketAPI market : markets) {
                        if (market.getSize() > maxSize) {
                            largest = market;
                            maxSize = market.getSize();
                        }
                        if (!market.getFaction().isHostileTo(DelayedFleetEncounter.this.requireLargestMarketNotHostileToFaction) || market.getSize() <= maxHostileSize) continue;
                        largestHostile = market;
                        maxHostileSize = market.getSize();
                    }
                    if (largestHostile != null && maxHostileSize > maxSize) {
                        return false;
                    }
                }
                if (DelayedFleetEncounter.this.requiredFactionPresence != null) {
                    boolean found = false;
                    for (MarketAPI market : markets) {
                        if (!DelayedFleetEncounter.this.requiredFactionPresence.contains(market.getFactionId())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return false;
                    }
                }
            }
            Vector2f coreCenter = new Vector2f();
            float fringeRange = 46000.0f;
            float nearMarketRange = 5000.0f;
            boolean nearCoreMarket = false;
            boolean nearAnyMarket = false;
            MarketAPI nearest = null;
            float minDist = Float.MAX_VALUE;
            float count = 0.0f;
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                float dist;
                if (market.isHidden()) continue;
                if (market.getContainingLocation().hasTag("theme_core_populated")) {
                    Vector2f.add((Vector2f)coreCenter, (Vector2f)market.getLocationInHyperspace(), (Vector2f)coreCenter);
                    count += 1.0f;
                    if (nearCoreMarket) continue;
                    dist = Misc.getDistance(market.getLocation(), playerFleet.getLocationInHyperspace());
                    boolean bl = nearCoreMarket = dist < nearMarketRange;
                    if (!(dist < minDist)) continue;
                    nearest = market;
                    minDist = dist;
                    continue;
                }
                if (nearAnyMarket) continue;
                dist = Misc.getDistance(market.getLocation(), playerFleet.getLocationInHyperspace());
                boolean bl = nearAnyMarket = dist < nearMarketRange;
                if (!(dist < minDist)) continue;
                nearest = market;
                minDist = dist;
            }
            if ((nearCoreMarket || nearAnyMarket) && !DelayedFleetEncounter.this.allowInsidePopulatedSystems && nearest != null && !Global.getSector().getPlayerFleet().isInHyperspace() && system == nearest.getStarSystem()) {
                return false;
            }
            if (count > 0.0f) {
                coreCenter.scale(1.0f / count);
            }
            if (nearCoreMarket && DelayedFleetEncounter.this.allowedLocations.contains((Object)EncounterLocation.NEAR_CORE)) {
                return true;
            }
            if (nearAnyMarket && DelayedFleetEncounter.this.allowedLocations.contains((Object)EncounterLocation.POPULATED_SYSTEM)) {
                return true;
            }
            for (EncounterLocation location : DelayedFleetEncounter.this.allowedLocations) {
                if (location == EncounterLocation.NEAR_CORE || location == EncounterLocation.POPULATED_SYSTEM) continue;
                float distFromCore = Misc.getDistance(coreCenter, playerFleet.getLocationInHyperspace());
                if (location == EncounterLocation.MIDRANGE && (distFromCore > fringeRange || nearCoreMarket) || location == EncounterLocation.FRINGE && (distFromCore < fringeRange || nearCoreMarket)) continue;
                return true;
            }
            return false;
        }
    }

    public class DFEPlaceFleetAction
    implements MissionTrigger.TriggerAction {
        @Override
        public void doAction(MissionTrigger.TriggerActionContext context) {
            DelayedFleetEncounter.setTimeout();
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            playerFleet.getContainingLocation().addEntity(context.fleet);
            if (DelayedFleetEncounter.this.checker.typePicked == EncounterType.OUTSIDE_SYSTEM) {
                Vector2f loc = Misc.getPointAtRadius(playerFleet.getLocationInHyperspace(), 1000.0f);
                context.fleet.setLocation(loc.x, loc.y);
            } else if (DelayedFleetEncounter.this.checker.typePicked == EncounterType.FROM_SOMEWHERE_IN_SYSTEM) {
                WeightedRandomPicker<MarketAPI> from = new WeightedRandomPicker<MarketAPI>(DelayedFleetEncounter.this.genRandom);
                for (MarketAPI curr : Global.getSector().getEconomy().getMarkets(playerFleet.getContainingLocation())) {
                    float w = 0.0f;
                    if (curr.getFaction() == context.fleet.getFaction()) {
                        w = (float)curr.getSize() * 10000.0f;
                    } else if (!curr.getFaction().isHostileTo(context.fleet.getFaction())) {
                        w = curr.getSize();
                    }
                    if (!(w > 0.0f)) continue;
                    from.add(curr, w);
                }
                MarketAPI market = (MarketAPI)from.pick();
                if (market != null) {
                    float dir = Misc.getAngleInDegrees(playerFleet.getLocation(), market.getPrimaryEntity().getLocation());
                    Vector2f loc = HubMissionWithTriggers.pickLocationWithinArc(DelayedFleetEncounter.this.genRandom, playerFleet, dir, 30.0f, 3000.0f, 3000.0f, 3000.0f);
                    context.fleet.setLocation(loc.x, loc.y);
                } else {
                    Vector2f loc = Misc.getPointAtRadius(playerFleet.getLocation(), 3000.0f);
                    context.fleet.setLocation(loc.x, loc.y);
                }
            } else if (DelayedFleetEncounter.this.checker.typePicked == EncounterType.JUMP_IN_NEAR_PLAYER) {
                JumpPointAPI.JumpDestination dest = new JumpPointAPI.JumpDestination(DelayedFleetEncounter.this.checker.foundEntity, null);
                if (DelayedFleetEncounter.this.checker.foundEntity instanceof JumpPointAPI) {
                    JumpPointAPI jp = (JumpPointAPI)DelayedFleetEncounter.this.checker.foundEntity;
                    jp.open();
                    context.fleet.setLocation(jp.getLocation().x, jp.getLocation().y);
                } else if (DelayedFleetEncounter.this.checker.foundEntity instanceof PlanetAPI) {
                    dest.setMinDistFromToken(DelayedFleetEncounter.this.checker.foundEntity.getRadius() + 50.0f);
                    dest.setMaxDistFromToken(DelayedFleetEncounter.this.checker.foundEntity.getRadius() + 400.0f);
                }
                context.fleet.updateFleetView();
                context.fleet.getContainingLocation().removeEntity(context.fleet);
                Global.getSector().getHyperspace().addEntity(context.fleet);
                context.fleet.setLocation(1.0E9f, 0.0f);
                Global.getSector().doHyperspaceTransition(context.fleet, null, dest);
            } else if (DelayedFleetEncounter.this.checker.typePicked == EncounterType.IN_HYPER_EN_ROUTE) {
                context.fleet.setLocation(DelayedFleetEncounter.this.checker.location.x, DelayedFleetEncounter.this.checker.location.y);
            }
            float radius = 2000.0f * (0.5f + 0.5f * DelayedFleetEncounter.this.genRandom.nextFloat());
            Vector2f approximatePlayerLoc = Misc.getPointAtRadius(playerFleet.getLocation(), radius);
            context.fleet.getMemoryWithoutUpdate().set("$ai_placeToLook", approximatePlayerLoc, 2.0f);
        }
    }

    public static enum EncounterLocation {
        ANYWHERE,
        POPULATED_SYSTEM,
        NEAR_CORE,
        MIDRANGE,
        FRINGE;

    }

    public static enum EncounterType {
        OUTSIDE_SYSTEM,
        IN_HYPER_EN_ROUTE,
        JUMP_IN_NEAR_PLAYER,
        FROM_SOMEWHERE_IN_SYSTEM;

    }

    public static enum Stage {
        WAITING,
        SPAWN_FLEET,
        ENDED;

    }
}

