/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GADepartments;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GADerelictArtifact
extends GABaseMission {
    public static float MISSION_DAYS = 120.0f;
    public static float PROB_PIRATES = 0.33f;
    public static float PROB_SCAVENGER = 0.5f;
    protected StarSystemAPI system;
    protected SectorEntityToken entity;
    protected StarSystemAPI pirateSystem;
    protected String widget;
    protected Variation variation;
    protected int piratePayment;
    protected int piratePaymentLow;
    protected int scavPayment;
    protected int scavPaymentHigh;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaDA_ref")) {
            return false;
        }
        this.pickDepartment(GADepartments.INDUSTRIAL, GADepartments.SOCIAL, GADepartments.MILITARY, GADepartments.SCIENCE, GADepartments.WEIRD);
        this.widget = this.pickOne("unique superconducting structural element", "an advanced field conversion prototype", "a transparametric integrator", "an extremely rare material sample", "an uncommon power system component", "a Domain-era forge component", "a small-scale momentum decoupling device", "a fascinating low-power field projector");
        this.requireSystemTags(ReqMode.ANY, "theme_remnant_resurgent", "theme_remnant_suppressed", "theme_derelict", "theme_misc", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_remnant_secondary");
        this.preferSystemUnexplored();
        this.preferSystemInDirectionOfOtherMissions();
        this.system = this.pickSystem();
        if (this.system == null) {
            return false;
        }
        this.entity = this.spawnDerelictOfType(null, new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN, null, this.system, false));
        if (this.entity == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_DERELCIT);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.makeImportant(this.entity, "$gaDA_entity", Stage.GO_TO_DERELCIT);
        this.makeImportant(this.getPerson(), "$gaDA_returnHere", Stage.RETURN_TO_ACADEMY);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_DERELCIT, (Object)Stage.GET_IT_FROM_PIRATES, "$gaDA_piratesTookIt");
        this.connectWithGlobalFlag((Object)Stage.GO_TO_DERELCIT, (Object)Stage.GET_IT_FROM_SCAVENGER, "$gaDA_scavengerTookIt");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, "$gaDA_gotWidget");
        this.connectWithGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, (Object)Stage.COMPLETED, "$gaDA_returnedWidget");
        if (WITH_TIME_LIMIT) {
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, this.entity.getStarSystem(), new Object[]{Stage.RETURN_TO_ACADEMY});
        }
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.setDefaultGARepRewards();
        if (this.system.hasTag("theme_remnant")) {
            this.variation = Variation.REMNANTS;
            this.setCreditReward(BaseHubMission.CreditReward.HIGH);
        } else {
            this.variation = this.rollProbability(PROB_PIRATES) ? Variation.PIRATES : (this.rollProbability(PROB_SCAVENGER) ? Variation.SCAVENGER : Variation.BASIC);
        }
        this.setMapMarkerNameColorBasedOnStar(this.system);
        if (this.variation == Variation.PIRATES) {
            this.requireSystemTags(ReqMode.ANY, "theme_misc_skip", "theme_derelict", "theme_misc", "theme_ruins");
            this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe");
            this.requireSystemNot(this.system);
            this.requireSystemWithinRangeOf(this.entity.getLocationInHyperspace(), 10.0f);
            this.pirateSystem = this.pickSystem();
            if (this.pirateSystem == null) {
                return false;
            }
            this.piratePayment = this.genRoundNumber(10000, 15000);
            this.piratePaymentLow = this.genRoundNumber(2000, 5000);
            this.beginStageTrigger(new Object[]{Stage.GET_IT_FROM_PIRATES});
            this.triggerSpawnEntity("supply_cache", new BaseHubMission.LocData(BaseHubMission.EntityLocationType.HIDDEN, null, this.pirateSystem, false));
            this.triggerSaveGlobalEntityRef("$gaDA_cache");
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", this.pirateSystem);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetStandardHostilePirateFlags();
            this.triggerMakeFleetIgnoredByOtherFleets();
            this.triggerPickLocationAtInSystemJumpPoint(this.pirateSystem);
            this.triggerSpawnFleetAtPickedLocation();
            this.triggerOrderFleetPatrolEntity(true);
            this.triggerFleetMakeImportant("$gaDA_pirate", Stage.GET_IT_FROM_PIRATES);
            this.triggerFleetAddDefeatTrigger("gaDAFleetWithWidgetDefeated");
            this.endTrigger();
        } else if (this.variation == Variation.SCAVENGER) {
            this.scavPayment = this.genRoundNumber(10000, 15000);
            this.scavPaymentHigh = this.genRoundNumber(20000, 25000);
            this.beginStageTrigger(new Object[]{Stage.GET_IT_FROM_SCAVENGER});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.LOWER, "scavengers", "scavengerMedium", this.system);
            this.triggerAutoAdjustFleetStrengthModerate();
            this.triggerSetFleetFaction("independent");
            this.triggerMakeLowRepImpact();
            this.triggerPickLocationAtClosestToPlayerJumpPoint(this.system);
            this.triggerSetEntityToPickedJumpPoint();
            this.triggerPickLocationAroundEntity(5000.0f);
            this.triggerSpawnFleetAtPickedLocation();
            this.triggerFleetSetTravelActionText("exploring system");
            this.triggerFleetSetPatrolActionText("preparing to leave system");
            this.triggerOrderFleetPatrolEntity(false);
            this.triggerFleetMakeImportant("$gaDA_scavenger", Stage.GET_IT_FROM_SCAVENGER);
            this.triggerFleetAddDefeatTrigger("gaDAFleetWithWidgetDefeated");
            this.endTrigger();
        }
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaDA_department", this.department);
        this.set("$gaDA_widget", this.widget);
        this.set("$gaDA_widgetNoArticle", this.getWidgetWithoutArticle());
        this.set("$gaDA_starName", this.entity.getStarSystem().getNameWithNoType());
        this.set("$gaDA_systemName", this.entity.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$gaDA_dist", this.getDistanceLY(this.entity));
        this.set("$gaDA_fuel", this.getFuel(this.entity, true));
        this.set("$gaDA_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaDA_piratePayment", Misc.getWithDGS(this.piratePayment));
        this.set("$gaDA_piratePaymentLow", Misc.getWithDGS(this.piratePaymentLow));
        this.set("$gaDA_scavPayment", Misc.getWithDGS(this.scavPayment));
        this.set("$gaDA_scavPaymentHigh", Misc.getWithDGS(this.scavPaymentHigh));
        this.set("$gaDA_notRemnants", this.variation != Variation.REMNANTS);
        this.set("$gaDA_variation", (Object)this.variation);
    }

    protected String getWidgetWithoutArticle() {
        if (this.widget.startsWith("a ")) {
            return this.widget.replaceFirst("a ", "");
        }
        if (this.widget.startsWith("an ")) {
            return this.widget.replaceFirst("an ", "");
        }
        return this.widget;
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_DERELCIT) {
            String extra = "";
            if (this.variation == Variation.REMNANTS) {
                extra = " 'Autonomous weapon systems' may pose a danger.";
            }
            info.addPara("Retrieve " + this.widget + " from a derelict ship " + this.getLocated(this.entity) + "." + extra, opad);
        } else if (this.currentStage == Stage.GET_IT_FROM_PIRATES) {
            SectorEntityToken cache = this.getEntityFromGlobal("$gaDA_cache");
            info.addPara("Retrieve the " + this.getWidgetWithoutArticle() + " from the pirates as they resupply from a cache " + this.getLocated(cache) + ".", opad);
        } else if (this.currentStage == Stage.GET_IT_FROM_SCAVENGER) {
            info.addPara("Go to the nearest jump-point and retrieve the " + this.getWidgetWithoutArticle() + " from scavengers before they leave the system.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("Return the " + this.getWidgetWithoutArticle() + " to the Galatia Academy and talk to " + this.getPerson().getNameString() + " to receive your reward.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_DERELCIT) {
            if (this.system.isCurrentLocation()) {
                info.addPara("Retrieve the " + this.getWidgetWithoutArticle() + " from a derelict ship", tc, pad);
            } else {
                info.addPara(this.getGoToSystemTextShort(this.system), tc, pad);
            }
            return true;
        }
        if (this.currentStage == Stage.GET_IT_FROM_PIRATES) {
            info.addPara("Retrieve the " + this.getWidgetWithoutArticle() + " from pirates in the " + this.pirateSystem.getNameWithLowercaseType(), tc, pad);
        } else if (this.currentStage == Stage.GET_IT_FROM_SCAVENGER) {
            info.addPara("Retrieve the " + this.getWidgetWithoutArticle() + " from scavengers at the nearest jump-point", tc, pad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("Return to the Galatia Academy and talk to " + this.getPerson().getNameString(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Derelict Artifact Recovery";
    }

    public static enum Stage {
        GO_TO_DERELCIT,
        GET_IT_FROM_PIRATES,
        GET_IT_FROM_SCAVENGER,
        RETURN_TO_ACADEMY,
        COMPLETED,
        FAILED;

    }

    public static enum Variation {
        BASIC,
        REMNANTS,
        PIRATES,
        SCAVENGER;

    }
}

