/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.cb.BaseCustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBStats;
import com.fs.starfarer.api.impl.campaign.missions.cb.CustomBountyCreator;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;

public class CBPather
extends BaseCustomBountyCreator {
    public static float PROB_IN_SYSTEM_WITH_BASE = 0.5f;

    @Override
    public float getFrequency(HubMissionWithBarEvent mission, int difficulty) {
        if ("luddic_path".equals(mission.getPerson().getFaction().getId())) {
            return 0.0f;
        }
        return super.getFrequency(mission, difficulty) * CBStats.PATHER_FREQ;
    }

    @Override
    public String getBountyNamePostfix(HubMissionWithBarEvent mission, CustomBountyCreator.CustomBountyData data) {
        return " - Pather";
    }

    @Override
    public CustomBountyCreator.CustomBountyData createBounty(MarketAPI createdAt, HubMissionWithBarEvent mission, int difficulty, Object bountyStage) {
        StarSystemAPI system;
        CustomBountyCreator.CustomBountyData data = new CustomBountyCreator.CustomBountyData();
        data.difficulty = difficulty;
        mission.requireSystemInterestingAndNotUnsafeOrCore();
        mission.requireSystemNotHasPulsar();
        if (difficulty >= 4 && mission.rollProbability(PROB_IN_SYSTEM_WITH_BASE)) {
            mission.preferSystemHasBase("luddic_path");
        }
        data.system = system = mission.pickSystem();
        HubMissionWithTriggers.FleetSize size = HubMissionWithTriggers.FleetSize.MEDIUM;
        HubMissionWithTriggers.FleetQuality quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
        String type = "patrolMedium";
        HubMissionWithTriggers.OfficerQuality oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
        HubMissionWithTriggers.OfficerNum oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
        String factionId = "luddic_path";
        if (difficulty <= 0) {
            size = HubMissionWithTriggers.FleetSize.TINY;
            quality = HubMissionWithTriggers.FleetQuality.VERY_LOW;
            oQuality = HubMissionWithTriggers.OfficerQuality.LOWER;
            oNum = HubMissionWithTriggers.OfficerNum.FC_ONLY;
            type = "patrolSmall";
        } else if (difficulty == 1) {
            size = HubMissionWithTriggers.FleetSize.VERY_SMALL;
            quality = HubMissionWithTriggers.FleetQuality.VERY_LOW;
            oQuality = HubMissionWithTriggers.OfficerQuality.LOWER;
            oNum = HubMissionWithTriggers.OfficerNum.FC_ONLY;
            type = "patrolSmall";
        } else if (difficulty == 2) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.LOWER;
            oNum = HubMissionWithTriggers.OfficerNum.FEWER;
            type = "patrolSmall";
        } else if (difficulty == 3) {
            size = HubMissionWithTriggers.FleetSize.SMALL;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = "patrolMedium";
        } else if (difficulty == 4 || difficulty == 5) {
            size = HubMissionWithTriggers.FleetSize.MEDIUM;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = "patrolMedium";
        } else if (difficulty == 6) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.DEFAULT;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.DEFAULT;
            type = "patrolLarge";
        } else if (difficulty == 7) {
            size = HubMissionWithTriggers.FleetSize.LARGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = "patrolLarge";
        } else if (difficulty == 8) {
            size = HubMissionWithTriggers.FleetSize.VERY_LARGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.DEFAULT;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = "patrolLarge";
        } else if (difficulty == 9) {
            size = HubMissionWithTriggers.FleetSize.HUGE;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = "patrolLarge";
        } else {
            size = HubMissionWithTriggers.FleetSize.MAXIMUM;
            quality = HubMissionWithTriggers.FleetQuality.HIGHER;
            oQuality = HubMissionWithTriggers.OfficerQuality.HIGHER;
            oNum = HubMissionWithTriggers.OfficerNum.MORE;
            type = "patrolLarge";
        }
        this.beginFleet(mission, data);
        mission.triggerCreateFleet(size, quality, factionId, type, data.system);
        mission.triggerSetFleetOfficers(oNum, oQuality);
        mission.triggerFleetPatherNoDefaultTithe();
        mission.triggerAutoAdjustFleetSize(size, size.next());
        mission.triggerSetStandardAggroPirateFlags();
        mission.triggerPickLocationAtInSystemJumpPoint(data.system);
        mission.triggerSpawnFleetAtPickedLocation(null, null);
        mission.triggerOrderFleetPatrol(data.system, true, "jump_point", "salvageable", "planet", "station");
        data.fleet = this.createFleet(mission, data);
        if (data.fleet == null) {
            return null;
        }
        this.setRepChangesBasedOnDifficulty(data, difficulty);
        data.baseReward = CBStats.getBaseBounty(difficulty, CBStats.PATHER_MULT, mission);
        return data;
    }
}

