/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.luddic;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithSearch;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class BornanewFilesFalseIdols
extends HubMissionWithSearch {
    protected PersonAPI bornanew;
    protected PersonAPI jaspis;
    protected PersonAPI ulmus_pond;
    protected PersonAPI sedge;
    protected PersonAPI menes_yaribay;
    protected PersonAPI horus_yaribay;
    protected PersonAPI cedra_keepfaith;
    protected MarketAPI asher;
    protected MarketAPI chalcedon;
    protected MarketAPI olinadu;
    protected MarketAPI kazeron;
    protected MarketAPI gilead;
    protected MarketAPI hesperus;
    protected MarketAPI tartessus;
    protected MarketAPI bornanewLocation;
    protected StarSystemAPI patherBaseSystem;
    protected LuddicPathBaseIntel patherStation;
    protected CampaignFleetAPI patherStationFleet;
    protected int stationSalvorLoss;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$bffi_ref", "$bffi_inProgress")) {
            return false;
        }
        this.chalcedon = Global.getSector().getEconomy().getMarket("chalcedon");
        if (this.chalcedon == null) {
            return false;
        }
        if (!this.chalcedon.getFactionId().equals("luddic_path")) {
            return false;
        }
        this.gilead = Global.getSector().getEconomy().getMarket("gilead");
        if (this.gilead == null) {
            return false;
        }
        if (!this.gilead.getFactionId().equals("luddic_church")) {
            return false;
        }
        this.kazeron = Global.getSector().getEconomy().getMarket("kazeron");
        if (this.kazeron == null) {
            return false;
        }
        if (!this.kazeron.getFactionId().equals("persean")) {
            return false;
        }
        this.olinadu = Global.getSector().getEconomy().getMarket("olinadu");
        if (this.olinadu == null) {
            return false;
        }
        if (!this.olinadu.getFactionId().equals("persean")) {
            return false;
        }
        this.hesperus = Global.getSector().getEconomy().getMarket("hesperus");
        if (this.hesperus == null) {
            return false;
        }
        if (!this.hesperus.getFactionId().equals("luddic_church")) {
            return false;
        }
        this.tartessus = Global.getSector().getEconomy().getMarket("tartessus");
        if (this.tartessus == null) {
            return false;
        }
        if (!this.tartessus.getFactionId().equals("luddic_church")) {
            return false;
        }
        this.asher = Global.getSector().getEconomy().getMarket("asher");
        if (this.asher == null) {
            return false;
        }
        if (!this.asher.getFactionId().equals("luddic_church")) {
            return false;
        }
        this.bornanew = this.getImportantPerson(People.BORNANEW);
        if (this.bornanew == null) {
            return false;
        }
        this.jaspis = this.getImportantPerson(People.JASPIS);
        if (this.bornanew == null) {
            return false;
        }
        this.ulmus_pond = this.getImportantPerson(People.ULMUS_POND);
        if (this.ulmus_pond == null) {
            return false;
        }
        this.menes_yaribay = this.getImportantPerson(People.MENES_YARIBAY);
        if (this.menes_yaribay == null) {
            return false;
        }
        this.horus_yaribay = this.getImportantPerson(People.HORUS_YARIBAY);
        if (this.horus_yaribay == null) {
            return false;
        }
        this.cedra_keepfaith = this.getImportantPerson(People.CEDRA_KEEPFAITH);
        if (this.cedra_keepfaith == null) {
            return false;
        }
        this.resetSearch();
        this.requireSystemTags(ReqMode.ANY, "theme_misc", "theme_misc_skip", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_unsafe", "theme_core", "system_already_used_for_story");
        this.requireSystemNotAlreadyUsedForStory();
        this.requireSystemNotHasPulsar();
        this.preferSystemOnFringeOfSector();
        this.preferSystemUnexplored();
        this.preferSystemInDirectionOfOtherMissions();
        this.patherBaseSystem = this.pickSystem();
        if (this.patherBaseSystem == null) {
            return false;
        }
        this.setStoryMission();
        this.setStartingStage((Object)Stage.PICK_UP_BORNANEW);
        this.connectWithGlobalFlag((Object)Stage.PICK_UP_BORNANEW, (Object)Stage.MEET_MENES_YARIBAY, "$bffi_goMeetMenesYaribay");
        this.setStageOnGlobalFlag((Object)Stage.ATTEND_A_PARTY, "$bffi_gotPartyInvite");
        this.setStageOnGlobalFlag((Object)Stage.TALK_TO_HORUS, "$bffi_goTalkToHorus");
        this.setStageOnGlobalFlag((Object)Stage.TALK_TO_ENGINEER, "$bffi_talkToEngineer");
        this.setStageOnGlobalFlag((Object)Stage.TALK_TO_ULMUS_POND, "$bffi_talkToUlmusPond");
        this.setStageOnGlobalFlag((Object)Stage.GO_TO_CHALCEDON, "$bffi_followUlmusPond");
        this.setStageOnGlobalFlag((Object)Stage.INVESTIGATE_PATHER_STATION, "$bffi_investigatePatherStation");
        this.setStageOnGlobalFlag((Object)Stage.ARREST_THE_CURATE, "$bffi_arrestTheCurate");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_HESPERUS_EARLY, "$bffi_destroyedStationEarly");
        this.setStageOnGlobalFlag((Object)Stage.GO_TO_HESPERUS, "$bffi_returnBornanewBody");
        this.setStageOnGlobalFlag((Object)Stage.GO_TO_HESPERUS, "$bffi_keepfaithEscapedTartessus");
        this.setStageOnGlobalFlag((Object)Stage.ARREST_THE_CURATE, "$bffi_learnedAboutKeepfaith");
        this.setStageOnGlobalFlag((Object)Stage.DELIVER_KEEPFAITH, "$bffi_arrestedKeepfaith");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$bffi_completed");
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.makeImportant(this.bornanew, "$bffi_pickUpBornanew", Stage.PICK_UP_BORNANEW);
        this.makeImportant(this.menes_yaribay, "$bffi_meetMenesYaribay", Stage.MEET_MENES_YARIBAY);
        this.makeImportant(this.olinadu, "$bffi_attendAParty", Stage.ATTEND_A_PARTY);
        this.makeImportant(this.horus_yaribay, "$bffi_talkToHorusAboutMenesParty", Stage.TALK_TO_HORUS);
        this.makeImportant(this.asher, "$bffi_talkToEngineer", Stage.TALK_TO_ENGINEER);
        this.makeImportant(this.ulmus_pond, "$bffi_talkToUlmusPond", Stage.TALK_TO_ULMUS_POND);
        this.makeImportant(this.chalcedon, "$bffi_followUlmusPond", Stage.GO_TO_CHALCEDON);
        this.makeImportant(this.tartessus, "$bffi_arrestTheCurate", Stage.ARREST_THE_CURATE);
        this.makeImportant(this.hesperus, "$bffi_deliverKeepfaith", Stage.DELIVER_KEEPFAITH);
        this.makeImportant(this.hesperus, "$bffi_goToHesperus", Stage.GO_TO_HESPERUS);
        this.makeImportant(this.hesperus, "$bffi_goToHesperus", Stage.RETURN_TO_HESPERUS_EARLY);
        this.setName("False Idols");
        this.setRepFactionChangesNone();
        this.setRepPersonChangesNone();
        this.beginStageTrigger(new Object[]{Stage.ATTEND_A_PARTY});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.DEFAULT, "persean", "patrolMedium", this.olinadu.getPlanetEntity());
        this.triggerPickLocationAroundEntity(this.olinadu.getPlanetEntity(), 1600.0f);
        this.triggerSpawnFleetAtPickedLocation("$gaDHO_arrayFleet", null);
        this.triggerOrderFleetPatrol(false, this.olinadu.getPlanetEntity(), this.olinadu.getStarSystem().getJumpPoints().get(0));
        this.triggerSetFleetMissionRef("$bffi_ref");
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.TALK_TO_ENGINEER});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.DEFAULT, "persean", "patrolMedium", this.olinadu.getPlanetEntity());
        this.triggerFleetAllowLongPursuit();
        this.triggerPickLocationAroundEntity(this.olinadu.getPlanetEntity(), 1000.0f);
        this.triggerSetFleetMissionRef("$bffi_ref");
        this.triggerSpawnFleetAtPickedLocation("$bffi_postRaidPatrol", null);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.TALK_TO_ENGINEER});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.SMALL, HubMissionWithTriggers.FleetQuality.DEFAULT, "persean", "patrolMedium", this.olinadu.getPlanetEntity());
        this.triggerSetFleetFaction("persean");
        this.triggerPickLocationTowardsEntity(this.olinadu.getStarSystem().getHyperspaceAnchor(), 30.0f, BornanewFilesFalseIdols.getUnits(1.5f));
        this.triggerSetFleetMissionRef("$bffi_ref");
        this.triggerSpawnFleetAtPickedLocation("$bffi_postRaidPatrol", null);
        this.triggerOrderFleetPatrol(false, this.olinadu.getPlanetEntity(), this.olinadu.getStarSystem().getJumpPoints().get(1));
        this.endTrigger();
        this.beginWithinHyperspaceRangeTrigger(this.chalcedon.getPlanetEntity(), 1.0f, false, new Object[]{Stage.GO_TO_CHALCEDON});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.DEFAULT, "luddic_path", "patrolMedium", this.chalcedon.getPlanetEntity());
        this.triggerSetFleetFaction("luddic_path");
        this.triggerPickLocationAroundEntity(this.chalcedon.getPlanetEntity(), 800.0f);
        this.triggerOrderFleetPatrol(this.chalcedon.getPlanetEntity());
        this.triggerSpawnFleetAtPickedLocation("$bffi_patherGoblins", null);
        this.triggerSetFleetMissionRef("$bffi_ref");
        if (Global.getSector().getFaction("luddic_path").getRelToPlayer().isAtBest(RepLevel.HOSTILE)) {
            this.triggerMakeHostileAndAggressive();
        }
        this.triggerFleetSetPatrolLeashRange(1400.0f);
        this.triggerMakeFleetGoAwayAfterDefeat();
        this.endTrigger();
        this.beginWithinHyperspaceRangeTrigger(this.chalcedon, 3.0f, true, new Object[]{Stage.INVESTIGATE_PATHER_STATION});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGER, HubMissionWithTriggers.FleetQuality.HIGHER, "luddic_path", "patrolLarge", this.chalcedon.getLocationInHyperspace());
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeHostileAndAggressive();
        this.triggerFleetMakeFaster(true, 2, true);
        this.triggerSetFleetAlwaysPursue();
        this.triggerPickLocationTowardsEntity(this.chalcedon.getStarSystem().getHyperspaceAnchor(), 30.0f, BornanewFilesFalseIdols.getUnits(1.5f));
        this.triggerSpawnFleetAtPickedLocation("$bffi_patherIntercept", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerSetFleetMissionRef("$bffi_ref");
        this.triggerFleetMakeImportant(null, Stage.INVESTIGATE_PATHER_STATION);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerMakeNonStoryCritical("asher", "chalcedon", "olinadu", "kazeron", "gilead", "hesperus", "tartessus");
        this.triggerSetGlobalMemoryValue("$bffi_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$bffi_stage", this.getCurrentStage());
        this.set("$bffi_patherStationSystem", this.patherBaseSystem.getName());
    }

    @Override
    protected boolean callAction(String action, String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if ("spawnPatherBase".equals(action)) {
            this.patherStation = new LuddicPathBaseIntel(this.patherBaseSystem, "luddic_path");
            MemoryAPI mem = this.patherStation.getEntity().getMemoryWithoutUpdate();
            mem.set("$bffi_patherStationTarget", true);
            Global.getSector().addScript(this.patherStation);
            CampaignFleetAPI patherStationFleet = Misc.getStationFleet(this.patherStation.getMarket());
            Misc.makeImportant(this.patherStation.getEntity(), "$bffi_investigatePatherStation");
            Misc.addDefeatTrigger(patherStationFleet, "BFFIpatherStationDefeated");
            return true;
        }
        if ("cleanUpPatherBase".equals(action)) {
            Misc.makeUnimportant(this.patherStation.getEntity(), "$bffi_investigatePatherStation");
            return true;
        }
        if ("patherBaseLosses".equals(action)) {
            Global.getSoundPlayer().playSound("explosion_from_damage", 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
            return true;
        }
        if ("shootEm".equals(action)) {
            Global.getSoundPlayer().playSound("storyevent_diktat_execution", 1.0f, 1.0f, Global.getSoundPlayer().getListenerPos(), new Vector2f());
            return true;
        }
        if ("ulmusPondMaskOff".equals(action)) {
            this.ulmus_pond.setFaction("luddic_path");
            return true;
        }
        if ("setCourseChalcedon".equals(action)) {
            Global.getSector().layInCourseFor(this.chalcedon.getPlanetEntity());
            return true;
        }
        if ("doCleanup".equals(action)) {
            Global.getSector().getMemoryWithoutUpdate().unset("$bffi_jethroCalledOutPond");
            return true;
        }
        return super.callAction(action, ruleId, dialog, params, memoryMap);
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        if (this.currentStage == Stage.PICK_UP_BORNANEW) {
            info.addPara("Pick up Jethro Bornanew from Gilead.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.gilead, info, opad);
        } else if (this.currentStage == Stage.MEET_MENES_YARIBAY) {
            info.addPara("Go to Olinadu and contact Menes Yaribay, the planetary administrator.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.olinadu, info, opad);
        } else if (this.currentStage == Stage.TALK_TO_HORUS) {
            info.addPara("Go to Kazeron and talk to Horus Yaribay about his cousin Menes.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.kazeron, info, opad);
        } else if (this.currentStage == Stage.ATTEND_A_PARTY) {
            if (Global.getSector().getMemoryWithoutUpdate().contains("$bffi_intendToSteal")) {
                info.addPara("Attend Menes Yaribay's 'gathering' on Olinadu and find a way to steal the false relic.", opad);
                BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.olinadu, info, opad);
            } else if (Global.getSector().getMemoryWithoutUpdate().contains("$bffi_horusToParty")) {
                info.addPara("Attend Menes Yaribay's 'gathering' on Olinadu with Horus Yaribay, the patriarch of Gens Yaribay.", opad);
                BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.olinadu, info, opad);
            } else {
                info.addPara("Attend Menes Yaribay's 'gathering' on Olinadu and acquire the false relic.", opad);
                BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.olinadu, info, opad);
            }
        } else if (this.currentStage == Stage.TALK_TO_ENGINEER) {
            info.addPara("Bring the false relic to Asher so that a nanoforge engineer in the employ of the Church can examine it.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.asher, info, opad);
        } else if (this.currentStage == Stage.TALK_TO_ULMUS_POND) {
            info.addPara("Go to Olinadu and confront Ulmus Pond to get a confession.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.asher, info, opad);
        } else if (this.currentStage == Stage.GO_TO_CHALCEDON) {
            info.addPara("Go to Chalcedon and use Bornanew's intel to track down where Ulmus Pond is hiding.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.chalcedon, info, opad);
        } else if (this.currentStage == Stage.INVESTIGATE_PATHER_STATION) {
            info.addPara(String.valueOf(this.getGoToSystemTextShort(this.patherStation.getMarket().getStarSystem())) + " and investigate. Find where the glove came from and how it was made. Ensure no more will be created.", opad);
        } else if (this.currentStage == Stage.ARREST_THE_CURATE) {
            info.addPara("Go to the Cathedral of Holy Exodus, on Tartessus, and arrest Subcurate Cedra Keepfaith.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.tartessus, info, opad);
        } else if (this.currentStage == Stage.DELIVER_KEEPFAITH) {
            info.addPara("Deliver Cedra Keepfaith to the Knights of Ludd on Hesperus to face their justice.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.hesperus, info, opad);
        } else if (this.currentStage == Stage.GO_TO_HESPERUS) {
            if (Global.getSector().getMemoryWithoutUpdate().contains("$bffi_keepfaithEscapedTartessus")) {
                info.addPara("Report back to Excubitor Orbis Gideon Oak on Hesperus with news of Bornanew's quest.", opad);
                BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.hesperus, info, opad);
            } else {
                info.addPara("Return Jethro Bornanew's body to the Knights of Ludd on Hesperus so he may rest with his fellow Knights.", opad);
                BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.hesperus, info, opad);
            }
        } else if (this.currentStage == Stage.RETURN_TO_HESPERUS_EARLY) {
            info.addPara("Report back to Excubitor Orbis Gideon Oak on Hesperus with news of Bornanew's quest.", opad);
            BornanewFilesFalseIdols.addStandardMarketDesc("Go to ", this.hesperus, info, opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        if (this.currentStage == Stage.PICK_UP_BORNANEW) {
            info.addPara("Send a shuttle down to pick Novice Bornanew up from Gilead", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.MEET_MENES_YARIBAY) {
            info.addPara("Go to Olinadu and talk to the administrator, Menes Yaribay", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.TALK_TO_HORUS) {
            info.addPara("Go to Kazeron and talk to Horus Yaribay about Menes", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.ATTEND_A_PARTY) {
            if (Global.getSector().getMemoryWithoutUpdate().contains("$bffi_intendToSteal")) {
                info.addPara("Attend the 'gathering' organized by Menes Yaribay on Olinadu", tc, pad);
            } else {
                info.addPara("Attend the 'gathering' organized by Menes Yaribay on Olinadu", tc, pad);
            }
            return true;
        }
        if (this.currentStage == Stage.TALK_TO_ENGINEER) {
            info.addPara("Bring the false relic to Asher to be examined by a nanoforge engineer", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.TALK_TO_ULMUS_POND) {
            info.addPara("Go to Olinadu and talk to Ulmus Pond", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_CHALCEDON) {
            info.addPara("Go to Chalcedon and find Ulmus Pond", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INVESTIGATE_PATHER_STATION) {
            info.addPara("Go to " + this.patherStation.getSystem().getName() + " and find the source of the 'relic'.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.ARREST_THE_CURATE) {
            info.addPara("Go to the Cathedral of Holy Exodus on Tartessus and arrest Subcurate Cedra Keepfaith", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.DELIVER_KEEPFAITH) {
            info.addPara("Bring Cedra Keeptfaith to Hesperus to face the justice of the Knights of Ludd", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_HESPERUS) {
            if (Global.getSector().getMemoryWithoutUpdate().contains("$global.bffi_keepfaithEscapedTartessus")) {
                info.addPara("Report back to Excubitor Orbis Gideon Oak on Hesperus", tc, pad);
            } else {
                info.addPara("Return Jethro Bornanew's body to the Knights of Ludd on Hesperus", tc, pad);
            }
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_HESPERUS_EARLY) {
            info.addPara("Report back to Excubitor Orbis Gideon Oak on Hesperus", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.patherStation != null && this.currentStage == Stage.INVESTIGATE_PATHER_STATION) {
            return this.patherStation.getEntity();
        }
        return super.getMapLocation(map);
    }

    public static enum Stage {
        PICK_UP_BORNANEW,
        MEET_MENES_YARIBAY,
        ATTEND_A_PARTY,
        TALK_TO_HORUS,
        TALK_TO_ENGINEER,
        TALK_TO_ULMUS_POND,
        GO_TO_CHALCEDON,
        INVESTIGATE_PATHER_STATION,
        RETURN_TO_HESPERUS_EARLY,
        GO_TO_HESPERUS,
        ARREST_THE_CURATE,
        DELIVER_KEEPFAITH,
        COMPLETED;

    }
}

