/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CategoryGenDataSpec {
    private String category;
    private float frequency;
    private Map<String, Float> multipliers = new HashMap<String, Float>();

    public CategoryGenDataSpec(JSONObject row) throws JSONException {
        this.category = row.getString("category");
        this.frequency = (float)row.getDouble("frequency");
        String[] stringArray = JSONObject.getNames((JSONObject)row);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            float frequency = (float)row.optDouble(key, 1.0);
            if (frequency != 1.0f) {
                this.multipliers.put(key, Float.valueOf(frequency));
            }
            ++n2;
        }
    }

    public String toString() {
        return this.getCategory();
    }

    public String getCategory() {
        return this.category;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public float getMultiplier(String key) {
        if (!this.multipliers.containsKey(key)) {
            return 1.0f;
        }
        return this.multipliers.get(key).floatValue();
    }

    public Map<String, Float> getMultipliers() {
        return this.multipliers;
    }
}

