/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.shared;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeProfitabilityData;
import com.fs.starfarer.api.impl.campaign.shared.ReputationChangeTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class PlayerActivityTracker {
    private Map<MarketAPI, Long> lastVisit = new HashMap<MarketAPI, Long>();
    private Map<SubmarketAPI, PlayerTradeDataForSubmarket> submarketTradeData = new LinkedHashMap<SubmarketAPI, PlayerTradeDataForSubmarket>();
    private PlayerTradeProfitabilityData profitabilityData = new PlayerTradeProfitabilityData();
    private ReputationChangeTracker repChangeTracker = new ReputationChangeTracker();
    private FleetStatsSnapshot playerFleetStats = new FleetStatsSnapshot();

    protected Object readResolve() {
        if (this.profitabilityData == null) {
            this.profitabilityData = new PlayerTradeProfitabilityData();
        }
        if (this.repChangeTracker == null) {
            this.repChangeTracker = new ReputationChangeTracker();
        }
        if (this.playerFleetStats == null) {
            this.playerFleetStats = new FleetStatsSnapshot();
        }
        return this;
    }

    public void advance(float days) {
        ArrayList<SubmarketAPI> remove = new ArrayList<SubmarketAPI>();
        for (PlayerTradeDataForSubmarket data : this.submarketTradeData.values()) {
            data.advance(days);
            MarketAPI market = Global.getSector().getEconomy().getMarket(data.getMarket().getId());
            if (market != null && market.getSubmarket(data.getSubmarket().getSpecId()) != null && market.getSubmarket(data.getSubmarket().getSpecId()) == data.getSubmarket()) continue;
            remove.add(data.getSubmarket());
        }
        for (SubmarketAPI sub : remove) {
            this.submarketTradeData.remove(sub);
        }
        ArrayList<MarketAPI> remove2 = new ArrayList<MarketAPI>();
        for (MarketAPI curr : this.lastVisit.keySet()) {
            if (curr.getPrimaryEntity() != null && curr.getPrimaryEntity().isAlive()) continue;
            remove2.add(curr);
        }
        for (MarketAPI curr : remove2) {
            this.lastVisit.remove(curr);
        }
        this.profitabilityData.advance(days);
        this.repChangeTracker.advance(days);
        this.playerFleetStats.update();
    }

    public ReputationChangeTracker getRepChangeTracker() {
        return this.repChangeTracker;
    }

    public PlayerTradeProfitabilityData getProfitabilityData() {
        return this.profitabilityData;
    }

    public void updateLastVisit(MarketAPI market) {
        Long timestamp = Global.getSector().getClock().getTimestamp();
        this.lastVisit.put(market, timestamp);
    }

    public float getDaysSinceLastVisitTo(MarketAPI market) {
        Long timestamp = this.lastVisit.get(market);
        if (timestamp == null) {
            return 10000.0f;
        }
        return Global.getSector().getClock().getElapsedDaysSince(timestamp);
    }

    public PlayerTradeDataForSubmarket getPlayerTradeData(SubmarketAPI submarket) {
        PlayerTradeDataForSubmarket data = this.submarketTradeData.get(submarket);
        if (data == null) {
            data = new PlayerTradeDataForSubmarket(submarket);
            this.submarketTradeData.put(submarket, data);
        }
        return data;
    }

    public FleetStatsSnapshot getPlayerFleetStats() {
        return this.playerFleetStats;
    }

    public Map<SubmarketAPI, PlayerTradeDataForSubmarket> getSubmarketTradeData() {
        return this.submarketTradeData;
    }

    public static class FleetStatsSnapshot
    implements Cloneable {
        private float fleetPoints;
        private float cargoOnBoard;
        private float cargoCapacity;
        private float fuelOnBoard;
        private float fuelCapacity;
        private float numShips;
        private float fleetSizeNum;

        public void update() {
            CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
            this.fleetPoints = pf.getFleetPoints();
            this.cargoOnBoard = pf.getCargo().getSpaceUsed();
            this.cargoCapacity = pf.getCargo().getMaxCapacity();
            this.fuelOnBoard = pf.getCargo().getFuel();
            this.fuelCapacity = pf.getCargo().getMaxFuel();
            this.numShips = pf.getFleetData().getMembersListCopy().size();
            this.fleetSizeNum = pf.getFleetSizeCount();
        }

        public FleetStatsSnapshot clone() {
            try {
                return (FleetStatsSnapshot)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public float getFleetPoints() {
            return this.fleetPoints;
        }

        public void setFleetPoints(float fleetPoints) {
            this.fleetPoints = fleetPoints;
        }

        public float getCargoOnBoard() {
            return this.cargoOnBoard;
        }

        public void setCargoOnBoard(float cargoOnBoard) {
            this.cargoOnBoard = cargoOnBoard;
        }

        public float getCargoCapacity() {
            return this.cargoCapacity;
        }

        public void setCargoCapacity(float cargoCapacity) {
            this.cargoCapacity = cargoCapacity;
        }

        public float getFuelOnBoard() {
            return this.fuelOnBoard;
        }

        public void setFuelOnBoard(float fuelOnBoard) {
            this.fuelOnBoard = fuelOnBoard;
        }

        public float getFuelCapacity() {
            return this.fuelCapacity;
        }

        public void setFuelCapacity(float fuelCapacity) {
            this.fuelCapacity = fuelCapacity;
        }

        public float getNumShips() {
            return this.numShips;
        }

        public void setNumShips(float numShips) {
            this.numShips = numShips;
        }

        public float getFleetSizeNum() {
            return this.fleetSizeNum;
        }

        public void setFleetSizeNum(float fleetSizeNum) {
            this.fleetSizeNum = fleetSizeNum;
        }
    }
}

