/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.util.Misc;

public class OrdnanceExpertise {
    public static float MAX_CR_BONUS = 15.0f;
    public static float FLUX_PER_OP = 1.5f;
    public static float CAP_PER_OP = 20.0f;

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (stats.getVariant() != null) {
                MutableCharacterStatsAPI cStats = BaseSkillEffectDescription.getCommanderStats(stats);
                float flux = FLUX_PER_OP * (float)stats.getVariant().computeWeaponOPCost(cStats);
                stats.getFluxDissipation().modifyFlat(id, flux);
            }
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFluxDissipation().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            if ((float)((int)FLUX_PER_OP) != FLUX_PER_OP) {
                return "+" + Misc.getRoundedValueMaxOneAfterDecimal(FLUX_PER_OP) + " flux dissipation per ordnance point spent on weapons";
            }
            return "+" + (int)FLUX_PER_OP + " flux dissipation per ordnance point spent on weapons";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxCombatReadiness().modifyFlat(id, MAX_CR_BONUS * 0.01f, "Ordnance Expertise skill");
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)MAX_CR_BONUS + "% maximum combat readiness";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            if (stats.getVariant() != null) {
                MutableCharacterStatsAPI cStats = BaseSkillEffectDescription.getCommanderStats(stats);
                float flux = CAP_PER_OP * (float)stats.getVariant().computeWeaponOPCost(cStats);
                stats.getFluxCapacity().modifyFlat(id, flux);
            }
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getFluxCapacity().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)CAP_PER_OP + " flux capacity per ordnance point spent on weapons";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

