/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class PointDefense {
    public static float FIGHTER_DAMAGE_BONUS = 50.0f;
    public static float MISSILE_DAMAGE_BONUS = 50.0f;
    public static float PD_RANGE_BONUS_FLAT = 200.0f;

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToFighters().modifyFlat(id, FIGHTER_DAMAGE_BONUS / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToFighters().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)FIGHTER_DAMAGE_BONUS + "% damage to fighters";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDamageToMissiles().modifyFlat(id, MISSILE_DAMAGE_BONUS / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDamageToMissiles().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)MISSILE_DAMAGE_BONUS + "% damage to missiles";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getNonBeamPDWeaponRangeBonus().modifyFlat(id, PD_RANGE_BONUS_FLAT);
            stats.getBeamPDWeaponRangeBonus().modifyFlat(id, PD_RANGE_BONUS_FLAT);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getNonBeamPDWeaponRangeBonus().unmodifyFlat(id);
            stats.getBeamPDWeaponRangeBonus().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Extends the range of point-defense weapons by " + (int)PD_RANGE_BONUS_FLAT;
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }
}

