/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.FleetStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class RecoveryOperations {
    public static final float OWN_WEAPON_WING_RECOVERY_BONUS = 30.0f;
    public static final float ENEMY_WEAPON_WING_RECOVERY_BONUS = 25.0f;
    public static final float SHIP_RECOVERY_BONUS = 25.0f;
    public static final float DMOD_REDUCTION = 2.0f;
    public static final float CREW_LOSS_REDUCTION = 30.0f;
    public static final float REPAIR_RATE_BONUS = 100.0f;
    public static final float FUEL_SALVAGE_BONUS = 50.0f;

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            float baseW = Math.round(Global.getSettings().getFloat("salvageWeaponProb") * 100.0f);
            float baseS = Math.round(Global.getSettings().getFloat("baseShipRecoveryChance") * 100.0f);
            float baseWO = Math.round(Global.getSettings().getFloat("salvageOwnWeaponProb") * 100.0f);
            float baseSO = Math.round(Global.getSettings().getFloat("baseOwnShipRecoveryChance") * 100.0f);
            return String.format("The base chance to be recoverable is %d%% for disabled enemy ships, and %d%% for your ships. The base chance for weapons from disabled enemy ships to be recovered is %d%%, and %d%% for weapons from your ships. Ships that have broken apart have half the chance to be recoverable and always suffer lasting structural damage.", (int)baseS, (int)baseSO, (int)baseW, (int)baseWO);
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            return new Color[]{h, h, h, h};
        }

        @Override
        public String[] getHighlights() {
            String baseW = Math.round(Global.getSettings().getFloat("salvageWeaponProb") * 100.0f) + "%";
            String baseS = Math.round(Global.getSettings().getFloat("baseShipRecoveryChance") * 100.0f) + "%";
            String baseWO = Math.round(Global.getSettings().getFloat("salvageOwnWeaponProb") * 100.0f) + "%";
            String baseSO = Math.round(Global.getSettings().getFloat("baseOwnShipRecoveryChance") * 100.0f) + "%";
            return new String[]{baseS, baseSO, baseW, baseWO};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("own_weapon_recovery_mod").modifyFlat(id, 0.29999998f);
            stats.getDynamic().getMod("own_wing_recovery_mod").modifyFlat(id, 0.29999998f);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("own_weapon_recovery_mod").unmodify(id);
            stats.getDynamic().getMod("own_wing_recovery_mod").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+30% chance to recover weapons and fighter LPCs from own ships lost in battle";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level1B
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("enemy_weapon_recovery_mod").modifyFlat(id, 0.25f);
            stats.getDynamic().getMod("enemy_wing_recovery_mod").modifyFlat(id, 0.25f);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("enemy_weapon_recovery_mod").unmodify(id);
            stats.getDynamic().getMod("enemy_wing_recovery_mod").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+25% chance to recover weapons and fighter LPCs from enemy ships";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_recovery_mod").modifyFlat(id, 0.25f);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_recovery_mod").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+25% chance to recover disabled ships after battle";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2A
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getCrewLossMult().modifyMult(id, 0.7f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCrewLossMult().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-30% crew lost due to hull damage in combat";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2B
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("overall_crew_loss_mult").modifyMult(id, 0.7f);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("overall_crew_loss_mult").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-30% crew lost in non-combat operations";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("ship_dmod_reduction_mod").modifyFlat(id, 2.0f);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getMod("ship_dmod_reduction_mod").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Recovered ships have fewer d-mods on average";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level3B
    implements FleetStatsSkillEffect {
        @Override
        public void apply(MutableFleetStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").modifyFlat(id, 0.5f);
        }

        @Override
        public void unapply(MutableFleetStatsAPI stats, String id) {
            stats.getDynamic().getStat("fuel_salvage_value_mult_fleet").unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            float max = 0.0f;
            return "+" + (int)(max += 50.0f) + "% fuel salvaged";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

