/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class StoragePlugin
extends BaseSubmarketPlugin {
    private boolean playerPaidToUnlock = false;

    @Override
    public void init(SubmarketAPI submarket) {
        super.init(submarket);
    }

    @Override
    public void updateCargoPrePlayerInteraction() {
    }

    @Override
    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        if (this.market.isPlayerOwned()) {
            return false;
        }
        return super.isIllegalOnSubmarket(stack, action);
    }

    @Override
    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        if (this.market.isPlayerOwned()) {
            return false;
        }
        return super.isIllegalOnSubmarket(commodityId, action);
    }

    @Override
    public boolean isIllegalOnSubmarket(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        if (this.market.isPlayerOwned() || this.market.getFaction() != null && this.market.getFaction().isNeutralFaction()) {
            return false;
        }
        return super.isIllegalOnSubmarket(member, action);
    }

    @Override
    public boolean isParticipatesInEconomy() {
        return false;
    }

    @Override
    public float getTariff() {
        return 0.0f;
    }

    @Override
    public boolean isFreeTransfer() {
        return true;
    }

    @Override
    public String getBuyVerb() {
        return "Take";
    }

    @Override
    public String getSellVerb() {
        return "Leave";
    }

    @Override
    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return "Illegal to put into storage here";
    }

    @Override
    public boolean isEnabled(CoreUIAPI ui) {
        return true;
    }

    public void setPlayerPaidToUnlock(boolean playerPaidToUnlock) {
        this.playerPaidToUnlock = playerPaidToUnlock;
    }

    @Override
    public SubmarketPlugin.OnClickAction getOnClickAction(CoreUIAPI ui) {
        if (this.playerPaidToUnlock) {
            return SubmarketPlugin.OnClickAction.OPEN_SUBMARKET;
        }
        return SubmarketPlugin.OnClickAction.SHOW_TEXT_DIALOG;
    }

    private int getUnlockCost() {
        return 5000;
    }

    private boolean canPlayerAffordUnlock() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        int credits = (int)playerFleet.getCargo().getCredits().get();
        return credits >= this.getUnlockCost();
    }

    @Override
    public String getDialogText(CoreUIAPI ui) {
        if (this.canPlayerAffordUnlock()) {
            return "Gaining access to storage at this colony requires a one-time fee of " + this.getUnlockCost() + " credits.";
        }
        return "Gaining access to storage at this colony requires a one-time fee of " + this.getUnlockCost() + " credits, which you can't afford.";
    }

    @Override
    public Highlights getDialogTextHighlights(CoreUIAPI ui) {
        Highlights h = new Highlights();
        h.setText("" + this.getUnlockCost());
        if (this.canPlayerAffordUnlock()) {
            h.setColors(Misc.getHighlightColor());
        } else {
            h.setColors(Misc.getNegativeHighlightColor());
        }
        return h;
    }

    @Override
    public SubmarketPlugin.DialogOption[] getDialogOptions(CoreUIAPI ui) {
        if (this.canPlayerAffordUnlock()) {
            return new SubmarketPlugin.DialogOption[]{new SubmarketPlugin.DialogOption("Pay", new Script(){

                @Override
                public void run() {
                    CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                    playerFleet.getCargo().getCredits().subtract(StoragePlugin.this.getUnlockCost());
                    StoragePlugin.this.playerPaidToUnlock = true;
                }
            }), new SubmarketPlugin.DialogOption("Never mind", null)};
        }
        return new SubmarketPlugin.DialogOption[]{new SubmarketPlugin.DialogOption("Never mind", null)};
    }

    @Override
    public String getTooltipAppendix(CoreUIAPI ui) {
        return null;
    }

    @Override
    public Highlights getTooltipAppendixHighlights(CoreUIAPI ui) {
        return null;
    }

    @Override
    protected void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        int shipCost;
        if (!this.market.isInEconomy()) {
            return;
        }
        float opad = 10.0f;
        float pad = 3.0f;
        if (this.market.isPlayerOwned()) {
            tooltip.addPara(Misc.getTokenReplaced("$marketName is under your control, and there are no storage fees or expenses.", this.market.getPrimaryEntity()), opad);
            return;
        }
        float f = Misc.getStorageFeeFraction();
        int percent = (int)(f * 100.0f);
        Color h = Misc.getHighlightColor();
        if (!this.playerPaidToUnlock) {
            tooltip.addPara("Requires a one-time access fee of %s, and a monthly fee equal to %s of the base value of the items in storage.", opad, h, this.getUnlockCost() + "\u00a2", percent + "%");
            return;
        }
        int cargoCost = (int)(Misc.getStorageCargoValue(this.market) * f);
        if (cargoCost + (shipCost = (int)(Misc.getStorageShipValue(this.market) * f)) > 0) {
            tooltip.addPara("Monthly fees and expenses (%s of base value of stored items):", opad, h, percent + "%");
            tooltip.beginGridFlipped(300.0f, 1, 80.0f, 10.0f);
            int j = 0;
            tooltip.addToGrid(0, j++, "Ships in storage", Misc.getDGSCredits(shipCost));
            tooltip.addToGrid(0, j++, "Cargo in storage", Misc.getDGSCredits(cargoCost));
            tooltip.addGrid(pad);
        } else {
            tooltip.addPara("Monthly fees and expenses are equal to %s of base value of the stored items.", opad, h, percent + "%");
        }
    }
}

