/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.velfield;

import com.fs.starfarer.api.impl.campaign.velfield.BoundingBox;
import com.fs.starfarer.api.impl.campaign.velfield.SlipstreamTerrainPlugin2;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SlipstreamBuilder {
    public static float MIN_SPACING = 200.0f;
    public static float MAX_SPACING = 400.0f;
    public static float WIDTH_TO_SPACING_MULT = 0.2f;
    public static float MIN_NARROW = 0.5f;
    public static float MAX_NARROW = 0.7f;
    public static float MIN_NORMAL = 0.9f;
    public static float MAX_NORMAL = 1.1f;
    public static float MIN_WIDE = 1.3f;
    public static float MAX_WIDE = 1.6f;
    public static float MIN_VERY_WIDE = 1.8f;
    public static float MAX_VERY_WIDE = 2.1f;
    public static float WCHANGE_SLOW_T_MULT_MIN = 1.0f;
    public static float WCHANGE_SLOW_T_MULT_MIN_MAX = 1.2f;
    public static float WCHANGE_MEDIUM_T_MULT_MIN = 1.8f;
    public static float WCHANGE_MEDIUM_T_MULT_MAX = 2.2f;
    public static float WCHANGE_FAST_T_MULT_MIN = 2.8f;
    public static float WCHANGE_FAST_T_MULT_MAX = 3.2f;
    public static float WRAND_NONE_MULT = 0.0f;
    public static float WRAND_LOW_MULT = 0.1f;
    public static float WRAND_MEDIUM_MULT = 0.17f;
    public static float WRAND_HIGH_MULT = 0.25f;
    public static float FLUCT_LENGTH_MIN = 2500.0f;
    public static float FLUCT_LENGTH_MAX = 4000.0f;
    public static float FLUCT_MAG_MIN = 350.0f;
    public static float FLUCT_MAG_MAX = 500.0f;
    public static float FLUCT_NONE_MULT = 0.0f;
    public static float FLUCT_LOW_MULT = 0.33f;
    public static float FLUCT_MEDIUM_MULT = 0.67f;
    public static float FLUCT_HIGH_MULT = 1.0f;
    public static final int WIDTH_NARROW = 0;
    public static final int WIDTH_NORMAL = 1;
    public static final int WIDTH_WIDE = 2;
    public static final int WIDTH_VERY_WIDE = 3;
    public static final int WRAND_NONE = 0;
    public static final int WRAND_LOW = 1;
    public static final int WRAND_MEDIUM = 2;
    public static final int WRAND_HIGH = 3;
    public static final int WCHANGE_SLOW = 0;
    public static final int WCHANGE_MEDIUM = 1;
    public static final int WCHANGE_FAST = 2;
    public static final int FLUCT_NONE = 0;
    public static final int FLUCT_LOW = 1;
    public static final int FLUCT_MEDIUM = 2;
    public static final int FLUCT_HIGH = 3;
    protected float[][] widthTM;
    protected float[][] wrandTM;
    protected float[][] wchangeTM;
    protected float[][] fluctTM;
    protected Random random;
    protected SlipstreamTerrainPlugin2.SlipstreamParams2 params;
    protected SlipstreamTerrainPlugin2 plugin;
    protected List<SlipstreamSection> sections = new ArrayList<SlipstreamSection>();
    protected int currWidth = 0;
    protected int currWRand = 0;
    protected int currWChange = 0;
    protected int currFluct = 0;
    protected Vector2f start;
    protected StreamType type;
    protected float maxAngleVarianceForCurve = 30.0f;
    protected float maxAngleVariance = 60.0f;
    protected float[] buildNoise;

    public void initTransitionMatrices() {
        this.widthTM = new float[4][4];
        if (this.type == StreamType.NORMAL) {
            this.widthTM[0] = new float[]{0.5f, 1.0f, 0.4f, 0.3f};
            this.widthTM[1] = new float[]{1.0f, 1.0f, 0.5f, 0.3f};
            this.widthTM[2] = new float[]{0.7f, 1.0f, 0.2f, 0.5f};
            this.widthTM[3] = new float[]{1.0f, 1.0f, 1.0f, 0.1f};
        } else if (this.type == StreamType.WIDE) {
            this.widthTM[0] = new float[]{0.1f, 1.0f, 0.6f, 0.4f};
            this.widthTM[1] = new float[]{0.2f, 0.5f, 1.0f, 0.5f};
            this.widthTM[2] = new float[]{0.1f, 0.5f, 1.0f, 0.5f};
            this.widthTM[3] = new float[]{0.0f, 0.5f, 1.0f, 0.3f};
        } else if (this.type == StreamType.NARROW) {
            this.widthTM[0] = new float[]{0.8f, 1.0f, 0.3f, 0.1f};
            this.widthTM[1] = new float[]{1.0f, 1.0f, 0.3f, 0.1f};
            this.widthTM[2] = new float[]{0.7f, 1.0f, 0.2f, 0.2f};
            this.widthTM[3] = new float[]{1.0f, 1.0f, 1.0f, 0.1f};
        }
        this.wrandTM = new float[4][4];
        this.wrandTM[0] = new float[]{1.0f, 1.0f, 0.1f, 0.1f};
        this.wrandTM[1] = new float[]{1.0f, 1.0f, 1.0f, 0.1f};
        this.wrandTM[2] = new float[]{0.1f, 1.0f, 0.5f, 0.2f};
        this.wrandTM[3] = new float[]{0.1f, 0.1f, 1.0f, 0.1f};
        this.wchangeTM = new float[3][3];
        this.wchangeTM[0] = new float[]{1.0f, 1.0f, 0.1f};
        this.wchangeTM[1] = new float[]{1.0f, 1.0f, 1.0f};
        this.wchangeTM[2] = new float[]{0.1f, 1.0f, 1.0f};
        this.fluctTM = new float[4][4];
        this.fluctTM[0] = new float[]{1.0f, 1.0f, 0.1f, 0.1f};
        this.fluctTM[1] = new float[]{1.0f, 1.0f, 1.0f, 0.1f};
        this.fluctTM[2] = new float[]{0.1f, 1.0f, 0.5f, 0.2f};
        this.fluctTM[3] = new float[]{0.1f, 0.1f, 1.0f, 0.1f};
    }

    public SlipstreamBuilder(Vector2f start, SlipstreamTerrainPlugin2 plugin, StreamType type, Random random) {
        this.plugin = plugin;
        this.type = type != null ? type : StreamType.NORMAL;
        this.params = plugin.getParams();
        if (random == null) {
            random = Misc.random;
        }
        this.random = random;
        this.start = start;
        this.initTransitionMatrices();
        int i = 0;
        while (i < 10) {
            this.pickAllNext();
            ++i;
        }
    }

    public float getMaxAngleVariance() {
        return this.maxAngleVariance;
    }

    public void setMaxAngleVariance(float maxAngleVariance) {
        this.maxAngleVariance = maxAngleVariance;
    }

    public float getMaxAngleVarianceForCurve() {
        return this.maxAngleVarianceForCurve;
    }

    public void setMaxAngleVarianceForCurve(float maxAngleVarianceForCurve) {
        this.maxAngleVarianceForCurve = maxAngleVarianceForCurve;
    }

    public void buildToDestination(Vector2f control, Vector2f control2, Vector2f to) {
        Vector2f p0 = new Vector2f((ReadableVector2f)this.start);
        Vector2f p1 = new Vector2f((ReadableVector2f)control);
        Vector2f p2 = new Vector2f((ReadableVector2f)control2);
        Vector2f p3 = new Vector2f((ReadableVector2f)to);
        float len = SlipstreamBuilder.getApproximateBezierLength(p0, p1, p2, p3);
        float t = 0.0f;
        Vector2f prev = new Vector2f((ReadableVector2f)p0);
        do {
            float actualDist;
            float length;
            float tIncr;
            if ((t += (tIncr = (length = 3000.0f + (float)this.random.nextInt(2000)) / len)) > 1.0f) {
                t = 1.0f;
            }
            Vector2f loc = Misc.bezierCubic(p0, p1, p2, p3, t);
            boolean wide = this.currWidth == 2 || this.currWidth == 3;
            this.pickAllNext();
            boolean bl = this.currWidth == 2 || this.currWidth == 3;
            float angle = this.random.nextFloat() * this.maxAngleVarianceForCurve - this.maxAngleVarianceForCurve / 2.0f;
            if (wide |= bl) {
                angle *= 0.5f;
            }
            if (t >= 1.0f) {
                angle = 0.0f;
            }
            if (!((actualDist = Misc.getDistance(prev, loc = Misc.rotateAroundOrigin(loc, angle, prev))) > length * 0.5f)) continue;
            prev.set((ReadableVector2f)loc);
            this.addSection(new Vector2f((ReadableVector2f)loc), true);
        } while (!(t >= 1.0f));
        this.generate();
    }

    public void buildToDestination(Vector2f control, Vector2f to) {
        Vector2f p0 = new Vector2f((ReadableVector2f)this.start);
        Vector2f p1 = new Vector2f((ReadableVector2f)control);
        Vector2f p2 = new Vector2f((ReadableVector2f)to);
        float len = SlipstreamBuilder.getApproximateBezierLength(p0, p1, p2);
        float t = 0.0f;
        Vector2f prev = new Vector2f((ReadableVector2f)p0);
        do {
            float actualDist;
            float length;
            float tIncr;
            if ((t += (tIncr = (length = 3000.0f + (float)this.random.nextInt(2000)) / len)) > 1.0f) {
                t = 1.0f;
            }
            Vector2f loc = Misc.bezier(p0, p1, p2, t);
            boolean wide = this.currWidth == 2 || this.currWidth == 3;
            this.pickAllNext();
            boolean bl = this.currWidth == 2 || this.currWidth == 3;
            float angle = this.random.nextFloat() * this.maxAngleVarianceForCurve - this.maxAngleVarianceForCurve / 2.0f;
            if (wide |= bl) {
                angle *= 0.5f;
            }
            if (t >= 1.0f) {
                angle = 0.0f;
            }
            if (!((actualDist = Misc.getDistance(prev, loc = Misc.rotateAroundOrigin(loc, angle, prev))) > length * 0.5f)) continue;
            prev.set((ReadableVector2f)loc);
            this.addSection(new Vector2f((ReadableVector2f)loc), true);
        } while (!(t >= 1.0f));
        this.generate();
    }

    public void buildToDestination(Vector2f to) {
        Vector2f loc = new Vector2f((ReadableVector2f)this.start);
        Vector2f p0 = new Vector2f((ReadableVector2f)loc);
        Vector2f p1 = new Vector2f((ReadableVector2f)to);
        float len = Misc.getDistance(p0, p1);
        Vector2f dir = Misc.getUnitVector(p0, p1);
        float dirAngle = Misc.getAngleInDegrees(dir);
        float distSoFar = 0.0f;
        float prevAngle = 0.0f;
        int i = 0;
        while (distSoFar < len) {
            float angle = this.random.nextFloat() * this.maxAngleVariance - this.maxAngleVariance / 2.0f;
            boolean wide = this.currWidth == 2 || this.currWidth == 3;
            this.pickAllNext();
            wide |= this.currWidth == 2 || this.currWidth == 3;
            angle += dirAngle;
            if (i % 2 == 1) {
                angle = prevAngle;
            }
            prevAngle = angle;
            Vector2f add = Misc.getUnitVectorAtDegreeAngle(angle);
            float length = 3000.0f + (float)this.random.nextInt(2000);
            distSoFar += length;
            add.scale(length);
            Vector2f.add((Vector2f)loc, (Vector2f)add, (Vector2f)loc);
            this.addSection(new Vector2f((ReadableVector2f)loc), true);
            ++i;
        }
        Vector2f end = this.sections.get((int)(this.sections.size() - 1)).to;
        float actualAngle = Misc.getAngleInDegrees(p0, end);
        float angleDiff = Misc.getAngleDiff(dirAngle, actualAngle);
        float turnDir = Misc.getClosestTurnDirection(actualAngle, dirAngle);
        for (SlipstreamSection section : this.sections) {
            section.from = Misc.rotateAroundOrigin(section.from, angleDiff * turnDir, p0);
            section.to = Misc.rotateAroundOrigin(section.to, angleDiff * turnDir, p0);
        }
        end = this.sections.get((int)(this.sections.size() - 1)).to;
        float actualDist = Misc.getDistance(p0, end);
        float distToAdd = len - actualDist;
        if (distToAdd > 1000.0f) {
            angleDiff = Misc.getAngleDiff(dirAngle, prevAngle);
            turnDir = Misc.getClosestTurnDirection(actualAngle, dirAngle);
            float turnAmount = Math.min(30.0f, angleDiff) * turnDir;
            Vector2f add = Misc.getUnitVectorAtDegreeAngle(prevAngle + turnAmount);
            float length = distToAdd;
            add.scale(length);
            loc = Vector2f.add((Vector2f)end, (Vector2f)add, (Vector2f)loc);
            this.addSection(new Vector2f((ReadableVector2f)loc));
        }
        this.generate();
    }

    public void buildTest() {
        Vector2f loc = new Vector2f((ReadableVector2f)this.start);
        Vector2f p0 = new Vector2f((ReadableVector2f)loc);
        Vector2f p1 = new Vector2f((ReadableVector2f)loc);
        float w = 15000.0f;
        float h = 15000.0f;
        h = 0.0f;
        w = 25000.0f;
        w = 50000.0f;
        p1.x += w;
        p1.y += h;
        float len = Misc.getDistance(p0, p1);
        Vector2f dir = Misc.getUnitVector(p0, p1);
        Vector2f perp = new Vector2f(-dir.y, dir.x);
        float dirAngle = Misc.getAngleInDegrees(dir);
        float distSoFar = 0.0f;
        float prevAngle = 0.0f;
        int i = 0;
        while (distSoFar < len) {
            float angle = this.random.nextFloat() * 60.0f - 30.0f;
            angle += dirAngle;
            if (i % 2 == 1) {
                angle = prevAngle;
            }
            prevAngle = angle;
            Vector2f add = Misc.getUnitVectorAtDegreeAngle(angle);
            float length = 3000.0f + (float)this.random.nextInt(2000);
            distSoFar += length;
            add.scale(length);
            Vector2f.add((Vector2f)loc, (Vector2f)add, (Vector2f)loc);
            this.addSection(new Vector2f((ReadableVector2f)loc));
            ++i;
        }
        Vector2f end = this.sections.get((int)(this.sections.size() - 1)).to;
        float actualAngle = Misc.getAngleInDegrees(p0, end);
        float angleDiff = Misc.getAngleDiff(dirAngle, actualAngle);
        float turnDir = Misc.getClosestTurnDirection(actualAngle, dirAngle);
        for (SlipstreamSection section : this.sections) {
            section.from = Misc.rotateAroundOrigin(section.from, angleDiff * turnDir, p0);
            section.to = Misc.rotateAroundOrigin(section.to, angleDiff * turnDir, p0);
        }
        end = this.sections.get((int)(this.sections.size() - 1)).to;
        float actualDist = Misc.getDistance(p0, end);
        float distToAdd = len - actualDist;
        if (distToAdd > 1000.0f) {
            angleDiff = Misc.getAngleDiff(dirAngle, prevAngle);
            turnDir = Misc.getClosestTurnDirection(actualAngle, dirAngle);
            float turnAmount = Math.min(30.0f, angleDiff) * turnDir;
            Vector2f add = Misc.getUnitVectorAtDegreeAngle(prevAngle + turnAmount);
            float length = distToAdd;
            add.scale(length);
            loc = Vector2f.add((Vector2f)end, (Vector2f)add, (Vector2f)loc);
            this.addSection(new Vector2f((ReadableVector2f)loc));
        }
        this.generate();
    }

    public void generate() {
        this.computeControlPoints();
        this.buildStream();
    }

    public void buildStream() {
        float b;
        this.plugin.setBuilder(this);
        if (this.sections.isEmpty()) {
            return;
        }
        float totalCurveLength = 0.0f;
        for (SlipstreamSection curr : this.sections) {
            totalCurveLength += curr.approxCurveLength;
        }
        int numNoisePoints = 32;
        while ((float)numNoisePoints * (MIN_SPACING + MAX_SPACING) / 2.0f < totalCurveLength) {
            numNoisePoints = (int)((float)numNoisePoints * 2.0f);
        }
        if (numNoisePoints > 2048) {
            numNoisePoints = 2048;
        }
        float spikes = 0.67f;
        float[] noiseForWidth = SlipstreamBuilder.initNoise1D(this.random, numNoisePoints, spikes);
        noiseForWidth[0] = 0.5f;
        noiseForWidth[noiseForWidth.length - 1] = 0.5f;
        SlipstreamBuilder.genNoise1D(this.random, noiseForWidth, numNoisePoints, spikes);
        SlipstreamBuilder.normalizeNoise1D(noiseForWidth);
        float width = this.getGoalWidth(this.sections.get(0));
        float curveLengthSoFar = 0.0f;
        for (SlipstreamSection curr : this.sections) {
            int segments;
            float startingWidth = width;
            float goalWidth = this.getGoalWidth(curr);
            float changeRate = this.getWChangeMult(curr);
            float wrandMult = this.getWRandMult(curr);
            float fluctMult = this.getFluctMult(curr);
            float desiredSpacing = Math.max(MIN_SPACING, width * WIDTH_TO_SPACING_MULT);
            if (desiredSpacing > MAX_SPACING) {
                desiredSpacing = MAX_SPACING;
            }
            if ((segments = (int)(curr.approxCurveLength / desiredSpacing)) < 2) {
                segments = 2;
            }
            float spacing = curr.approxCurveLength / (float)segments;
            ArrayList<AddedSegment> added = new ArrayList<AddedSegment>();
            int startIndex = 1;
            if (this.getPrev(curr) == null) {
                startIndex = 0;
            }
            int i = startIndex;
            while (i < segments) {
                float f = (float)i / ((float)segments - 1.0f);
                float f2 = ((float)i + 0.1f) / ((float)segments - 1.0f);
                width = Misc.interpolate(startingWidth, goalWidth, Math.min(1.0f, f * f * changeRate));
                float t = (curveLengthSoFar + f * curr.approxCurveLength) / totalCurveLength;
                float wNoise = (SlipstreamBuilder.getInterpNoise(noiseForWidth, t) - 0.5f) * 2.0f;
                width *= 1.0f + (wNoise *= wrandMult);
                Vector2f loc = Misc.bezier(curr.from, curr.control, curr.to, f);
                Vector2f loc2 = Misc.bezier(curr.from, curr.control, curr.to, f2);
                Vector2f dir = Vector2f.sub((Vector2f)loc2, (Vector2f)loc, (Vector2f)new Vector2f());
                Misc.normalise(dir);
                Vector2f perp = new Vector2f(-dir.y, dir.x);
                this.plugin.addSegment(loc, width);
                AddedSegment seg = new AddedSegment();
                seg.segment = this.plugin.getSegments().get(this.plugin.getSegments().size() - 1);
                seg.dir = new Vector2f((ReadableVector2f)dir);
                seg.perp = new Vector2f((ReadableVector2f)perp);
                added.add(seg);
                ++i;
            }
            float distPerFluct = FLUCT_LENGTH_MIN + this.random.nextFloat() * (FLUCT_LENGTH_MAX - FLUCT_LENGTH_MIN);
            float fluctAmount = FLUCT_MAG_MIN + this.random.nextFloat() * (FLUCT_MAG_MAX - FLUCT_MAG_MIN);
            float fluctDir = Math.signum(this.random.nextFloat() - 0.5f);
            float distSoFar = 0.0f;
            ArrayList<AddedSegment> temp = new ArrayList<AddedSegment>();
            AddedSegment prev = null;
            for (AddedSegment seg : added) {
                if (prev != null) {
                    distSoFar += Misc.getDistance(seg.segment.loc, prev.segment.loc);
                }
                temp.add(seg);
                prev = seg;
                if (!(distSoFar > distPerFluct) || temp.size() < 4) continue;
                int i2 = 0;
                while (i2 < temp.size()) {
                    float t = (float)i2 / ((float)temp.size() - 1.0f);
                    AddedSegment seg2 = (AddedSegment)temp.get(i2);
                    float fluctMag = this.getFluctuationFunc(t);
                    fluctMag *= fluctMult;
                    seg2.segment.loc.x += seg2.perp.x * (fluctMag *= fluctAmount * fluctDir);
                    seg2.segment.loc.y += seg2.perp.y * fluctMag;
                    ++i2;
                }
                temp.clear();
                distSoFar = 0.0f;
                distPerFluct = FLUCT_LENGTH_MIN + this.random.nextFloat() * (FLUCT_LENGTH_MAX - FLUCT_LENGTH_MIN);
                fluctAmount = FLUCT_MAG_MIN + this.random.nextFloat() * (FLUCT_MAG_MAX - FLUCT_MAG_MIN);
                fluctDir = Math.signum(this.random.nextFloat() - 0.5f);
            }
            curveLengthSoFar += curr.approxCurveLength;
        }
        this.adjustSharpInflectionPoints();
        float fadeDist = 500.0f;
        float distSoFar = 0.0f;
        SlipstreamTerrainPlugin2.SlipstreamSegment prev = null;
        int i = 0;
        while (i < this.plugin.getSegments().size()) {
            SlipstreamTerrainPlugin2.SlipstreamSegment curr = this.plugin.getSegments().get(i);
            if (prev != null) {
                distSoFar += Misc.getDistance(prev.loc, curr.loc);
            }
            if (distSoFar >= fadeDist) break;
            b = distSoFar / fadeDist;
            if (b < 0.0f) {
                b = 0.0f;
            }
            if (b > 1.0f) {
                b = 1.0f;
            }
            curr.bMult = b;
            prev = curr;
            ++i;
        }
        distSoFar = 0.0f;
        prev = null;
        i = this.plugin.getSegments().size() - 1;
        while (i >= 0) {
            SlipstreamTerrainPlugin2.SlipstreamSegment curr = this.plugin.getSegments().get(i);
            if (prev != null) {
                distSoFar += Misc.getDistance(prev.loc, curr.loc);
            }
            if (distSoFar >= fadeDist) break;
            b = distSoFar / fadeDist;
            if (b < 0.0f) {
                b = 0.0f;
            }
            if (b > 1.0f) {
                b = 1.0f;
            }
            curr.bMult = b;
            prev = curr;
            --i;
        }
    }

    protected float getFluctuationFunc(float t) {
        float pi = (float)Math.PI;
        return ((float)Math.cos(pi + 2.0f * pi * t) + 1.0f) * 0.5f;
    }

    protected void adjustSharpInflectionPoints() {
        int i = 1;
        while (i < this.plugin.getSegments().size() - 1) {
            float dir2;
            SlipstreamTerrainPlugin2.SlipstreamSegment prev = this.plugin.getSegments().get(i - 1);
            SlipstreamTerrainPlugin2.SlipstreamSegment curr = this.plugin.getSegments().get(i);
            SlipstreamTerrainPlugin2.SlipstreamSegment next = this.plugin.getSegments().get(i + 1);
            float dir1 = Misc.getAngleInDegrees(prev.loc, curr.loc);
            float diff = Misc.getAngleDiff(dir1, dir2 = Misc.getAngleInDegrees(curr.loc, next.loc));
            if (diff > 5.0f) {
                Vector2f avg = Vector2f.add((Vector2f)prev.loc, (Vector2f)next.loc, (Vector2f)new Vector2f());
                avg.scale(0.5f);
                curr.loc.set((ReadableVector2f)Misc.interpolateVector(curr.loc, avg, 0.67f));
            }
            ++i;
        }
    }

    protected float getWRandMult(SlipstreamSection curr) {
        float mult = 0.0f;
        if (curr.wrand == 0) {
            mult = WRAND_NONE_MULT;
        } else if (curr.wrand == 1) {
            mult = WRAND_LOW_MULT;
        } else if (curr.wrand == 2) {
            mult = WRAND_MEDIUM_MULT;
        } else if (curr.wrand == 3) {
            mult = WRAND_HIGH_MULT;
        }
        return mult;
    }

    protected float getFluctMult(SlipstreamSection curr) {
        float mult = 0.0f;
        if (curr.fluct == 0) {
            mult = FLUCT_NONE_MULT;
        } else if (curr.fluct == 1) {
            mult = FLUCT_LOW_MULT;
        } else if (curr.fluct == 2) {
            mult = FLUCT_MEDIUM_MULT;
        } else if (curr.fluct == 3) {
            mult = FLUCT_HIGH_MULT;
        }
        return mult *= 0.9f + 0.2f * this.random.nextFloat();
    }

    protected float getWChangeMult(SlipstreamSection curr) {
        float mult = 1.0f;
        if (curr.wchange == 0) {
            mult = WCHANGE_SLOW_T_MULT_MIN + this.random.nextFloat() * (WCHANGE_SLOW_T_MULT_MIN_MAX - WCHANGE_SLOW_T_MULT_MIN);
        } else if (curr.wchange == 1) {
            mult = WCHANGE_MEDIUM_T_MULT_MIN + this.random.nextFloat() * (WCHANGE_MEDIUM_T_MULT_MAX - WCHANGE_MEDIUM_T_MULT_MIN);
        } else if (curr.wchange == 2) {
            mult = WCHANGE_FAST_T_MULT_MIN + this.random.nextFloat() * (WCHANGE_FAST_T_MULT_MAX - WCHANGE_FAST_T_MULT_MIN);
        }
        return mult;
    }

    protected float getGoalWidth(SlipstreamSection curr) {
        float goalWidth = this.params.baseWidth;
        float mult = 1.0f;
        if (curr.width == 0) {
            mult = MIN_NARROW + this.random.nextFloat() * (MAX_NARROW - MIN_NARROW);
        } else if (curr.width == 1) {
            mult = MIN_NORMAL + this.random.nextFloat() * (MAX_NORMAL - MIN_NORMAL);
        } else if (curr.width == 2) {
            mult = MIN_WIDE + this.random.nextFloat() * (MAX_WIDE - MIN_WIDE);
        } else if (curr.width == 3) {
            mult = MIN_VERY_WIDE + this.random.nextFloat() * (MAX_VERY_WIDE - MIN_VERY_WIDE);
        }
        return goalWidth * mult;
    }

    protected void computeControlPoints() {
        float angleLimit = 30.0f;
        for (SlipstreamSection curr : this.sections) {
            SlipstreamSection prev = this.getPrev(curr);
            SlipstreamSection next = this.getNext(curr);
            if (prev == null && next == null) {
                curr.control = Vector2f.add((Vector2f)curr.from, (Vector2f)curr.to, (Vector2f)new Vector2f());
                curr.control.scale(0.5f);
            } else if (prev == null && next != null) {
                p1 = curr.from;
                p2 = curr.to;
                p3 = next.to;
                angleP2ToControl = Misc.getAngleInDegrees(p3, p2);
                dirP2ToControl = Misc.getUnitVectorAtDegreeAngle(angleP2ToControl);
                Vector2f p2ToP1 = Vector2f.sub((Vector2f)p1, (Vector2f)p2, (Vector2f)new Vector2f());
                float angleP2toP1 = Misc.getAngleInDegrees(p2ToP1);
                float angleToControlAndP2toP1 = Vector2f.angle((Vector2f)dirP2ToControl, (Vector2f)p2ToP1) * Misc.DEG_PER_RAD;
                if (angleToControlAndP2toP1 > angleLimit) {
                    angleToControlAndP2toP1 = angleLimit;
                    turnDir = Misc.getClosestTurnDirection(angleP2toP1, angleP2ToControl);
                    angleP2ToControl = angleP2toP1 + turnDir * angleToControlAndP2toP1;
                    dirP2ToControl = Misc.getUnitVectorAtDegreeAngle(angleP2ToControl);
                }
                dist = Misc.getDistance(p1, p2);
                h = (dist /= 2.0f) * (float)Math.tan(angleToControlAndP2toP1 * Misc.RAD_PER_DEG);
                b = (float)Math.sqrt(dist * dist + h * h);
                dirP2ToControl.scale(b);
                Vector2f.add((Vector2f)dirP2ToControl, (Vector2f)p2, (Vector2f)curr.control);
            } else {
                p1 = prev.control;
                p2 = curr.from;
                p3 = curr.to;
                angleP2ToControl = Misc.getAngleInDegrees(p1, p2);
                dirP2ToControl = Misc.getUnitVectorAtDegreeAngle(angleP2ToControl);
                Vector2f p2ToP3 = Vector2f.sub((Vector2f)p3, (Vector2f)p2, (Vector2f)new Vector2f());
                float angleP2ToP3 = Misc.getAngleInDegrees(p2ToP3);
                float angleToControlAndP2toP3 = Vector2f.angle((Vector2f)dirP2ToControl, (Vector2f)p2ToP3) * Misc.DEG_PER_RAD;
                if (angleToControlAndP2toP3 > angleLimit) {
                    angleToControlAndP2toP3 = angleLimit;
                    turnDir = Misc.getClosestTurnDirection(angleP2ToP3, angleP2ToControl);
                    angleP2ToControl = angleP2ToP3 + turnDir * angleToControlAndP2toP3;
                    dirP2ToControl = Misc.getUnitVectorAtDegreeAngle(angleP2ToControl);
                }
                dist = Misc.getDistance(p2, p3);
                h = (dist /= 2.0f) * (float)Math.tan(angleToControlAndP2toP3 * Misc.RAD_PER_DEG);
                b = (float)Math.sqrt(dist * dist + h * h);
                dirP2ToControl.scale(b);
                Vector2f.add((Vector2f)dirP2ToControl, (Vector2f)p2, (Vector2f)curr.control);
            }
            curr.approxCurveLength = SlipstreamBuilder.getApproximateBezierLength(curr.from, curr.control, curr.to);
        }
    }

    public void addSection(Vector2f to) {
        this.addSection(to, false);
    }

    public void addSection(Vector2f to, boolean alreadyPicked) {
        if (!alreadyPicked) {
            this.pickAllNext();
        }
        this.addSection(to, this.currWidth, this.currWRand, this.currWChange, this.currFluct);
    }

    public void addSection(Vector2f to, int width, int wrand, int wchange, int fluct) {
        this.addSection(to, width, wrand, wchange, fluct, -1);
    }

    public void addSection(Vector2f to, int width, int wrand, int wchange, int fluct, int insertIndex) {
        SlipstreamSection s = new SlipstreamSection();
        s.to.set((ReadableVector2f)to);
        s.width = width;
        s.wrand = wrand;
        s.wchange = wchange;
        s.fluct = fluct;
        if (insertIndex < 0) {
            this.sections.add(s);
        } else {
            this.sections.add(insertIndex, s);
        }
        SlipstreamSection p = this.getPrev(s);
        if (p != null) {
            s.from.set((ReadableVector2f)p.to);
        } else {
            s.from.set((ReadableVector2f)this.start);
        }
    }

    public SlipstreamSection getPrev(SlipstreamSection s) {
        int index = this.sections.indexOf(s);
        if (index < 1) {
            return null;
        }
        return this.sections.get(index - 1);
    }

    public SlipstreamSection getNext(SlipstreamSection s) {
        int index = this.sections.indexOf(s);
        if (index < 0 || index >= this.sections.size() - 1) {
            return null;
        }
        return this.sections.get(index + 1);
    }

    public void pickAllNext() {
        this.currWidth = this.pickWidth(this.currWidth);
        this.currWRand = this.pickWRand(this.currWRand);
        this.currWChange = this.pickWChange(this.currWChange);
        this.currFluct = this.pickFluct(this.currFluct);
        if (this.currWidth == 0) {
            if (this.currFluct == 3) {
                this.currFluct = 1;
            } else if (this.currFluct == 2) {
                this.currFluct = 0;
            }
        }
    }

    public int pickWidth(int curr) {
        return this.pickNext(curr, this.widthTM);
    }

    public int pickWRand(int curr) {
        return this.pickNext(curr, this.wrandTM);
    }

    public int pickWChange(int curr) {
        return this.pickNext(curr, this.wchangeTM);
    }

    public int pickFluct(int curr) {
        return this.pickNext(curr, this.fluctTM);
    }

    public int pickNext(int curr, float[][] matrix) {
        float[] weights = matrix[curr];
        WeightedRandomPicker<Integer> picker = new WeightedRandomPicker<Integer>(this.random);
        int i = 0;
        while (i < weights.length) {
            picker.add(i, weights[i]);
            ++i;
        }
        return (Integer)picker.pick();
    }

    public void renderDebug(float alpha) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (BoundingBox box : this.plugin.getBounds()) {
            Misc.setColor(Color.cyan);
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)3.0f);
            GL11.glBegin((int)2);
            if (box != null) {
                for (Vector2f p : box.box) {
                    GL11.glVertex2f((float)p.x, (float)p.y);
                }
            }
            GL11.glEnd();
        }
        GL11.glPopMatrix();
    }

    public static float getInterpNoise(float[] noise, float t) {
        int index2;
        int index = (int)(t *= (float)noise.length);
        if (index >= noise.length) {
            index = noise.length - 1;
        }
        if (index < 0) {
            index = 0;
        }
        if ((index2 = index + 1) >= noise.length) {
            index2 = index - 1;
        }
        float f = t - (float)index;
        return Misc.interpolate(noise[index], noise[index2], f);
    }

    public static void normalizeNoise1D(float[] noise) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float[] fArray = noise;
        int n = noise.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            if (f < min) {
                min = f;
            }
            if (f > max) {
                max = f;
            }
            ++n2;
        }
        if (max <= min) {
            int i = 0;
            while (i < noise.length) {
                noise[i] = 0.5f;
                ++i;
            }
            return;
        }
        float range = max - min;
        int i = 0;
        while (i < noise.length) {
            noise[i] = (noise[i] - min) / range;
            ++i;
        }
    }

    public static float[] initNoise1D(Random random, int size, float spikes) {
        float[] noise = new float[size];
        int i = 0;
        while (i < noise.length) {
            noise[i] = -1.0f;
            ++i;
        }
        noise[0] = random.nextFloat() * spikes;
        noise[noise.length - 1] = random.nextFloat() * spikes;
        return noise;
    }

    public static void genNoise1D(Random random, float[] noise, int size, float spikes) {
        SlipstreamBuilder.genNoise1DFill(random, noise, 0, noise.length - 1, 1, spikes);
    }

    public static void genNoise1DFill(Random random, float[] noise, int x1, int x2, int iter, float spikes) {
        if (x1 + 1 >= x2) {
            return;
        }
        int midX = (x1 + x2) / 2;
        float avg = (noise[x1] + noise[x2]) / 2.0f;
        noise[midX] = avg + (float)Math.pow(spikes, iter) * (random.nextFloat() - 0.5f);
        SlipstreamBuilder.genNoise1DFill(random, noise, x1, midX, iter + 1, spikes);
        SlipstreamBuilder.genNoise1DFill(random, noise, midX, x2, iter + 1, spikes);
    }

    public static float getApproximateBezierLength(Vector2f p0, Vector2f p1, Vector2f p2) {
        float total = 0.0f;
        Vector2f prev = p0;
        float f = 0.0f;
        while (f <= 1.01f) {
            Vector2f curr = Misc.bezier(p0, p1, p2, f);
            total += Misc.getDistance(prev, curr);
            prev = curr;
            f += 0.1f;
        }
        return total;
    }

    public static float getApproximateBezierLength(Vector2f p0, Vector2f p1, Vector2f p2, Vector2f p3) {
        float total = 0.0f;
        Vector2f prev = p0;
        float f = 0.0f;
        while (f <= 1.01f) {
            Vector2f curr = Misc.bezierCubic(p0, p1, p2, p3, f);
            total += Misc.getDistance(prev, curr);
            prev = curr;
            f += 0.05f;
        }
        return total;
    }

    public static class AddedSegment {
        public SlipstreamTerrainPlugin2.SlipstreamSegment segment;
        public Vector2f dir;
        public Vector2f perp;
    }

    public static class SlipstreamSection {
        public Vector2f from = new Vector2f();
        public Vector2f to = new Vector2f();
        public Vector2f control = new Vector2f();
        public int width;
        public int wrand;
        public int wchange;
        public int fluct;
        public boolean subdivision = false;
        public float approxCurveLength;
    }

    public static enum StreamType {
        NORMAL,
        WIDE,
        NARROW;

    }
}

