/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class EntropyAmplifierStats
extends BaseShipSystemScript {
    public static Object KEY_SHIP = new Object();
    public static Object KEY_TARGET = new Object();
    public static float DAM_MULT = 1.5f;
    protected static float RANGE = 1500.0f;
    public static Color TEXT_COLOR = new Color(255, 55, 55, 255);
    public static Color JITTER_COLOR = new Color(255, 50, 50, 75);
    public static Color JITTER_UNDER_COLOR = new Color(255, 100, 100, 155);

    @Override
    public void apply(MutableShipStatsAPI stats, final String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        String targetDataKey = String.valueOf(ship.getId()) + "_entropy_target_data";
        Object targetDataObj = Global.getCombatEngine().getCustomData().get(targetDataKey);
        if (state == ShipSystemStatsScript.State.IN && targetDataObj == null) {
            ShipAPI target = this.findTarget(ship);
            Global.getCombatEngine().getCustomData().put(targetDataKey, new TargetData(ship, target));
            if (target != null && (target.getFluxTracker().showFloaty() || ship == Global.getCombatEngine().getPlayerShip() || target == Global.getCombatEngine().getPlayerShip())) {
                target.getFluxTracker().showOverloadFloatyIfNeeded("Amplified Entropy!", TEXT_COLOR, 4.0f, true);
            }
        } else if (state == ShipSystemStatsScript.State.IDLE && targetDataObj != null) {
            Global.getCombatEngine().getCustomData().remove(targetDataKey);
            ((TargetData)targetDataObj).currDamMult = 1.0f;
            targetDataObj = null;
        }
        if (targetDataObj == null || ((TargetData)targetDataObj).target == null) {
            return;
        }
        final TargetData targetData = (TargetData)targetDataObj;
        targetData.currDamMult = 1.0f + (DAM_MULT - 1.0f) * effectLevel;
        if (targetData.targetEffectPlugin == null) {
            targetData.targetEffectPlugin = new BaseEveryFrameCombatPlugin(){

                @Override
                public void advance(float amount, List<InputEventAPI> events) {
                    if (Global.getCombatEngine().isPaused()) {
                        return;
                    }
                    if (targetData.target == Global.getCombatEngine().getPlayerShip()) {
                        Global.getCombatEngine().maintainStatusForPlayerShip(KEY_TARGET, targetData.ship.getSystem().getSpecAPI().getIconSpriteName(), targetData.ship.getSystem().getDisplayName(), (int)((targetData.currDamMult - 1.0f) * 100.0f) + "% more damage taken", true);
                    }
                    if (targetData.currDamMult <= 1.0f || !targetData.ship.isAlive()) {
                        targetData.target.getMutableStats().getHullDamageTakenMult().unmodify(id);
                        targetData.target.getMutableStats().getArmorDamageTakenMult().unmodify(id);
                        targetData.target.getMutableStats().getShieldDamageTakenMult().unmodify(id);
                        targetData.target.getMutableStats().getEmpDamageTakenMult().unmodify(id);
                        Global.getCombatEngine().removePlugin(targetData.targetEffectPlugin);
                    } else {
                        targetData.target.getMutableStats().getHullDamageTakenMult().modifyMult(id, targetData.currDamMult);
                        targetData.target.getMutableStats().getArmorDamageTakenMult().modifyMult(id, targetData.currDamMult);
                        targetData.target.getMutableStats().getShieldDamageTakenMult().modifyMult(id, targetData.currDamMult);
                        targetData.target.getMutableStats().getEmpDamageTakenMult().modifyMult(id, targetData.currDamMult);
                    }
                }
            };
            Global.getCombatEngine().addPlugin(targetData.targetEffectPlugin);
        }
        if (effectLevel > 0.0f) {
            if (state != ShipSystemStatsScript.State.IN) {
                targetData.elaspedAfterInState += Global.getCombatEngine().getElapsedInLastFrame();
            }
            float shipJitterLevel = 0.0f;
            if (state == ShipSystemStatsScript.State.IN) {
                shipJitterLevel = effectLevel;
            } else {
                float durOut = 0.5f;
                shipJitterLevel = Math.max(0.0f, durOut - targetData.elaspedAfterInState) / durOut;
            }
            float targetJitterLevel = effectLevel;
            float maxRangeBonus = 50.0f;
            float jitterRangeBonus = shipJitterLevel * maxRangeBonus;
            Color color = JITTER_COLOR;
            if (shipJitterLevel > 0.0f) {
                ship.setJitter(KEY_SHIP, color, shipJitterLevel, 4, 0.0f, 0.0f + jitterRangeBonus * 1.0f);
            }
            if (targetJitterLevel > 0.0f) {
                targetData.target.setJitter(KEY_TARGET, color, targetJitterLevel, 3, 0.0f, 5.0f);
            }
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    protected ShipAPI findTarget(ShipAPI ship) {
        float range = EntropyAmplifierStats.getMaxRange(ship);
        boolean player = ship == Global.getCombatEngine().getPlayerShip();
        ShipAPI target = ship.getShipTarget();
        if (ship.getShipAI() != null && ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.TARGET_FOR_SHIP_SYSTEM) && (target = (ShipAPI)ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.TARGET_FOR_SHIP_SYSTEM)) != null && target.getOriginalOwner() == ship.getOriginalOwner()) {
            target = null;
        }
        if (target != null) {
            float radSum;
            float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
            if (dist > range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius())) {
                target = null;
            }
        } else if (target == null || target.getOwner() == ship.getOwner()) {
            if (player) {
                target = Misc.findClosestShipEnemyOf(ship, ship.getMouseTarget(), ShipAPI.HullSize.FRIGATE, range, true);
            } else {
                Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
                if (test instanceof ShipAPI) {
                    float radSum;
                    target = (ShipAPI)test;
                    float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
                    if (dist > range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius()) || target.isFighter()) {
                        target = null;
                    }
                    if (target != null && target.getOriginalOwner() == ship.getOriginalOwner()) {
                        target = null;
                    }
                }
            }
        }
        if (target != null && target.isFighter()) {
            target = null;
        }
        if (target == null) {
            target = Misc.findClosestShipEnemyOf(ship, ship.getLocation(), ShipAPI.HullSize.FRIGATE, range, true);
        }
        return target;
    }

    public static float getMaxRange(ShipAPI ship) {
        return ship.getMutableStats().getSystemRangeBonus().computeEffective(RANGE);
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (effectLevel > 0.0f && index == 0) {
            float damMult = 1.0f + (DAM_MULT - 1.0f) * effectLevel;
            return new ShipSystemStatsScript.StatusData((int)((damMult - 1.0f) * 100.0f) + "% more damage to target", false);
        }
        return null;
    }

    @Override
    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        if (system.isOutOfAmmo()) {
            return null;
        }
        if (system.getState() != ShipSystemAPI.SystemState.IDLE) {
            return null;
        }
        ShipAPI target = this.findTarget(ship);
        if (target != null && target != ship) {
            return "READY";
        }
        if (target == null && ship.getShipTarget() != null) {
            return "OUT OF RANGE";
        }
        return "NO TARGET";
    }

    @Override
    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        ShipAPI target = this.findTarget(ship);
        return target != null && target != ship;
    }

    public static class TargetData {
        public ShipAPI ship;
        public ShipAPI target;
        public EveryFrameCombatPlugin targetEffectPlugin;
        public float currDamMult;
        public float elaspedAfterInState;

        public TargetData(ShipAPI ship, ShipAPI target) {
            this.ship = ship;
            this.target = target;
        }
    }
}

