/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Iterator;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ShockRepeaterOnFireEffect
implements OnFireEffectPlugin {
    public static float ARC = 30.0f;

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        float emp = projectile.getEmpAmount();
        float dam = projectile.getDamageAmount();
        CombatEntityAPI target = this.findTarget(projectile, weapon, engine);
        float thickness = 20.0f;
        float coreWidthMult = 0.67f;
        Color color = weapon.getSpec().getGlowColor();
        if (target != null) {
            EmpArcEntityAPI arc = engine.spawnEmpArc(projectile.getSource(), projectile.getLocation(), weapon.getShip(), target, DamageType.ENERGY, dam, emp, 100000.0f, "shock_repeater_emp_impact", thickness, color, new Color(255, 255, 255, 255));
            arc.setCoreWidthOverride(thickness * coreWidthMult);
            arc.setSingleFlickerMode();
        } else {
            Vector2f from = new Vector2f((ReadableVector2f)projectile.getLocation());
            Vector2f to = this.pickNoTargetDest(projectile, weapon, engine);
            EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, weapon.getShip(), to, weapon.getShip(), thickness, color, Color.white);
            arc.setCoreWidthOverride(thickness * coreWidthMult);
            arc.setSingleFlickerMode();
        }
    }

    public Vector2f pickNoTargetDest(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        float spread = 50.0f;
        float range = weapon.getRange() - spread;
        Vector2f from = projectile.getLocation();
        Vector2f dir = Misc.getUnitVectorAtDegreeAngle(weapon.getCurrAngle());
        dir.scale(range);
        Vector2f.add((Vector2f)from, (Vector2f)dir, (Vector2f)dir);
        dir = Misc.getPointWithinRadius(dir, spread);
        return dir;
    }

    public CombatEntityAPI findTarget(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        float range = weapon.getRange();
        Vector2f from = projectile.getLocation();
        Iterator<Object> iter = Global.getCombatEngine().getAllObjectGrid().getCheckIterator(from, range * 2.0f, range * 2.0f);
        int owner = weapon.getShip().getOwner();
        CombatEntityAPI best = null;
        float minScore = Float.MAX_VALUE;
        ShipAPI ship = weapon.getShip();
        boolean ignoreFlares = ship != null && ship.getMutableStats().getDynamic().getValue("pd_ignores_flares", 0.0f) >= 1.0f;
        ignoreFlares |= weapon.hasAIHint(WeaponAPI.AIHints.IGNORES_FLARES);
        while (iter.hasNext()) {
            float score;
            MissileAPI missile;
            ShipAPI otherShip;
            CombatEntityAPI other;
            Object o = iter.next();
            if (!(o instanceof MissileAPI) && !(o instanceof ShipAPI) || (other = (CombatEntityAPI)o).getOwner() == owner || other instanceof ShipAPI && ((otherShip = (ShipAPI)other).isHulk() || otherShip.isPhased() || !otherShip.isTargetable()) || other.getCollisionClass() == CollisionClass.NONE || ignoreFlares && other instanceof MissileAPI && (missile = (MissileAPI)other).isFlare()) continue;
            float radius = Misc.getTargetingRadius(from, other, false);
            float dist = Misc.getDistance(from, other.getLocation()) - radius;
            if (dist > range || !Misc.isInArc(weapon.getCurrAngle(), ARC, from, other.getLocation()) || !((score = dist) < minScore)) continue;
            minScore = score;
            best = other;
        }
        return best;
    }
}

