/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatPlugin;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipPart;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.ValueShifterUtil;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class BaseDwellerShipPart
implements DwellerShipPart {
    public String id;
    public Set<String> tags = new LinkedHashSet<String>();
    public Vector2f offset;
    public float facingOffset;
    public float alphaMult = 1.0f;
    public float currBrightness;
    public ValueShifterUtil brightness;
    public Color color = Color.white;
    public boolean additiveBlend = false;
    public boolean negativeBlend = false;
    public FaderUtil fader;

    public BaseDwellerShipPart(Vector2f offset, float facingOffset) {
        this.offset = offset;
        this.facingOffset = facingOffset;
        this.fader = new FaderUtil(0.0f, 1.0f, 1.0f);
        this.fader.fadeIn();
        this.brightness = new ValueShifterUtil(1.0f);
    }

    public void setSystemActivated() {
        this.setActivated(DwellerCombatPlugin.SYSTEM_ACTIVATED);
    }

    public void setWeaponActivated() {
        this.setActivated(DwellerCombatPlugin.WEAPON_ACTIVATED);
    }

    public void setShieldActivated() {
        this.setActivated(DwellerCombatPlugin.SHIELD_ACTIVATED);
    }

    public void setFluxActivated() {
        this.setActivated(DwellerCombatPlugin.FLUX_ACTIVATED);
    }

    public void setActivated(String ... tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.tags.add(tag);
            ++n2;
        }
    }

    @Override
    public void advance(float amount) {
        this.fader.advance(amount);
        this.brightness.advance(amount);
        float desired = this.brightness.getCurr();
        this.currBrightness = Misc.approach(this.currBrightness, desired, 1.0f, 1.0f, amount);
    }

    @Override
    public void render(float entityX, float entityY, float alphaMult, float angle, CombatEngineLayers layer) {
        alphaMult *= this.alphaMult;
        alphaMult *= this.fader.getBrightness();
        Vector2f rot = Misc.rotateAroundOrigin(this.offset, angle + 90.0f);
        this.renderImpl(entityX + rot.x, entityY + rot.y, alphaMult *= this.currBrightness, angle, layer);
    }

    protected void renderImpl(float x, float y, float alphaMult, float angle, CombatEngineLayers layer) {
    }

    @Override
    public void fadeOut() {
        this.fader.fadeOut();
    }

    @Override
    public void fadeIn() {
        this.fader.fadeIn();
    }

    @Override
    public FaderUtil getFader() {
        return this.fader;
    }

    @Override
    public float getAlphaMult() {
        return this.alphaMult;
    }

    @Override
    public void setAlphaMult(float alphaMult) {
        this.alphaMult = alphaMult;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public void addTag(String tag) {
        this.tags.add(tag);
    }

    @Override
    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    @Override
    public ValueShifterUtil getBrightness() {
        return this.brightness;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }
}

