/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.impl.combat.dweller.BaseDwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class HumanShipShroudCreator
extends BaseDwellerShipCreator {
    @Override
    public void initBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    @Override
    public void initAfterShipCreation(ShipAPI ship, String id) {
    }

    @Override
    public void initAfterShipAddedToCombatEngine(ShipAPI ship, String id) {
    }

    @Override
    public void initInCombat(ShipAPI ship) {
        DwellerShroud shroud = this.createShroud(ship);
        Color color = Misc.setAlpha(Misc.setBrightness(shroud.getParams().flashFringeColor, 255), 255);
        ship.getFluxTracker().setOverloadColor(color);
    }

    @Override
    protected void modifyBaselineShroudParams(ShipAPI ship, final DwellerShroud.DwellerShroudParams params) {
        float maxOffset = 100.0f;
        float scale = 1.0f;
        float overloadGlowScale = 1.0f;
        switch (ship.getHullSize()) {
            case CAPITAL_SHIP: {
                maxOffset = 150.0f;
                scale = 1.75f;
                overloadGlowScale = 0.75f;
                break;
            }
            case CRUISER: {
                maxOffset = 120.0f;
                scale = 1.5f;
                overloadGlowScale = 0.75f;
                break;
            }
            case DESTROYER: {
                maxOffset = 100.0f;
                scale = 1.25f;
                overloadGlowScale = 0.5f;
                break;
            }
            case FIGHTER: 
            case FRIGATE: {
                overloadGlowScale = 0.5f;
                maxOffset = 75.0f;
            }
        }
        params.maxOffset = maxOffset * 0.5f;
        params.baseMembersToMaintain = params.initialMembers = 0;
        params.spawnOffsetMult = 0.75f;
        int num = (int)(ship.getCollisionRadius() * ship.getCollisionRadius() / 800.0f);
        if (num < 15) {
            num = 15;
        }
        if (ship.isDestroyer() && num < 22) {
            num = 22;
        }
        if (num > 150) {
            num = 150;
        }
        params.baseMembersToMaintain = num;
        params.initialMembers = num;
        float numShroudMods = 0.0f;
        for (String modId : ship.getVariant().getHullMods()) {
            HullModSpecAPI spec = Global.getSettings().getHullModSpec(modId);
            if (!spec.hasTag("shrouded")) continue;
            numShroudMods += 1.0f;
        }
        params.alphaMult = 0.25f + (numShroudMods - 1.0f) * 0.1f;
        if (params.alphaMult > 0.75f) {
            params.alphaMult = 0.75f;
        }
        if (params.alphaMult < 0.25f) {
            params.alphaMult = 0.25f;
        }
        params.baseSpriteSize *= scale;
        params.negativeParticleSpeedCap = ship.getMaxSpeedWithoutBoost() + 100.0f;
        params.negativeParticleColorOverride = RiftLanceEffect.getColorForDarkening(ship.getSpriteAPI().getAverageColor());
        params.negativeParticleSizeMult = scale;
        params.negativeParticleAreaMult = ship.getCollisionRadius() / params.maxOffset;
        params.overloadGlowSizeMult *= overloadGlowScale;
        params.overloadArcOffsetMult = params.negativeParticleAreaMult * 0.8f;
        params.generateOffsetAroundAttachedEntityOval = true;
        params.negativeParticleFilter = new DwellerShroud.ShroudNegativeParticleFilter(){

            @Override
            public boolean isParticleOk(DwellerShroud shroud, Vector2f loc) {
                if (shroud.getAttachedTo() instanceof ShipAPI) {
                    ShipAPI ship = (ShipAPI)shroud.getAttachedTo();
                    float targetingRadius = Misc.getTargetingRadius(loc, ship, false);
                    float dist = Misc.getDistance(ship.getLocation(), loc);
                    float pad = Math.max(50.0f, targetingRadius * 0.2f);
                    pad = params.maxOffset;
                    return dist < targetingRadius + pad && dist > targetingRadius * 0.75f;
                }
                return true;
            }
        };
    }
}

