/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.hullmods.BaseLogisticsHullMod;

public class MilitarizedSubsystems
extends BaseLogisticsHullMod {
    private static int BURN_LEVEL_BONUS = 1;
    private static float MAINTENANCE_PERCENT = 100.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        boolean sMod = this.isSMod(stats);
        stats.getSensorStrength().unmodify("civgrade");
        stats.getSensorProfile().unmodify("civgrade");
        stats.getMaxBurnLevel().modifyFlat(id, BURN_LEVEL_BONUS);
        if (!sMod) {
            stats.getMinCrewMod().modifyPercent(id, MAINTENANCE_PERCENT);
        }
    }

    public static float getEffectMult(MutableShipStatsAPI stats) {
        float bonus = MilitarizedSubsystems.getBonusPercent(stats);
        return 1.0f + bonus / 100.0f;
    }

    public static float getBonusPercent(MutableShipStatsAPI stats) {
        if (Global.getSettings().getCurrentState() == GameState.TITLE) {
            return 0.0f;
        }
        MutableCharacterStatsAPI cStats = null;
        if (stats == null) {
            cStats = Global.getSector().getPlayerStats();
        } else {
            FleetMemberAPI member = stats.getFleetMember();
            if (member == null) {
                return 0.0f;
            }
            PersonAPI commander = member.getFleetCommanderForStats();
            if (commander == null) {
                commander = member.getFleetCommander();
            }
            if (commander == null) {
                return 0.0f;
            }
            cStats = commander.getStats();
        }
        float bonus = cStats.getDynamic().getMod("auxiliary_effect_add_percent").computeEffective(0.0f);
        return Math.round(bonus);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + BURN_LEVEL_BONUS;
        }
        if (index == 1) {
            return Math.round(MAINTENANCE_PERCENT) + "%";
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship.getVariant().hasHullMod("civgrade") && super.isApplicableToShip(ship);
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (!ship.getVariant().hasHullMod("civgrade")) {
            return "Can only be installed on civilian-grade hulls";
        }
        return super.getUnapplicableReason(ship);
    }
}

