/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ai;

import com.fs.profiler.Profiler;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainPlugin;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.NavigationModulePlugin;
import com.fs.starfarer.api.campaign.ai.StrategicModulePlugin;
import com.fs.starfarer.api.campaign.ai.TacticalModulePlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.combat.CombatReadinessPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.fleet.CrewCompositionAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.shared.WormholeManager;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceAbyssPluginImpl;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTrackerMap;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.campaign.CampaignTerrain;
import com.fs.starfarer.campaign.Hyperspace;
import com.fs.starfarer.campaign.JumpPoint;
import com.fs.starfarer.campaign.ai.CampaignFleetAI;
import com.fs.starfarer.campaign.ai.StrategicModule;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.combat.ai.while;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.IntervalTracker;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class TacticalModule
implements DoNotObfuscate,
TacticalModulePlugin {
    private CampaignFleet fleet;
    private final ModularFleetAIAPI ai;
    private IntervalTracker tracker = new IntervalTracker(0.05f, 0.1f);
    private Vector2f travelDest = null;
    private SectorEntityToken priorityTarget = null;
    private float travelDur;
    private float targetDur;
    private SectorEntityToken target = null;
    private SectorEntityToken largestEnemy = null;
    private float pursueDuration = 0.0f;
    private float pursuitDays = 0.0f;
    private float beforeSearchPattern = 0.0f;
    private CampaignFleetAI.JumpPlan plan;
    private boolean followMode;
    private boolean isFleeing = false;
    private boolean isMaintainingContact = false;
    private transient boolean slowDown = false;
    private transient boolean didSlowDownBark = false;
    private transient List<CampaignTerrain> currentTerrain = new ArrayList<CampaignTerrain>();
    private transient TimeoutTrackerMap<String, CampaignFleetAIAPI.EncounterOption> optionCache = new TimeoutTrackerMap();

    public TacticalModule(CampaignFleet campaignFleet, ModularFleetAIAPI modularFleetAIAPI) {
        this.fleet = campaignFleet;
        this.ai = modularFleetAIAPI;
        this.tracker.forceIntervalElapsed();
    }

    public void advance(float f2) {
        float f3;
        float f4;
        float f5;
        LocationAPI locationAPI;
        AbilityPlugin abilityPlugin;
        boolean bl;
        boolean bl2;
        Profiler.\u00d200000((String)"Every frame stuff");
        this.travelDur -= f2;
        if (this.travelDur <= 0.0f) {
            this.travelDur = 0.0f;
            this.travelDest = null;
        }
        if (this.plan != null) {
            this.plan.timeLeft -= f2;
            if (this.plan.timeLeft <= 0.0f) {
                this.plan = null;
            }
            if (this.plan != null && this.target != null && this.plan.point.getContainingLocation() == this.target.getContainingLocation()) {
                this.plan = null;
            }
            if (this.plan != null && this.priorityTarget != null && this.plan.point.getContainingLocation() == this.priorityTarget.getContainingLocation()) {
                this.plan = null;
            }
        }
        this.targetDur -= f2;
        if (this.targetDur <= 0.0f) {
            this.targetDur = 0.0f;
            this.priorityTarget = null;
        }
        this.getOptionCache().advance(f2);
        MemoryAPI memoryAPI = this.fleet.getMemoryWithoutUpdate();
        if (this.target != null && !this.target.isAlive()) {
            this.setTarget(null);
        }
        if (!(!(this.target instanceof CampaignFleetAPI) || ((CampaignFleetAPI)this.target).getBattle() == null || ((CampaignFleetAPI)this.target).getBattle().canJoin((CampaignFleetAPI)this.fleet) && this.wantsToJoin(((CampaignFleetAPI)this.target).getBattle(), false))) {
            this.ai.getStrategicModule().getDoNotAttack().set((Object)this.target, 0.5f + 1.0f * (float)Math.random());
            this.setTarget(null);
        }
        if (this.target != null && !this.ai.getStrategicModule().isAllowedToEngage(this.target)) {
            this.setTarget(null);
        }
        boolean bl3 = bl2 = this.target instanceof CampaignFleetAPI && !this.fleet.isHostileTo(this.target);
        if (this.target != null && this.target.isPlayerFleet() && (bl = memoryAPI.getBoolean("$isPatrol"))) {
            if (!this.target.isTransponderOn() || memoryAPI.contains("$sawPlayerTransponderOff")) {
                bl2 = false;
            }
            if (memoryAPI.contains("$pursuePlayer")) {
                bl2 = false;
            }
            if (memoryAPI.contains("$keepPursuingPlayer")) {
                bl2 = false;
            }
        }
        if (this.pursueDuration > 0.0f) {
            this.pursuitDays += f2;
        }
        this.pursueDuration -= f2;
        bl = true;
        if (this.target != null && this.pursueDuration > 0.0f && !bl2) {
            bl = false;
        }
        if (this.slowDown) {
            this.fleet.goSlowOneFrame(false);
        }
        NavigationModulePlugin navigationModulePlugin = this.ai.getNavModule();
        StrategicModulePlugin strategicModulePlugin = this.ai.getStrategicModule();
        this.tracker.advance(f2);
        Profiler.o00000();
        if (this.tracker.intervalElapsed()) {
            CampaignFleet campaignFleet;
            boolean bl4 = false;
            abilityPlugin = this.fleet.getAbility("emergency_burn");
            if (abilityPlugin != null && abilityPlugin.isActiveOrInProgress()) {
                bl4 = true;
            }
            if (this.currentTerrain != null) {
                this.slowDown = false;
                if (!bl4) {
                    boolean bl5 = memoryAPI.getBoolean("$doNotGetSidetracked");
                    for (CampaignTerrain object22 : this.currentTerrain) {
                        boolean string2;
                        if (object22.getContainingLocation() != this.fleet.getContainingLocation()) break;
                        CampaignTerrainPlugin string = object22.getPlugin();
                        if (string == null || !string.hasAIFlag((Object)TerrainAIFlags.DANGEROUS_UNLESS_GO_SLOW, (CampaignFleetAPI)this.fleet) || (string2 = string.hasAIFlag((Object)TerrainAIFlags.NOT_SUPER_DANGEROUS_UNLESS_GO_SLOW, (CampaignFleetAPI)this.fleet)) && bl5) continue;
                        this.slowDown = true;
                        if (this.didSlowDownBark) break;
                        this.fleet.addFloatingText("Moving slowly", this.fleet.getFaction().getBaseUIColor(), 0.5f);
                        this.didSlowDownBark = true;
                        break;
                    }
                }
                if (!this.slowDown) {
                    this.didSlowDownBark = false;
                }
            }
            locationAPI = this.fleet.getContainingLocation();
            memoryAPI.unset("$ai_nearestEnemy");
            memoryAPI.unset("$ai_fleeingFrom");
            Profiler.\u00d200000((String)"Updating avoid list");
            this.updateAvoidList();
            Profiler.o00000();
            List f14 = locationAPI.getObjects().getList(CampaignFleet.class);
            SectorEntityToken object3 = null;
            f5 = Float.MAX_VALUE;
            f4 = Float.MAX_VALUE;
            this.isFleeing = false;
            this.isMaintainingContact = false;
            this.largestEnemy = null;
            f3 = 0.0f;
            boolean f24 = memoryAPI.getBoolean("$isSmuggler");
            boolean abilityPlugin2 = memoryAPI.getBoolean("$isPirate");
            boolean bl5 = memoryAPI.getBoolean("$isPatrol");
            boolean bl6 = memoryAPI.getBoolean("$isTradeFleet");
            CombatReadinessPlugin combatReadinessPlugin = StarfarerSettings.\u00f8\u00d50000();
            boolean bl7 = true;
            for (FleetMemberAPI fleetMemberAPI : this.fleet.getFleetData().getMembers()) {
                if (fleetMemberAPI.isCivilian() || !(fleetMemberAPI.getRepairTracker().getCR() > combatReadinessPlugin.getCriticalMalfunctionThreshold(fleetMemberAPI.getStats()))) continue;
                bl7 = false;
                break;
            }
            Profiler.\u00d200000((String)"Looking at other fleets");
            Iterator<FleetMember> iterator = f14.iterator();
            while (iterator.hasNext()) {
                float f6;
                boolean bl8;
                boolean bl9;
                boolean bl10;
                CampaignFleet campaignFleet2 = (CampaignFleet)((Object)iterator.next());
                if (this.fleet == campaignFleet2 || campaignFleet2.getFleetPoints() <= 0) continue;
                Profiler.\u00d200000((String)"Checking visibility level");
                SectorEntityToken.VisibilityLevel visibilityLevel = campaignFleet2.getVisibilityLevelTo(this.fleet);
                Profiler.o00000();
                if (visibilityLevel == SectorEntityToken.VisibilityLevel.NONE) continue;
                boolean bl11 = false;
                boolean bl12 = this.fleet.getAI() != null && this.fleet.getAI().isHostileTo((CampaignFleetAPI)campaignFleet2);
                bl12 |= campaignFleet2.getAI() != null && campaignFleet2.getAI().isHostileTo((CampaignFleetAPI)this.fleet);
                if (campaignFleet2.getBattle() != null && campaignFleet2.getFaction() != this.fleet.getFaction() && this.wantsToJoin(campaignFleet2.getBattle(), false)) {
                    bl12 = true;
                }
                boolean bl13 = bl12;
                boolean bl14 = this.isHostileTo(campaignFleet2, true);
                boolean bl15 = bl10 = campaignFleet2.isPlayerFleet() && memoryAPI.getBoolean("$cfai_recentlyDefeatedByPlayer");
                if (campaignFleet2.isPlayerFleet()) {
                    boolean bl16 = Misc.caresAboutPlayerTransponder((CampaignFleetAPI)this.fleet);
                    if ((!campaignFleet2.isTransponderOn() || memoryAPI.contains("$sawPlayerTransponderOff")) && memoryAPI.contains("$cfai_makeHostileWhileTOff")) {
                        Misc.setFlagWithReason((MemoryAPI)memoryAPI, (String)"$cfai_makeHostileWhileTOff", (String)"tOff", (boolean)true, (float)1.0f);
                    }
                    if (abilityPlugin2 && bl14 && (visibilityLevel == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS || visibilityLevel == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS)) {
                        bl12 = true;
                        Misc.setFlagWithReason((MemoryAPI)memoryAPI, (String)"$cfai_makeHostileWhileTOff", (String)"tOff", (boolean)true, (float)1.0f);
                    }
                    if (!campaignFleet2.isTransponderOn() || memoryAPI.contains("$sawPlayerTransponderOff")) {
                        if (bl5 && bl16) {
                            bl12 = true;
                            if (!bl13) {
                                Misc.setFlagWithReason((MemoryAPI)memoryAPI, (String)"$cfai_makeAggressive", (String)"tOff", (boolean)true, (float)1.0f);
                            }
                        }
                        memoryAPI.set("$sawPlayerTransponderOff", (Object)true, 1.0f);
                    } else {
                        Misc.setFlagWithReason((MemoryAPI)memoryAPI, (String)"$cfai_makeAggressive", (String)"tOff", (boolean)false, (float)0.0f);
                    }
                    if (campaignFleet2.isTransponderOn() && !Misc.isPermaKnowsWhoPlayerIs((CampaignFleetAPI)this.fleet)) {
                        memoryAPI.set("$sawPlayerTransponderOn", (Object)true, 7.0f + (float)Math.random() * 7.0f);
                    }
                    if (memoryAPI.getBoolean("$pursuePlayer") && !bl13) {
                        bl12 = true;
                        Misc.setFlagWithReason((MemoryAPI)memoryAPI, (String)"$cfai_makeAggressive", (String)"pursue", (boolean)true, (float)1.0f);
                    }
                    if (bl13) {
                        Misc.setFlagWithReason((MemoryAPI)memoryAPI, (String)"$cfai_makeAggressive", (String)"tOff", (boolean)false, (float)0.0f);
                        Misc.setFlagWithReason((MemoryAPI)memoryAPI, (String)"$cfai_makeAggressive", (String)"pursue", (boolean)false, (float)0.0f);
                    }
                }
                Profiler.\u00d200000((String)"Picking encounter option");
                CampaignFleetAIAPI.EncounterOption encounterOption = this.pickEncounterOption(null, campaignFleet2);
                if (abilityPlugin2 && (bl9 = campaignFleet2.getMemoryWithoutUpdate().getBoolean("$isPatrol")) && (encounterOption == CampaignFleetAIAPI.EncounterOption.HOLD || encounterOption == CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER)) {
                    encounterOption = CampaignFleetAIAPI.EncounterOption.DISENGAGE;
                }
                Profiler.o00000();
                if (bl10) {
                    encounterOption = CampaignFleetAIAPI.EncounterOption.DISENGAGE;
                }
                if (campaignFleet2.isPlayerFleet() && (bl9 = Misc.isAvoidingPlayerHalfheartedly((CampaignFleetAPI)this.fleet))) {
                    bl12 = true;
                    bl11 = true;
                    encounterOption = CampaignFleetAIAPI.EncounterOption.DISENGAGE;
                }
                if (campaignFleet2.isPlayerFleet() && bl6 && visibilityLevel != SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS && encounterOption == CampaignFleetAIAPI.EncounterOption.DISENGAGE && !this.fleet.knowsWhoPlayerIs()) {
                    bl12 = true;
                }
                if (this.target == campaignFleet2 && this.target != null && this.isAlreadyIntercepting() && this.ai != null && this.ai.getAssignmentModule() != null && this.ai.getAssignmentModule().getCurrentAssignment() != null && this.ai.getAssignmentModule().getCurrentAssignment().getTarget() == this.target) {
                    bl12 = true;
                }
                if (bl12) {
                    float f7;
                    float f8;
                    float f9;
                    float f10;
                    bl9 = false;
                    if (campaignFleet2.isPlayerFleet()) {
                        bl9 = Misc.isAvoidingPlayerHalfheartedly((CampaignFleetAPI)this.fleet);
                    }
                    boolean bl17 = "reckless".equals(this.fleet.getCommander().getPersonality().getId());
                    bl8 = "aggressive".equals(this.fleet.getCommander().getPersonality().getId());
                    float f11 = 0.5f;
                    if (bl17) {
                        f11 = 0.25f;
                    }
                    if (bl8) {
                        f11 = 0.33f;
                    }
                    if (this.fleet.getFaction().getCustomBoolean("engageWhenEvenStrength")) {
                        f11 = 0.5f;
                    }
                    boolean bl18 = this.hasEnoughStuffAround(campaignFleet2, f11 *= 2.0f, true, true, campaignFleet2.isPlayerFleet(), null);
                    if (bl9 || bl6) {
                        bl18 = false;
                    }
                    if ((f10 = Utils.\u00d800000(this.fleet.getLocation(), campaignFleet2.getLocation())) < f4 && bl13) {
                        f4 = f10;
                        memoryAPI.set("$ai_nearestEnemy", (Object)campaignFleet2, 0.5f);
                    }
                    if ((encounterOption == CampaignFleetAIAPI.EncounterOption.ENGAGE || bl18) && f10 < f5 && this.isOkToPursue(campaignFleet2) && (campaignFleet2.getBattle() == null || campaignFleet2.getBattle().canJoin((CampaignFleetAPI)this.fleet) && this.wantsToJoin(campaignFleet2.getBattle(), false))) {
                        object3 = campaignFleet2;
                        f5 = f10;
                        this.isMaintainingContact = false;
                        continue;
                    }
                    if (encounterOption == CampaignFleetAIAPI.EncounterOption.HOLD && f10 < f5 && !campaignFleet2.isPlayerFleet() && this.isOkToPursue(campaignFleet2)) {
                        object3 = campaignFleet2;
                        f5 = f10;
                        this.isMaintainingContact = false;
                        continue;
                    }
                    if ((encounterOption == CampaignFleetAIAPI.EncounterOption.HOLD || (bl5 || abilityPlugin2 && campaignFleet2.isPlayerFleet()) && encounterOption == CampaignFleetAIAPI.EncounterOption.DISENGAGE) && f10 < f5 && campaignFleet2.getBattle() == null && this.isOkToPursue(campaignFleet2) && !bl7 && !bl6) {
                        f9 = while.\u00d200000(this.fleet.getLocation(), campaignFleet2.getLocation(), this.fleet.getVelocity(), campaignFleet2.getVelocity());
                        f8 = 1000.0f;
                        if (f9 > 1.0f) {
                            f8 = f10 / f9;
                        }
                        if (campaignFleet2.isStationMode() || bl9 || bl4 || f10 < campaignFleet2.getRadius() + Misc.getBattleJoinRange() - 100.0f || f8 < 5.0f && f10 < campaignFleet2.getRadius() + Misc.getBattleJoinRange()) {
                            this.isFleeing = true;
                            f7 = campaignFleet2.getFleetPoints();
                            if (f7 > f3 || this.largestEnemy instanceof CampaignFleetAPI && ((CampaignFleetAPI)this.largestEnemy).isStationMode() && !campaignFleet2.isStationMode() || this.largestEnemy instanceof CampaignFleetAPI && !((CampaignFleetAPI)this.largestEnemy).isStationMode() && campaignFleet2.isStationMode()) {
                                f3 = f7;
                                this.largestEnemy = campaignFleet2;
                            }
                            memoryAPI.set("$ai_fleeingFrom", (Object)campaignFleet2, 0.5f);
                            this.isMaintainingContact = false;
                        } else if (!bl6 && !f24) {
                            object3 = campaignFleet2;
                            f5 = f10;
                            this.isMaintainingContact = true;
                        }
                        if (campaignFleet2 == this.target) {
                            this.setTarget(null);
                            this.priorityTarget = null;
                        }
                        if (bl4) {
                            navigationModulePlugin.avoidEntity((SectorEntityToken)campaignFleet2, 100000.0f, 100000.0f, 0.5f);
                            continue;
                        }
                        navigationModulePlugin.avoidEntity((SectorEntityToken)campaignFleet2, this.fleet.getRadius() + campaignFleet2.getRadius() + 0.0f, campaignFleet2.getRadius() + Misc.getBattleJoinRange() - 100.0f, 0.5f);
                        continue;
                    }
                    if (encounterOption != CampaignFleetAIAPI.EncounterOption.DISENGAGE && encounterOption != CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER || !strategicModulePlugin.isAllowedToEvade((SectorEntityToken)campaignFleet2) || campaignFleet2.getBattle() != null) continue;
                    f9 = 0.0f;
                    f8 = 0.0f;
                    if (campaignFleet2.isPlayerFleet()) {
                        f9 = 500.0f;
                        f8 = 2000.0f;
                    }
                    if (campaignFleet2 == this.target) {
                        this.setTarget(null);
                        this.priorityTarget = null;
                    }
                    if (bl4) {
                        navigationModulePlugin.avoidEntity((SectorEntityToken)campaignFleet2, 100000.0f, 100000.0f, 0.5f);
                    } else {
                        navigationModulePlugin.avoidEntity((SectorEntityToken)campaignFleet2, campaignFleet2.getRadius() + 100.0f + f9, campaignFleet2.getRadius() + 500.0f + f8, 0.5f);
                    }
                    if (f10 < campaignFleet2.getRadius() + 500.0f) {
                        this.isFleeing = true;
                    }
                    if ((f7 = (float)campaignFleet2.getFleetPoints()) > f3 || this.largestEnemy instanceof CampaignFleetAPI && ((CampaignFleetAPI)this.largestEnemy).isStationMode() && !campaignFleet2.isStationMode() || this.largestEnemy instanceof CampaignFleetAPI && !((CampaignFleetAPI)this.largestEnemy).isStationMode() && campaignFleet2.isStationMode()) {
                        f3 = f7;
                        this.largestEnemy = campaignFleet2;
                    }
                    memoryAPI.set("$ai_fleeingFrom", (Object)campaignFleet2, 0.5f);
                    continue;
                }
                bl9 = false;
                SectorEntityToken sectorEntityToken = this.target;
                if (sectorEntityToken == null) {
                    sectorEntityToken = object3;
                }
                if (sectorEntityToken != null && sectorEntityToken.getContainingLocation() == this.fleet.getContainingLocation() && sectorEntityToken.getFaction() != null && (bl8 = campaignFleet2.isHostileTo(sectorEntityToken))) {
                    float f12;
                    float f13 = Utils.\u00d800000(this.fleet.getLocation(), sectorEntityToken.getLocation()) - this.fleet.getRadius();
                    boolean bl19 = bl9 = f13 > (f12 = Utils.\u00d800000(campaignFleet2.getLocation(), sectorEntityToken.getLocation()) - campaignFleet2.getRadius());
                }
                if ((f6 = Utils.\u00d800000(this.fleet.getLocation(), campaignFleet2.getLocation())) < this.fleet.getRadius() + campaignFleet2.getRadius() + 100.0f && (bl9 || sectorEntityToken == null)) {
                    boolean bl20 = this.fleet.getMemoryWithoutUpdate().getBoolean("$doNotTryToAvoidNearbyFleets");
                    if (this.fleet.getCurrentAssignment() != null) {
                        FleetAssignment fleetAssignment = this.fleet.getCurrentAssignment().getAssignment();
                        bl20 |= fleetAssignment == FleetAssignment.HOLD;
                        bl20 |= fleetAssignment == FleetAssignment.STANDING_DOWN;
                        bl20 |= fleetAssignment == FleetAssignment.INTERCEPT;
                        bl20 |= fleetAssignment == FleetAssignment.FOLLOW;
                    }
                    if (!bl20) {
                        navigationModulePlugin.avoidEntity((SectorEntityToken)campaignFleet2, campaignFleet2.getRadius() + 125.0f, campaignFleet2.getRadius() + 250.0f, 0.5f);
                    }
                }
                if (campaignFleet2 != this.target) continue;
                this.setTarget(null);
                this.priorityTarget = null;
            }
            Profiler.o00000();
            if (this.priorityTarget != null) {
                object3 = this.priorityTarget;
                if (this.target == null) {
                    bl = true;
                }
            }
            if (this.isFleeing || !(this.target instanceof CampaignFleetAPI) && this.target != this.priorityTarget) {
                bl = true;
            }
            if (object3 instanceof CampaignFleetAPI && ((CampaignFleetAPI)object3).getBattle() != null && this.priorityTarget == null) {
                bl = true;
            }
            if (this.target != this.priorityTarget && this.target != null && this.target instanceof CampaignFleetAPI && ((iterator = this.pickEncounterOption(null, campaignFleet = (CampaignFleet)this.target)) != CampaignFleetAIAPI.EncounterOption.ENGAGE || !this.isOkToPursue(campaignFleet)) && (iterator == CampaignFleetAIAPI.EncounterOption.HOLD && campaignFleet.isPlayerFleet() || iterator == CampaignFleetAIAPI.EncounterOption.DISENGAGE)) {
                bl = true;
            }
            if (object3 != null && bl) {
                if (object3 != this.target) {
                    this.pursueDuration = 10.0f + 10.0f * (float)Math.random();
                    this.pursuitDays = 0.0f;
                }
                this.setTarget(object3);
            } else if (bl) {
                this.setTarget(null);
            } else if (!bl && object3 != null && object3 != this.target && f5 < object3.getRadius() + this.fleet.getRadius()) {
                this.pursueDuration = 0.1f;
                this.pursuitDays = 0.0f;
                this.setTarget(object3);
            }
        }
        if (this.target != null && this.target instanceof CampaignFleetAPI) {
            memoryAPI.set("$ai_pursuitTarget", (Object)this.target, 0.1f);
        } else if (this.target == null) {
            memoryAPI.unset("$ai_pursuitTarget");
        }
        if (this.travelDest != null && this.target == null) {
            navigationModulePlugin.setDestination(this.travelDest);
            memoryAPI.set("$ai_travelDest", (Object)this.travelDest, 0.1f);
            memoryAPI.unset("$ai_daysTargetUnseen");
            memoryAPI.unset("$ai_lastSeenTargetLoc");
            memoryAPI.unset("$ai_lastSeenTargetHeading");
            memoryAPI.unset("$ai_seenTargetJumpingFrom");
        } else if (this.target == null) {
            navigationModulePlugin.setDestination(null);
            memoryAPI.unset("$ai_travelDest");
            memoryAPI.unset("$ai_daysTargetUnseen");
            memoryAPI.unset("$ai_lastSeenTargetLoc");
            memoryAPI.unset("$ai_lastSeenTargetHeading");
            memoryAPI.unset("$ai_seenTargetJumpingFrom");
        } else if (this.target != null) {
            SectorEntityToken.VisibilityLevel visibilityLevel = this.target.getVisibilityLevelTo((SectorEntityToken)this.fleet);
            if (visibilityLevel != SectorEntityToken.VisibilityLevel.NONE || !(this.target instanceof CampaignFleetAPI)) {
                abilityPlugin = Misc.getInterceptPointBasic((SectorEntityToken)this.fleet, (SectorEntityToken)this.target);
                locationAPI = null;
                if (this.target instanceof CampaignFleetAPI) {
                    if (this.isMaintainingContact()) {
                        float f18 = this.target.getFacing();
                        f18 = this.target.getVelocity().length() > 10.0f ? Misc.getAngleInDegrees((Vector2f)this.target.getVelocity()) : Misc.getAngleInDegrees((Vector2f)this.fleet.getVelocity());
                        float f15 = Misc.getAngleInDegrees((Vector2f)this.target.getLocation(), (Vector2f)this.fleet.getLocation());
                        f5 = Misc.getClosestTurnDirection((float)f18, (float)f15);
                        f4 = Utils.\u00d800000(this.fleet.getLocation(), this.target.getLocation());
                        f4 -= this.fleet.getRadius();
                        f3 = Misc.getBattleJoinRange() + 100.0f;
                        float f14 = 90.0f - Math.min(90.0f, Math.max(0.0f, (f4 -= this.target.getRadius()) - f3) * 0.2f);
                        float f16 = f15 - 180.0f + f5 * f14;
                        locationAPI = Misc.getUnitVectorAtDegreeAngle((float)f16);
                        locationAPI.scale(2000.0f);
                        Vector2f.add((Vector2f)locationAPI, (Vector2f)this.fleet.getLocation(), (Vector2f)locationAPI);
                    } else {
                        locationAPI = Misc.getInterceptPoint((CampaignFleetAPI)this.fleet, (SectorEntityToken)this.target);
                    }
                } else {
                    locationAPI = Utils.\u00d300000(Utils.\u00d300000(this.fleet.getLocation(), (Vector2f)abilityPlugin));
                    float bl25 = Utils.\u00d800000(this.fleet.getLocation(), this.target.getLocation());
                    locationAPI.scale(bl25);
                    Vector2f.add((Vector2f)locationAPI, (Vector2f)this.fleet.getLocation(), (Vector2f)locationAPI);
                }
                if (!this.isFleeing) {
                    navigationModulePlugin.unavoidEntity(this.target);
                }
                navigationModulePlugin.setDestination((Vector2f)locationAPI);
                memoryAPI.set("$ai_travelDest", (Object)locationAPI, 0.1f);
                memoryAPI.set("$ai_lastSeenTargetLoc", (Object)new Vector2f((ReadableVector2f)this.target.getLocation()), 0.1f);
                if (this.target.isPlayerFleet() && this.target.getContainingLocation() != null && this.fleet.getContainingLocation() != null) {
                    boolean f23;
                    JumpPointAPI jumpPointAPI;
                    boolean f21 = ((CampaignFleetAPI)this.target).isInHyperspaceTransition();
                    if ((!f21 || this.pursueDuration < 10.0f) && this.target.getContainingLocation() != this.fleet.getContainingLocation() && Misc.getDistance((SectorEntityToken)this.fleet, (SectorEntityToken)(jumpPointAPI = Misc.findNearestJumpPoint((SectorEntityToken)this.fleet))) < 2000.0f) {
                        f23 = true;
                    }
                    if (f23) {
                        float f19 = 5.0f + 5.0f * (float)Math.random();
                        this.pursueDuration = Math.max(f19, this.pursueDuration);
                        memoryAPI.set("$ai_seenTargetJumpingFrom", (Object)this.fleet.getContainingLocation().getId(), this.pursueDuration);
                    }
                }
                if (this.target.getVelocity().length() > StarfarerSettings.\u00d2\u00d20000()) {
                    memoryAPI.set("$ai_lastSeenTargetHeading", (Object)Float.valueOf(Utils.\u00d300000(this.target.getVelocity())), 0.1f);
                }
                memoryAPI.unset("$ai_daysTargetUnseen");
            } else {
                float f20;
                memoryAPI.unset("$ai_travelDest");
                abilityPlugin = memoryAPI.getVector2f("$ai_lastSeenTargetLoc");
                if (abilityPlugin == null) {
                    abilityPlugin = memoryAPI.getVector2f("$ai_placeToLook");
                }
                if ((f20 = memoryAPI.getFloat("$ai_daysTargetUnseen")) <= 0.0f && abilityPlugin != null) {
                    float f17 = Utils.\u00d800000(this.fleet.getLocation(), (Vector2f)abilityPlugin);
                    float f22 = Global.getSector().getClock().convertToDays(f17 / Math.max(1.0f, this.fleet.getTravelSpeed()));
                    this.beforeSearchPattern = f22 += 0.3f + 0.5f * (float)Math.random();
                }
                if (memoryAPI.getBoolean("$ai_hasVisionPenalty")) {
                    this.beforeSearchPattern += f2;
                }
                memoryAPI.set("$ai_daysTargetUnseen", (Object)Float.valueOf(f20 += f2), 0.1f);
                float f18 = memoryAPI.getFloat("$ai_lastSeenTargetHeading");
                boolean bl26 = false;
                if (memoryAPI.contains("$ai_lastSeenTargetHeading")) {
                    bl26 = true;
                    memoryAPI.set("$ai_lastSeenTargetHeading", (Object)Float.valueOf(f18), 0.1f);
                }
                if (abilityPlugin == null) {
                    abilityPlugin = Misc.getPointAtRadius((Vector2f)this.fleet.getLocation(), (float)3000.0f);
                }
                if (abilityPlugin != null) {
                    AbilityPlugin abilityPlugin2;
                    memoryAPI.set("$ai_lastSeenTargetLoc", (Object)abilityPlugin, 0.1f);
                    String string = "$ai_searchDir";
                    String string2 = "$ai_searchDist";
                    f3 = 500.0f;
                    float f19 = 0.0f;
                    if (this.target instanceof CampaignFleetAPI) {
                        f3 = this.fleet.getMaxSensorRangeToDetect((SectorEntityToken)((CampaignFleetAPI)this.target));
                        f19 = ((CampaignFleetAPI)this.target).getTravelSpeed();
                    }
                    if (bl26) {
                        abilityPlugin2 = Utils.\u00d300000(f18);
                        abilityPlugin2.scale(f19 * f20 * Global.getSector().getClock().getSecondsPerDay());
                        Vector2f.add((Vector2f)abilityPlugin2, (Vector2f)abilityPlugin, (Vector2f)abilityPlugin2);
                    } else {
                        abilityPlugin2 = abilityPlugin;
                    }
                    float f21 = Utils.\u00d800000(this.fleet.getLocation(), (Vector2f)abilityPlugin2);
                    if (f21 < f3 * 0.5f || memoryAPI.contains(string) || f20 > this.beforeSearchPattern) {
                        if (!memoryAPI.contains(string) && !this.isFleeing() && this.fleet.isVisibleToPlayerFleet()) {
                            this.fleet.addFloatingText("Executing search pattern", this.fleet.getFaction().getBaseUIColor(), 0.5f);
                        }
                        StrategicModule.doCircularPatrol(this.fleet, this.ai, (Vector2f)abilityPlugin2, string, string2, 1.0f, 1.0f, 300.0f, 400.0f);
                        if (this.travelDest != null) {
                            navigationModulePlugin.setDestination(this.travelDest);
                        }
                    } else {
                        Vector2f vector2f = Utils.\u00d300000(Utils.\u00d300000(this.fleet.getLocation(), (Vector2f)abilityPlugin2));
                        vector2f.scale(2000.0f);
                        Vector2f.add((Vector2f)vector2f, (Vector2f)this.fleet.getLocation(), (Vector2f)vector2f);
                        navigationModulePlugin.setDestination(vector2f);
                        memoryAPI.unset(string);
                        memoryAPI.unset(string2);
                    }
                } else {
                    this.pursueDuration = 0.0f;
                    this.pursuitDays = 0.0f;
                }
            }
        }
        Profiler.\u00d200000((String)"Every frame stuff, post");
        if (this.target != null) {
            Vector2f vector2f = this.target.getLocation();
            if (this.plan == null && TacticalModule.knowsIfTargetJumped(this.fleet, this.target)) {
                this.plan = this.computeJumpPlanTo(this.target.getContainingLocation());
                if (this.plan != null) {
                    this.plan.timeLeft = 0.1f + 0.1f * (float)Math.random();
                    if (!this.fleet.isInCurrentLocation()) {
                        this.plan.timeLeft *= 10.0f;
                    }
                }
            }
            if (this.plan != null) {
                if (this.fleet.getMemoryWithoutUpdate().getBoolean("$cfai_noJump")) {
                    this.setTarget(null);
                } else {
                    this.fleet.setInteractionTarget(this.plan.point);
                    vector2f = this.plan.point.getLocation();
                    float f26 = Utils.\u00d800000(vector2f, this.fleet.getLocation());
                    float f27 = 100.0f;
                    if (!this.fleet.isInCurrentLocation()) {
                        f27 = 500.0f;
                    }
                    if (this.plan != null && f26 < f27 && !this.fleet.isInHyperspaceTransition()) {
                        CampaignEngine.getInstance().doHyperspaceTransition(this.fleet, this.plan.point, this.plan.dest);
                        this.plan = null;
                    }
                }
            }
            if (!this.followMode && this.target instanceof CampaignEntity && !this.isFleeing && !this.isMaintainingContact) {
                this.fleet.setInteractionTarget(this.target);
            } else {
                this.fleet.setInteractionTarget(null);
            }
            CampaignFleetAI.FleetAssignmentData fleetAssignmentData = (CampaignFleetAI.FleetAssignmentData)this.ai.getAssignmentModule().getCurrentAssignment();
            if (fleetAssignmentData != null && fleetAssignmentData.target == null && (fleetAssignmentData.getAssignment() == FleetAssignment.HOLD || fleetAssignmentData.getAssignment() == FleetAssignment.STANDING_DOWN)) {
                this.fleet.setInteractionTarget(null);
            }
        } else {
            if (this.fleet.getInteractionTarget() instanceof CampaignFleetAPI) {
                this.fleet.setInteractionTarget(null);
            }
            this.plan = null;
        }
        if ((this.isBusy() || this.travelDest != null) && this.fleet.getOrbit() != null) {
            this.fleet.setOrbit(null);
        }
        if (this.fleet.getOrbit() == null) {
            Vector2f vector2f = this.ai.getNavModule().getClickToMoveLocation();
            this.fleet.setMoveDestination(vector2f.x, vector2f.y);
            memoryAPI.set("$ai_moveDest", (Object)vector2f, 0.1f);
        } else {
            memoryAPI.unset("$ai_moveDest");
        }
        Profiler.o00000();
    }

    private boolean hasEnoughStuffAround(SectorEntityToken sectorEntityToken, float f2, boolean bl, boolean bl2, boolean bl3, BattleAPI battleAPI) {
        BattleAPI.BattleSide battleSide;
        if (sectorEntityToken == null) {
            sectorEntityToken = this.fleet;
        }
        if (bl3 && this.fleet != null && !this.fleet.isPlayerFleet()) {
            this.fleet.inflateIfNeeded();
        }
        boolean bl4 = false;
        if (sectorEntityToken instanceof CampaignFleetAPI) {
            bl4 = ((CampaignFleetAPI)sectorEntityToken).getFaction().isPlayerFaction();
        }
        float f3 = Misc.getBattleJoinRange();
        if (battleAPI != null) {
            f3 += 200.0f;
        }
        LocationAPI locationAPI = this.fleet.getContainingLocation();
        List list = locationAPI.getObjects().getList(CampaignFleet.class);
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (battleAPI != null && (battleSide = battleAPI.pickSide((CampaignFleetAPI)this.fleet)) != null) {
            for (CampaignFleetAPI campaignFleetAPI : battleAPI.getSide(battleSide)) {
                if (bl3) {
                    f4 += this.computeFleetStrength(campaignFleetAPI, campaignFleetAPI.isPlayerFleet());
                    continue;
                }
                f4 += (float)campaignFleetAPI.getFleetPoints();
            }
            for (CampaignFleetAPI campaignFleetAPI : battleAPI.getOtherSide(battleSide)) {
                if (bl3) {
                    f5 += this.computeFleetStrength(campaignFleetAPI, false);
                    continue;
                }
                f5 += (float)campaignFleetAPI.getFleetPoints();
            }
        }
        boolean bl5 = false;
        if (battleAPI != null && (bl2 || !bl || f2 > 4.0f)) {
            bl5 = true;
        }
        float f6 = this.fleet.getFleetPoints();
        float f7 = this.fleet.getFleetPoints();
        if (bl3) {
            f6 = f7 = this.computeFleetStrength(this.fleet, false);
        }
        if (!bl) {
            f7 = 0.0f;
        }
        float f8 = 0.0f;
        f7 += f4;
        f8 += f5;
        if (!bl5) {
            float f9 = Misc.getDistance((Vector2f)sectorEntityToken.getLocation(), (Vector2f)this.fleet.getLocation());
            f9 -= sectorEntityToken.getRadius();
            f9 -= this.fleet.getRadius();
            for (CampaignFleet campaignFleet : list) {
                SectorEntityToken.VisibilityLevel visibilityLevel;
                if (this.fleet == campaignFleet || campaignFleet.getFleetPoints() <= 0 || campaignFleet.isStationMode() || campaignFleet.getMemoryWithoutUpdate().is("$isTradeFleet", true) || !campaignFleet.isPlayerFleet() && campaignFleet.getAI() == null || (visibilityLevel = campaignFleet.getVisibilityLevelTo(this.fleet)) == SectorEntityToken.VisibilityLevel.NONE && campaignFleet.getFaction() != this.fleet.getFaction() || campaignFleet.getBattle() != null) continue;
                float f10 = Misc.getDistance((Vector2f)sectorEntityToken.getLocation(), (Vector2f)campaignFleet.getLocation());
                f10 -= sectorEntityToken.getRadius();
                if ((f10 -= campaignFleet.getRadius()) > f3 && f10 > f9 + 500.0f || bl4 && this.fleet.getFaction().isPlayerFaction() && campaignFleet.getFaction().isPlayerFaction()) continue;
                boolean bl6 = this.isHostileTo(campaignFleet, true);
                if (!bl6 && campaignFleet.isFriendlyTo(this.fleet) && this.fleet.isFriendlyTo(campaignFleet)) {
                    if (bl3) {
                        f7 += this.computeFleetStrength(campaignFleet, false);
                        continue;
                    }
                    f7 += (float)campaignFleet.getFleetPoints();
                    continue;
                }
                if (!bl6 && !campaignFleet.isHostileTo(this.fleet) && !this.fleet.isHostileTo(campaignFleet)) continue;
                if (bl3) {
                    f8 += this.computeFleetStrength(campaignFleet, false);
                    continue;
                }
                f8 += (float)campaignFleet.getFleetPoints();
            }
        }
        if (bl2) {
            return f7 > f8 * f2 && f7 > f6;
        }
        return f7 > f8 * f2;
    }

    protected float computeFleetStrength(CampaignFleetAPI campaignFleetAPI, boolean bl) {
        CampaignFleet campaignFleet = (CampaignFleet)campaignFleetAPI;
        float f2 = 0.0f;
        for (FleetMember fleetMember : campaignFleet.getMembers()) {
            if (!fleetMember.canBeDeployedForCombat()) continue;
            float f3 = Misc.getMemberStrength((FleetMemberAPI)fleetMember, (boolean)true, (boolean)true, (boolean)bl);
            f2 += f3;
        }
        return f2;
    }

    public static Vector2f computeAbyssalGradient(Vector2f vector2f) {
        float f2 = Misc.getAbyssalDepth((Vector2f)vector2f, (boolean)true);
        if (f2 <= 0.0f) {
            return null;
        }
        Vector2f vector2f2 = Misc.getUnitVectorAtDegreeAngle((float)0.0f);
        Vector2f vector2f3 = Misc.getUnitVectorAtDegreeAngle((float)120.0f);
        Vector2f vector2f4 = Misc.getUnitVectorAtDegreeAngle((float)240.0f);
        float f3 = 400.0f;
        vector2f2.scale(f3);
        vector2f3.scale(f3);
        vector2f4.scale(f3);
        Vector2f.add((Vector2f)vector2f2, (Vector2f)vector2f, (Vector2f)vector2f2);
        Vector2f.add((Vector2f)vector2f3, (Vector2f)vector2f, (Vector2f)vector2f3);
        Vector2f.add((Vector2f)vector2f4, (Vector2f)vector2f, (Vector2f)vector2f4);
        float f4 = Misc.getAbyssalDepth((Vector2f)vector2f2, (boolean)true);
        float f5 = Misc.getAbyssalDepth((Vector2f)vector2f3, (boolean)true);
        float f6 = Misc.getAbyssalDepth((Vector2f)vector2f4, (boolean)true);
        if (f4 >= 1.0f && f5 >= 1.0f && f6 >= 1.0f) {
            Vector2f vector2f5 = new Vector2f();
            float f7 = Misc.getAngleInDegrees((Vector2f)vector2f, (Vector2f)vector2f5);
            return Misc.getUnitVectorAtDegreeAngle((float)f7);
        }
        Vector3f vector3f = new Vector3f(vector2f2.x, vector2f2.y, f4);
        Vector3f vector3f2 = new Vector3f(vector2f3.x, vector2f3.y, f5);
        Vector3f vector3f3 = new Vector3f(vector2f4.x, vector2f4.y, f6);
        Vector3f vector3f4 = Vector3f.sub((Vector3f)vector3f2, (Vector3f)vector3f, (Vector3f)new Vector3f());
        Vector3f vector3f5 = Vector3f.sub((Vector3f)vector3f3, (Vector3f)vector3f, (Vector3f)new Vector3f());
        Vector3f vector3f6 = Vector3f.cross((Vector3f)vector3f4, (Vector3f)vector3f5, (Vector3f)new Vector3f());
        return Misc.normalise((Vector2f)new Vector2f(vector3f6.x, vector3f6.y));
    }

    private void updateAvoidList() {
        boolean bl;
        float f2;
        NavigationModulePlugin navigationModulePlugin = this.ai.getNavModule();
        MemoryAPI memoryAPI = this.fleet.getMemoryWithoutUpdate();
        LocationAPI locationAPI = this.fleet.getContainingLocation();
        Vector2f vector2f = this.fleet.getLocation();
        if (this.fleet.isInHyperspace() && !memoryAPI.getBoolean("$mayGoIntoAbyss") && !memoryAPI.getBoolean("$tempNotAvoidingAbyssal") && (f2 = Misc.getAbyssalDepth((Vector2f)vector2f)) > HyperspaceAbyssPluginImpl.DEPTH_THRESHOLD_FOR_FLEETS_FLEEING) {
            float f3;
            float f4;
            Object object;
            bl = false;
            if (!memoryAPI.getBoolean("$avoidingAbyssalHyperspace") && !this.isFleeing() && this.getTarget() != null && this.fleet.getCommander() != null && this.fleet.getCommander().getPersonality() != null) {
                object = this.fleet.getCommander().getPersonality().getId();
                f4 = 0.0f;
                if ("reckless".equals(object)) {
                    f4 = 0.4f;
                } else if ("aggressive".equals(object)) {
                    f4 = 0.2f;
                } else if ("steady".equals(object)) {
                    f4 = 0.1f;
                }
                if ((float)Math.random() < f4) {
                    f3 = 1.0f + 1.0f * (float)Math.random();
                    memoryAPI.set("$tempNotAvoidingAbyssal", (Object)true, f3);
                    bl = true;
                }
            }
            if (!bl && (object = TacticalModule.computeAbyssalGradient(vector2f)) != null) {
                object.negate();
                f4 = 1000.0f;
                object.scale(f4);
                Vector2f.add((Vector2f)object, (Vector2f)vector2f, (Vector2f)object);
                f3 = 0.5f;
                navigationModulePlugin.avoidLocation(this.fleet.getContainingLocation(), object, f4 * 0.75f, f4 * 1.5f, f3);
                memoryAPI.set("$avoidingAbyssalHyperspace", (Object)true, f3);
            }
        }
        this.currentTerrain = new ArrayList<CampaignTerrain>();
        boolean cfr_ignored_0 = locationAPI instanceof StarSystemAPI;
        boolean bl2 = memoryAPI.getBoolean("$isTradeFleet");
        bl = memoryAPI.getBoolean("$isSmuggler");
        boolean bl3 = false;
        AbilityPlugin abilityPlugin = this.fleet.getAbility("emergency_burn");
        if (abilityPlugin != null && abilityPlugin.isActiveOrInProgress()) {
            bl3 = true;
        }
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.ai.getAssignmentModule().getCurrentAssignment();
        o o2 = this.computeCRLevel();
        for (CampaignTerrain campaignTerrain : locationAPI.getTerrain()) {
            float f5;
            float f6;
            float f7;
            boolean bl4;
            CampaignTerrainPlugin campaignTerrainPlugin = campaignTerrain.getPlugin();
            if (campaignTerrainPlugin instanceof BaseTerrain) {
                BaseTerrain baseTerrain = (BaseTerrain)campaignTerrainPlugin;
                if (fleetAssignmentDataAPI != null && fleetAssignmentDataAPI.getTarget() != null && fleetAssignmentDataAPI.getTarget() == baseTerrain.getRelatedEntity()) continue;
            }
            if (bl4 = campaignTerrainPlugin.containsEntity((SectorEntityToken)this.fleet)) {
                this.currentTerrain.add(campaignTerrain);
            }
            boolean bl5 = campaignTerrainPlugin.hasAIFlag((Object)TerrainAIFlags.AVOID_VERY_CAREFULLY);
            if (!campaignTerrainPlugin.hasAIFlag((Object)TerrainAIFlags.CR_DRAIN, (CampaignFleetAPI)this.fleet) && !bl5) continue;
            if (this.travelDest != null && bl4 && (f7 = Misc.getDistance((Vector2f)this.fleet.getLocation(), (Vector2f)this.travelDest)) < 2000.0f) {
                f6 = Misc.getAngleInDegrees((Vector2f)this.fleet.getLocation(), (Vector2f)this.travelDest);
                Vector2f vector2f2 = Misc.getUnitVectorAtDegreeAngle((float)f6);
                f5 = Vector2f.dot((Vector2f)this.fleet.getVelocity(), (Vector2f)vector2f2);
                if (!(f5 < 50.0f)) continue;
                this.fleet.getMemoryWithoutUpdate().set("$ai_useEBForTravel", (Object)true, 0.5f);
                campaignTerrainPlugin.hasAIFlag((Object)TerrainAIFlags.CR_DRAIN, (CampaignFleetAPI)this.fleet);
                continue;
            }
            f7 = campaignTerrainPlugin.getMaxEffectRadius(vector2f);
            f6 = campaignTerrainPlugin.getMinEffectRadius(vector2f);
            float f8 = campaignTerrainPlugin.getOptimalEffectRadius(vector2f);
            f5 = 200.0f;
            if (bl2 || bl) {
                f5 += 500.0f;
            }
            if (f8 > f7) {
                f8 = f7;
            }
            if (bl5) {
                navigationModulePlugin.avoidEntity((SectorEntityToken)campaignTerrain, f7 + 200.0f, f7 + 200.0f, 0.5f);
                continue;
            }
            if (campaignTerrainPlugin.hasAIFlag((Object)TerrainAIFlags.TILE_BASED)) {
                if (o2 == o.o00000) continue;
                navigationModulePlugin.avoidEntity((SectorEntityToken)campaignTerrain, f7, f7 + 200.0f, 0.5f);
                continue;
            }
            if (campaignTerrainPlugin.hasAIFlag((Object)TerrainAIFlags.EFFECT_DIMINISHED_WITH_RANGE)) {
                if (bl3) {
                    f6 *= 0.5f;
                    f7 *= 0.5f;
                }
                if (o2 == o.o00000 && this.getLargestEnemy() != null) {
                    navigationModulePlugin.avoidEntity((SectorEntityToken)campaignTerrain, f8, f8 + (f7 - f8) * 0.5f, 0.5f);
                    continue;
                }
                navigationModulePlugin.avoidEntity((SectorEntityToken)campaignTerrain, f7 - f5 / 2.0f, f7 + f5 / 2.0f, 0.5f);
                continue;
            }
            if (o2 == o.o00000 && this.getLargestEnemy() != null) {
                navigationModulePlugin.avoidEntity((SectorEntityToken)campaignTerrain, f7, f7 - 200.0f, 0.5f);
                continue;
            }
            navigationModulePlugin.avoidEntity((SectorEntityToken)campaignTerrain, f7 - f5 / 2.0f, f7 + f5 / 2.0f, 0.5f);
        }
        if (this.fleet.isInHyperspace()) {
            Profiler.\u00d200000((String)"Avoiding hyperstorms");
            boolean bl6 = memoryAPI.getBoolean("$ai_hasSpeedBonus");
            CampaignTerrainAPI campaignTerrainAPI = Misc.getHyperspaceTerrain();
            Profiler.o00000();
        }
    }

    public boolean isMaintainingContact() {
        return this.isMaintainingContact;
    }

    private o computeCRLevel() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = Global.getSettings().getCRPlugin().getCriticalMalfunctionThreshold(null);
        float f7 = Global.getSettings().getCRPlugin().getMalfunctionThreshold(null) + 0.01f;
        for (FleetMemberAPI fleetMemberAPI : this.fleet.getFleetData().getMembersListCopy()) {
            f2 += 1.0f;
            if (fleetMemberAPI.isCivilian()) {
                f5 += 1.0f;
                continue;
            }
            float f8 = fleetMemberAPI.getRepairTracker().getCR();
            if (f8 <= f6) {
                f3 += 1.0f;
                continue;
            }
            if (f8 <= f7) {
                f4 += 1.0f;
                continue;
            }
            f5 += 1.0f;
        }
        if (f5 + f4 >= f2 && f5 * 0.5f >= f4) {
            return o.o00000;
        }
        if (f4 > f3 * 0.5f) {
            return o.Object;
        }
        return o.\u00d400000;
    }

    public boolean isFleeing() {
        return this.isFleeing;
    }

    public void forceTargetReEval() {
        this.tracker.forceIntervalElapsed();
        this.fleet.setInteractionTarget(null);
        this.setTarget(null);
        this.setPriorityTarget(null, 0.0f, false);
    }

    public static boolean knowsIfTargetJumped(CampaignFleetAPI campaignFleetAPI, SectorEntityToken sectorEntityToken) {
        if (sectorEntityToken != CampaignEngine.getInstance().getPlayerFleet() || campaignFleetAPI.getFaction().isPlayerFaction()) {
            return true;
        }
        String string = campaignFleetAPI.getMemoryWithoutUpdate().getString("$ai_seenTargetJumpingFrom");
        if (string == null || string.isEmpty()) {
            return false;
        }
        return campaignFleetAPI.getContainingLocation() != null && string.equals(campaignFleetAPI.getContainingLocation().getId());
    }

    public CampaignFleetAI.JumpPlan computeJumpPlanTo(LocationAPI locationAPI) {
        Object object;
        boolean bl;
        if (locationAPI == this.fleet.getContainingLocation()) {
            return null;
        }
        if (this.fleet.getCargo().getFuel() <= 0.0f && !this.fleet.isAIMode()) {
            return null;
        }
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$cfai_noJump")) {
            return null;
        }
        List list = this.fleet.getContainingLocation().getEntities(JumpPoint.class);
        Object object2 = null;
        JumpPointAPI.JumpDestination jumpDestination = null;
        float f2 = Float.MAX_VALUE;
        Hyperspace hyperspace = CampaignEngine.getInstance().getHyperspace();
        boolean bl2 = bl = locationAPI == null;
        if (hyperspace != locationAPI && hyperspace != this.fleet.getContainingLocation()) {
            bl = true;
        }
        ArrayList<StarCoronaTerrainPlugin> arrayList = new ArrayList<StarCoronaTerrainPlugin>();
        if (this.fleet.getContainingLocation() instanceof StarSystemAPI) {
            Object object3 = (StarSystemAPI)this.fleet.getContainingLocation();
            for (CampaignTerrainAPI campaignTerrainAPI : object3.getTerrainCopy()) {
                if (!(campaignTerrainAPI.getPlugin() instanceof StarCoronaTerrainPlugin)) continue;
                object = (StarCoronaTerrainPlugin)campaignTerrainAPI.getPlugin();
                arrayList.add((StarCoronaTerrainPlugin)object);
            }
        }
        block1: for (Object object3 : list) {
            if (((JumpPoint)object3).isStarAnchor() || ((BaseCampaignEntity)object3).getMemoryWithoutUpdate().getBoolean("$unstable") || ((BaseCampaignEntity)object3).getMemoryWithoutUpdate().getBoolean(WormholeManager.WORMHOLE)) continue;
            for (JumpPointAPI.JumpDestination jumpDestination2 : ((JumpPoint)object3).getDestinations()) {
                float f3;
                if (jumpDestination2.getDestination() == null || jumpDestination2.getDestination().getContainingLocation() != locationAPI && (!bl || hyperspace != jumpDestination2.getDestination().getContainingLocation()) || !((f3 = Utils.\u00d800000(((BaseCampaignEntity)object3).getLocation(), this.fleet.getLocation())) < f2)) continue;
                f2 = f3;
                object2 = object3;
                jumpDestination = jumpDestination2;
                continue block1;
            }
        }
        if (object2 == null) {
            return null;
        }
        float f4 = Misc.getDistance((SectorEntityToken)this.fleet, object2);
        if (f4 < 2000.0f && f4 > 500.0f) {
            for (StarCoronaTerrainPlugin starCoronaTerrainPlugin : arrayList) {
                if (!starCoronaTerrainPlugin.containsPoint(((BaseCampaignEntity)object2).getLocation(), 100.0f)) continue;
                this.fleet.getMemoryWithoutUpdate().set("$ai_useEBForTravel", (Object)true, 0.2f);
                object = this.ai.getNavModule();
                object.doNotAvoid(starCoronaTerrainPlugin.getRelatedEntity(), 0.2f);
                break;
            }
        }
        return new CampaignFleetAI.JumpPlan((JumpPoint)object2, jumpDestination);
    }

    private boolean isOkToPursue(CampaignFleet campaignFleet) {
        StrategicModulePlugin strategicModulePlugin = this.ai.getStrategicModule();
        return strategicModulePlugin.isAllowedToEngage((SectorEntityToken)campaignFleet);
    }

    public SectorEntityToken getTarget() {
        return this.target;
    }

    public void setTarget(SectorEntityToken sectorEntityToken) {
        if (this.target != sectorEntityToken) {
            this.plan = null;
        }
        this.target = sectorEntityToken;
    }

    public SectorEntityToken getPriorityTarget() {
        return this.priorityTarget;
    }

    public SectorEntityToken getLargestEnemy() {
        return this.largestEnemy;
    }

    public boolean isBusy() {
        return this.target != null || this.largestEnemy != null && (this.isFleeing() || this.isMaintainingContact());
    }

    public IntervalTracker getTracker() {
        return this.tracker;
    }

    public boolean isFollowMode() {
        return this.followMode;
    }

    public void setTravelDestination(Vector2f vector2f, float f2) {
        this.travelDest = vector2f;
        this.travelDur = f2;
    }

    public void setPriorityTarget(SectorEntityToken sectorEntityToken, float f2, boolean bl) {
        this.priorityTarget = sectorEntityToken;
        this.targetDur = f2;
        this.followMode = bl;
    }

    public boolean isHostileTo(CampaignFleetAPI campaignFleetAPI) {
        return this.isHostileTo(campaignFleetAPI, false);
    }

    public boolean isHostileTo(CampaignFleetAPI campaignFleetAPI, boolean bl) {
        if (Misc.isPlayerOrCombinedPlayerPrimary((CampaignFleetAPI)campaignFleetAPI)) {
            boolean bl2 = this.fleet.getMemoryWithoutUpdate().getBoolean("$makeNonHostileTakesPriority");
            if (bl2 && this.fleet.getMemoryWithoutUpdate().is("$cfai_makeNonHostile", true)) {
                return false;
            }
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeHostile", true)) {
                return true;
            }
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeNonHostile", true)) {
                return false;
            }
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeHostileWhileTOff", true) && !Global.getSector().getPlayerFleet().isTransponderOn()) {
                return true;
            }
            if (!(bl || campaignFleetAPI.isTransponderOn() || this.fleet.knowsWhoPlayerIs())) {
                return false;
            }
        }
        if (campaignFleetAPI.getFaction().isPlayerFaction()) {
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeHostile", true)) {
                return true;
            }
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeHostileToPlayerTradeFleets", true) && Misc.isTrader((CampaignFleetAPI)campaignFleetAPI)) {
                return true;
            }
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeNonHostile", true)) {
                return false;
            }
        }
        if (this.fleet.getFaction().isPlayerFaction() && campaignFleetAPI.getMemoryWithoutUpdate().is("$cfai_makeHostile", true)) {
            return true;
        }
        String string = "$cfai_makeNonHostile_" + campaignFleetAPI.getFaction().getId();
        if (this.fleet.getMemoryWithoutUpdate().getBoolean(string)) {
            return false;
        }
        String string2 = "$cfai_makeNonHostile_" + this.fleet.getFaction().getId();
        if (campaignFleetAPI.getMemoryWithoutUpdate().getBoolean(string2)) {
            return false;
        }
        if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeHostileToAllTradeFleets", true) && Misc.isTrader((CampaignFleetAPI)campaignFleetAPI) && campaignFleetAPI.getFaction() != this.fleet.getFaction()) {
            return true;
        }
        string = "$cfai_makeHostile_" + campaignFleetAPI.getFaction().getId();
        if (this.fleet.getMemoryWithoutUpdate().getBoolean(string)) {
            return true;
        }
        string2 = "$cfai_makeHostile_" + this.fleet.getFaction().getId();
        if (campaignFleetAPI.getMemoryWithoutUpdate().getBoolean(string2)) {
            return true;
        }
        return this.fleet.getFaction().isAtBest(campaignFleetAPI.getFaction(), RepLevel.HOSTILE);
    }

    /*
     * WARNING - void declaration
     */
    public void performCrashMothballingPriorToEscape(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        void var9_13;
        float f2;
        FleetMember fleetMember2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = Misc.isPlayerOrCombinedContainingPlayer((CampaignFleetAPI)this.fleet);
        CombatReadinessPlugin combatReadinessPlugin = StarfarerSettings.\u00f8\u00d50000();
        for (FleetMember fleetMember2 : this.fleet.getMembers()) {
            if (!fleetMember2.canBeDeployedForCombat() || fleetMember2.isCivilian()) continue;
            f2 = Misc.getMemberStrength((FleetMemberAPI)fleetMember2, (boolean)true, (boolean)true, (boolean)true);
            f3 += f2;
            f4 += f2;
        }
        for (FleetMember fleetMember2 : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            if (!fleetMember2.canBeDeployedForCombat()) continue;
            f2 = fleetMember2.getMemberStrength();
            f5 += f2;
        }
        fleetMember2 = new WeightedRandomPicker();
        for (FleetMember fleetMember3 : this.fleet.getMembers()) {
            if (bl && !fleetMember3.isAlly() || !fleetMember3.canBeDeployedForCombat() || fleetMember3.isFighterWing() || !(fleetMember3.getCR() < combatReadinessPlugin.getCriticalMalfunctionThreshold((MutableShipStatsAPI)fleetMember3.getStats()))) continue;
            if (fleetMember3.isCivilian()) {
                fleetMember3.getRepairTracker().setCrashMothballed(true);
                continue;
            }
            fleetMember2.add(fleetMember3, 1.0f);
        }
        boolean bl2 = false;
        while (var9_13 < 10 && f4 > f3 * 0.33f && !fleetMember2.isEmpty()) {
            ++var9_13;
            FleetMemberAPI fleetMemberAPI = (FleetMemberAPI)fleetMember2.pick();
            if (fleetMemberAPI != null) {
                fleetMemberAPI.getRepairTracker().setCrashMothballed(true);
                float f6 = fleetMemberAPI.getMemberStrength();
                f4 -= f6;
            }
            fleetMember2.remove(fleetMemberAPI);
        }
    }

    public boolean wantsToJoin(BattleAPI battleAPI, boolean bl) {
        CampaignFleetAPI campaignFleetAPI22;
        if (this.fleet.getMemoryWithoutUpdate().is("$isTradeFleet", true)) {
            return false;
        }
        BattleAPI.BattleSide battleSide = battleAPI.pickSide((CampaignFleetAPI)this.fleet);
        if (battleSide == BattleAPI.BattleSide.NO_JOIN) {
            return false;
        }
        boolean bl2 = false;
        for (CampaignFleetAPI campaignFleetAPI22 : battleAPI.getSide(battleSide)) {
            ModularFleetAIAPI modularFleetAIAPI;
            if (campaignFleetAPI22 == this.fleet || !(campaignFleetAPI22.getAI() instanceof ModularFleetAIAPI) || !(modularFleetAIAPI = (ModularFleetAIAPI)campaignFleetAPI22.getAI()).getTacticalModule().isStandingDown()) continue;
            bl2 = true;
            break;
        }
        if (battleAPI.isPlayerInvolved() && !battleAPI.isPlayerSide(battleAPI.getSide(battleSide)) && this.fleet.getMemoryWithoutUpdate().is("$cfai_makeNonHostile", true)) {
            return false;
        }
        campaignFleetAPI22 = battleAPI.getPrimary(battleAPI.getSide(battleSide));
        if (!(bl2 == this.isStandingDown() || campaignFleetAPI22 != null && campaignFleetAPI22.isStationMode())) {
            return false;
        }
        CombatReadinessPlugin combatReadinessPlugin = StarfarerSettings.\u00f8\u00d50000();
        boolean bl3 = true;
        for (FleetMemberAPI fleetMemberAPI : this.fleet.getFleetData().getMembers()) {
            if (fleetMemberAPI.isCivilian() || !(fleetMemberAPI.getRepairTracker().getCR() > combatReadinessPlugin.getCriticalMalfunctionThreshold(fleetMemberAPI.getStats()))) continue;
            bl3 = false;
            break;
        }
        if (bl3) {
            return false;
        }
        float f2 = 0.67f;
        float f3 = 2.0f;
        if (bl) {
            BattleAPI.BattleSide battleSide2 = battleAPI.pickSide(Global.getSector().getPlayerFleet());
            if (battleSide == battleSide2) {
                f2 = 0.2f;
                f3 = 2.0f;
            } else {
                f3 = 5.0f;
            }
        }
        boolean bl4 = "reckless".equals(this.fleet.getCommander().getPersonality().getId());
        boolean bl5 = "aggressive".equals(this.fleet.getCommander().getPersonality().getId());
        if (bl5 || bl4 || this.fleet.getFaction().getCustomBoolean("engageWhenEvenStrength")) {
            f2 *= 0.33f;
        }
        boolean bl6 = this.hasEnoughStuffAround((SectorEntityToken)campaignFleetAPI22, f2, true, false, bl, battleAPI);
        boolean bl7 = this.hasEnoughStuffAround((SectorEntityToken)campaignFleetAPI22, f3, false, false, bl, battleAPI);
        if (campaignFleetAPI22 != null && campaignFleetAPI22.isStationMode()) {
            bl6 = true;
            bl7 = false;
        }
        if (battleAPI.isStationInvolved()) {
            bl7 = false;
        }
        if (bl7 || !bl6) {
            return false;
        }
        List list = battleAPI.getSide(battleSide);
        CampaignFleetAPI campaignFleetAPI3 = battleAPI.getPrimary(list);
        List list2 = battleAPI.getOtherSide(battleSide);
        if (campaignFleetAPI3.getFaction() == this.fleet.getFaction()) {
            return true;
        }
        if (this.fleet.isFriendlyTo((SectorEntityToken)campaignFleetAPI3)) {
            return true;
        }
        return this.fleet.getMemoryWithoutUpdate().is("$isPatrol", true);
    }

    public TimeoutTrackerMap<String, CampaignFleetAIAPI.EncounterOption> getOptionCache() {
        if (this.optionCache == null) {
            this.optionCache = new TimeoutTrackerMap();
        }
        return this.optionCache;
    }

    public CampaignFleetAIAPI.EncounterOption pickEncounterOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        return this.pickEncounterOption(fleetEncounterContextPlugin, campaignFleetAPI, false);
    }

    public CampaignFleetAIAPI.EncounterOption pickEncounterOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI, boolean bl) {
        float f2;
        FleetMember fleetMember2;
        float f3;
        boolean bl2 = Misc.isPlayerOrCombinedPlayerPrimary((CampaignFleetAPI)campaignFleetAPI);
        boolean bl3 = false;
        if (!bl && bl2) {
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeAggressive", true) && !this.allNonPlayerShipsAreMothballed()) {
                return CampaignFleetAIAPI.EncounterOption.ENGAGE;
            }
            if (this.fleet.getMemoryWithoutUpdate().is("$cfai_holdVsStronger", true) && !this.allNonPlayerShipsAreMothballed()) {
                bl3 = true;
            }
            if (fleetEncounterContextPlugin != null && this.fleet.getMemoryWithoutUpdate().is("$cfai_makePreventDisengage", true) && !this.allNonPlayerShipsAreMothballed()) {
                return CampaignFleetAIAPI.EncounterOption.ENGAGE;
            }
        }
        if (!bl && Misc.isTrader((CampaignFleetAPI)this.fleet) && Misc.isTrader((CampaignFleetAPI)campaignFleetAPI)) {
            return CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER;
        }
        TimeoutTrackerMap<String, CampaignFleetAIAPI.EncounterOption> timeoutTrackerMap = this.getOptionCache();
        String string = campaignFleetAPI.getId();
        float f4 = 0.3f;
        if (fleetEncounterContextPlugin == null && timeoutTrackerMap.contains((Object)string) && !bl2 && this.fleet.getBattle() == null && (f3 = Misc.getDistance((Vector2f)this.fleet.getLocation(), (Vector2f)campaignFleetAPI.getLocation()) + this.fleet.getRadius() + campaignFleetAPI.getRadius()) > 300.0f && this.fleet.getContainingLocation() == campaignFleetAPI.getContainingLocation()) {
            return (CampaignFleetAIAPI.EncounterOption)timeoutTrackerMap.getItem((Object)string);
        }
        boolean bl4 = this.allNonPlayerShipsAreCiv();
        if (bl4) {
            CampaignFleetAIAPI.EncounterOption encounterOption = CampaignFleetAIAPI.EncounterOption.DISENGAGE;
            if (bl3) {
                encounterOption = CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER;
            }
            timeoutTrackerMap.add((Object)string, (Object)encounterOption, f4, f4);
            return encounterOption;
        }
        if (fleetEncounterContextPlugin != null && fleetEncounterContextPlugin.getBattle() != null) {
            boolean bl5 = false;
            for (CampaignFleetAIAPI.EncounterOption encounterOption : fleetEncounterContextPlugin.getBattle().getSideFor((CampaignFleetAPI)this.fleet)) {
                bl5 |= encounterOption.isStationMode();
            }
            if (bl5) {
                CampaignFleetAIAPI.EncounterOption encounterOption;
                encounterOption = CampaignFleetAIAPI.EncounterOption.ENGAGE;
                timeoutTrackerMap.add((Object)string, (Object)encounterOption, f4, f4);
                return encounterOption;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        CombatReadinessPlugin combatReadinessPlugin = StarfarerSettings.\u00f8\u00d50000();
        boolean bl6 = true;
        boolean bl7 = true;
        float f8 = 0.0f;
        float f9 = 0.0f;
        for (FleetMember fleetMember2 : this.fleet.getMembers()) {
            float f10;
            if (!fleetMember2.canBeDeployedForCombat()) continue;
            if (!fleetMember2.isCivilian()) {
                bl6 = false;
                f8 += (float)fleetMember2.getFleetPointCost();
            }
            f2 = Misc.getMemberStrength((FleetMemberAPI)fleetMember2, (boolean)true, (boolean)true, (boolean)true);
            f5 += f2;
            float f11 = fleetMember2.getRepairTracker().getCR();
            if (f11 < (f10 = fleetMember2.getDeployCost()) + combatReadinessPlugin.getCriticalMalfunctionThreshold((MutableShipStatsAPI)fleetMember2.getStats())) {
                f7 += f2;
            }
            if (fleetMember2.isFighterWing() && !(f11 > 0.1f)) continue;
            bl7 = false;
        }
        for (FleetMember fleetMember2 : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            if (!fleetMember2.canBeDeployedForCombat()) continue;
            if (!fleetMember2.isCivilian()) {
                f9 += (float)fleetMember2.getFleetPointCost();
            }
            f2 = Misc.getMemberStrength((FleetMemberAPI)fleetMember2, (boolean)true, (boolean)true, (boolean)false);
            f6 += f2;
        }
        if (f5 > f6 * 1.25f && !bl7 && !bl6 && !this.fleet.getMemoryWithoutUpdate().is("$cfai_makeAllowDisengage", true)) {
            fleetMember2 = CampaignFleetAIAPI.EncounterOption.ENGAGE;
            timeoutTrackerMap.add((Object)string, (Object)fleetMember2, f4, f4);
            return fleetMember2;
        }
        if (f7 > f5 * 0.4f && !bl6 && !bl7 && this.fleet.getFleetData().getBurnLevel() < campaignFleetAPI.getFleetData().getBurnLevel()) {
            fleetMember2 = CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER;
            timeoutTrackerMap.add((Object)string, (Object)fleetMember2, f4, f4);
            return fleetMember2;
        }
        boolean bl8 = "reckless".equals(this.fleet.getCommander().getPersonality().getId());
        boolean bl9 = "aggressive".equals(this.fleet.getCommander().getPersonality().getId());
        f2 = 0.5f;
        if (bl8) {
            f2 = 0.25f;
        }
        if (bl9) {
            f2 = 0.33f;
        }
        if (f5 <= f6 * f2 || f5 <= 0.0f) {
            CampaignFleetAIAPI.EncounterOption encounterOption = CampaignFleetAIAPI.EncounterOption.DISENGAGE;
            if (bl3) {
                encounterOption = CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER;
            }
            timeoutTrackerMap.add((Object)string, (Object)encounterOption, f4, f4);
            return encounterOption;
        }
        f2 = 0.75f;
        if (f5 <= f6 * f2 || f5 <= 0.0f) {
            CampaignFleetAIAPI.EncounterOption encounterOption = CampaignFleetAIAPI.EncounterOption.HOLD;
            if (bl2 && f8 * 1.5f > f9 && f9 <= 50.0f) {
                encounterOption = CampaignFleetAIAPI.EncounterOption.ENGAGE;
            }
            timeoutTrackerMap.add((Object)string, (Object)encounterOption, f4, f4);
            return encounterOption;
        }
        boolean bl10 = "steady".equals(this.fleet.getCommander().getPersonality().getId());
        boolean bl11 = "cautious".equals(this.fleet.getCommander().getPersonality().getId());
        boolean bl12 = "timid".equals(this.fleet.getCommander().getPersonality().getId());
        if (this.fleet.getFaction().getCustomBoolean("engageWhenEvenStrength")) {
            CampaignFleetAIAPI.EncounterOption encounterOption = CampaignFleetAIAPI.EncounterOption.ENGAGE;
            timeoutTrackerMap.add((Object)string, (Object)encounterOption, f4, f4);
            return encounterOption;
        }
        if ((bl9 || bl8) && !bl7) {
            CampaignFleetAIAPI.EncounterOption encounterOption = CampaignFleetAIAPI.EncounterOption.ENGAGE;
            timeoutTrackerMap.add((Object)string, (Object)encounterOption, f4, f4);
            return encounterOption;
        }
        if ((bl12 || bl11) && this.fleet.getBattle() == null) {
            CampaignFleetAIAPI.EncounterOption encounterOption = CampaignFleetAIAPI.EncounterOption.DISENGAGE;
            if (bl3) {
                encounterOption = CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER;
            }
            timeoutTrackerMap.add((Object)string, (Object)encounterOption, f4, f4);
            return encounterOption;
        }
        CampaignFleetAIAPI.EncounterOption encounterOption = CampaignFleetAIAPI.EncounterOption.HOLD;
        timeoutTrackerMap.add((Object)string, (Object)encounterOption, f4, f4);
        return encounterOption;
    }

    protected boolean allNonPlayerShipsAreCiv() {
        boolean bl = false;
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            if (!fleetMember.isAlly()) continue;
            bl = true;
            break;
        }
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            if (bl != fleetMember.isAlly() || !fleetMember.canBeDeployedForCombat() || fleetMember.isCivilian()) continue;
            return false;
        }
        return true;
    }

    protected boolean allNonPlayerShipsAreMothballed() {
        boolean bl = false;
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            if (!fleetMember.isAlly()) continue;
            bl = true;
            break;
        }
        for (FleetMember fleetMember : this.fleet.getMembers()) {
            if (bl != fleetMember.isAlly() || fleetMember.isMothballed()) continue;
            return false;
        }
        return true;
    }

    public CampaignFleetAIAPI.PursuitOption pickPursuitOption(FleetEncounterContextPlugin fleetEncounterContextPlugin, CampaignFleetAPI campaignFleetAPI) {
        float f2;
        if (Misc.isPlayerOrCombinedPlayerPrimary((CampaignFleetAPI)campaignFleetAPI) && this.fleet.getMemoryWithoutUpdate().is("$cfai_makeAlwaysPursue", true)) {
            return CampaignFleetAIAPI.PursuitOption.PURSUE;
        }
        if (!this.isHostileTo(campaignFleetAPI) && !fleetEncounterContextPlugin.isEngagedInHostilities()) {
            if (Misc.isPlayerOrCombinedPlayerPrimary((CampaignFleetAPI)campaignFleetAPI) && this.fleet.getMemoryWithoutUpdate().is("$cfai_makePreventDisengage", true)) {
                return CampaignFleetAIAPI.PursuitOption.HARRY;
            }
            return CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
        }
        if (this.fleet.getMemoryWithoutUpdate().is("$cfai_makeAllowDisengage", true)) {
            return CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
        }
        if (this.allNonPlayerShipsAreCiv()) {
            return CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
        }
        FleetEncounterContextPlugin.PursueAvailability pursueAvailability = fleetEncounterContextPlugin.getPursuitAvailability((CampaignFleetAPI)this.fleet, campaignFleetAPI);
        FleetEncounterContextPlugin.DisengageHarryAvailability disengageHarryAvailability = fleetEncounterContextPlugin.getDisengageHarryAvailability((CampaignFleetAPI)this.fleet, campaignFleetAPI);
        if (pursueAvailability != FleetEncounterContextPlugin.PursueAvailability.AVAILABLE && disengageHarryAvailability != FleetEncounterContextPlugin.DisengageHarryAvailability.AVAILABLE) {
            return CampaignFleetAIAPI.PursuitOption.LET_THEM_GO;
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (FleetMemberAPI fleetMemberAPI : this.fleet.getMembers()) {
            if (fleetMemberAPI.isStation() || !fleetMemberAPI.canBeDeployedForCombat()) continue;
            f2 = Misc.getMemberStrength((FleetMemberAPI)fleetMemberAPI, (boolean)true, (boolean)true, (boolean)true);
            f3 += f2;
        }
        for (FleetMemberAPI fleetMemberAPI : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            if (!fleetMemberAPI.canBeDeployedForCombat()) continue;
            f4 += (float)fleetMemberAPI.getFleetPointCost();
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        if (f4 < 1.0f) {
            f4 = 1.0f;
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        for (FleetMemberAPI fleetMemberAPI : this.fleet.getMembers()) {
            if (!fleetMemberAPI.canBeDeployedForCombat()) continue;
            f6 += fleetMemberAPI.getRepairTracker().getCR() * (float)fleetMemberAPI.getFleetPointCost();
            f5 = fleetMemberAPI.getFleetPointCost();
        }
        f2 = 0.0f;
        float f7 = 0.0f;
        for (FleetMemberAPI fleetMemberAPI : campaignFleetAPI.getFleetData().getMembersListCopy()) {
            if (!fleetMemberAPI.canBeDeployedForCombat()) continue;
            f7 += fleetMemberAPI.getRepairTracker().getCR() * (float)fleetMemberAPI.getFleetPointCost();
            f2 = fleetMemberAPI.getFleetPointCost();
        }
        if (pursueAvailability == FleetEncounterContextPlugin.PursueAvailability.AVAILABLE && f3 > f4 * 0.75f && (f6 / f3 > f7 / f2 || f6 > f5 * 0.35f)) {
            boolean bl = Misc.isPlayerOrCombinedContainingPlayer((CampaignFleetAPI)campaignFleetAPI);
            if (f3 > f4 * 10.0f && !bl) {
                return CampaignFleetAIAPI.PursuitOption.HARRY;
            }
            if (bl) {
                float f8 = 0.0f;
                for (FleetMemberAPI fleetMemberAPI : this.fleet.getMembers()) {
                    float f9;
                    if (fleetMemberAPI.isCivilian() || fleetMemberAPI.isCarrier() || !((f9 = Utils.o00000((FleetMember)fleetMemberAPI, true)) > f8)) continue;
                    f8 = f9;
                }
                float f10 = Float.MAX_VALUE;
                for (FleetMemberAPI fleetMemberAPI : ((CampaignFleet)campaignFleetAPI).getMembers()) {
                    float f11 = Utils.o00000((FleetMember)fleetMemberAPI, false);
                    if (!(f11 < f10)) continue;
                    f10 = f11;
                }
                if (f10 + 30.0f > f8) {
                    return CampaignFleetAIAPI.PursuitOption.HARRY;
                }
            }
            return CampaignFleetAIAPI.PursuitOption.PURSUE;
        }
        return CampaignFleetAIAPI.PursuitOption.HARRY;
    }

    public CampaignFleetAIAPI.BoardingActionDecision makeBoardingDecision(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CrewCompositionAPI crewCompositionAPI) {
        return null;
    }

    public CampaignFleetAIAPI.InitialBoardingResponse pickBoardingResponse(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CampaignFleetAPI campaignFleetAPI) {
        if ((float)Math.random() > 0.95f) {
            return CampaignFleetAIAPI.InitialBoardingResponse.LET_IT_GO;
        }
        return CampaignFleetAIAPI.InitialBoardingResponse.ENGAGE;
    }

    public List<FleetMemberAPI> pickBoardingTaskForce(FleetEncounterContextPlugin fleetEncounterContextPlugin, FleetMemberAPI fleetMemberAPI, CampaignFleetAPI campaignFleetAPI) {
        return null;
    }

    public void reportNearbyAction(CampaignFleetAIAPI.ActionType actionType, SectorEntityToken sectorEntityToken, SectorEntityToken sectorEntityToken2, String string) {
        SectorEntityToken.VisibilityLevel visibilityLevel = sectorEntityToken.getVisibilityLevelTo((SectorEntityToken)this.fleet);
        if (visibilityLevel == SectorEntityToken.VisibilityLevel.NONE) {
            return;
        }
        if (actionType == CampaignFleetAIAPI.ActionType.HOSTILE) {
            if (this.fleet.getMemoryWithoutUpdate().is("$core_fleetBusy", true)) {
                return;
            }
            if (this.isAlreadyIntercepting()) {
                return;
            }
            boolean bl = this.fleet.getFaction().isAtWorst(sectorEntityToken2.getFaction(), RepLevel.COOPERATIVE);
            if (!(bl &= !this.fleet.getMemoryWithoutUpdate().is("$isTradeFleet", true))) {
                return;
            }
            CampaignFleetAIAPI.EncounterOption encounterOption = this.pickEncounterOption(null, (CampaignFleetAPI)sectorEntityToken);
            if (encounterOption == CampaignFleetAIAPI.EncounterOption.ENGAGE || encounterOption == CampaignFleetAIAPI.EncounterOption.HOLD) {
                this.fleet.getMemoryWithoutUpdate().set(string, (Object)true, 10.0f);
                Misc.setFlagWithReason((MemoryAPI)this.fleet.getMemoryWithoutUpdate(), (String)"$core_fleetBusy", (String)string.substring(1), (boolean)true, (float)5.0f);
                this.ai.getAssignmentModule().addAssignmentAtStart(FleetAssignment.INTERCEPT, sectorEntityToken, 10.0f, null);
                this.fleet.getMemoryWithoutUpdate().set("$ai_lastSeenTargetLoc", (Object)new Vector2f((ReadableVector2f)Global.getSector().getPlayerFleet().getLocation()), 10.0f);
                Global.getSector().addPing((SectorEntityToken)this.fleet, "danger");
            }
        } else if (actionType == CampaignFleetAIAPI.ActionType.CANCEL && this.fleet.getMemoryWithoutUpdate().is(string, true)) {
            this.fleet.getMemoryWithoutUpdate().unset(string);
            Misc.setFlagWithReason((MemoryAPI)this.fleet.getMemoryWithoutUpdate(), (String)"$core_fleetBusy", (String)string.substring(1), (boolean)false, (float)0.0f);
            this.ai.getAssignmentModule().removeFirstAssignmentIfItIs(FleetAssignment.INTERCEPT);
            this.ai.getTacticalModule().setPriorityTarget(null, 0.0f, false);
            this.ai.getTacticalModule().setTarget(null);
            this.fleet.setInteractionTarget(null);
        }
    }

    private boolean isAlreadyIntercepting() {
        return this.ai.getAssignmentModule().isCurrentAssignment(FleetAssignment.INTERCEPT);
    }

    public void notifyInteractedWith(CampaignFleetAPI campaignFleetAPI) {
        if (this.isAlreadyIntercepting()) {
            this.ai.getAssignmentModule().removeFirstAssignment();
        }
    }

    public boolean isStandingDown() {
        CampaignFleetAI.FleetAssignmentData fleetAssignmentData = (CampaignFleetAI.FleetAssignmentData)this.ai.getAssignmentModule().getCurrentAssignment();
        return fleetAssignmentData != null && fleetAssignmentData.getAssignment() == FleetAssignment.STANDING_DOWN;
    }

    public float getPursuitDays() {
        return this.pursuitDays;
    }

    private static enum o {
        o00000,
        Object,
        \u00d400000;

    }
}

