/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ;

import com.fs.starfarer.api.campaign.econ.PriceVariability;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.util.DoNotObfuscate;

public class PriceCalculator
implements DoNotObfuscate {
    public static int MIN_DEMAND_FOR_PRICING = Economy.MIN_DEMAND_FOR_PRICING;
    public static int MIN_STOCKPILE_FOR_PRICING = Economy.MIN_STOCKPILE_FOR_PRICING;
    public static float IMPACT_MULT = 5.0f;
    public static float MIN_FRACTION = 0.25f;
    private double B = 1.0;
    private double D = MIN_DEMAND_FOR_PRICING;
    private double v = 1.6f;
    private boolean needsUpdate = true;
    private double mult;
    private float lowPriceThreshold = -1.0f;
    private float lowPriceMult = 1.0f;
    private float highPriceThreshold = -1.0f;
    private float highPriceMult = 1.0f;

    public PriceCalculator() {
        this.setVariability(PriceVariability.V4);
    }

    public void setBasePrice(float f2) {
        this.B = f2;
        this.needsUpdate = true;
    }

    public void setDemand(float f2) {
        this.D = f2 += (float)MIN_DEMAND_FOR_PRICING;
        this.needsUpdate = true;
    }

    public double getD() {
        return this.D;
    }

    public void setVariability(PriceVariability priceVariability) {
        this.v = priceVariability.v;
        this.needsUpdate = true;
    }

    private void update() {
        this.mult = this.B * Math.pow(this.D + this.D + 1.0, this.v);
        this.needsUpdate = false;
    }

    public float getPrice(double d2) {
        return this.getRemovePrice(d2, 1.0);
    }

    public float getAddPrice(double d2, double d3) {
        return this.getPrice(d2 += (double)MIN_STOCKPILE_FOR_PRICING, d2 + d3);
    }

    public float getRemovePrice(double d2, double d3) {
        return this.getPrice((d2 += (double)MIN_STOCKPILE_FOR_PRICING) - d3, d2);
    }

    private float getPrice(double d2, double d3) {
        float f2 = this.highPriceThreshold + (float)MIN_STOCKPILE_FOR_PRICING;
        float f3 = this.lowPriceThreshold + (float)MIN_STOCKPILE_FOR_PRICING;
        float f4 = 0.0f;
        if (f2 >= (float)MIN_STOCKPILE_FOR_PRICING && d2 < (double)f2) {
            f4 += this.getPriceInner(d2, Math.min(d3, (double)f2)) * this.highPriceMult;
            d2 = Math.min(d3, (double)f2);
        }
        if (f3 >= (float)MIN_STOCKPILE_FOR_PRICING && d3 > (double)f3) {
            f4 += this.getPriceInner(Math.max(d2, (double)f3), d3) * this.lowPriceMult;
            d3 = Math.max(d2, (double)f3);
        }
        if ((f4 += this.getPriceInner(d2, d3)) <= 0.0f) {
            f4 = 0.0f;
        }
        return f4;
    }

    private float getPriceInner(double d2, double d3) {
        if (this.needsUpdate) {
            this.update();
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        double d4 = d2;
        double d5 = d3;
        double d6 = Math.pow(d4 + this.D + 1.0, 1.0 - this.v);
        double d7 = Math.pow(d5 + this.D + 1.0, 1.0 - this.v);
        float f2 = (float)(this.mult * (d7 - d6) / (1.0 - this.v));
        if (f2 <= 0.0f) {
            f2 = 0.0f;
        }
        return f2;
    }

    public static void main(String[] stringArray) {
        PriceCalculator priceCalculator = new PriceCalculator();
        priceCalculator.setBasePrice(50.0f);
        priceCalculator.setDemand(100.0f);
        priceCalculator.setVariability(PriceVariability.V5);
        priceCalculator.update();
        System.out.println("300 to 500: " + priceCalculator.getPrice(300.0, 500.0));
        priceCalculator.setHighPriceThreshold(600.0f);
        priceCalculator.setHighPriceMult(2.0f);
        System.out.println("300 to 500: " + priceCalculator.getPrice(300.0, 500.0));
    }

    public float getLowPriceThreshold() {
        return this.lowPriceThreshold;
    }

    public void setLowPriceThreshold(float f2) {
        this.lowPriceThreshold = f2;
    }

    public float getLowPriceMult() {
        return this.lowPriceMult;
    }

    public void setLowPriceMult(float f2) {
        this.lowPriceMult = f2;
    }

    public float getHighPriceThreshold() {
        return this.highPriceThreshold;
    }

    public void setHighPriceThreshold(float f2) {
        this.highPriceThreshold = f2;
    }

    public float getHighPriceMult() {
        return this.highPriceMult;
    }

    public void setHighPriceMult(float f2) {
        this.highPriceMult = f2;
    }
}

