/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.graphics.Object;
import com.fs.graphics.oOoO;
import com.fs.graphics.util.B;
import com.fs.starfarer.combat.entities.ContrailEngine;
import com.fs.starfarer.loading.specs.EngineSlot;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import com.fs.util.oOOO;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ContrailEngineV2
implements DoNotObfuscate {
    private static final float THRESHOLD = 0.5f;
    private static final float FULL_BRIGHTNESS_LENGTH = 50.0f;
    private Map<java.lang.Object, Contrail> contrails = new HashMap<java.lang.Object, Contrail>();

    public void initContrail(java.lang.Object object, Color color, float f2, float f3, float f4, float f5, float f6, ContrailEngine.ContrailWidthMode contrailWidthMode, EngineSlot.BlendMode blendMode, boolean bl) {
        Contrail contrail = new Contrail();
        contrail.source = object;
        contrail.tex = oOoO.new((String)"graphics/fx/contrail64b.png");
        contrail.blendMode = blendMode;
        contrail.color = color;
        contrail.width = f2;
        contrail.minSegLength = f4;
        contrail.maxSegLength = f5;
        contrail.duration = f3;
        contrail.mode = contrailWidthMode;
        contrail.widthMultiplier = f6;
        contrail.autoCleanup = bl;
        this.contrails.put(object, contrail);
    }

    public void updateContrail(java.lang.Object object, Color color, float f2, float f3, float f4, float f5, float f6, ContrailEngine.ContrailWidthMode contrailWidthMode, EngineSlot.BlendMode blendMode) {
        Contrail contrail = this.contrails.get(object);
        if (contrail == null) {
            return;
        }
        contrail.source = object;
        contrail.blendMode = blendMode;
        contrail.color = color;
        contrail.width = f2;
        contrail.minSegLength = f4;
        contrail.maxSegLength = f5;
        contrail.duration = f3;
        contrail.mode = contrailWidthMode;
        contrail.widthMultiplier = f6;
    }

    public void removeContrail(java.lang.Object object) {
        Contrail contrail = this.contrails.get(object);
        if (contrail == null) {
            return;
        }
        contrail.remove = true;
        this.terminateContrail(object);
    }

    public void terminateContrail(java.lang.Object object) {
        Contrail contrail = this.contrails.get(object);
        if (contrail == null) {
            return;
        }
        if (contrail.points.size() >= 2) {
            ContrailPoint contrailPoint = contrail.points.get(contrail.points.size() - 1);
            ContrailPoint contrailPoint2 = contrail.points.get(contrail.points.size() - 2);
            Vector2f vector2f = new Vector2f((ReadableVector2f)contrailPoint2.dirToNext);
            vector2f.scale(20.0f);
            Vector2f.add((Vector2f)vector2f, (Vector2f)contrailPoint.point, (Vector2f)vector2f);
            this.addPoint(contrail.source, vector2f, contrailPoint.vel, 0.0f);
        }
    }

    public boolean hasContrail(java.lang.Object object) {
        return this.contrails.get(object) != null;
    }

    public Map<java.lang.Object, Contrail> getContrails() {
        return this.contrails;
    }

    public void addPoint(java.lang.Object object, Vector2f vector2f, Vector2f vector2f2, float f2) {
        ContrailPoint contrailPoint;
        Contrail contrail = this.contrails.get(object);
        if (contrail == null) {
            return;
        }
        if (!contrail.points.isEmpty()) {
            contrailPoint = contrail.points.get(contrail.points.size() - 1);
            float f3 = Utils.\u00d600000(contrailPoint.point, vector2f);
            if (f3 < contrail.minSegLength * contrail.minSegLength) {
                return;
            }
        }
        contrailPoint = null;
        if (contrail.lastPoint != null) {
            contrailPoint = new Vector2f((ReadableVector2f)contrail.lastPoint);
        }
        contrail.lastPoint = new Vector2f((ReadableVector2f)vector2f);
        ContrailPoint contrailPoint2 = new ContrailPoint();
        contrailPoint2.point = new Vector2f((ReadableVector2f)vector2f);
        contrailPoint2.width = contrail.width;
        contrailPoint2.maxWidth = contrail.width;
        contrailPoint2.maxBrightness = f2;
        contrailPoint2.vel = vector2f2;
        contrailPoint2.duration = contrail.duration;
        if (contrail.points.isEmpty()) {
            contrailPoint2.perp = new Vector2f(0.0f, 1.0f);
            contrailPoint2.maxBrightness = 0.0f;
            contrailPoint2.distToPrev = 0.0f;
            contrailPoint2.texCoord = 0.0f;
            contrail.addPoint(contrailPoint2);
        } else if (contrail.points.size() == 1) {
            ContrailPoint contrailPoint3 = contrail.points.get(contrail.points.size() - 1);
            Vector2f vector2f3 = Vector2f.sub((Vector2f)vector2f, (Vector2f)contrailPoint3.point, (Vector2f)new Vector2f());
            contrailPoint2.distToPrev = vector2f3.length();
            Utils.o00000(vector2f3);
            Vector2f vector2f4 = Utils.\u00d400000(vector2f3);
            contrailPoint3.dirToNext = vector2f3;
            contrailPoint2.perp = vector2f4;
            contrailPoint2.texCoord = contrailPoint3.texCoord + contrailPoint2.distToPrev / 256.0f;
            contrailPoint2.maxBrightness = 0.0f;
            contrail.addPoint(contrailPoint2);
        } else {
            ContrailPoint contrailPoint4 = contrail.points.get(contrail.points.size() - 1);
            ContrailPoint contrailPoint5 = contrail.points.get(contrail.points.size() - 2);
            float f4 = Utils.\u00d800000(contrailPoint4.point, vector2f);
            if (f4 < contrail.minSegLength) {
                return;
            }
            Vector2f vector2f5 = new Vector2f((ReadableVector2f)contrailPoint4.point);
            vector2f5.x += f4 * contrailPoint5.dirToNext.x;
            vector2f5.y += f4 * contrailPoint5.dirToNext.y;
            float f5 = Utils.\u00d800000(contrailPoint5.point, contrailPoint4.point);
            float f6 = Utils.\u00d800000(contrailPoint2.point, contrailPoint4.point);
            if (!(f5 > contrail.maxSegLength)) {
                Utils.\u00d800000(vector2f5, contrailPoint2.point);
            }
            Vector2f vector2f6 = Vector2f.sub((Vector2f)contrailPoint2.point, (Vector2f)contrailPoint4.point, (Vector2f)new Vector2f());
            contrailPoint2.distToPrev = vector2f6.length();
            Utils.o00000(vector2f6);
            Vector2f vector2f7 = Utils.\u00d400000(vector2f6);
            contrailPoint4.dirToNext = vector2f6;
            contrailPoint2.perp = vector2f7;
            contrailPoint2.texCoord = contrailPoint4.texCoord + contrailPoint2.distToPrev / 256.0f;
            if (f6 > contrail.maxSegLength) {
                ContrailPoint contrailPoint6;
                if (contrailPoint != null) {
                    contrailPoint6 = new ContrailPoint();
                    contrailPoint6.point = new Vector2f((ReadableVector2f)contrailPoint);
                    contrailPoint6.width = contrailPoint4.width * 0.5f;
                    contrailPoint6.maxWidth = contrailPoint4.width * 0.5f;
                    contrailPoint6.maxBrightness = 0.0f;
                    contrailPoint6.vel = new Vector2f((ReadableVector2f)contrailPoint4.vel);
                    contrailPoint6.duration = contrailPoint4.duration;
                    contrailPoint6.distToPrev = 0.0f;
                    contrailPoint6.perp = new Vector2f((ReadableVector2f)contrailPoint4.perp);
                    contrailPoint6.dirToNext = new Vector2f((ReadableVector2f)contrailPoint4.dirToNext);
                    contrailPoint6.texCoord = contrailPoint4.texCoord;
                    contrail.addPoint(contrailPoint6);
                }
                contrailPoint6 = new ContrailPoint();
                contrailPoint6.point = new Vector2f((ReadableVector2f)vector2f);
                contrailPoint6.width = contrail.width;
                contrailPoint6.maxWidth = contrail.width;
                contrailPoint6.maxBrightness = 0.0f;
                contrailPoint6.vel = new Vector2f((ReadableVector2f)contrailPoint4.vel);
                contrailPoint6.duration = contrail.duration;
                contrailPoint6.distToPrev = 0.0f;
                contrailPoint6.perp = new Vector2f((ReadableVector2f)vector2f7);
                contrailPoint6.dirToNext = new Vector2f((ReadableVector2f)contrailPoint4.dirToNext);
                contrail.addPoint(contrailPoint6);
            }
            contrail.addPoint(contrailPoint2);
        }
    }

    public void advance(float f2) {
        ArrayList<java.lang.Object> arrayList = new ArrayList<java.lang.Object>();
        for (Contrail contrail : this.contrails.values()) {
            float f3 = f2 * 0.25f;
            float f4 = 0.0f;
            for (ContrailPoint contrailPoint : contrail.points) {
                f4 += 1.0f;
                contrailPoint.elapsed += f2;
                if (contrail.remove) {
                    contrailPoint.elapsed += f2 / 3.0f;
                }
                if (contrailPoint.elapsed > contrailPoint.duration) {
                    contrailPoint.elapsed = contrailPoint.duration;
                }
                contrailPoint.progress = contrailPoint.elapsed / contrailPoint.duration;
                if (contrailPoint.fadeOut) {
                    contrailPoint.maxBrightness -= f2 * 2.0f;
                    if (contrailPoint.maxBrightness < 0.0f) {
                        contrailPoint.maxBrightness = 0.0f;
                    }
                }
                if (contrail.mode == ContrailEngine.ContrailWidthMode.WIDEN) {
                    contrailPoint.width = contrailPoint.maxWidth * (contrailPoint.progress * contrail.widthMultiplier + 1.0f);
                } else if (contrail.mode == ContrailEngine.ContrailWidthMode.NARROW) {
                    contrailPoint.width = contrailPoint.maxWidth * (0.25f + (1.0f - contrailPoint.progress) * 0.75f);
                }
                if (contrail.remove) continue;
                contrailPoint.point.x += contrailPoint.vel.x * f2;
                contrailPoint.point.y += contrailPoint.vel.y * f2;
            }
            if (contrail.points.size() >= 3) {
                while (contrail.points.size() >= 3 && contrail.removeFirstIfNecessary()) {
                }
            }
            if (!contrail.remove && !contrail.autoCleanup || contrail.points.size() >= 3) continue;
            boolean bl = true;
            for (ContrailPoint contrailPoint : contrail.points) {
                if (!(contrailPoint.elapsed < contrailPoint.duration)) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(contrail.source);
        }
        for (Contrail contrail : arrayList) {
            this.contrails.remove(contrail);
        }
    }

    public void render() {
        this.render(1.0f);
    }

    public void render(float f2) {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        int n2 = 0;
        boolean bl = false;
        ContrailPoint contrailPoint = null;
        for (Contrail contrail : this.contrails.values()) {
            if (contrail.blendMode == EngineSlot.BlendMode.GLOW) {
                GL11.glBlendFunc((int)770, (int)1);
            } else {
                GL11.glBlendFunc((int)770, (int)771);
            }
            n2 += contrail.points.size();
            if (contrail.points.size() > 1) {
                if (!bl) {
                    contrail.tex.\u00d800000();
                    bl = true;
                }
                GL11.glBegin((int)8);
                ContrailPoint contrailPoint2 = null;
                java.lang.Object object = null;
                float f3 = 0.0f;
                for (ContrailPoint contrailPoint3 : contrail.points) {
                    object = (float)contrail.points.size() > f3 ? contrail.points.get((int)(f3 += 1.0f)) : null;
                    float f4 = 0.0f;
                    float f5 = 0.1f;
                    float f6 = contrailPoint3.elapsed;
                    if (f6 > contrailPoint3.elapsedWhenFadeOut) {
                        f6 = contrailPoint3.elapsedWhenFadeOut;
                    }
                    if (f5 > contrailPoint3.duration / 2.0f) {
                        f5 = contrailPoint3.duration / 2.0f;
                    }
                    if ((f4 = f6 < f5 ? f6 / f5 : (contrailPoint3.duration - f6) / (contrailPoint3.duration - f5)) > 1.0f) {
                        f4 = 1.0f;
                    }
                    f4 *= f2;
                    Color color = contrail.color;
                    if (object != null) {
                        Vector2f vector2f = new Vector2f((ReadableVector2f)contrailPoint3.perp);
                        vector2f.scale(contrailPoint3.width / 2.0f * 1.5f);
                        Vector2f vector2f2 = Vector2f.add((Vector2f)contrailPoint3.point, (Vector2f)vector2f, (Vector2f)new Vector2f());
                        vector2f = Vector2f.sub((Vector2f)contrailPoint3.point, (Vector2f)vector2f, (Vector2f)vector2f);
                        Vector2f vector2f3 = new Vector2f((ReadableVector2f)((ContrailPoint)object).perp);
                        vector2f3.scale(((ContrailPoint)object).width / 2.0f * 1.5f);
                        Vector2f vector2f4 = Vector2f.add((Vector2f)((ContrailPoint)object).point, (Vector2f)vector2f3, (Vector2f)new Vector2f());
                        vector2f3 = Vector2f.sub((Vector2f)((ContrailPoint)object).point, (Vector2f)vector2f3, (Vector2f)vector2f3);
                        Vector2f vector2f5 = oOOO.o00000((Vector2f)vector2f, (Vector2f)vector2f2, (Vector2f)vector2f3, (Vector2f)vector2f4);
                        if (vector2f5 != null) {
                            if (!contrailPoint3.fadeOut) {
                                contrailPoint3.origMax = contrailPoint3.maxBrightness;
                                contrailPoint3.elapsedWhenFadeOut = contrailPoint3.elapsed;
                            }
                            contrailPoint3.fadeOut = true;
                        } else if (contrailPoint2 != null) {
                            Vector2f vector2f6;
                            Vector2f vector2f7;
                            float f7;
                            Vector2f vector2f8 = new Vector2f((ReadableVector2f)contrailPoint2.perp);
                            vector2f8.scale(contrailPoint2.width / 2.0f * 1.5f);
                            Vector2f vector2f9 = Vector2f.add((Vector2f)contrailPoint2.point, (Vector2f)vector2f8, (Vector2f)new Vector2f());
                            vector2f8 = Vector2f.sub((Vector2f)contrailPoint2.point, (Vector2f)vector2f8, (Vector2f)vector2f8);
                            vector2f5 = oOOO.o00000((Vector2f)vector2f, (Vector2f)vector2f2, (Vector2f)vector2f8, (Vector2f)vector2f9);
                            if (vector2f5 != null) {
                                if (!contrailPoint3.fadeOut) {
                                    contrailPoint3.origMax = contrailPoint3.maxBrightness;
                                    contrailPoint3.elapsedWhenFadeOut = contrailPoint3.elapsed;
                                }
                                contrailPoint3.fadeOut = true;
                            }
                            if (f4 > 0.0f && (f7 = Vector2f.dot((Vector2f)(vector2f7 = Vector2f.sub((Vector2f)contrailPoint2.point, (Vector2f)contrailPoint3.point, (Vector2f)new Vector2f())), (Vector2f)(vector2f6 = Vector2f.sub((Vector2f)((ContrailPoint)object).point, (Vector2f)contrailPoint3.point, (Vector2f)new Vector2f())))) > 0.0f) {
                                if (!contrailPoint3.fadeOut) {
                                    contrailPoint3.origMax = contrailPoint3.maxBrightness;
                                    contrailPoint3.elapsedWhenFadeOut = contrailPoint3.elapsed;
                                }
                                contrailPoint3.fadeOut = true;
                            }
                        }
                    }
                    if (f3 == 1.0f) {
                        f4 = 0.0f;
                    }
                    if (contrailPoint3.fadeOut) {
                        contrailPoint = contrailPoint3;
                    }
                    if (contrailPoint != null) {
                        float f8;
                        float f9 = Utils.\u00d800000(contrailPoint3.point, contrailPoint.point);
                        float f10 = 50.0f;
                        float f11 = 1.0f;
                        if (contrailPoint.origMax > 0.0f) {
                            f11 = 1.0f - contrailPoint.maxBrightness / contrailPoint.origMax;
                        }
                        if ((f8 = 1.0f - f11 + f11 * Math.min(1.0f, f9 / f10)) > contrailPoint3.lastProximityMult) {
                            f8 = contrailPoint3.lastProximityMult;
                        }
                        contrailPoint3.lastProximityMult = f8;
                        f4 *= f8;
                    }
                    B.o00000((Color)color, (int)((int)((float)color.getAlpha() * contrailPoint3.maxBrightness * f4)));
                    GL11.glTexCoord2f((float)contrailPoint3.texCoord, (float)0.01f);
                    GL11.glVertex2f((float)(contrailPoint3.point.x - contrailPoint3.perp.x * contrailPoint3.width / 2.0f), (float)(contrailPoint3.point.y - contrailPoint3.perp.y * contrailPoint3.width / 2.0f));
                    GL11.glTexCoord2f((float)contrailPoint3.texCoord, (float)0.99f);
                    GL11.glVertex2f((float)(contrailPoint3.point.x + contrailPoint3.perp.x * contrailPoint3.width / 2.0f), (float)(contrailPoint3.point.y + contrailPoint3.perp.y * contrailPoint3.width / 2.0f));
                    contrailPoint2 = contrailPoint3;
                }
                if (contrail.lastPoint != null && contrailPoint2 != null) {
                    B.new((Color)contrail.color, (float)0.0f);
                    GL11.glTexCoord2f((float)contrailPoint2.texCoord, (float)0.01f);
                    GL11.glVertex2f((float)(contrail.lastPoint.x - contrailPoint2.perp.x * contrailPoint2.width / 4.0f), (float)(contrail.lastPoint.y - contrailPoint2.perp.y * contrailPoint2.width / 4.0f));
                    GL11.glTexCoord2f((float)contrailPoint2.texCoord, (float)0.99f);
                    GL11.glVertex2f((float)(contrail.lastPoint.x + contrailPoint2.perp.x * contrailPoint2.width / 4.0f), (float)(contrail.lastPoint.y + contrailPoint2.perp.y * contrailPoint2.width / 4.0f));
                }
                GL11.glEnd();
                continue;
            }
            for (ContrailPoint contrailPoint2 : contrail.points) {
                contrailPoint2.maxBrightness = 0.0f;
            }
        }
    }

    public static void main(String[] stringArray) {
        ContrailEngineV2 contrailEngineV2 = new ContrailEngineV2();
        java.lang.Object object = new java.lang.Object();
        String string = "x_1";
        String string2 = "x_2";
        String string3 = "x_1";
        contrailEngineV2.initContrail(string, Color.black, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ContrailEngine.ContrailWidthMode.WIDEN, EngineSlot.BlendMode.GLOW, true);
        contrailEngineV2.initContrail(string2, Color.black, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ContrailEngine.ContrailWidthMode.WIDEN, EngineSlot.BlendMode.GLOW, true);
        System.out.println(contrailEngineV2.hasContrail(string));
        System.out.println(contrailEngineV2.hasContrail(string2));
        System.out.println(contrailEngineV2.hasContrail(string3));
    }

    public void clear() {
        this.contrails.clear();
    }

    public static class Contrail
    implements DoNotObfuscate {
        public transient Object tex;
        public java.lang.Object source;
        public boolean remove = false;
        public List<ContrailPoint> points = new ArrayList<ContrailPoint>();
        public float totalLength = 0.0f;
        public Vector2f lastPoint;
        public Color color;
        public float width;
        public float duration;
        public float minSegLength;
        public float maxSegLength;
        public float widthMultiplier;
        public ContrailEngine.ContrailWidthMode mode;
        public EngineSlot.BlendMode blendMode;
        public boolean autoCleanup = false;

        java.lang.Object readResolve() {
            this.tex = oOoO.new((String)"graphics/fx/contrail64b.png");
            return this;
        }

        public void addPoint(ContrailPoint contrailPoint) {
            this.totalLength += contrailPoint.distToPrev;
            this.points.add(contrailPoint);
        }

        public boolean removeFirstIfNecessary() {
            ContrailPoint contrailPoint = this.points.get(0);
            ContrailPoint contrailPoint2 = this.points.get(1);
            ContrailPoint contrailPoint3 = this.points.get(2);
            if (contrailPoint.elapsed >= contrailPoint.duration && contrailPoint2.elapsed >= contrailPoint2.duration && contrailPoint3.elapsed >= contrailPoint3.duration) {
                this.points.remove(0);
                this.totalLength -= contrailPoint2.distToPrev;
                contrailPoint2.distToPrev = 0.0f;
                return true;
            }
            contrailPoint.maxBrightness = 0.0f;
            return false;
        }
    }

    public static class ContrailPoint
    implements DoNotObfuscate {
        public Vector2f point;
        public Vector2f dirToNext;
        public Vector2f perp;
        public Vector2f vel;
        public float width;
        public float duration = 3.0f;
        public float maxWidth;
        public float maxBrightness;
        public float elapsed = 0.0f;
        public float progress = 0.0f;
        public float distToPrev;
        public float texCoord = 0.0f;
        public boolean fadeOut = false;
        public float origMax = 1.0f;
        public float lastProximityMult = 1.0f;
        public float elapsedWhenFadeOut = 1000.0f;

        java.lang.Object writeReplace() {
            float f2 = 100.0f;
            this.width = (float)((int)(this.width * f2)) / f2;
            this.duration = (float)((int)(this.duration * f2)) / f2;
            this.maxWidth = (float)((int)(this.maxWidth * f2)) / f2;
            this.maxBrightness = (float)((int)(this.maxBrightness * f2)) / f2;
            this.elapsed = (float)((int)(this.elapsed * f2)) / f2;
            this.progress = (float)((int)(this.progress * f2)) / f2;
            this.distToPrev = (float)((int)(this.distToPrev * f2)) / f2;
            this.origMax = (float)((int)(this.origMax * f2)) / f2;
            this.lastProximityMult = (float)((int)(this.lastProximityMult * f2)) / f2;
            this.elapsedWhenFadeOut = (float)((int)(this.elapsedWhenFadeOut * f2)) / f2;
            this.point.x = (float)((int)(this.point.x * f2)) / f2;
            this.point.y = (float)((int)(this.point.y * f2)) / f2;
            if (this.dirToNext != null) {
                this.dirToNext.x = (float)((int)(this.dirToNext.x * f2)) / f2;
                this.dirToNext.y = (float)((int)(this.dirToNext.y * f2)) / f2;
            }
            if (this.perp != null) {
                this.perp.x = (float)((int)(this.perp.x * f2)) / f2;
                this.perp.y = (float)((int)(this.perp.y * f2)) / f2;
            }
            if (this.vel != null) {
                this.vel.x = (float)((int)(this.vel.x * f2)) / f2;
                this.vel.y = (float)((int)(this.vel.y * f2)) / f2;
            }
            return this;
        }
    }
}

