/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.entities;

import com.fs.graphics.LayeredRenderable;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.loading.ProjectileSpawnType;
import com.fs.starfarer.api.loading.ProjectileSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.combat.ai.ProximityFuseAI;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.for;
import com.fs.starfarer.combat.entities.o0oO;
import com.fs.starfarer.combat.entities.ship.A.E;
import com.fs.starfarer.combat.entities.ship.G;
import com.fs.starfarer.combat.o0OO.B;
import com.fs.starfarer.combat.systems.Q;
import com.fs.starfarer.loading.specs.F;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.O0oO;
import com.fs.starfarer.renderers.OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.renderers.while;
import com.fs.starfarer.settings.StarfarerSettings;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class MovingRay
extends o0oO
implements ProximityFuseAI.o,
DamagingProjectileAPI,
LayeredRenderable<CombatEngineLayers, CombatViewport> {
    private F spec;
    private OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.o textureAnimator;
    private while.o projAnimator;
    private float maxBrightness = 0.0f;
    private boolean didDamage = false;
    private for rayExtender;
    private float launchPower;
    private float maxPulseLength;
    private O0oO shine;
    private OnHitEffectPlugin effect = null;
    private final Q weapon;
    private int owner;
    private List<B> damagedAlready;
    private Vector2f spawnLocation = new Vector2f();
    private EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_LAYER);
    private float elapsed = 0.0f;
    private B damageTarget;
    private boolean fromMissile = false;

    public MovingRay(Ship ship, Q q2, F f2, float f3, Vector2f vector2f) {
        this.weapon = q2;
        this.spec = f2;
        if (f2.isPassThroughMissiles() || f2.isPassThroughFighters()) {
            this.damagedAlready = new ArrayList<B>();
        }
        this.setSource(ship);
        this.effect = f2.getOnHitEffect();
        this.projAnimator = new while.o(f2.getBulletSpriteName());
        this.maxBrightness = 1.0f;
        this.launchPower = f3;
        if (f2.getTextureType() != null) {
            this.textureAnimator = new OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.o(f2.getTextureType());
            this.projAnimator.o00000 = this.textureAnimator.\u00d300000();
            this.projAnimator.Object = this.textureAnimator.\u00d500000();
        } else {
            this.textureAnimator = new OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.o(f2.getFringeTex(), f2.getCoreTex());
            this.projAnimator.o00000 = this.textureAnimator.\u00d300000();
            this.projAnimator.Object = this.textureAnimator.\u00d500000();
        }
        if (f2.getGlowRadius() > 0.0f) {
            this.shine = new O0oO(f2.getGlowRadius(), f2.getWidth() * 1.5f, f2.getGlowColor());
        }
        float f4 = com.fs.starfarer.combat.entities.ship.E.getAdjustedBaseRange(f2.getMaxRange(), ship, q2);
        float f5 = com.fs.starfarer.combat.entities.ship.E.getThresholdAdjustedRange(ship, q2, f4 * com.fs.starfarer.combat.entities.ship.E.computeExtraRangeMult(ship, q2) + com.fs.starfarer.combat.entities.ship.E.computeExtraRangeFlat(ship, q2));
        if (f2.getBehaviorSpec() != null && f2.getBehaviorSpec().getParams() != null) {
            float f6 = (float)f2.getBehaviorSpec().getParams().optDouble("shotRangeVariance", 0.0);
            float f7 = (float)f2.getBehaviorSpec().getParams().optDouble("probOfVariance", 1.0);
            if ((float)Math.random() < f7) {
                f5 *= 1.0f - f6 * (float)Math.random();
            }
        }
        this.maxPulseLength = Math.max(f3 * f2.getLength(), 1.0f / StarfarerSettings.\u00f8\u00d30000() * f2.getMoveSpeed(ship.getStats(), q2) * 1.5f);
        this.rayExtender = new for(this.getFrom(), this.getTo(), this.maxPulseLength, f2.getMoveSpeed(ship.getStats(), q2), f5, f2.getFadeTime(), vector2f);
        this.setImpactMass(f2.getImpactMass());
        this.setDamage(f2.getDamage().clone());
        this.getDamage().setStats(ship.getStats());
        float[] fArray = com.fs.starfarer.combat.entities.ship.E.computeExtraDamageComponents(ship, q2);
        if (fArray != null) {
            this.getDamage().getModifier().modifyPercent("core_edc_0", fArray[0]);
            this.getDamage().getModifier().modifyFlat("core_edc_1", fArray[1]);
            this.getDamage().getModifier().modifyMult("core_edc_2", fArray[2]);
        }
        this.owner = ship.getOwner();
    }

    public Vector2f getSpawnLocation() {
        return this.spawnLocation;
    }

    @Override
    public int getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(int n2) {
        this.owner = n2;
    }

    @Override
    public WeaponAPI getWeapon() {
        return this.weapon;
    }

    public Vector2f getImpactDirecion() {
        Vector2f vector2f = Utils.\u00d300000(Utils.\u00d300000(this.rayExtender.\u00d400000(), this.rayExtender.\u00d600000()));
        return vector2f;
    }

    public float getImpact() {
        return this.spec.getImpactMass();
    }

    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean isExpired() {
        return this.rayExtender.\u00f600000();
    }

    public float getBrightness() {
        return this.rayExtender.o00000() * this.maxBrightness;
    }

    public void render(CombatEngineLayers combatEngineLayers, CombatViewport combatViewport) {
        Vector2f vector2f = this.getFrom();
        Vector2f vector2f2 = this.getTo();
        if (!combatViewport.isNearViewport(vector2f, 100.0f)) {
            return;
        }
        if (!combatViewport.isNearViewport(vector2f2, 100.0f)) {
            return;
        }
        if (this.spec.getFringeColor().getAlpha() <= 0 && this.spec.getCoreColor().getAlpha() <= 0) {
            return;
        }
        float f2 = this.rayExtender.o00000() * this.maxBrightness;
        float f3 = Utils.\u00d800000(this.getFrom(), this.getTo());
        if (f3 < this.maxPulseLength) {
            f2 *= f3 / this.maxPulseLength;
        }
        if (this.shine != null) {
            this.shine.o00000(vector2f2.x, vector2f2.y, f2, false);
        }
        if (this.spec.getSpawnType() == ProjectileSpawnType.BEAM) {
            OO0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.o00000(this.textureAnimator, this.spec.getFringeColor(), this.spec.getCoreColor(), this.spec.isDarkCore(), this.spec.getDarkFringeIter(), this.spec.getDarkCoreIter(), vector2f, vector2f2, this.spec.getWidth() * f2, this.spec.getCoreWidthMult(), this.spec.getPixelsPerTexel(), f2, false);
        } else if (this.spec.getSpawnType() == ProjectileSpawnType.BALLISTIC_AS_BEAM) {
            while.o00000(this.projAnimator, this.getVelocity(), this.spec.getFringeColor(), this.spec.getCoreColor(), vector2f2, vector2f, this.spec.getWidth(), this.spec.getCoreWidthMult(), f2);
        }
    }

    @Override
    public boolean canCauseInsideBoundsCollision() {
        if (this.didDamage) {
            return false;
        }
        float f2 = this.spec.getMoveSpeed(this.getSource() == null ? null : this.getSource().getStats(), this.weapon);
        if (f2 <= 50.0f) {
            return this.elapsed > 0.5f;
        }
        return this.elapsed > 50.0f / f2;
    }

    @Override
    public void advance(float f2) {
        this.elapsed += f2;
        float f3 = this.launchPower * (1.0f - this.rayExtender.\u00d800000()) * (1.0f - this.rayExtender.\u00d800000());
        if (this.rayExtender.new()) {
            f3 = this.launchPower;
        }
        if (this.isFading()) {
            this.getDamage().setSoftFlux(true);
        }
        if (this.didDamage) {
            f3 = 0.0f;
        }
        this.getDamage().setMultiplier(f3);
        this.textureAnimator.super(f2, this.spec.getTextureScrollSpeed());
        this.projAnimator.super(f2, this.spec.getTextureScrollSpeed());
        this.rayExtender.o00000(f2, this.didDamage);
    }

    @Override
    public void setFacing(float f2) {
        super.setFacing(f2);
    }

    @Override
    public boolean pierces(B b2) {
        if (this.damagedAlready == null) {
            return super.pierces(b2);
        }
        return super.pierces(b2) || !this.didDamage && this.damagedAlready.contains(b2);
    }

    @Override
    public void notifyDealtDamage(Vector2f vector2f, G g2, B b2) {
        if (!(this.didDamage || this.damagedAlready != null && this.damagedAlready.contains(b2))) {
            this.damageTarget = b2;
            float f2 = this.spec.getHitGlowRadius();
            if (f2 == 0.0f) {
                f2 = this.spec.getLength() * 0.5f;
            }
            float f3 = f2 / 1.0f;
            float f4 = f2 / 2.0f;
            boolean bl = false;
            if (this.damagedAlready != null) {
                if (this.spec.isPassThroughMissiles() && b2 instanceof Missile) {
                    bl = true;
                } else if (this.spec.isPassThroughFighters() && b2 instanceof Ship && ((Ship)b2).isFighter() && (!this.spec.isPassThroughFightersOnlyWhenDestroyed() || b2.getHitpoints() <= 0.0f)) {
                    bl = true;
                }
            }
            if (!bl) {
                this.didDamage = true;
            }
            float f5 = f3 + (float)Math.random() * f4;
            f5 = Misc.getHitGlowSize((float)f5, (float)this.getDamage().getBaseDamage(), (ApplyDamageResultAPI)g2);
            if (!this.didDamage) {
                f5 *= 0.5f;
            }
            E.o00000(vector2f, g2, f5, b2, this.spec.getFringeColor(), this.getDamage().getMultiplier() * 0.4f, this.getDamage().getMultiplier());
            if (this.damagedAlready != null) {
                this.damagedAlready.add(b2);
            }
            if ((this.didDamage || this.spec.isApplyOnHitEffectWhenPassThrough()) && this.effect != null) {
                this.effect.onHit((DamagingProjectileAPI)this, (CombatEntityAPI)b2, vector2f, g2.getDamageToShields() > 0.0f, (ApplyDamageResultAPI)g2, (CombatEngineAPI)CombatEngine.getInstance());
            }
        }
    }

    public CombatEntityAPI getDamageTarget() {
        return this.damageTarget instanceof CombatEntityAPI ? this.damageTarget : null;
    }

    @Override
    public boolean didDamage() {
        return this.didDamage;
    }

    @Override
    public Vector2f getVelocity() {
        return this.rayExtender.\u00f500000();
    }

    public float getMoveSpeed() {
        return this.spec.getMoveSpeed(this.getSource() == null ? null : this.getSource().getStats(), this.weapon);
    }

    @Override
    public com.fs.starfarer.combat.o0OO.F getDamage(Vector2f vector2f, B b2) {
        if (this.damagedAlready != null && this.damagedAlready.contains(b2)) {
            return new com.fs.starfarer.combat.o0OO.F(0.0f, false, this.getDamage().getType(), this.getSource().getStats());
        }
        return this.getDamage();
    }

    @Override
    public boolean isFading() {
        return this.rayExtender.null();
    }

    public float getDamageAmount() {
        return this.getDamage().getDamage();
    }

    public float getBaseDamageAmount() {
        return this.getDamage().getBaseDamage();
    }

    public void setDamageAmount(float f2) {
        this.getDamage().setDamage(f2);
    }

    public DamageType getDamageType() {
        return this.getDamage().getType();
    }

    public String getProjectileSpecId() {
        return this.spec.getId();
    }

    public float getEmpAmount() {
        return this.getDamage().getFluxComponent();
    }

    public ProjectileSpawnType getSpawnType() {
        return this.spec.getSpawnType();
    }

    public float getElapsed() {
        return this.elapsed;
    }

    public boolean isFromMissile() {
        return this.fromMissile;
    }

    public void setFromMissile(boolean bl) {
        this.fromMissile = bl;
    }

    public void addDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public void removeDamagedAlready(CombatEntityAPI combatEntityAPI) {
    }

    public ProjectileSpecAPI getProjectileSpec() {
        return this.spec;
    }

    public Vector2f getTailEnd() {
        return this.rayExtender.\u00d400000();
    }

    public List<CombatEntityAPI> getDamagedAlready() {
        return null;
    }
}

