/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.loading;

import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.loading.LoadingUtils;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.title.Object.Oo0O;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class new {
    private static Logger \u00d200000 = Logger.getLogger(new.class);
    private static Map<String, HullVariantSpec> \u00d300000 = new HashMap<String, HullVariantSpec>();
    public static boolean super = true;

    public static List<String> o00000() {
        return new ArrayList<String>(\u00d300000.keySet());
    }

    public static void Object() {
        \u00d300000.clear();
    }

    public static void o00000(HullVariantSpec hullVariantSpec) {
        new.o00000(hullVariantSpec, false);
    }

    public static void o00000(HullVariantSpec hullVariantSpec, boolean bl) {
        String string = hullVariantSpec.getHullVariantId();
        if (\u00d300000.containsKey(string) && !bl) {
            throw new RuntimeException(String.format("Ship hull variant [%s] already exists", string));
        }
        \u00d300000.put(string, hullVariantSpec);
    }

    public static void \u00d200000(String string) {
        if (!new.\u00d400000(string)) {
            return;
        }
        HullVariantSpec hullVariantSpec = new.o00000(string);
        if (hullVariantSpec == null || hullVariantSpec.isStockVariant() || hullVariantSpec.isEmptyHullVariant()) {
            return;
        }
        \u00d300000.remove(string);
    }

    public static HullVariantSpec o00000(String string) {
        return new.o00000(string, false);
    }

    public static HullVariantSpec o00000(String string, boolean bl) {
        if (super && string != null && string.startsWith("wendigo")) {
            string = string.replaceFirst("wendigo", "grendel");
        }
        if (!\u00d300000.containsKey(string)) {
            HullVariantSpec hullVariantSpec = CampaignEngine.getInstance().getSavedVariant(string);
            if (hullVariantSpec == null && !bl) {
                throw new RuntimeException(String.format("Ship hull variant [%s] not found!", string));
            }
            return hullVariantSpec;
        }
        return \u00d300000.get(string);
    }

    public static boolean \u00d400000(String string) {
        return \u00d300000.containsKey(string);
    }

    public static void \u00d200000() throws IOException, JSONException {
        HullVariantSpec hullVariantSpec;
        \u00d200000.info((Object)"Loading mission-specific ship designs");
        List<String> list = LoadingUtils.\u00d500000(String.valueOf(StarfarerSettings.do.new()) + "/missions/variants", "variant");
        for (String object : list) {
            \u00d200000.info((Object)("Loading variant [" + object + "]"));
            try {
                JSONObject jSONObject = LoadingUtils.\u00f400000(object);
                String string = jSONObject.getString("variantId");
                if (new.\u00d400000(string)) continue;
                hullVariantSpec = new HullVariantSpec(jSONObject);
                hullVariantSpec.setSource(VariantSource.MISSION_DESIGN);
                new.o00000(hullVariantSpec, false);
            }
            catch (Exception exception) {
                \u00d200000.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        for (Oo0O oo0O2 : SpecStore.\u00d200000()) {
            \u00d200000.info((Object)("Loading saved variants for mission " + oo0O2.class()));
            list = LoadingUtils.\u00d500000(String.valueOf(StarfarerSettings.do.new()) + "/missions/" + oo0O2.class(), "variant");
            for (String string : list) {
                \u00d200000.info((Object)("Loading variant [" + string + "]"));
                try {
                    hullVariantSpec = LoadingUtils.\u00f400000(string);
                    String string2 = hullVariantSpec.getString("variantId");
                    if (new.\u00d400000(string2)) continue;
                    HullVariantSpec hullVariantSpec2 = new HullVariantSpec((JSONObject)hullVariantSpec);
                    hullVariantSpec2.setSource(VariantSource.MISSION_SAVE);
                    hullVariantSpec2.setSourceDetail(oo0O2.class());
                    new.o00000(hullVariantSpec2, false);
                }
                catch (Exception exception) {
                    \u00d200000.warn((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public static String o00000(Oo0O oo0O2, int n2) {
        if (oo0O2 == null) {
            return "invalid variant id that won't be found and therefore won't get used";
        }
        String string = "mission_" + oo0O2.class() + "_ship_" + n2;
        return string;
    }

    public static HullVariantSpec o00000(HullVariantSpec hullVariantSpec, Oo0O oo0O2, int n2, boolean bl) {
        String string2;
        HullVariantSpec hullVariantSpec2 = hullVariantSpec.clone();
        int n3 = 0;
        for (String string2 : hullVariantSpec2.getStationModules().keySet()) {
            HullVariantSpec hullVariantSpec3 = hullVariantSpec2.getModuleVariant(string2);
            if (hullVariantSpec3 == null) continue;
            HullVariantSpec hullVariantSpec4 = new.o00000(hullVariantSpec3, oo0O2, n2 + 10000 + n3, false);
            hullVariantSpec2.setModuleVariant(string2, hullVariantSpec4);
            ++n3;
        }
        if (oo0O2 != null) {
            string2 = new.o00000(oo0O2, n2);
            hullVariantSpec2.setHullVariantId(string2);
            hullVariantSpec2.setSource(VariantSource.MISSION_SAVE);
        } else if (!bl) {
            string2 = "missions_common_" + hullVariantSpec2.getHullSpec().getHullId() + "_" + Misc.genUID();
            hullVariantSpec2.setHullVariantId(string2);
            hullVariantSpec2.setSource(VariantSource.MISSION_DESIGN);
        }
        new.o00000(hullVariantSpec2, true);
        try {
            string2 = hullVariantSpec2.toJSONObject().toString(4);
            String string3 = oo0O2 != null ? String.valueOf(StarfarerSettings.do.new()) + "/missions/" + oo0O2.class() + "/" + hullVariantSpec2.getHullVariantId() + ".variant" : String.valueOf(StarfarerSettings.do.new()) + "/missions/variants/" + hullVariantSpec2.getHullVariantId() + ".variant";
            LoadingUtils.\u00d300000(string2, string3, true);
        }
        catch (JSONException jSONException) {
            \u00d200000.error((Object)jSONException.getMessage(), (Throwable)jSONException);
        }
        catch (IOException iOException) {
            \u00d200000.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        return hullVariantSpec2;
    }

    public static void o00000(HullVariantSpec hullVariantSpec, String string) {
        HullVariantSpec hullVariantSpec2 = hullVariantSpec.clone();
        hullVariantSpec2.setSource(VariantSource.STOCK);
        hullVariantSpec.setSource(VariantSource.STOCK);
        new.o00000(hullVariantSpec2, true);
        try {
            String string2 = hullVariantSpec2.toJSONObject().toString(4);
            LoadingUtils.\u00d300000(string2, string, true);
        }
        catch (JSONException jSONException) {
            \u00d200000.error((Object)jSONException.getMessage(), (Throwable)jSONException);
        }
        catch (IOException iOException) {
            \u00d200000.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public static void o00000(Oo0O oo0O2) {
        File[] fileArray;
        String string = String.valueOf(StarfarerSettings.do.new()) + "/missions/" + oo0O2.class();
        \u00d200000.info((Object)("Looking in " + string + " for mission variants to delete"));
        File file = new File(string);
        if (!(file.exists() && file.isDirectory() && file.canWrite())) {
            return;
        }
        File[] fileArray2 = fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                if (string.contains("..") || string.contains("/") || string.contains("\\")) {
                    return false;
                }
                return string.endsWith(".variant");
            }
        });
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray2[n3];
            if (file2.exists() && file2.isFile() && file2.canWrite()) {
                \u00d200000.info((Object)("Removing: " + file2.getAbsolutePath()));
                file2.delete();
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < 500) {
            String string2 = new.o00000(oo0O2, n4);
            new.\u00d200000(string2);
            ++n4;
        }
    }

    public static void Object(String string) {
        if (string.contains("..") || string.contains("/") || string.contains("\\") || !new.\u00d400000(string)) {
            return;
        }
        HullVariantSpec hullVariantSpec = new.o00000(string);
        if (hullVariantSpec == null || hullVariantSpec.isStockVariant()) {
            return;
        }
        \u00d300000.remove(string);
        String string2 = String.valueOf(StarfarerSettings.do.new()) + "/missions/variants/" + string + ".variant";
        File file = new File(string2);
        if (file.exists() && file.isFile() && file.canWrite()) {
            file.delete();
        }
    }
}

