/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.particle;

import com.fs.graphics.Object;
import com.fs.graphics.oOoO;
import com.fs.graphics.particle.BaseParticle;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class GenericTextureParticle
extends BaseParticle
implements DoNotObfuscate {
    private transient Object texture = null;
    private Color color;
    private float origSize;
    private float endSize;
    private float fullBrightnessFraction;
    private float tw;
    private float th;
    private int renderCount = 1;
    private int src = 770;
    private int dst = 771;
    private String textureId;
    private boolean shrinkAndFade = false;
    boolean fullyFadedIn = false;
    private float offsetX;
    private float offsetY;
    private float width;
    private float height;

    public GenericTextureParticle(String string, float f, float f2, float f3) {
        this(oOoO.new(string), new Color(255, 255, 255, 255), f, f2, f3);
        this.textureId = string;
    }

    @Deprecated
    public GenericTextureParticle(Object object, float f, float f2, float f3) {
        this(object, new Color(255, 255, 255, 255), f, f2, f3);
        this.textureId = object.oO0000();
    }

    public GenericTextureParticle(String string, Color color, float f, float f2, float f3) {
        this(oOoO.new(string), color, f, f2, f3);
        this.textureId = string;
    }

    private GenericTextureParticle(Object object, Color color, float f, float f2, float f3) {
        this.texture = object;
        this.color = color;
        this.origSize = f;
        this.endSize = f2;
        this.fullBrightnessFraction = f3;
        this.setSize(f, f);
        this.tw = object.\u00d2O0000();
        this.th = object.o00000();
    }

    java.lang.Object readResolve() {
        if (this.textureId != null) {
            this.texture = oOoO.new(this.textureId);
        }
        return this;
    }

    @Override
    public void advance(float f) {
        super.advance(f);
        this.setCurrSize(this.origSize + (this.endSize - this.origSize) * this.getAge() / this.getMaxAge());
    }

    @Override
    public void preBatch() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        this.texture.\u00d800000();
    }

    public void setBlendFunc(int n, int n2) {
        this.src = n;
        this.dst = n2;
    }

    @Override
    public void postBatch() {
        GL11.glDisable((int)3553);
    }

    public void setShrinkAndFade(boolean bl) {
        this.shrinkAndFade = bl;
    }

    @Override
    public void render() {
        float f = this.getBrightness();
        if (f >= 1.0f) {
            this.fullyFadedIn = true;
        }
        if (this.fullyFadedIn && this.fullBrightnessFraction > 0.0f) {
            f = this.getAge() / this.getMaxAge();
            f = f <= this.fullBrightnessFraction ? 1.0f : 1.0f - (f - this.fullBrightnessFraction) / (1.0f - this.fullBrightnessFraction);
        }
        GL11.glBlendFunc((int)this.src, (int)this.dst);
        GL11.glColor4ub((byte)((byte)this.color.getRed()), (byte)((byte)this.color.getGreen()), (byte)((byte)this.color.getBlue()), (byte)((byte)((float)this.color.getAlpha() * f)));
        float f2 = this.getX();
        float f3 = this.getY();
        GL11.glPushMatrix();
        float f4 = this.getAngle();
        GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
        GL11.glRotatef((float)f4, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        float f5 = 0.0f;
        while (f5 < (float)this.renderCount) {
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)(this.offsetX + f5), (float)this.offsetY);
            GL11.glTexCoord2f((float)0.0f, (float)this.th);
            GL11.glVertex2f((float)(this.offsetX + f5), (float)(this.offsetY + this.height));
            GL11.glTexCoord2f((float)this.tw, (float)this.th);
            GL11.glVertex2f((float)(this.offsetX + f5 + this.width), (float)(this.offsetY + this.height));
            GL11.glTexCoord2f((float)this.tw, (float)0.0f);
            GL11.glVertex2f((float)(this.offsetX + f5 + this.width), (float)this.offsetY);
            f5 += 1.0f;
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setRenderCount(int n) {
        this.renderCount = n;
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.offsetX = -f / 2.0f;
        this.offsetY = -f2 / 2.0f;
    }

    private void setCurrSize(float f) {
        this.width = f;
        this.height = f;
        this.offsetX = -f / 2.0f;
        this.offsetY = -f / 2.0f;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void preBatch(int n) {
        this.preBatch();
    }
}

