/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign.impl.items;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CargoTransferHandlerAPI;
import com.fs.starfarer.api.campaign.SpecialItemPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.impl.items.BaseSpecialItemPlugin;
import com.fs.starfarer.api.campaign.impl.items.BlueprintProviderItem;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.SharedUnlockData;
import com.fs.starfarer.api.loading.IndustrySpecAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class IndustryBlueprintItemPlugin
extends BaseSpecialItemPlugin
implements BlueprintProviderItem {
    protected IndustrySpecAPI industry;

    @Override
    public void init(CargoStackAPI stack) {
        super.init(stack);
        this.industry = Global.getSettings().getIndustrySpec(stack.getSpecialDataIfSpecial().getData());
    }

    @Override
    public List<String> getProvidedFighters() {
        return null;
    }

    @Override
    public List<String> getProvidedShips() {
        return null;
    }

    @Override
    public List<String> getProvidedWeapons() {
        return null;
    }

    @Override
    public List<String> getProvidedIndustries() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.industry.getId());
        return result;
    }

    @Override
    public void render(float x, float y, float w, float h, float alphaMult, float glowMult, SpecialItemPlugin.SpecialItemRendererAPI renderer) {
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        float blX = cx - 25.0f;
        float blY = cy - 14.0f;
        float tlX = cx - 30.0f;
        float tlY = cy + 16.0f;
        float trX = cx + 24.0f;
        float trY = cy + 22.0f;
        float brX = cx + 30.0f;
        float brY = cy - 6.0f;
        SpriteAPI sprite = Global.getSettings().getSprite(this.industry.getImageName());
        String industryId = this.stack.getSpecialDataIfSpecial().getData();
        boolean known = Global.getSector().getPlayerFaction().knowsIndustry(industryId);
        float mult = 1.0f;
        sprite.setAlphaMult(alphaMult * mult);
        sprite.setNormalBlend();
        sprite.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
        if (glowMult > 0.0f) {
            sprite.setAlphaMult(alphaMult * glowMult * 0.5f * mult);
            sprite.setAdditiveBlend();
            sprite.renderWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY);
        }
        if (known) {
            renderer.renderBGWithCorners(Color.black, blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult * 0.5f, 0.0f, false);
        }
        renderer.renderScanlinesWithCorners(blX, blY, tlX, tlY, trX, trY, brX, brY, alphaMult, false);
    }

    @Override
    public int getPrice(MarketAPI market, SubmarketAPI submarket) {
        if (this.industry != null) {
            float base = super.getPrice(market, submarket);
            return (int)(base + this.industry.getCost() * this.getItemPriceMult());
        }
        return super.getPrice(market, submarket);
    }

    @Override
    public String getName() {
        if (this.industry != null) {
            return String.valueOf(this.industry.getName()) + " Blueprint";
        }
        return super.getName();
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, CargoTransferHandlerAPI transferHandler, Object stackSource) {
        super.createTooltip(tooltip, expanded, transferHandler, stackSource);
        float pad = 3.0f;
        float opad = 10.0f;
        float small = 5.0f;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color b = Misc.getButtonTextColor();
        b = Misc.getPositiveHighlightColor();
        String industryId = this.stack.getSpecialDataIfSpecial().getData();
        boolean known = Global.getSector().getPlayerFaction().knowsIndustry(industryId);
        tooltip.addPara(this.industry.getDesc(), opad);
        this.addCostLabel(tooltip, opad, transferHandler, stackSource);
        if (known) {
            tooltip.addPara("Already known", g, opad);
        } else {
            tooltip.addPara("Right-click to learn", b, opad);
        }
    }

    @Override
    public boolean hasRightClickAction() {
        return true;
    }

    @Override
    public boolean shouldRemoveOnRightClickAction() {
        String industryId = this.stack.getSpecialDataIfSpecial().getData();
        return !Global.getSector().getPlayerFaction().knowsIndustry(industryId);
    }

    @Override
    public void performRightClickAction() {
        String industryId = this.stack.getSpecialDataIfSpecial().getData();
        if (this.industry.hasTag("codex_unlockable")) {
            SharedUnlockData.get().reportPlayerAwareOfIndustry(this.industry.getId(), true);
        }
        if (Global.getSector().getPlayerFaction().knowsIndustry(industryId)) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(this.industry.getName() + ": blueprint already known");
        } else {
            Global.getSoundPlayer().playUISound("ui_acquired_blueprint", 1.0f, 1.0f);
            Global.getSector().getPlayerFaction().addKnownIndustry(industryId);
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage("Acquired blueprint: " + this.industry.getName());
        }
    }
}

