/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl;

import com.fs.starfarer.api.Global;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class SharedSettings {
    public static String SETTINGS_DATA_FILE = "core_shared_settings.json";
    protected static JSONObject json = new JSONObject();

    static {
        SharedSettings.loadIfNeeded();
    }

    public static void loadIfNeeded() {
        try {
            if (Global.getSettings().fileExistsInCommon(SETTINGS_DATA_FILE)) {
                json = Global.getSettings().readJSONFromCommon(SETTINGS_DATA_FILE, true);
            }
        }
        catch (IOException e) {
            Global.getLogger(SharedSettings.class).warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            Global.getLogger(SharedSettings.class).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void saveIfNeeded() {
        try {
            Global.getSettings().writeJSONToCommon(SETTINGS_DATA_FILE, json, true);
        }
        catch (JSONException e) {
            Global.getLogger(SharedSettings.class).warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Global.getLogger(SharedSettings.class).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static JSONObject get() {
        return json;
    }

    public static boolean optBoolean(String key, boolean defaultValue) {
        return json.optBoolean(key, defaultValue);
    }

    public static void setBoolean(String key, boolean value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            Global.getLogger(SharedSettings.class).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static float optFloat(String key, float defaultValue) {
        return (float)json.optDouble(key, (double)defaultValue);
    }

    public static void setFloat(String key, float value) {
        try {
            json.put(key, (double)value);
        }
        catch (JSONException e) {
            Global.getLogger(SharedSettings.class).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static int optInt(String key, int defaultValue) {
        return json.optInt(key, defaultValue);
    }

    public static void setInt(String key, int value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            Global.getLogger(SharedSettings.class).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String optString(String key, String defaultValue) {
        return json.optString(key, defaultValue);
    }

    public static void setString(String key, String value) {
        try {
            json.put(key, (Object)value);
        }
        catch (JSONException e) {
            Global.getLogger(SharedSettings.class).warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void unset(String key) {
        json.remove(key);
    }
}

