/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.ApplyCRDamage;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class HassleNPCScript
implements EveryFrameScript {
    public static String HASSLE_ASSIGNMENT_ID = "hassle_assignment_id";
    protected CampaignFleetAPI fleet;
    protected CampaignFleetAPI target;
    protected Vector2f loc1;
    protected Vector2f loc2;
    protected HassleParams params = new HassleParams();
    protected float durDays = 3.0f;
    private IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    boolean done = false;

    public HassleNPCScript(CampaignFleetAPI fleet, CampaignFleetAPI target) {
        this(fleet, target, "conducting an inspection", "standing by for inspection");
    }

    public HassleNPCScript(CampaignFleetAPI fleet, CampaignFleetAPI target, HassleParams params) {
        this.fleet = fleet;
        this.target = target;
        this.params = params;
        this.durDays = params.minDurDays + (params.maxDurDays - params.minDurDays) * (float)Math.random();
        this.interval.forceIntervalElapsed();
    }

    public HassleNPCScript(CampaignFleetAPI fleet, CampaignFleetAPI target, String fleetAction, String targetAction) {
        this.fleet = fleet;
        this.target = target;
        this.params.fleetAction = fleetAction;
        this.params.targetAction = targetAction;
        this.durDays = this.params.minDurDays + (this.params.maxDurDays - this.params.minDurDays) * (float)Math.random();
        this.interval.forceIntervalElapsed();
    }

    public float getDurDays() {
        return this.durDays;
    }

    public void setDurDays(float durDays) {
        this.durDays = durDays;
    }

    public void abort() {
        this.done = true;
        this.cleanUpFleet(this.fleet);
        this.cleanUpFleet(this.target);
    }

    protected void cleanUpFleet(CampaignFleetAPI fleet) {
        if (fleet.getAI() != null) {
            Misc.setFlagWithReason(fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", "npc_hassle", false, 0.0f);
            fleet.getMemoryWithoutUpdate().unset("$core_fleetSpecialAction");
            fleet.getMemoryWithoutUpdate().unset("$doNotGetSidetracked");
            FleetAssignmentDataAPI curr = fleet.getAI().getCurrentAssignment();
            if (curr != null && HASSLE_ASSIGNMENT_ID.equals(curr.getCustom())) {
                fleet.removeFirstAssignment();
            }
        }
    }

    @Override
    public void advance(float amount) {
        FleetAssignmentDataAPI curr;
        if (this.done) {
            return;
        }
        if (this.target.isPlayerFleet()) {
            this.abort();
            return;
        }
        if (this.fleet.getBattle() != null || this.target.getBattle() != null) {
            this.abort();
            return;
        }
        if (this.fleet.getAI() != null && (this.fleet.getAI().isFleeing() || this.fleet.getAI().isMaintainingContact())) {
            this.abort();
            return;
        }
        if (this.target.getAI() != null && (this.target.getAI().isFleeing() || this.target.getAI().isMaintainingContact())) {
            this.abort();
            return;
        }
        if (this.fleet.getContainingLocation() != this.target.getContainingLocation()) {
            this.abort();
            return;
        }
        if (this.fleet.isHostileTo(this.target) || this.fleet.getFaction() == this.target.getFaction()) {
            this.abort();
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.durDays -= days;
        if (this.durDays <= 0.0f) {
            this.abort();
            if (this.params.crDamageMult > 0.0f) {
                float damageFP = (float)this.fleet.getFleetPoints() * 0.2f;
                ApplyCRDamage.applyCRDamage(this.target, damageFP, this.params.crDamageMult, "Vindictive inspection", null, new Random());
            }
            return;
        }
        if (this.loc1 == null) {
            this.loc1 = new Vector2f((ReadableVector2f)this.target.getLocation());
            Vector2f.add((Vector2f)this.loc1, (Vector2f)this.fleet.getLocation(), (Vector2f)this.loc1);
            this.loc1.scale(0.5f);
            this.loc2 = Misc.getPointAtRadius(this.loc1, this.fleet.getRadius() + this.target.getRadius());
        }
        this.fleet.setMoveDestinationOverride(this.loc2.x, this.loc2.y);
        this.target.setMoveDestinationOverride(this.loc1.x, this.loc1.y);
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        if (this.fleet.getAI() != null) {
            Misc.setFlagWithReason(this.fleet.getMemoryWithoutUpdate(), "$core_fleetBusy", "npc_hassle", true, 0.4f);
            this.fleet.getMemoryWithoutUpdate().set("$doNotGetSidetracked", true, 0.4f);
            this.fleet.getMemoryWithoutUpdate().set("$core_fleetSpecialAction", true, 0.4f);
            curr = this.fleet.getAI().getCurrentAssignment();
            if (curr == null || !HASSLE_ASSIGNMENT_ID.equals(curr.getCustom())) {
                this.fleet.clearAssignments();
                this.fleet.addAssignmentAtStart(FleetAssignment.HOLD, null, this.durDays + 1.0f, this.params.fleetAction, null);
                this.fleet.getCurrentAssignment().setCustom(HASSLE_ASSIGNMENT_ID);
            }
        }
        if (this.target.getAI() != null) {
            Misc.setFlagWithReason(this.target.getMemoryWithoutUpdate(), "$core_fleetBusy", "npc_hassle", true, 0.4f);
            this.target.getMemoryWithoutUpdate().set("$doNotGetSidetracked", true, 0.4f);
            this.target.getMemoryWithoutUpdate().set("$core_fleetSpecialAction", true, 0.4f);
            curr = this.target.getAI().getCurrentAssignment();
            curr = null;
            if (curr == null || !HASSLE_ASSIGNMENT_ID.equals(curr.getCustom())) {
                this.target.clearAssignments();
                this.target.addAssignmentAtStart(FleetAssignment.HOLD, null, this.durDays + 1.0f, this.params.targetAction, null);
                this.target.getCurrentAssignment().setCustom(HASSLE_ASSIGNMENT_ID);
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public float getCrDamageMult() {
        return this.params.crDamageMult;
    }

    public void setCrDamageMult(float crDamageMult) {
        this.params.crDamageMult = crDamageMult;
    }

    public HassleParams getParams() {
        return this.params;
    }

    public static class HassleParams {
        public String fleetAction = "conducting an inspection";
        public String targetAction = "standing by for inspection";
        public float minDurDays = 2.0f;
        public float maxDurDays = 3.0f;
        public float crDamageMult = 1.0f;
        public String timeoutKey = "$NPCHassleTimeout";
        public float minGlobalTimeout = 1.0f;
        public float maxGlobalTimeout = 2.0f;
        public float minTargetTimeout = 25.0f;
        public float maxTargetTimeout = 35.0f;
    }
}

