/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.abilities.ai;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.BaseAbilityAI;
import com.fs.starfarer.api.impl.campaign.abilities.ai.EmergencyBurnAbilityAI;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;

public class TransponderAbilityAI
extends BaseAbilityAI {
    private IntervalUtil interval = new IntervalUtil(0.05f, 0.15f);

    @Override
    public void advance(float days) {
        this.interval.advance(days * EmergencyBurnAbilityAI.AI_FREQUENCY_MULT);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        MemoryAPI mem = this.fleet.getMemoryWithoutUpdate();
        boolean smuggler = mem.getBoolean("$isSmuggler");
        boolean pirate = mem.getBoolean("$isPirate");
        boolean patrol = mem.getBoolean("$isPatrol");
        boolean trader = mem.getBoolean("$isTradeFleet");
        if (smuggler || pirate || mem.getBoolean("$forceTOff")) {
            if (this.ability.isActive()) {
                this.ability.deactivate();
            }
            return;
        }
        if (patrol || trader) {
            if (!this.ability.isActive()) {
                this.ability.activate();
            }
            return;
        }
        if (this.fleet.isInHyperspace()) {
            float nonHostileSize = 0.0f;
            float hostileSize = 0.0f;
            for (MarketAPI market : Misc.getNearbyMarkets(this.fleet.getLocation(), 1.0f)) {
                float size = market.getSize();
                if (market.getFaction().isHostileTo(this.fleet.getFaction())) {
                    hostileSize += size;
                    continue;
                }
                nonHostileSize += size;
            }
            if (nonHostileSize > hostileSize) {
                if (!this.ability.isActive()) {
                    this.ability.activate();
                }
            } else if (this.ability.isActive()) {
                this.ability.deactivate();
            }
            return;
        }
        MarketAPI nearestMarket = Misc.findNearestLocalMarket(this.fleet, 1000000.0f, new BaseEventPlugin.MarketFilter(){

            @Override
            public boolean acceptMarket(MarketAPI market) {
                return true;
            }
        });
        if (nearestMarket != null) {
            if (nearestMarket.getFaction().isHostileTo(this.fleet.getFaction())) {
                if (this.ability.isActive()) {
                    this.ability.deactivate();
                }
            } else if (!this.ability.isActive()) {
                this.ability.activate();
            }
            return;
        }
        if (this.ability.isActive()) {
            this.ability.deactivate();
        }
    }
}

