/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.enc.BaseEPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.intel.bases.LuddicPathBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SlipstreamMercenaryEPEC
extends BaseEPEncounterCreator {
    @Override
    public void createEncounter(EncounterManager manager, EncounterPoint point) {
        Random random = manager.getRandom();
        float f = SlipstreamMercenaryEPEC.getProximityFactor(point.getLocInHyper());
        int difficulty = 0;
        difficulty += Math.round(f * 5.0f);
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = point.getLocInHyper();
        m.createQualityFleet(difficulty += random.nextInt(6), "mercenary", loc);
        m.triggerFleetAllowLongPursuit();
        m.triggerSetFleetFaction("independent");
        m.triggerMakeNoRepImpact();
        m.triggerFleetSetAllWeapons();
        CampaignFleetAPI fleet = m.createFleet();
        if (fleet != null) {
            point.where.addEntity(fleet);
            fleet.setLocation(point.loc.x, point.loc.y);
            Vector2f spawnLoc = Misc.getPointWithinRadius(point.loc, 1000.0f);
            SectorEntityToken e = point.where.createToken(spawnLoc);
            fleet.addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, e, 30.0f * random.nextFloat(), "laying in wait");
            fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
            fleet.addScript(new MissionFleetAutoDespawn(null, fleet));
        }
    }

    @Override
    public float getFrequencyForPoint(EncounterManager manager, EncounterPoint point) {
        if (!EncounterManager.EP_TYPE_SLIPSTREAM.equals(point.type)) {
            return 0.0f;
        }
        float f = SlipstreamMercenaryEPEC.getProximityFactor(point.getLocInHyper());
        if (f > 0.0f) {
            f = 0.25f + 0.75f * f;
        }
        return 10.0f * f;
    }

    public static float getProximityFactor(Vector2f locInHyper) {
        LuddicPathBaseIntel intel = SlipstreamMercenaryEPEC.getClosestLuddicPathBase(locInHyper);
        float f1 = SlipstreamMercenaryEPEC.getLuddicPathBaseProximityFactor(intel, locInHyper);
        PirateBaseIntel intel2 = SlipstreamMercenaryEPEC.getClosestPirateBase(locInHyper);
        float f2 = SlipstreamMercenaryEPEC.getPirateBaseProximityFactor(intel2, locInHyper);
        float result = Math.max(f1, f2);
        StarSystemAPI ruins = SlipstreamMercenaryEPEC.getClosestSystemWithRuins(locInHyper);
        float f3 = SlipstreamMercenaryEPEC.getRuinsProximityFactor(ruins, locInHyper);
        result = Math.max(result, f3 *= 0.25f);
        return result;
    }
}

