/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.SDFBase;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import org.lwjgl.util.vector.Vector2f;

public class SDFLeague
extends SDFBase {
    @Override
    protected String getFactionId() {
        return "persean";
    }

    @Override
    protected OfficerManagerEvent.SkillPickPreference getCommanderShipSkillPreference() {
        return OfficerManagerEvent.SkillPickPreference.NO_ENERGY_YES_BALLISTIC_YES_MISSILE_YES_DEFENSE;
    }

    @Override
    protected MarketAPI getSourceMarket() {
        return Global.getSector().getEconomy().getMarket("kazeron");
    }

    @Override
    protected String getDefeatTriggerToUse() {
        return "SDFLeagueDefeated";
    }

    @Override
    public CampaignFleetAPI spawnFleet() {
        WeightedRandomPicker<String> capitalShipNames = new WeightedRandomPicker<String>(this.random);
        capitalShipNames.add("Pride of Hannan");
        capitalShipNames.add("Pride of Kato");
        capitalShipNames.add("Pride of Yaribay");
        capitalShipNames.add("Reynard's Gift");
        capitalShipNames.add("Fortuna's Gift");
        capitalShipNames.add("Mairaath Remembered");
        capitalShipNames.add("Navarch Arnulf Hannan");
        capitalShipNames.add("Navarch Mars Kato");
        capitalShipNames.add("Navarch Leandro Tethys");
        capitalShipNames.add("Navarch Herman Zhou");
        MarketAPI kazeron = this.getSourceMarket();
        FleetCreatorMission m = new FleetCreatorMission(this.random);
        m.beginFleet();
        Vector2f loc = kazeron.getLocationInHyperspace();
        m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MAXIMUM, HubMissionWithTriggers.FleetQuality.SMOD_2, this.getFactionId(), "patrolLarge", loc);
        m.triggerSetFleetSizeFraction(1.25f);
        m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        m.triggerSetFleetDoctrineComp(5, 0, 0);
        m.triggerSetFleetCommander(this.getPerson());
        m.triggerFleetAddCommanderSkill("crew_training", 1);
        m.triggerFleetAddCommanderSkill("tactical_drills", 1);
        m.triggerFleetAddCommanderSkill("support_doctrine", 1);
        m.triggerFleetAddCommanderSkill("flux_regulation", 1);
        m.triggerSetPatrol();
        m.triggerSetFleetMemoryValue("$sourceMarket", kazeron);
        m.triggerFleetSetName("All-League Aegis");
        m.triggerPatrolAllowTransponderOff();
        m.triggerOrderFleetPatrol(kazeron.getStarSystem());
        CampaignFleetAPI fleet = m.createFleet();
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        kazeron.getContainingLocation().addEntity(fleet);
        fleet.setLocation(kazeron.getPlanetEntity().getLocation().x, kazeron.getPlanetEntity().getLocation().y);
        fleet.setFacing(this.random.nextFloat() * 360.0f);
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            String name;
            if (!member.isCapital() || (name = (String)capitalShipNames.pickAndRemove()) == null) continue;
            member.setShipName(name);
        }
        return fleet;
    }
}

