/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts.types;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.impl.campaign.ghosts.BaseSensorGhost;
import com.fs.starfarer.api.impl.campaign.ghosts.GBGoInDirectionWithWobble;
import com.fs.starfarer.api.impl.campaign.ghosts.GBIGenerateSlipstream;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhostManager;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class LeviathanGhost
extends BaseSensorGhost {
    public LeviathanGhost(SensorGhostManager manager, int burnMod) {
        super(manager, 0);
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        float size = this.genFloat(400.0f, 500.0f);
        this.initEntity(this.genHugeSensorProfile(), size);
        this.setDespawnRange(-200.0f);
        this.entity.addTag("unaffected_by_slipstream");
        float dirToCore = Misc.getAngleInDegrees(pf.getLocation());
        float travelDirMin = dirToCore + 90.0f - 20.0f;
        float travelDirMax = dirToCore + 90.0f + 20.0f;
        float travelDir = travelDirMin + (travelDirMax - travelDirMin) * this.getRandom().nextFloat();
        travelDir = Misc.normalizeAngle(travelDir);
        float spawnDist = this.genFloat(6000.0f, 8000.0f);
        float spawnAngle = travelDir + 30.0f - 60.0f * this.getRandom().nextFloat() + 180.0f;
        if (this.getRandom().nextBoolean()) {
            travelDir += 180.0f;
            spawnAngle += 180.0f;
        }
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(spawnAngle);
        loc.scale(spawnDist);
        Vector2f.add((Vector2f)loc, (Vector2f)pf.getLocation(), (Vector2f)loc);
        this.setLoc(loc);
        int burnLevel = 25 + burnMod;
        float speed = Misc.getSpeedForBurnLevel(burnLevel);
        Vector2f vel = Misc.getUnitVectorAtDegreeAngle(travelDir);
        vel.scale(speed);
        this.setVel(vel);
        float travelDur = this.genFloat(15.0f, 20.0f);
        float streamDur = travelDur - (1.0f + this.getRandom().nextFloat());
        this.setAccelMult(0.1f);
        this.addBehavior(new GBGoInDirectionWithWobble(travelDur, travelDir, 0.01f + 0.04f * manager.getRandom().nextFloat(), 10.0f + 20.0f * manager.getRandom().nextFloat(), burnLevel));
        this.addInterrupt(new GBIGenerateSlipstream(size, size * 1.2f, burnLevel - 5, 30.0f, 20, streamDur));
    }
}

