/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseBarEvent;
import com.fs.starfarer.api.util.Misc;
import java.util.Random;

public abstract class BaseBarEventWithPerson
extends BaseBarEvent {
    protected PersonAPI person;
    protected long seed = Misc.random.nextLong();
    protected MarketAPI market = null;
    protected transient Random random;

    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        this.market = market;
        this.random = new Random(this.seed + (long)market.getId().hashCode());
        this.person = this.createPerson();
    }

    protected PersonAPI createPerson() {
        PersonAPI person = Global.getSector().getFaction(this.getPersonFaction()).createRandomPerson(this.getPersonGender(), this.random);
        String p = this.getPersonPortrait();
        if (p != null) {
            person.setPortraitSprite(p);
        }
        person.setRankId(this.getPersonRank());
        person.setPostId(this.getPersonPost());
        return person;
    }

    protected String getPersonPortrait() {
        return null;
    }

    protected String getPersonFaction() {
        return "independent";
    }

    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    protected FullName.Gender getPersonGender() {
        return FullName.Gender.ANY;
    }

    protected String getPersonPost() {
        return Ranks.CITIZEN;
    }

    protected String getManOrWoman() {
        String manOrWoman = "man";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            manOrWoman = "woman";
        }
        return manOrWoman;
    }

    protected String getHeOrShe() {
        String heOrShe = "he";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            heOrShe = "she";
        }
        return heOrShe;
    }

    protected String getHimOrHer() {
        String himOrHer = "him";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            himOrHer = "her";
        }
        return himOrHer;
    }

    protected String getHimOrHerself() {
        String himOrHer = "himself";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            himOrHer = "herself";
        }
        return himOrHer;
    }

    protected String getHisOrHer() {
        String hisOrHer = "his";
        if (this.person.getGender() == FullName.Gender.FEMALE) {
            hisOrHer = "her";
        }
        return hisOrHer;
    }

    @Override
    public boolean isDialogFinished() {
        return this.done;
    }

    public PersonAPI getPerson() {
        return this.person;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    public Random getRandom() {
        return this.random;
    }
}

