/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.ui.SectorMapAPI;
import java.util.Set;

public class FleetLogIntel
extends BaseIntelPlugin {
    public static Object DISCOVERED_PARAM = new Object();
    public static float DEFAULT_DURATION = 365.0f;
    protected Float duration = null;
    protected SectorEntityToken removeTrigger = null;
    protected Boolean keepExploredDebrisField = null;
    protected Boolean removeSurveyedPlanet = null;
    protected String icon = null;
    protected String iconId = null;
    protected String sound = null;

    public FleetLogIntel() {
    }

    public FleetLogIntel(float duration) {
        this.duration = Float.valueOf(duration);
    }

    public void setDefaultExpiration() {
        this.duration = Float.valueOf(DEFAULT_DURATION);
    }

    public void setDuration(float days) {
        this.duration = Float.valueOf(days);
    }

    @Override
    public String getSortString() {
        return this.getSortStringNewestFirst();
    }

    public Boolean getKeepExploredDebrisField() {
        return this.keepExploredDebrisField;
    }

    public void setKeepExploredDebrisField(Boolean keepExploredDebrisField) {
        this.keepExploredDebrisField = keepExploredDebrisField;
    }

    public Boolean getRemoveSurveyedPlanet() {
        return this.removeSurveyedPlanet;
    }

    public void setRemoveSurveyedPlanet(Boolean removeSurveyedPlanet) {
        this.removeSurveyedPlanet = removeSurveyedPlanet;
    }

    @Override
    public boolean shouldRemoveIntel() {
        if (this.isEnded()) {
            return true;
        }
        if (this.removeTrigger != null) {
            PlanetAPI planet;
            DebrisFieldTerrainPlugin debris;
            CampaignTerrainAPI terrain;
            if (!this.removeTrigger.isAlive()) {
                return true;
            }
            if (this.removeTrigger instanceof CampaignTerrainAPI && this.keepExploredDebrisField == null ? (terrain = (CampaignTerrainAPI)this.removeTrigger).getPlugin() instanceof DebrisFieldTerrainPlugin && (debris = (DebrisFieldTerrainPlugin)terrain.getPlugin()).isScavenged() : this.removeTrigger instanceof PlanetAPI && this.removeSurveyedPlanet != null && this.removeSurveyedPlanet != false && (planet = (PlanetAPI)this.removeTrigger).getMarket() != null && planet.getMarket().getSurveyLevel() == MarketAPI.SurveyLevel.FULL) {
                return true;
            }
        }
        if (this.isImportant() || this.duration == null) {
            return false;
        }
        Long ts = this.getPlayerVisibleTimestamp();
        if (ts == null) {
            return false;
        }
        return Global.getSector().getClock().getElapsedDaysSince(ts) >= this.duration.floatValue();
    }

    public String getIconId() {
        return this.iconId;
    }

    public void setIconId(String iconId) {
        this.iconId = iconId;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String getIcon() {
        if (this.iconId != null) {
            return Global.getSettings().getSpriteName("intel", this.iconId);
        }
        if (this.icon != null) {
            return this.icon;
        }
        return Global.getSettings().getSpriteName("intel", "fleet_log");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Fleet log");
        return tags;
    }

    public SectorEntityToken getRemoveTrigger() {
        return this.removeTrigger;
    }

    public void setRemoveTrigger(SectorEntityToken removeTrigger) {
        this.removeTrigger = removeTrigger;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    @Override
    public String getCommMessageSound() {
        if (this.sound != null) {
            return this.sound;
        }
        return FleetLogIntel.getSoundLogUpdate();
    }
}

