/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.missions.luddic.LuddicPilgrimsPath;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class LuddicShrineIntel
extends BaseIntelPlugin {
    public static String VISITED = "$visitedShrine";
    protected SectorEntityToken entity;
    public static String BUTTON_SHOW_SHRINES = "button_show_shrines";

    public static void addShrineIntelIfNeeded(String id, TextPanelAPI text) {
        LuddicShrineIntel.addShrineIntelIfNeeded(LuddicShrineIntel.getEntity(id), text);
    }

    public static void addShrineIntelIfNeeded(SectorEntityToken entity, TextPanelAPI text) {
        LuddicShrineIntel.addShrineIntelIfNeeded(entity, text, false);
    }

    public static void addShrineIntelIfNeeded(SectorEntityToken entity, TextPanelAPI text, boolean quiet) {
        if (LuddicShrineIntel.getShrineIntel(entity) == null) {
            LuddicShrineIntel intel = new LuddicShrineIntel(entity);
            Global.getSector().getIntelManager().addIntel(intel, quiet, text);
        }
    }

    public static void setVisited(SectorEntityToken entity, TextPanelAPI text) {
        LuddicShrineIntel intel;
        if (LuddicShrineIntel.isVisited(entity)) {
            return;
        }
        entity.getMemoryWithoutUpdate().set(VISITED, true);
        if (text != null && (intel = LuddicShrineIntel.getShrineIntel(entity)) != null) {
            Global.getSector().getIntelManager().addIntelToTextPanel(intel, text);
        }
    }

    public static boolean isVisited(SectorEntityToken entity) {
        return entity.getMemoryWithoutUpdate().getBoolean(VISITED) || entity.getMarket() != null && entity.getMarket().getMemoryWithoutUpdate().getBoolean(VISITED);
    }

    public static LuddicShrineIntel getShrineIntel(SectorEntityToken entity) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(LuddicShrineIntel.class)) {
            if (((LuddicShrineIntel)intel).getEntity() != entity) continue;
            return (LuddicShrineIntel)intel;
        }
        return null;
    }

    public static SectorEntityToken getEntity(String id) {
        MarketAPI market = Global.getSector().getEconomy().getMarket(id);
        if (market != null) {
            if (market.getPlanetEntity() != null) {
                return market.getPlanetEntity();
            }
            return market.getPrimaryEntity();
        }
        return Global.getSector().getEntityById(id);
    }

    public LuddicShrineIntel(SectorEntityToken entity) {
        this.entity = entity;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        boolean visited = LuddicShrineIntel.isVisited(this.entity);
        if (visited) {
            Color c = Global.getSector().getFaction("luddic_church").getBaseUIColor();
            info.addPara("Visited", c, initPad);
            initPad = 0.0f;
        } else {
            info.addPara("Not visited", tc, initPad);
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        String pre = "";
        String post = "";
        if (mode == IntelInfoPlugin.ListInfoMode.MESSAGES) {
            pre = "Discovered: ";
        }
        Color c = this.getTitleColor(mode);
        info.addPara(String.valueOf(pre) + this.getName() + post, c, 0.0f);
        this.addBulletPoints(info, mode);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        String id = this.entity.getId();
        if (this.entity.getMarket() != null && !this.entity.getMarket().isPlanetConditionMarketOnly()) {
            id = this.entity.getMarket().getId();
        }
        boolean visited = LuddicShrineIntel.isVisited(this.entity);
        if (id.equals("jangala")) {
            if (visited) {
                info.addImage(Global.getSettings().getSpriteName("illustrations", "jangala_shrine"), width, opad);
            }
            Description desc = Global.getSettings().getDescription("shrine_jangala", Description.Type.CUSTOM);
            info.addPara(desc.getText1(), opad);
        } else if (id.equals("volturn")) {
            if (visited) {
                info.addImage(Global.getSettings().getSpriteName("illustrations", "volturn_shrine_fake"), width, opad);
            }
            Description desc = Global.getSettings().getDescription("shrine_volturn", Description.Type.CUSTOM);
            info.addPara(desc.getText1(), opad);
        } else if (id.equals("hesperus")) {
            if (visited) {
                info.addImage(Global.getSettings().getSpriteName("illustrations", "hesperus_shrine"), width, opad);
            }
            Description desc = Global.getSettings().getDescription("shrine_hesperus", Description.Type.CUSTOM);
            info.addPara(desc.getText1(), opad);
        } else if (id.equals("gilead")) {
            if (visited) {
                info.addImage(Global.getSettings().getSpriteName("illustrations", "gilead"), width, opad);
            }
            Description desc = Global.getSettings().getDescription("shrine_gilead", Description.Type.CUSTOM);
            info.addPara(desc.getText1(), opad);
        } else if (id.equals("beholder_station")) {
            if (visited) {
                info.addImage(Global.getSettings().getSpriteName("illustrations", "luddic_shrine"), width, opad);
            }
            Description desc = Global.getSettings().getDescription("shrine_beholder", Description.Type.CUSTOM);
            info.addPara(desc.getText1(), opad);
        } else if (id.equals("killa")) {
            if (visited) {
                info.addImage(Global.getSettings().getSpriteName("illustrations", "killa_shrine"), width, opad);
            }
            Description desc = Global.getSettings().getDescription("shrine_killa", Description.Type.CUSTOM);
            info.addPara(desc.getText1(), opad);
        }
        LuddicShrineIntel.addShowShrinesButton(this, width, height, info);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "luddic_shrine");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Luddic shrines");
        return tags;
    }

    @Override
    public String getSortString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return "Luddic Shrine - " + this.entity.getName();
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return Global.getSector().getFaction("luddic_church");
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return this.entity;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return false;
    }

    @Override
    public String getCommMessageSound() {
        return "ui_discovered_entity";
    }

    public SectorEntityToken getEntity() {
        return this.entity;
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_SHOW_SHRINES) {
            LuddicShrineIntel.toggleShrineList(this, ui);
            return;
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    public static void addShowShrinesButton(IntelInfoPlugin curr, float width, float height, TooltipMakerAPI info) {
        if (!Global.getSector().getIntelManager().hasIntelOfClass(LuddicPilgrimsPath.class)) {
            return;
        }
        if (!info.getIntelUI().isShowingCustomIntelSubset() && curr instanceof LuddicShrineIntel) {
            return;
        }
        String buttonText = "Show shrines";
        if (info.getIntelUI().isShowingCustomIntelSubset()) {
            buttonText = "Go back";
        }
        info.addSpacer(height - info.getHeightSoFar() - 20.0f - 20.0f);
        ButtonAPI button = ((BaseIntelPlugin)curr).addGenericButton(info, width, buttonText, BUTTON_SHOW_SHRINES);
        button.setShortcut(20, true);
    }

    public static void toggleShrineList(IntelInfoPlugin curr, IntelUIAPI ui) {
        if (ui.isShowingCustomIntelSubset()) {
            ui.updateIntelList(true);
            ui.updateUIForItem(curr);
            Iterator<IntelInfoPlugin> iterator = Global.getSector().getIntelManager().getIntel(LuddicPilgrimsPath.class).iterator();
            if (iterator.hasNext()) {
                IntelInfoPlugin intel = iterator.next();
                ui.selectItem(intel);
            }
        } else {
            ArrayList<IntelInfoPlugin> show = new ArrayList<IntelInfoPlugin>();
            for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(LuddicPilgrimsPath.class)) {
                show.add(intel);
            }
            for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(LuddicShrineIntel.class)) {
                show.add(intel);
            }
            Global.getSector().getIntelManager().sortIntel(show);
            ui.updateIntelList(true, show);
            ui.updateUIForItem(curr);
        }
    }
}

