/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.util.Misc;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MissionFleetStopPursuingPlayer
implements EveryFrameScript {
    protected CampaignFleetAPI fleet;
    protected BaseHubMission mission;
    protected Set<Object> stages = new HashSet<Object>();
    protected boolean done = false;

    public MissionFleetStopPursuingPlayer(CampaignFleetAPI fleet, BaseHubMission mission, List<Object> stages) {
        this.mission = mission;
        this.fleet = fleet;
        this.stages.addAll(stages);
    }

    @Override
    public void advance(float amount) {
        if (this.done) {
            return;
        }
        Object stage = this.mission.getCurrentStage();
        if (!this.stages.contains(stage)) {
            FleetAssignmentDataAPI curr;
            ModularFleetAIAPI ai;
            if (this.fleet.getAI() instanceof ModularFleetAIAPI && (ai = (ModularFleetAIAPI)this.fleet.getAI()).getAssignmentModule() != null && (curr = ai.getAssignmentModule().getCurrentAssignment()) != null && curr.getTarget() == Global.getSector().getPlayerFleet() && (curr.getAssignment() == FleetAssignment.INTERCEPT || curr.getAssignment() == FleetAssignment.FOLLOW)) {
                ai.getAssignmentModule().removeFirstAssignment();
            }
            if (this.fleet.getAI() != null && this.fleet.getAI().getAssignmentsCopy().isEmpty()) {
                Misc.giveStandardReturnToSourceAssignments(this.fleet, true);
            }
            Misc.setFlagWithReason(this.fleet.getMemoryWithoutUpdate(), "$cfai_makeHostile", this.mission.getReason(), false, -1.0f);
            this.done = true;
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

