/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class NebulaEditor {
    protected BaseTiledTerrain plugin;
    protected int[][] tiles;
    protected int[][] orig;
    protected float ts;
    protected float width;
    protected float height;
    protected float cx;
    protected float cy;
    protected int w;
    protected int h;
    private float[][] noise;
    protected boolean setToOrigInsteadOfClear = false;

    public NebulaEditor(BaseTiledTerrain plugin) {
        this.plugin = plugin;
        this.tiles = plugin.getTiles();
        this.ts = plugin.getTileSize();
        this.width = (float)this.tiles.length * this.ts;
        this.height = (float)this.tiles[0].length * this.ts;
        this.cx = plugin.getEntity().getLocation().x;
        this.cy = plugin.getEntity().getLocation().y;
        this.w = this.tiles.length;
        this.h = this.tiles[0].length;
        this.orig = this.getTilesCopy();
        this.regenNoise();
    }

    public int[][] getTilesCopy() {
        int[][] copy = new int[this.w][this.h];
        int i = 0;
        while (i < this.w) {
            int j = 0;
            while (j < this.h) {
                copy[i][j] = this.tiles[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public int[][] getTiles() {
        return this.tiles;
    }

    public int[][] getOrigTiles() {
        return this.orig;
    }

    public float getTileSize() {
        return this.ts;
    }

    public void regenNoise() {
        float spikes = 1.0f;
        this.noise = Misc.initNoise(StarSystemGenerator.random, this.w, this.h, spikes);
        Misc.genFractalNoise(StarSystemGenerator.random, this.noise, 0, 0, this.w - 1, this.h - 1, 1, spikes);
        Misc.normalizeNoise(this.noise);
    }

    public void noisePrune(float fractionKeep) {
        if (this.noise == null) {
            this.regenNoise();
        }
        float[] counts = new float[100];
        int i = 0;
        while (i < this.w) {
            int j = 0;
            while (j < this.h) {
                float f = this.noise[i][j];
                int index = (int)(f * 100.0f);
                if (index < 0) {
                    index = 0;
                }
                if (index > 99) {
                    index = 99;
                }
                int n = index;
                counts[n] = counts[n] + 1.0f;
                ++j;
            }
            ++i;
        }
        float total = this.w * this.h;
        float keep = fractionKeep * total;
        float threshold = 0.0f;
        float totalKept = 0.0f;
        int i2 = 0;
        while (i2 < 100) {
            if ((totalKept += counts[i2]) >= keep) {
                threshold = (float)i2 / 100.0f;
                break;
            }
            ++i2;
        }
        int count = 0;
        int i3 = 0;
        while (i3 < this.w) {
            int j = 0;
            while (j < this.h) {
                if (this.noise[i3][j] > threshold) {
                    this.tiles[i3][j] = -1;
                    ++count;
                }
                ++j;
            }
            ++i3;
        }
    }

    public void clearArc(float x, float y, float innerRadius, float outerRadius, float startAngle, float endAngle) {
        this.clearArc(x, y, innerRadius, outerRadius, startAngle, endAngle, 0.0f);
    }

    public void clearArc(float x, float y, float innerRadius, float outerRadius, float startAngle, float endAngle, float noiseThresholdToClear) {
        this.clearArc(x, y, innerRadius, outerRadius, startAngle, endAngle, 1.0f, noiseThresholdToClear);
    }

    public void clearArc(float x, float y, float innerRadius, float outerRadius, float startAngle, float endAngle, float endRadiusMult, float noiseThresholdToClear) {
        float circumference = (float)Math.PI * 2 * outerRadius;
        float degreesPerIteration = 360.0f / (circumference / (this.ts * 0.5f));
        float angle = startAngle;
        while (angle < endAngle) {
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
            float distMult = 1.0f;
            if (endAngle > startAngle) {
                float p = (angle - startAngle) / (endAngle - startAngle);
                distMult = 1.0f + (endRadiusMult - 1.0f) * p;
            }
            float dist = innerRadius * distMult;
            while (dist <= innerRadius * distMult + (outerRadius - innerRadius)) {
                Vector2f curr = new Vector2f((ReadableVector2f)dir);
                curr.scale(dist);
                curr.x += x;
                curr.y += y;
                this.setTileAt(curr.x, curr.y, -1, noiseThresholdToClear, this.setToOrigInsteadOfClear);
                dist += this.ts * 0.5f;
            }
            angle += degreesPerIteration;
        }
    }

    public boolean isSetToOrigInsteadOfClear() {
        return this.setToOrigInsteadOfClear;
    }

    public void setSetToOrigInsteadOfClear(boolean setToOrigInsteadOfClear) {
        this.setToOrigInsteadOfClear = setToOrigInsteadOfClear;
    }

    public void setTileAt(float x, float y, int value) {
        this.setTileAt(x, y, value, 0.0f);
    }

    public void setTileAt(float x, float y, int value, float noiseThresholdToClear) {
        this.setTileAt(x, y, value, noiseThresholdToClear, false);
    }

    public void setTileAt(float x, float y, int value, float noiseThresholdToClear, boolean setToOrigTile) {
        int cellX = (int)((this.width / 2.0f + x - this.cx) / this.ts);
        int cellY = (int)((this.height / 2.0f + y - this.cy) / this.ts);
        if (cellX < 0) {
            return;
        }
        if (cellY < 0) {
            return;
        }
        if (cellX > this.tiles.length - 1) {
            return;
        }
        if (cellY > this.tiles[0].length - 1) {
            return;
        }
        if (setToOrigTile) {
            value = this.orig[cellX][cellY];
        }
        if (noiseThresholdToClear <= 0.0f || this.noise[cellX][cellY] > noiseThresholdToClear) {
            this.tiles[cellX][cellY] = value;
        }
    }
}

