/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class CombatEndurance {
    public static float PEAK_TIME_BONUS = 60.0f;
    public static float DEGRADE_REDUCTION_PERCENT = 25.0f;
    public static float MAX_CR_BONUS = 15.0f;
    public static float MAX_REGEN_LEVEL = 1.0f;
    public static float REGEN_RATE = 0.005f;
    public static float TOTAL_REGEN_MAX_POINTS = 2000.0f;
    public static float TOTAL_REGEN_MAX_HULL_FRACTION = 0.5f;

    public static class CombatEnduranceRegen
    implements DamageTakenModifier,
    AdvanceableListener {
        protected ShipAPI ship;
        protected boolean inited = false;
        protected float limit = 0.0f;
        protected float repaired = 0.0f;
        protected String repKey1;
        protected String repKey2;

        public CombatEnduranceRegen(ShipAPI ship) {
            this.ship = ship;
        }

        protected void init() {
            this.inited = true;
            float maxHull = this.ship.getMaxHitpoints();
            this.limit = Math.max(TOTAL_REGEN_MAX_POINTS, TOTAL_REGEN_MAX_HULL_FRACTION * maxHull);
            this.repKey1 = "CombatEnduranceRegen_ " + this.ship.getId() + "_repaired";
            this.repKey2 = "CombatEnduranceRegen_ " + this.ship.getCaptain().getId() + "_repaired";
            float r1 = this.getRepaired(this.repKey1);
            float r2 = this.getRepaired(this.repKey2);
            this.repaired = Math.max(this.repaired, r1);
            this.repaired = Math.max(this.repaired, r2);
        }

        protected float getRepaired(String key) {
            Float r = (Float)Global.getCombatEngine().getCustomData().get(key);
            if (r == null) {
                r = Float.valueOf(0.0f);
            }
            return r.floatValue();
        }

        @Override
        public void advance(float amount) {
            if (!this.inited) {
                this.init();
            }
            if (this.repaired >= this.limit) {
                return;
            }
            if (this.ship.getHullLevel() >= MAX_REGEN_LEVEL) {
                return;
            }
            if (this.ship.isHulk()) {
                return;
            }
            float maxHull = this.ship.getMaxHitpoints();
            float currHull = this.ship.getHitpoints();
            float maxPoints = maxHull * MAX_REGEN_LEVEL;
            float repairAmount = Math.min(this.limit - this.repaired, maxHull * REGEN_RATE * amount);
            if (repairAmount > maxPoints - currHull) {
                repairAmount = maxPoints - currHull;
            }
            if (repairAmount > 0.0f) {
                this.ship.setHitpoints(this.ship.getHitpoints() + repairAmount);
                this.repaired += repairAmount;
                Global.getCombatEngine().getCustomData().put(this.repKey1, Float.valueOf(this.repaired));
                Global.getCombatEngine().getCustomData().put(this.repKey2, Float.valueOf(this.repaired * 0.5f));
            }
        }

        @Override
        public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            return null;
        }
    }

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getPeakCRDuration().modifyFlat(id, PEAK_TIME_BONUS);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getPeakCRDuration().unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)PEAK_TIME_BONUS + " seconds peak operating time";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level2
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getCRLossPerSecondPercent().modifyMult(id, 1.0f - DEGRADE_REDUCTION_PERCENT / 100.0f);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getCRLossPerSecondPercent().unmodifyMult(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "-" + (int)DEGRADE_REDUCTION_PERCENT + "% combat readiness degradation rate after peak performance time runs out";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level3
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getMaxCombatReadiness().modifyFlat(id, MAX_CR_BONUS * 0.01f, "Combat Endurance skill");
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getMaxCombatReadiness().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)MAX_CR_BONUS + "% maximum combat readiness";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.PILOTED_SHIP;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements ShipSkillEffect,
    AfterShipCreationSkillEffect {
        @Override
        public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.addListener(new CombatEnduranceRegen(ship));
        }

        @Override
        public void unapplyEffectsAfterShipCreation(ShipAPI ship, String id) {
            ship.removeListenerOfClass(CombatEnduranceRegen.class);
        }

        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.initElite(stats, skill);
            info.addPara("When below %s hull, repair %s per second; total repair is the higher of %s points or %s of maximum hull", 0.0f, this.hc, this.hc, Math.round(MAX_REGEN_LEVEL * 100.0f) + "%", Misc.getRoundedValueMaxOneAfterDecimal(REGEN_RATE * 100.0f) + "%", "" + Math.round(TOTAL_REGEN_MAX_POINTS), Math.round(TOTAL_REGEN_MAX_HULL_FRACTION * 100.0f) + "%");
        }
    }
}

