/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class ForceConcentration {
    public static float ZERO_FLUX_SPEED_BONUS_SMALL = 25.0f;
    public static float ZERO_FLUX_SPEED_BONUS;
    public static float ZERO_FLUX_ACCEL_BONUS;
    public static float ZERO_FLUX_TURN_BONUS;
    public static float ZERO_FLUX_TURN_ACCEL_BONUS;
    public static float COMMAND_POINT_REGEN_PERCENT;

    static {
        ZERO_FLUX_ACCEL_BONUS = ZERO_FLUX_SPEED_BONUS = 100.0f;
        ZERO_FLUX_TURN_BONUS = 20.0f;
        ZERO_FLUX_TURN_ACCEL_BONUS = ZERO_FLUX_TURN_BONUS * 2.0f;
        COMMAND_POINT_REGEN_PERCENT = 100.0f;
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
        }

        @Override
        public String getEffectDescription(float level) {
            return "+" + (int)ZERO_FLUX_SPEED_BONUS + " to 0-flux speed boost and a high maneuverability bonus if no enemy presence nearby, +" + (int)ZERO_FLUX_SPEED_BONUS_SMALL + " to 0-flux boost otherwise";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("can_deploy_left_right").modifyFlat(id, 1.0f);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("can_deploy_left_right").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Able to deploy ships of all size classes from the flanks in all combat scenarios";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level4
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getStat("command_point_rate").modifyFlat(id, COMMAND_POINT_REGEN_PERCENT / 100.0f);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getStat("command_point_rate").unmodify(id);
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            float opad = 10.0f;
            Color c = Misc.getBasePlayerColor();
            info.addPara("Affects: %s", opad + 5.0f, Misc.getGrayColor(), c, "fleet");
            info.addSpacer(opad);
            info.addPara("%s faster command point recovery", 0.0f, this.hc, this.hc, (int)COMMAND_POINT_REGEN_PERCENT + "%");
        }

        @Override
        public String getEffectDescription(float level) {
            return null;
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

